/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display.axes;

import java.awt.event.MouseEvent;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.InteractivePanel;
import org.opensourcephysics.display.axes.CoordinateStringBuilder;

public class CartesianCoordinateStringBuilder
extends CoordinateStringBuilder {
    public CartesianCoordinateStringBuilder() {
        this("x=", "  y=");
    }

    public CartesianCoordinateStringBuilder(String xLabel, String yLabel) {
        this.xLabel = xLabel;
        this.yLabel = yLabel;
    }

    @Override
    public void setCoordinateLabels(String xLabel, String yLabel) {
        this.xLabel = xLabel;
        this.yLabel = yLabel;
    }

    @Override
    public String getCoordinateString(DrawingPanel panel, MouseEvent e) {
        double x = panel.pixToX(e.getPoint().x);
        double y = panel.pixToY(e.getPoint().y);
        if (panel instanceof InteractivePanel && ((InteractivePanel)panel).getCurrentDraggable() != null) {
            x = ((InteractivePanel)panel).getCurrentDraggable().getX();
            y = ((InteractivePanel)panel).getCurrentDraggable().getY();
        }
        String msg = "";
        if (Math.abs(x) > 100.0 || Math.abs(x) < 0.01 || Math.abs(y) > 100.0 || Math.abs(y) < 0.01) {
            if (this.xLabel != null) {
                msg = String.valueOf(this.xLabel) + this.scientificFormat.format((float)x);
            }
            if (this.yLabel != null) {
                msg = String.valueOf(msg) + this.yLabel + this.scientificFormat.format((float)y);
            }
        } else {
            if (this.xLabel != null) {
                msg = String.valueOf(this.xLabel) + this.decimalFormat.format((float)x);
            }
            if (this.yLabel != null) {
                msg = String.valueOf(msg) + this.yLabel + this.decimalFormat.format((float)y);
            }
        }
        return msg;
    }
}

