/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.util.HashMap;
import java.util.Map;

public class TeXParser {
    public static Map<String, String> charMap = new HashMap<String, String>();

    static {
        charMap.put("\\Alpha", "\u0391");
        charMap.put("\\Beta", "\u0392");
        charMap.put("\\Gamma", "\u0393");
        charMap.put("\\Delta", "\u0394");
        charMap.put("\\Epsilon", "\u0395");
        charMap.put("\\Zeta", "\u0396");
        charMap.put("\\Eta", "\u0397");
        charMap.put("\\Theta", "\u0398");
        charMap.put("\\Pi", "\u03a0");
        charMap.put("\\Rho", "\u03a1");
        charMap.put("\\Sigma", "\u03a3");
        charMap.put("\\Tau", "\u03a4");
        charMap.put("\\Phi", "\u03a6");
        charMap.put("\\Chi", "\u03a7");
        charMap.put("\\Psi", "\u03a8");
        charMap.put("\\Omega", "\u03a9");
        charMap.put("\\Xi", "\u039e");
        charMap.put("\\alpha", "\u03b1");
        charMap.put("\\beta", "\u03b2");
        charMap.put("\\gamma", "\u03b3");
        charMap.put("\\delta", "\u03b4");
        charMap.put("\\epsilon", "\u03b5");
        charMap.put("\\zeta", "\u03b6");
        charMap.put("\\eta", "\u03b7");
        charMap.put("\\theta", "\u03b8");
        charMap.put("\\iota", "\u03b9");
        charMap.put("\\kappa", "\u03ba");
        charMap.put("\\lamda", "\u03bb");
        charMap.put("\\lambda", "\u03bb");
        charMap.put("\\mu", "\u03bc");
        charMap.put("\\micro", "\u03bc");
        charMap.put("\\nu", "\u03bd");
        charMap.put("\\xi", "\u03be");
        charMap.put("\\pi", "\u03c0");
        charMap.put("\\rho", "\u03c1");
        charMap.put("\\sigma", "\u03c3");
        charMap.put("\\tau", "\u03c4");
        charMap.put("\\phi", "\u03c6");
        charMap.put("\\chi", "\u03c7");
        charMap.put("\\psi", "\u03c8");
        charMap.put("\\omega", "\u03c9");
        charMap.put("\\degree", "\u00b0");
        charMap.put("\\sqr", "\u00b2");
        charMap.put("\\pm", "\u00b1");
        charMap.put("\\neq", "\u2260");
        charMap.put("\\leq", "\u2264");
        charMap.put("\\geq", "\u00f7");
        charMap.put("\\div", "\u00f7");
        charMap.put("\\perp", "\u27c2");
        charMap.put("\\parallel", "\u2225");
    }

    public static String parseTeX(String inputStr) {
        if (inputStr == null) {
            return null;
        }
        String[] chunks = inputStr.split("\\$");
        boolean mathMode = false;
        int i = 0;
        while (i < chunks.length) {
            String val;
            if (mathMode && (val = charMap.get(chunks[i].trim())) != null) {
                chunks[i] = val;
            }
            mathMode = !mathMode;
            ++i;
        }
        String outStr = "";
        int i2 = 0;
        while (i2 < chunks.length) {
            outStr = String.valueOf(outStr) + chunks[i2];
            ++i2;
        }
        return outStr;
    }

    public static String removeSubscripting(String input) {
        if (input == null) {
            return null;
        }
        return String.valueOf(TeXParser.removeSubscript(input)) + TeXParser.getSubscript(input);
    }

    public static String removeSubscript(String input) {
        if (input == null) {
            return null;
        }
        int n = input.indexOf("_");
        if (n > 0) {
            return input.substring(0, n);
        }
        return input;
    }

    public static String getSubscript(String input) {
        int m;
        if (input == null) {
            return null;
        }
        String subscript = "";
        int n = input.indexOf("_");
        if (n > 0 && (subscript = input.substring(n + 1)).startsWith("{") && (m = subscript.indexOf("}")) > 0) {
            subscript = subscript.substring(1, m);
        }
        return subscript;
    }

    public static String addSubscript(String root, String subscript) {
        if (root == null) {
            return null;
        }
        if (subscript == null) {
            return root;
        }
        if ((subscript = subscript.trim()).startsWith("{")) {
            int n = subscript.indexOf("}");
            if (n == -1) {
                n = subscript.length();
            }
            subscript = subscript.substring(1, n).trim();
        }
        if (subscript.equals("")) {
            return root;
        }
        String prevSubscript = TeXParser.getSubscript(root);
        if (prevSubscript != null) {
            subscript = String.valueOf(prevSubscript) + subscript;
        }
        return String.valueOf(TeXParser.removeSubscript(root)) + "_{" + subscript + "}";
    }
}

