/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.util.Arrays;
import java.util.Comparator;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class SortDecorator
implements TableModel,
TableModelListener {
    private TableModel realModel;
    private int[] indexes;
    private int sortedColumn;

    public SortDecorator(TableModel model) {
        if (model == null) {
            throw new IllegalArgumentException("null models are not allowed");
        }
        this.realModel = model;
        this.realModel.addTableModelListener(this);
        this.allocate();
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (column >= this.getColumnCount()) {
            return null;
        }
        if (this.indexes.length <= row) {
            this.allocate();
        }
        return this.realModel.getValueAt(this.indexes[row], column);
    }

    @Override
    public void setValueAt(Object aValue, int row, int column) {
        if (this.indexes.length <= row) {
            this.allocate();
        }
        this.realModel.setValueAt(aValue, this.indexes[row], column);
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.allocate();
    }

    public void sort(int column) {
        this.sortedColumn = column;
        int rowCount = this.getRowCount();
        if (this.indexes.length <= rowCount) {
            this.allocate();
        }
        if (this.realModel.getColumnClass(column) == Double.class || this.realModel.getColumnClass(column) == Integer.class) {
            int i;
            Double[][] sortArray = new Double[rowCount][2];
            if (this.realModel.getColumnClass(column) == Double.class) {
                i = 0;
                while (i < rowCount) {
                    sortArray[i][0] = (Double)this.realModel.getValueAt(i, column);
                    sortArray[i][1] = 1.0 * (double)this.indexes[i];
                    ++i;
                }
            } else {
                i = 0;
                while (i < rowCount) {
                    sortArray[i][0] = ((Integer)this.realModel.getValueAt(i, column)).doubleValue();
                    sortArray[i][1] = 1.0 * (double)this.indexes[i];
                    ++i;
                }
            }
            Arrays.sort(sortArray, new Comparator<Double[]>(){

                @Override
                public int compare(Double[] a, Double[] b) {
                    if (a[0] == null || b[0] == null) {
                        return b[0] == a[0] ? 0 : (b[0] == null ? -1 : 1);
                    }
                    return b[0] < a[0] ? 1 : (b[0] > a[0] ? -1 : 0);
                }
            });
            i = 0;
            while (i < rowCount) {
                this.indexes[i] = sortArray[i][1].intValue();
                ++i;
            }
        } else {
            int i = 0;
            while (i < rowCount) {
                int j = i + 1;
                while (j < rowCount) {
                    if (this.compare(this.indexes[i], this.indexes[j], column) < 0) {
                        this.swap(i, j);
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    public int getSortedColumn() {
        return this.sortedColumn;
    }

    public void swap(int i, int j) {
        int tmp = this.indexes[i];
        this.indexes[i] = this.indexes[j];
        this.indexes[j] = tmp;
    }

    public int compare(int i, int j, int column) {
        Object io = this.realModel.getValueAt(i, column);
        Object jo = this.realModel.getValueAt(j, column);
        if (io != null && jo == null) {
            return 1;
        }
        if (io == null && jo != null) {
            return -1;
        }
        if (io == null && jo == null) {
            return 0;
        }
        if (io instanceof Integer && jo instanceof Integer) {
            int a = (Integer)io;
            int b = (Integer)jo;
            return b < a ? -1 : (b > a ? 1 : 0);
        }
        if (io instanceof Double && jo instanceof Double) {
            double a = (Double)io;
            double b = (Double)jo;
            return b < a ? -1 : (b > a ? 1 : 0);
        }
        if (io instanceof Integer && jo instanceof Double) {
            int a = (Integer)io;
            double b = (Double)jo;
            return b < (double)a ? -1 : (b > (double)a ? 1 : 0);
        }
        if (io instanceof Double && jo instanceof Integer) {
            double a = (Double)io;
            int b = (Integer)jo;
            return (double)b < a ? -1 : ((double)b > a ? 1 : 0);
        }
        int c = jo.toString().compareTo(io.toString());
        return c < 0 ? -1 : (c > 0 ? 1 : 0);
    }

    private void allocate() {
        this.indexes = new int[this.getRowCount()];
        int i = 0;
        while (i < this.indexes.length) {
            this.indexes[i] = i;
            ++i;
        }
    }

    @Override
    public int getRowCount() {
        return this.realModel.getRowCount();
    }

    @Override
    public int getColumnCount() {
        return this.realModel.getColumnCount();
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (columnIndex >= this.getColumnCount()) {
            return "unknown";
        }
        return this.realModel.getColumnName(columnIndex);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex >= this.getColumnCount()) {
            return Object.class;
        }
        return this.realModel.getColumnClass(columnIndex);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (columnIndex >= this.getColumnCount()) {
            return false;
        }
        return this.realModel.isCellEditable(rowIndex, columnIndex);
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.realModel.addTableModelListener(l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.realModel.removeTableModelListener(l);
    }
}

