/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import org.jibble.epsgraphics.EpsGraphics2D;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.display.DataTableFrame;
import org.opensourcephysics.display.DisplayRes;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display.DrawingFrame;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.OSPFrame;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.display.Renderable;
import org.opensourcephysics.display.TeXParser;
import org.opensourcephysics.media.gif.GIFEncoder;

public class GUIUtils {
    private GUIUtils() {
    }

    public static String parseTeX(String input) {
        return TeXParser.parseTeX(input);
    }

    public static String removeSubscripting(String input) {
        return TeXParser.removeSubscripting(input);
    }

    public static Component findInstance(Container container, Class<?> c) {
        if (container == null || c.isInstance(container)) {
            return container;
        }
        Component[] components = container.getComponents();
        int i = 0;
        int n = components.length;
        while (i < n) {
            Component comp;
            if (c.isInstance(components[i])) {
                return components[i];
            }
            if (components[i] instanceof Container && c.isInstance(comp = GUIUtils.findInstance((Container)components[i], c))) {
                return comp;
            }
            ++i;
        }
        return null;
    }

    public static void showDrawingAndTableFrames() {
        Frame[] frames = Frame.getFrames();
        int i = 0;
        while (i < frames.length) {
            if (frames[i].isDisplayable() && (frames[i].getName() == null || frames[i].getName().indexOf("Tool") <= -1) && OSPFrame.class.isInstance(frames[i])) {
                if (DataTableFrame.class.isInstance(frames[i])) {
                    ((DataTableFrame)frames[i]).refreshTable();
                }
                frames[i].setVisible(true);
                ((OSPFrame)frames[i]).invalidateImage();
                frames[i].repaint();
                frames[i].toFront();
            }
            ++i;
        }
        if (OSPRuntime.applet != null) {
            OSPRuntime.applet.getRootPane().repaint();
        }
    }

    public static void renderAnimatedFrames() {
        Frame[] frames = Frame.getFrames();
        int i = 0;
        while (i < frames.length) {
            if (frames[i].isDisplayable() && OSPFrame.class.isInstance(frames[i]) && ((OSPFrame)frames[i]).isAnimated()) {
                ((OSPFrame)frames[i]).render();
            }
            ++i;
        }
        if (OSPRuntime.applet != null && OSPRuntime.applet instanceof Renderable) {
            ((Renderable)((Object)OSPRuntime.applet)).render();
        }
    }

    public static void repaintAnimatedFrames() {
        Frame[] frames = Frame.getFrames();
        int i = 0;
        while (i < frames.length) {
            if (frames[i].isDisplayable() && OSPFrame.class.isInstance(frames[i]) && ((OSPFrame)frames[i]).isAnimated()) {
                ((OSPFrame)frames[i]).invalidateImage();
                ((OSPFrame)frames[i]).repaint();
            }
            ++i;
        }
    }

    public static void repaintOSPFrames() {
        Frame[] frames = Frame.getFrames();
        int i = 0;
        while (i < frames.length) {
            if (frames[i].isVisible() && frames[i].isDisplayable() && OSPFrame.class.isInstance(frames[i])) {
                ((OSPFrame)frames[i]).repaint();
            }
            ++i;
        }
    }

    public static void clearDrawingFrameData(boolean clearAll) {
        Frame[] frames = Frame.getFrames();
        int i = 0;
        while (i < frames.length) {
            if (frames[i].isDisplayable() && OSPFrame.class.isInstance(frames[i])) {
                OSPFrame frame = (OSPFrame)frames[i];
                if (clearAll || frame.isAutoclear()) {
                    frame.clearDataAndRepaint();
                }
            }
            ++i;
        }
    }

    public static void setAnimatedFrameIgnoreRepaint(boolean ignoreRepaint) {
        Frame[] frames = Frame.getFrames();
        int i = 0;
        while (i < frames.length) {
            DrawingPanel dp;
            if (frames[i].isDisplayable() && DrawingFrame.class.isInstance(frames[i]) && ((DrawingFrame)frames[i]).isAnimated() && (dp = ((DrawingFrame)frames[i]).getDrawingPanel()) != null) {
                dp.setIgnoreRepaint(ignoreRepaint);
            }
            ++i;
        }
    }

    public static void enableMenubars(boolean enable) {
        Frame[] frames = Frame.getFrames();
        int i = 0;
        while (i < frames.length) {
            if (frames[i].isDisplayable() && (frames[i].getName() == null || frames[i].getName().indexOf("Tool") <= -1)) {
                JMenuBar bar;
                Class<?> frame3d = null;
                try {
                    frame3d = Class.forName("org.opensourcephysics.display3d.core.DrawingFrame3D");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                if ((DrawingFrame.class.isInstance(frames[i]) || frame3d != null && frame3d.isInstance(frames[i])) && (bar = ((JFrame)frames[i]).getJMenuBar()) != null) {
                    int j = 0;
                    int n = bar.getMenuCount();
                    while (j < n) {
                        bar.getMenu(j).setEnabled(enable);
                        ++j;
                    }
                }
            }
            ++i;
        }
    }

    public static void closeAndDisposeOSPFrames(Frame frame) {
        Frame[] frames = Frame.getFrames();
        int i = 0;
        while (i < frames.length) {
            if (frames[i] != frame && OSPFrame.class.isInstance(frames[i])) {
                ((OSPFrame)frames[i]).setDefaultCloseOperation(2);
                ((OSPFrame)frames[i]).setVisible(false);
                ((OSPFrame)frames[i]).dispose();
            }
            ++i;
        }
    }

    public static File showSaveDialog(Component parent) {
        return GUIUtils.showSaveDialog(parent, DisplayRes.getString("GUIUtils.Title.Save"));
    }

    public static File showSaveDialog(Component parent, String title) {
        int selected;
        JFileChooser fileChooser = OSPRuntime.getChooser();
        if (fileChooser == null) {
            return null;
        }
        String oldTitle = fileChooser.getDialogTitle();
        fileChooser.setDialogTitle(title);
        int result = fileChooser.showSaveDialog(parent);
        fileChooser.setDialogTitle(oldTitle);
        if (result != 0) {
            return null;
        }
        OSPRuntime.chooserDir = fileChooser.getCurrentDirectory().toString();
        File file = fileChooser.getSelectedFile();
        if (file.exists() && (selected = JOptionPane.showConfirmDialog(parent, String.valueOf(DisplayRes.getString("DrawingFrame.ReplaceExisting_message")) + " " + file.getName() + DisplayRes.getString("DrawingFrame.QuestionMark"), DisplayRes.getString("DrawingFrame.ReplaceFile_option_title"), 1)) != 0) {
            return null;
        }
        return file;
    }

    public static File showOpenDialog(Component parent) {
        JFileChooser fileChooser = OSPRuntime.getChooser();
        int result = fileChooser.showOpenDialog(parent);
        if (result != 0) {
            return null;
        }
        OSPRuntime.chooserDir = fileChooser.getCurrentDirectory().toString();
        File file = fileChooser.getSelectedFile();
        return file;
    }

    public static void timingTest(Drawable drawable) {
        DrawingPanel dp = new DrawingPanel();
        DrawingFrame df = new DrawingFrame(dp);
        df.setVisible(true);
        dp.addDrawable(drawable);
        dp.scale();
        dp.setPixelScale();
        Graphics g2 = dp.getGraphics();
        if (g2 == null) {
            return;
        }
        long startTime = System.currentTimeMillis();
        drawable.draw(dp, g2);
        System.out.print("first drawing=" + (System.currentTimeMillis() - startTime));
        startTime = System.currentTimeMillis();
        int i = 0;
        while (i < 5) {
            drawable.draw(dp, g2);
            ++i;
        }
        System.out.println("  avg time/drawing=" + (System.currentTimeMillis() - startTime) / 5L);
        g2.dispose();
    }

    public static void saveImage(JComponent comp, File outputFile, String outputFileFormat) throws IOException {
        block10: {
            try (FileOutputStream fos = null;){
                try {
                    fos = new FileOutputStream(outputFile);
                    if (outputFileFormat.equals("eps")) {
                        EpsGraphics2D g = new EpsGraphics2D("", fos, 0, 0, comp.getWidth(), comp.getHeight());
                        comp.paint(g);
                        g.scale(0.24, 0.24);
                        g.close();
                        break block10;
                    }
                    BufferedImage bi = new BufferedImage(comp.getWidth(), comp.getHeight(), 5);
                    Graphics g = bi.getGraphics();
                    comp.paint(g);
                    g.dispose();
                    if (outputFileFormat.equals("gif")) {
                        GIFEncoder encoder = new GIFEncoder(bi);
                        encoder.Write(fos);
                    } else {
                        ImageIO.write((RenderedImage)bi, outputFileFormat, fos);
                    }
                    fos.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (fos != null) {
                        fos.close();
                    }
                }
            }
        }
    }

    public static void saveImage(JComponent component, String ouputFileFormat, Component parent) {
        File outputFile = GUIUtils.showSaveDialog(component, DisplayRes.getString("GUIUtils.Title.SaveImage"));
        if (outputFile == null) {
            return;
        }
        try {
            GUIUtils.saveImage(component, outputFile, ouputFileFormat);
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(parent, "An error occurred while saving the file " + outputFile.getName() + ".'");
        }
    }

    public static void saveImageAs(JComponent component, String type, String title, String description, String[] extensions) {
        int selected;
        JFileChooser chooser = OSPRuntime.createChooser(title, description, extensions);
        String fileName = OSPRuntime.chooseFilename(chooser);
        if (fileName == null) {
            return;
        }
        File file = new File(fileName);
        String extension = XML.getExtension(fileName);
        if ((extension == null || ".".equals(extension)) && (file = new File(fileName = String.valueOf(XML.stripExtension(fileName)) + "." + extensions[0])).exists() && (selected = JOptionPane.showConfirmDialog(null, String.valueOf(DisplayRes.getString("DrawingFrame.ReplaceExisting_message")) + " " + file.getName() + DisplayRes.getString("DrawingFrame.QuestionMark"), DisplayRes.getString("DrawingFrame.ReplaceFile_option_title"), 1)) != 0) {
            return;
        }
        try {
            GUIUtils.saveImage(component, file, type);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

