/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.controls;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.XMLFormatter;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import org.opensourcephysics.controls.ConsoleFormatter;
import org.opensourcephysics.controls.ConsoleLevel;
import org.opensourcephysics.controls.ControlsRes;
import org.opensourcephysics.controls.LoggerOutputStream;
import org.opensourcephysics.controls.MessageFrame;
import org.opensourcephysics.controls.OSPLogHandler;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.tools.FontSizer;

public class OSPLog
extends JFrame {
    private static OSPLog OSPLOG;
    private static JFileChooser chooser;
    protected static Style black;
    protected static Style red;
    protected static Style blue;
    protected static Style green;
    protected static Style magenta;
    protected static Style gray;
    protected static final Color DARK_GREEN;
    protected static final Color DARK_BLUE;
    protected static final Color DARK_RED;
    public static final Level[] levels;
    private static Level defaultLevel;
    public static final int OUT_OF_MEMORY_ERROR = 1;
    protected static boolean logConsole;
    private Logger logger;
    private Handler fileHandler;
    private OSPLogHandler logHandler;
    private JTextPane textPane;
    private String logFileName;
    private String tempFileName;
    private JPanel logPanel;
    private JPopupMenu popup;
    private ButtonGroup popupGroup;
    private ButtonGroup menubarGroup;
    private String pkgName;
    private String bundleName;
    private JMenuItem logToFileItem;
    private boolean hasPermission = true;
    private static LogRecord[] messageStorage;
    private static int messageIndex;
    static String eol;
    static String logdir;
    static String slash;

    static {
        DARK_GREEN = new Color(0, 128, 0);
        DARK_BLUE = new Color(0, 0, 128);
        DARK_RED = new Color(128, 0, 0);
        levels = new Level[]{Level.OFF, Level.SEVERE, Level.WARNING, Level.INFO, ConsoleLevel.ERR_CONSOLE, ConsoleLevel.OUT_CONSOLE, Level.CONFIG, Level.FINE, Level.FINER, Level.FINEST, Level.ALL};
        defaultLevel = ConsoleLevel.OUT_CONSOLE;
        logConsole = true;
        messageStorage = new LogRecord[128];
        messageIndex = 0;
        eol = "\n";
        logdir = ".";
        slash = "/";
        try {
            eol = System.getProperty("line.separator", eol);
            logdir = System.getProperty("user.home", logdir);
            slash = System.getProperty("file.separator", "/");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static OSPLog getOSPLog() {
        if (OSPLOG == null && !OSPRuntime.appletMode && OSPRuntime.applet == null) {
            OSPLOG = new OSPLog("org.opensourcephysics", null);
            try {
                System.setOut(new PrintStream(new LoggerOutputStream(ConsoleLevel.OUT_CONSOLE, System.out)));
                System.setErr(new PrintStream(new LoggerOutputStream(ConsoleLevel.ERR_CONSOLE, System.err)));
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            OSPLog.setLevel(defaultLevel);
        }
        return OSPLOG;
    }

    public void setLogDir(String dir) {
        logdir = dir;
    }

    public String getLogDir() {
        return logdir;
    }

    public static boolean isLogVisible() {
        if ((OSPRuntime.appletMode || OSPRuntime.applet != null) && MessageFrame.APPLET_MESSAGEFRAME != null) {
            return MessageFrame.APPLET_MESSAGEFRAME.isVisible();
        }
        if (OSPLOG != null) {
            return OSPLOG.isVisible();
        }
        return false;
    }

    @Override
    public void setVisible(boolean visible) {
        if (OSPRuntime.appletMode || OSPRuntime.applet != null) {
            MessageFrame.showLog(visible);
        } else {
            super.setVisible(visible);
        }
    }

    @Override
    public boolean isVisible() {
        if (OSPRuntime.appletMode || OSPRuntime.applet != null) {
            return MessageFrame.isLogVisible();
        }
        return super.isVisible();
    }

    public static JFrame showLog() {
        if (OSPRuntime.appletMode || OSPRuntime.applet != null) {
            return MessageFrame.showLog(true);
        }
        OSPLog.getOSPLog().setVisible(true);
        Logger logger = OSPLOG.getLogger();
        int i = 0;
        int n = messageStorage.length;
        while (i < n) {
            LogRecord record = messageStorage[(i + messageIndex) % n];
            if (record != null) {
                logger.log(record);
            }
            ++i;
        }
        messageIndex = 0;
        return OSPLog.getOSPLog();
    }

    public static void showLogInvokeLater() {
        Runnable doLater = new Runnable(){

            @Override
            public void run() {
                OSPLog.showLog();
            }
        };
        EventQueue.invokeLater(doLater);
    }

    public static int getLevelValue() {
        if (OSPRuntime.appletMode || OSPRuntime.applet != null) {
            return MessageFrame.getLevelValue();
        }
        try {
            Level level = OSPLog.getOSPLog().getLogger().getLevel();
            if (level != null) {
                return level.intValue();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -1;
    }

    public static void setLevel(Level level) {
        if (OSPRuntime.appletMode || OSPRuntime.applet != null) {
            MessageFrame.setLevel(level);
        } else {
            try {
                OSPLog.getOSPLog().getLogger().setLevel(level);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (OSPLog.getOSPLog() == null || OSPLog.getOSPLog().menubarGroup == null) {
                return;
            }
            int i = 0;
            while (i < 2) {
                Enumeration<AbstractButton> e = OSPLog.getOSPLog().menubarGroup.getElements();
                if (i == 1) {
                    e = OSPLog.getOSPLog().popupGroup.getElements();
                }
                while (e.hasMoreElements()) {
                    JMenuItem item = (JMenuItem)e.nextElement();
                    if (!OSPLog.getOSPLog().getLogger().getLevel().toString().equals(item.getActionCommand())) continue;
                    item.setSelected(true);
                    break;
                }
                ++i;
            }
        }
    }

    public static Level parseLevel(String level) {
        int i = 0;
        while (i < levels.length) {
            if (levels[i].getName().equals(level)) {
                return levels[i];
            }
            ++i;
        }
        return null;
    }

    public static void severe(String msg) {
        if (OSPRuntime.appletMode || OSPRuntime.applet != null) {
            MessageFrame.severe(msg);
        } else {
            OSPLog.log(Level.SEVERE, msg);
        }
    }

    public static void warning(String msg) {
        if (OSPRuntime.appletMode || OSPRuntime.applet != null) {
            MessageFrame.warning(msg);
        } else {
            OSPLog.log(Level.WARNING, msg);
        }
    }

    public static void info(String msg) {
        if (OSPRuntime.appletMode || OSPRuntime.applet != null) {
            MessageFrame.info(msg);
        } else {
            OSPLog.log(Level.INFO, msg);
        }
    }

    public static void config(String msg) {
        if (OSPRuntime.appletMode || OSPRuntime.applet != null) {
            MessageFrame.config(msg);
        } else {
            OSPLog.log(Level.CONFIG, msg);
        }
    }

    public static void fine(String msg) {
        if (OSPRuntime.appletMode || OSPRuntime.applet != null) {
            MessageFrame.fine(msg);
        } else {
            OSPLog.log(Level.FINE, msg);
        }
    }

    public static void clearLog() {
        messageIndex = 0;
        if (OSPRuntime.appletMode || OSPRuntime.applet != null) {
            MessageFrame.clear();
        } else {
            OSPLOG.clear();
        }
    }

    public static void finer(String msg) {
        if (OSPRuntime.appletMode || OSPRuntime.applet != null) {
            MessageFrame.finer(msg);
        } else {
            OSPLog.log(Level.FINER, msg);
        }
    }

    public static void finest(String msg) {
        if (OSPRuntime.appletMode || OSPRuntime.applet != null) {
            MessageFrame.finest(msg);
        } else {
            OSPLog.log(Level.FINEST, msg);
        }
    }

    public static void setConsoleMessagesLogged(boolean log) {
        logConsole = log;
    }

    public static boolean isConsoleMessagesLogged() {
        return logConsole;
    }

    public OSPLog(Package pkg) {
        this(pkg.getName(), (String)null);
    }

    public OSPLog(Package pkg, String resourceBundleName) {
        this(pkg.getName(), resourceBundleName);
    }

    public OSPLog(Class<?> type) {
        this(type, null);
    }

    public OSPLog(Class<?> type, String resourceBundleName) {
        this(type.getPackage().getName(), resourceBundleName);
    }

    public JPanel getLogPanel() {
        return this.logPanel;
    }

    public void clear() {
        this.textPane.setText(null);
    }

    public String saveLog(String fileName) {
        if (fileName == null || fileName.trim().equals("")) {
            return this.saveLogAs();
        }
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(fileName));
            out.write(this.textPane.getText());
            out.flush();
            out.close();
            return fileName;
        }
        catch (IOException ex) {
            return null;
        }
    }

    public String saveLogAs() {
        int result = OSPLog.getChooser().showSaveDialog(null);
        if (result == 0) {
            int selected;
            File file = OSPLog.getChooser().getSelectedFile();
            if (file.exists() && (selected = JOptionPane.showConfirmDialog(this, String.valueOf(ControlsRes.getString("OSPLog.ReplaceExisting_dialog_message")) + file.getName() + ControlsRes.getString("OSPLog.question_mark"), ControlsRes.getString("OSPLog.ReplaceFile_dialog_title"), 1)) != 0) {
                return null;
            }
            String fileName = XML.getRelativePath(file.getAbsolutePath());
            return this.saveLog(fileName);
        }
        return null;
    }

    public String saveXML(String fileName) {
        if (OSPRuntime.appletMode || OSPRuntime.applet != null) {
            this.logger.log(Level.FINE, "Cannot save XML file when running as an applet.");
            return null;
        }
        if (fileName == null || fileName.trim().equals("")) {
            return this.saveXMLAs();
        }
        String xml = this.read(this.tempFileName);
        Handler fileHandler = this.getFileHandler();
        String tail = fileHandler.getFormatter().getTail(fileHandler);
        xml = String.valueOf(xml) + tail;
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(fileName));
            out.write(xml);
            out.flush();
            out.close();
            return fileName;
        }
        catch (IOException ex) {
            return null;
        }
    }

    public String saveXMLAs() {
        int result = OSPLog.getChooser().showSaveDialog(null);
        if (result == 0) {
            int selected;
            File file = OSPLog.getChooser().getSelectedFile();
            if (file.exists() && (selected = JOptionPane.showConfirmDialog(this, String.valueOf(ControlsRes.getString("OSPLog.ReplaceExisting_dialog_message")) + file.getName() + ControlsRes.getString("OSPLog.question_mark"), ControlsRes.getString("OSPLog.ReplaceFile_dialog_title"), 1)) != 0) {
                return null;
            }
            this.logFileName = XML.getRelativePath(file.getAbsolutePath());
            return this.saveXML(this.logFileName);
        }
        return null;
    }

    public String open() {
        int result = OSPLog.getChooser().showOpenDialog(null);
        if (result == 0) {
            File file = OSPLog.getChooser().getSelectedFile();
            String fileName = XML.getRelativePath(file.getAbsolutePath());
            return this.open(fileName);
        }
        return null;
    }

    public String open(String fileName) {
        this.textPane.setText(this.read(fileName));
        return fileName;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogToFile(boolean enable) {
        if (OSPRuntime.appletMode || OSPRuntime.applet != null) {
            this.logger.log(Level.FINE, "Cannot log to file when running as an applet.");
            return;
        }
        if (enable) {
            this.logToFileItem.setSelected(true);
            this.logger.addHandler(this.getFileHandler());
        } else {
            this.logToFileItem.setSelected(false);
            this.logger.removeHandler(this.fileHandler);
        }
    }

    @Override
    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    protected void createGUI() {
        this.logPanel = new JPanel(new BorderLayout());
        this.logPanel.setPreferredSize(new Dimension(480, 240));
        this.setContentPane(this.logPanel);
        this.textPane = new JTextPane(){

            @Override
            public void paintComponent(Graphics g) {
                if (OSPRuntime.antiAliasText.booleanValue()) {
                    Graphics2D g2 = (Graphics2D)g;
                    RenderingHints rh = g2.getRenderingHints();
                    rh.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                    rh.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                }
                super.paintComponent(g);
            }
        };
        this.textPane.setEditable(false);
        this.textPane.setAutoscrolls(true);
        JScrollPane textScroller = new JScrollPane(this.textPane);
        textScroller.setWheelScrollingEnabled(true);
        this.logPanel.add((Component)textScroller, "Center");
        black = StyleContext.getDefaultStyleContext().getStyle("default");
        red = this.textPane.addStyle("red", black);
        StyleConstants.setForeground(red, DARK_RED);
        blue = this.textPane.addStyle("blue", black);
        StyleConstants.setForeground(blue, DARK_BLUE);
        green = this.textPane.addStyle("green", black);
        StyleConstants.setForeground(green, DARK_GREEN);
        magenta = this.textPane.addStyle("magenta", black);
        StyleConstants.setForeground(magenta, Color.MAGENTA);
        gray = this.textPane.addStyle("gray", black);
        StyleConstants.setForeground(gray, Color.GRAY);
        this.createLogger();
        this.createMenus();
        this.pack();
        this.textPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                try {
                    if (OSPRuntime.isPopupTrigger(e) && OSPLog.this.popup != null) {
                        FontSizer.setFonts(OSPLog.this.popup, FontSizer.getLevel());
                        OSPLog.this.popup.show(OSPLog.this.textPane, e.getX(), e.getY() + 8);
                    }
                }
                catch (Exception ex) {
                    System.err.println("Error in mouse action.");
                    System.err.println(ex.toString());
                    ex.printStackTrace();
                }
            }
        });
    }

    protected Logger createLogger() {
        if (this.bundleName != null) {
            try {
                this.logger = Logger.getLogger(this.pkgName, this.bundleName);
            }
            catch (Exception ex) {
                this.logger = Logger.getLogger(this.pkgName);
            }
        } else {
            this.logger = Logger.getLogger(this.pkgName);
        }
        try {
            this.logger.setLevel(defaultLevel);
            this.logHandler = new OSPLogHandler(this.textPane, this);
            this.logHandler.setFormatter(new ConsoleFormatter());
            this.logHandler.setLevel(Level.ALL);
            OSPRuntime.class.getClass();
            this.logger.setUseParentHandlers(false);
            this.logger.addHandler(this.logHandler);
        }
        catch (SecurityException ex) {
            this.hasPermission = false;
        }
        return this.logger;
    }

    protected synchronized Handler getFileHandler() {
        if (this.fileHandler != null) {
            return this.fileHandler;
        }
        try {
            int i = this.pkgName.lastIndexOf(".");
            if (i > -1) {
                this.pkgName = this.pkgName.substring(i + 1);
            }
            this.tempFileName = logdir.endsWith(slash) ? String.valueOf(logdir) + this.pkgName + ".log" : String.valueOf(logdir) + slash + this.pkgName + ".log";
            this.fileHandler = new FileHandler(this.tempFileName);
            this.fileHandler.setFormatter(new XMLFormatter());
            this.fileHandler.setLevel(Level.ALL);
            this.logger.addHandler(this.fileHandler);
            this.logger.log(Level.INFO, "Logging to file enabled. File = " + this.tempFileName);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return this.fileHandler;
    }

    protected void createMenus() {
        if (!this.hasPermission) {
            return;
        }
        this.popup = new JPopupMenu();
        JMenu menu = new JMenu(ControlsRes.getString("OSPLog.Level_menu"));
        this.popup.add(menu);
        this.popupGroup = new ButtonGroup();
        int i = 0;
        while (i < levels.length) {
            JRadioButtonMenuItem item = new JRadioButtonMenuItem(levels[i].getName());
            menu.add((Component)item, 0);
            this.popupGroup.add(item);
            if (this.logger.getLevel().toString().equals(levels[i])) {
                item.setSelected(true);
            }
            item.setActionCommand(levels[i].getName());
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    OSPLog.this.logger.setLevel(Level.parse(e.getActionCommand()));
                    Enumeration<AbstractButton> e2 = OSPLog.this.menubarGroup.getElements();
                    while (e2.hasMoreElements()) {
                        JMenuItem item = (JMenuItem)e2.nextElement();
                        if (!OSPLog.this.logger.getLevel().toString().equals(item.getActionCommand())) continue;
                        item.setSelected(true);
                        break;
                    }
                }
            });
            ++i;
        }
        this.popup.addSeparator();
        AbstractAction openAction = new AbstractAction(ControlsRes.getString("OSPLog.Open_popup")){

            @Override
            public void actionPerformed(ActionEvent e) {
                OSPLog.this.open();
            }
        };
        openAction.setEnabled(!OSPRuntime.appletMode && OSPRuntime.applet == null);
        this.popup.add(openAction);
        AbstractAction saveAsAction = new AbstractAction(ControlsRes.getString("OSPLog.SaveAs_popup")){

            @Override
            public void actionPerformed(ActionEvent e) {
                OSPLog.this.saveLogAs();
            }
        };
        saveAsAction.setEnabled(!OSPRuntime.appletMode && OSPRuntime.applet == null);
        this.popup.add(saveAsAction);
        this.popup.addSeparator();
        AbstractAction clearAction = new AbstractAction(ControlsRes.getString("OSPLog.Clear_popup")){

            @Override
            public void actionPerformed(ActionEvent e) {
                OSPLog.this.clear();
            }
        };
        this.popup.add(clearAction);
        JMenuBar menubar = new JMenuBar();
        this.setJMenuBar(menubar);
        menu = new JMenu(ControlsRes.getString("OSPLog.File_menu"));
        menubar.add(menu);
        menu.add(openAction);
        menu.add(saveAsAction);
        menu = new JMenu(ControlsRes.getString("OSPLog.Edit_menu"));
        menubar.add(menu);
        menu.add(clearAction);
        menu = new JMenu(ControlsRes.getString("OSPLog.Level_menu"));
        menubar.add(menu);
        this.menubarGroup = new ButtonGroup();
        int i2 = 0;
        while (i2 < levels.length) {
            JRadioButtonMenuItem item = new JRadioButtonMenuItem(levels[i2].getName());
            menu.add((Component)item, 0);
            this.menubarGroup.add(item);
            if (this.logger.getLevel().toString().equals(levels[i2])) {
                item.setSelected(true);
            }
            item.setActionCommand(levels[i2].getName());
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    OSPLog.this.logger.setLevel(Level.parse(e.getActionCommand()));
                    Enumeration<AbstractButton> e2 = OSPLog.this.popupGroup.getElements();
                    while (e2.hasMoreElements()) {
                        JMenuItem item = (JMenuItem)e2.nextElement();
                        if (!OSPLog.this.logger.getLevel().toString().equals(item.getActionCommand())) continue;
                        item.setSelected(true);
                        break;
                    }
                }
            });
            ++i2;
        }
        JMenu prefMenu = new JMenu(ControlsRes.getString("OSPLog.Options_menu"));
        menubar.add(prefMenu);
        this.logToFileItem = new JCheckBoxMenuItem(ControlsRes.getString("OSPLog.LogToFile_check_box"));
        this.logToFileItem.setSelected(false);
        this.logToFileItem.setEnabled(!OSPRuntime.appletMode && OSPRuntime.applet == null);
        this.logToFileItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBoxMenuItem item = (JCheckBoxMenuItem)e.getSource();
                OSPLog.this.setLogToFile(item.isSelected());
            }
        });
        prefMenu.add(this.logToFileItem);
    }

    protected static JFileChooser getChooser() {
        if (chooser == null) {
            chooser = new JFileChooser(new File(OSPRuntime.chooserDir));
        }
        FontSizer.setFonts(chooser, FontSizer.getLevel());
        return chooser;
    }

    protected String read(String fileName) {
        File file = new File(fileName);
        StringBuffer buffer = null;
        try {
            BufferedReader in = new BufferedReader(new FileReader(file));
            buffer = new StringBuffer();
            String line = in.readLine();
            while (line != null) {
                buffer.append(String.valueOf(line) + XML.NEW_LINE);
                line = in.readLine();
            }
            in.close();
        }
        catch (IOException ex) {
            this.logger.warning(ex.toString());
        }
        return buffer.toString();
    }

    private OSPLog(String name, String resourceBundleName) {
        super(ControlsRes.getString("OSPLog.DefaultTitle"));
        this.setName("LogTool");
        this.bundleName = resourceBundleName;
        this.pkgName = name;
        ConsoleLevel.class.getName();
        this.createGUI();
        this.setDefaultCloseOperation(1);
    }

    private static void log(Level level, String msg) {
        LogRecord record = new LogRecord(level, msg);
        StackTraceElement[] stack = new Throwable().getStackTrace();
        int i = 0;
        while (i < stack.length) {
            StackTraceElement el = stack[i];
            String className = el.getClassName();
            if (!className.equals("org.opensourcephysics.controls.OSPLog")) {
                record.setSourceClassName(className);
                record.setSourceMethodName(el.getMethodName());
                break;
            }
            ++i;
        }
        if (OSPLOG != null) {
            OSPLOG.getLogger().log(record);
        } else {
            OSPLog.messageStorage[OSPLog.messageIndex] = record;
            ++messageIndex;
            messageIndex %= messageStorage.length;
        }
    }
}

