/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.utils;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.utils.LocaleItem;
import org.colos.ejs.library.utils.LocaleSelector;
import org.colos.ejs.library.utils.TranslatorUtil;
import org.opensourcephysics.tools.Resource;
import org.opensourcephysics.tools.ResourceLoader;
import org.opensourcephysics.tools.ToolsRes;

public class TranslatorResourceUtil
extends TranslatorUtil {
    private String classname;
    private Simulation simulation;
    private Map<LocaleItem, Map<String, String>> translations = new HashMap<LocaleItem, Map<String, String>>();
    private Map<String, String> currentTranslation;
    private JMenu langMenu = null;
    private LocaleSelector localeSelector;

    public TranslatorResourceUtil(String _classname) {
        this.classname = _classname.replace('.', '/');
        this.currentTranslation = this.defaultProperties;
        TranslatorResourceUtil.readPropertiesFile(this.defaultProperties, this.classname);
        this.translations.put(LocaleItem.getDefaultItem(), this.defaultProperties);
    }

    @Override
    public JComponent getSelectorComponent(Simulation _simulation) {
        this.simulation = _simulation;
        if (this.localeSelector == null) {
            this.localeSelector = new LocaleSelector(this.simulation);
            this.localeSelector.setEditable(false);
            for (LocaleItem item : this.translations.keySet()) {
                this.localeSelector.addLocaleItem(item);
            }
        }
        return this.localeSelector.getComponent();
    }

    @Override
    protected String getValueOf(String _keyword) {
        String value = this.currentTranslation.get(_keyword);
        if (value == null) {
            value = (String)this.defaultProperties.get(_keyword);
        }
        return value;
    }

    @Override
    public void addTranslation(String _language) {
        LocaleItem item = LocaleItem.getLocaleItem(_language);
        if (item != null) {
            Map<String, String> translation = this.translations.get(item);
            if (translation != null) {
                return;
            }
            translation = new HashMap<String, String>();
            TranslatorResourceUtil.readPropertiesFile(translation, String.valueOf(this.classname) + "_" + item.getKeyword());
            this.translations.put(item, translation);
        } else {
            System.out.println("Warning! Ignored invalid locale " + _language);
        }
    }

    @Override
    public void setLocaleItem(LocaleItem _item) {
        this.currentTranslation = this.translations.get(_item);
        if (this.currentTranslation == null) {
            this.currentTranslation = this.defaultProperties;
        }
        if (this.localeSelector != null) {
            this.localeSelector.refreshGUI(_item);
        }
    }

    @Override
    public void addToMenu(JMenu _menu, Simulation _simulation) {
        this.simulation = _simulation;
        this.langMenu = new JMenu(ToolsRes.getString("TranslatorTool.Label.Description"));
        _menu.add(this.langMenu);
    }

    @Override
    public void refreshMenu() {
        if (this.langMenu == null) {
            return;
        }
        this.langMenu.removeAll();
        ArrayList<LocaleItem> localeItems = new ArrayList<LocaleItem>(this.translations.keySet());
        Collections.sort(localeItems);
        for (LocaleItem localeItem : localeItems) {
            this.langMenu.add(new MyMenuItem(localeItem));
        }
    }

    private static boolean readPropertiesFile(Map<String, String> _translation, String _filename) {
        Resource resourceFile = ResourceLoader.getResource(String.valueOf(_filename) + ".properties");
        if (resourceFile == null) {
            System.out.println("Warning! Ignored unavailable resource file : " + _filename + ".properties.");
            return false;
        }
        try {
            InputStream stream = resourceFile.openInputStream();
            BufferedReader input = new BufferedReader(new InputStreamReader(stream, LocaleItem.getCharset()));
            String next = input.readLine();
            while (next != null) {
                int i = next.indexOf("=");
                if (i > -1) {
                    String key = next.substring(0, i);
                    String val = next.substring(i + 1);
                    _translation.put(key, val);
                }
                next = input.readLine();
            }
            return true;
        }
        catch (IOException iOException) {
            System.out.println("Warning! Error reading resource file " + _filename + ".");
            return false;
        }
    }

    private class MyMenuItem
    extends JMenuItem {
        LocaleItem item;

        MyMenuItem(LocaleItem _item) {
            super(_item.toString());
            this.item = _item;
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TranslatorResourceUtil.this.simulation.setLocaleItem(MyMenuItem.this.item);
                }
            });
        }
    }
}

