/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Image;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.control.ControlElement;
import org.colos.ejs.library.control.EjsControl;
import org.colos.ejs.library.control.swing.ControlSwingElement;
import org.colos.ejs.library.control.swing.ControlWindow;
import org.colos.ejs.library.control.value.BooleanValue;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.display.TeXParser;
import org.opensourcephysics.tools.ResourceLoader;

public class ControlFrame
extends ControlWindow {
    private static final int FRAME_ADDED = 6;
    private static final int FRAME_NAME = 12;
    protected JFrame frame;
    protected String iconImageFile = null;
    private static List<String> infoList = null;

    @Override
    protected Component createVisual() {
        Image image;
        this.startingup = true;
        this.frame = new JFrame(EjsControl.getDefaultGraphicsConfiguration());
        this.frame.getContentPane().setLayout(new BorderLayout());
        String path = Simulation.getPathToLibrary();
        if (!path.endsWith("/")) {
            path = String.valueOf(path) + "/";
        }
        if ((image = ResourceLoader.getImage(String.valueOf(path) + "_ejs_library/images/EjsMainIcon.gif")) != null) {
            this.frame.setIconImage(image);
        }
        this.frame.setDefaultCloseOperation(1);
        this.internalValue = new BooleanValue(true);
        this.frame.getContentPane().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent _e) {
                if (_e.isControlDown() && ControlFrame.this.getSimulation() != null) {
                    if (_e.getKeyCode() == 77) {
                        ControlFrame.this.getPopupMenu(0, 0);
                    } else if (_e.getKeyCode() == 80) {
                        ControlFrame.this.printScreen();
                    }
                }
            }
        });
        this.frame.getContentPane().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent _evt) {
                if (ControlFrame.this.getSimulation() != null && OSPRuntime.isPopupTrigger(_evt)) {
                    ControlFrame.this.getPopupMenu(_evt.getX(), _evt.getY());
                }
            }
        });
        return this.frame.getContentPane();
    }

    @Override
    public String getObjectClassname() {
        return "java.awt.Component";
    }

    @Override
    public Object getObject() {
        return this.frame;
    }

    @Override
    protected JRootPane getRootPane() {
        return this.frame.getRootPane();
    }

    @Override
    public JMenuBar getJMenuBar() {
        return this.frame.getJMenuBar();
    }

    @Override
    protected void whenClosing() {
        super.whenClosing();
        if (this.frame.getDefaultCloseOperation() == 3 || this.frame.getDefaultCloseOperation() == 2) {
            this.invokeActions();
            Simulation sim = this.getSimulation();
            if (sim != null) {
                sim.pause();
                sim.onExit();
            }
        }
    }

    @Override
    protected int getVisibleIndex() {
        return 16;
    }

    @Override
    protected int getLocationIndex() {
        return 7;
    }

    @Override
    protected int getSizeIndex() {
        return 17;
    }

    @Override
    public Component getComponent() {
        return this.frame;
    }

    public JFrame getJFrame() {
        return this.frame;
    }

    @Override
    public Container getContainer() {
        return this.frame.getContentPane();
    }

    @Override
    public void add(final ControlElement _child) {
        if (!(_child.getVisual() instanceof JMenuBar)) {
            super.add(_child);
            return;
        }
        this.children.add(_child);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ControlFrame.this.menubar = (JMenuBar)_child.getVisual();
                ControlFrame.this.frame.setJMenuBar(ControlFrame.this.menubar);
                ControlFrame.this.adjustSize();
            }
        });
        ((ControlSwingElement)_child).setControlWindow(this);
        this.propagateProperty(_child, "font", this.getPropagatedProperty("font"));
        this.propagateProperty(_child, "foreground", this.getPropagatedProperty("foreground"));
        this.propagateProperty(_child, "background", this.getPropagatedProperty("background"));
    }

    @Override
    public void remove(ControlElement _child) {
        if (!(_child.getVisual() instanceof JMenuBar)) {
            super.remove(_child);
            return;
        }
        this.children.remove(_child);
        ((ControlSwingElement)_child).setControlWindow(null);
        this.menubar = null;
        this.frame.setJMenuBar(null);
        this.adjustSize();
        this.frame.validate();
        this.frame.repaint();
    }

    @Override
    public List<String> getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList<String>();
            infoList.add("title");
            infoList.add("resizable");
            infoList.add("exit");
            infoList.add("onExit");
            infoList.add("image");
            infoList.add("glasspane");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    @Override
    public String getPropertyInfo(String _property) {
        if (_property.equals("title")) {
            return "String TRANSLATABLE";
        }
        if (_property.equals("resizable")) {
            return "boolean";
        }
        if (_property.equals("exit")) {
            return "boolean CONSTANT";
        }
        if (_property.equals("onExit")) {
            return "Action CONSTANT";
        }
        if (_property.equals("image")) {
            return "File|String TRANSLATABLE";
        }
        if (_property.equals("glasspane")) {
            return "boolean";
        }
        return super.getPropertyInfo(_property);
    }

    @Override
    public void setValue(int _index, Value _value) {
        switch (_index) {
            case 0: {
                String ejsWindow = this.getProperty("_ejs_window_");
                if (ejsWindow != null) {
                    this.frame.setTitle(String.valueOf(TeXParser.parseTeX(_value.getString())) + " " + ejsWindow);
                    break;
                }
                this.frame.setTitle(TeXParser.parseTeX(_value.getString()));
                break;
            }
            case 1: {
                this.frame.setResizable(_value.getBoolean());
                break;
            }
            case 2: {
                if (this.getProperty("_ejs_") != null) break;
                if (_value.getBoolean()) {
                    this.frame.setDefaultCloseOperation(OSPRuntime.appletMode ? 2 : 3);
                    break;
                }
                this.frame.setDefaultCloseOperation(1);
                break;
            }
            case 3: {
                this.removeAction(0, this.getProperty("onExit"));
                this.addAction(0, _value.getString());
                break;
            }
            case 4: {
                if (_value.getString().equals(this.iconImageFile)) {
                    return;
                }
                this.iconImageFile = _value.getString();
                this.frame.setIconImage(ControlSwingElement.getImage(this.iconImageFile));
                break;
            }
            case 5: {
                this.frame.getGlassPane().setVisible(_value.getBoolean());
                break;
            }
            case 12: {
                super.setValue(6, _value);
                if (this.getGroup() == null || this.getGroup().getOwnerFrame() != this.getComponent()) break;
                String replacement = this.getGroup().getReplaceOwnerName();
                if (replacement != null && replacement.equals(_value.getString())) {
                    this.getGroup().setOwnerFrame(this.getGroup().getReplaceOwnerFrame());
                    break;
                }
                this.getGroup().setOwnerFrame(this.frame);
                break;
            }
            default: {
                super.setValue(_index - 6, _value);
            }
        }
    }

    @Override
    public void setDefaultValue(int _index) {
        switch (_index) {
            case 0: {
                String ejsWindow = this.getProperty("_ejs_window_");
                if (ejsWindow != null) {
                    this.frame.setTitle(ejsWindow);
                    break;
                }
                this.frame.setTitle("");
                break;
            }
            case 1: {
                this.frame.setResizable(true);
                break;
            }
            case 2: {
                if (this.getProperty("_ejs_") != null) break;
                this.frame.setDefaultCloseOperation(1);
                break;
            }
            case 3: {
                this.removeAction(0, this.getProperty("onExit"));
                break;
            }
            case 4: {
                this.iconImageFile = null;
                this.frame.setIconImage(null);
                break;
            }
            case 5: {
                this.frame.getGlassPane().setVisible(false);
                break;
            }
            case 12: {
                super.setDefaultValue(6);
                if (this.getGroup() == null || this.getGroup().getOwnerFrame() != this.getComponent()) break;
                this.getGroup().setOwnerFrame(this.frame);
                break;
            }
            default: {
                super.setDefaultValue(_index - 6);
            }
        }
    }

    @Override
    public String getDefaultValueString(int _index) {
        switch (_index) {
            case 0: {
                return "<none>";
            }
            case 1: {
                return "true";
            }
            case 2: {
                return "<none>";
            }
            case 3: {
                return "<no_action>";
            }
            case 4: {
                return "<none>";
            }
            case 5: {
                return "false";
            }
        }
        return super.getDefaultValueString(_index - 6);
    }

    @Override
    public Value getValue(int _index) {
        switch (_index) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return null;
            }
        }
        return super.getValue(_index - 6);
    }
}

