/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.xuggler.io;

import com.xuggle.xuggler.io.DataInputOutputHandler;
import com.xuggle.xuggler.io.IURLProtocolHandler;
import com.xuggle.xuggler.io.IURLProtocolHandlerFactory;
import com.xuggle.xuggler.io.InputOutputStreamHandler;
import com.xuggle.xuggler.io.ReadableWritableChannelHandler;
import com.xuggle.xuggler.io.URLProtocolManager;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.channels.ByteChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XugglerIO
implements IURLProtocolHandlerFactory {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    public static final String DEFAULT_PROTOCOL = "xuggler";
    private static final boolean DEFAULT_UNMAP_URL_ON_OPEN = true;
    private static final boolean DEFAULT_CLOSE_STREAM_ON_CLOSE = true;
    private ConcurrentMap<String, RegistrationInformation> mURLs = new ConcurrentHashMap<String, RegistrationInformation>();
    private static final XugglerIO mFactory = new XugglerIO();

    XugglerIO() {
    }

    static XugglerIO registerFactory(String protocolPrefix) {
        URLProtocolManager manager = URLProtocolManager.getManager();
        manager.registerFactory(protocolPrefix, mFactory);
        return mFactory;
    }

    public static XugglerIO getFactory() {
        return mFactory;
    }

    public static String generateUniqueName(Object src) {
        return XugglerIO.generateUniqueName(src, null);
    }

    public static String generateUniqueName(Object src, String extension) {
        StringBuilder builder = new StringBuilder();
        builder.append(UUID.randomUUID().toString());
        if (src != null) {
            builder.append("-");
            builder.append(src.getClass().getName());
            builder.append("-");
            builder.append(Integer.toHexString(src.hashCode()));
        }
        if (extension != null) {
            builder.append(extension);
        }
        return builder.toString();
    }

    public static String map(IURLProtocolHandler handler) {
        return XugglerIO.map(XugglerIO.generateUniqueName(handler), handler, true);
    }

    public static String map(String url, IURLProtocolHandler handler) {
        return XugglerIO.map(url, handler, true);
    }

    public static String map(DataInput input) {
        return XugglerIO.map(XugglerIO.generateUniqueName(input), input, null, true, true);
    }

    public static String map(String url, DataInput input) {
        return XugglerIO.map(url, input, null, true, true);
    }

    public static String map(DataOutput output) {
        return XugglerIO.map(XugglerIO.generateUniqueName(output), null, output, true, true);
    }

    public static String map(String url, DataOutput output) {
        return XugglerIO.map(url, null, output, true, true);
    }

    public static String map(RandomAccessFile file) {
        return XugglerIO.map(XugglerIO.generateUniqueName(file), file, file, true, true);
    }

    public static String map(String url, RandomAccessFile file) {
        return XugglerIO.map(url, file, file, true, true);
    }

    public static String map(ReadableByteChannel channel) {
        return XugglerIO.map(XugglerIO.generateUniqueName(channel), channel, null, true, true);
    }

    public static String map(String url, ReadableByteChannel channel) {
        return XugglerIO.map(url, channel, null, true, true);
    }

    public static String map(WritableByteChannel channel) {
        return XugglerIO.map(XugglerIO.generateUniqueName(channel), null, channel, true, true);
    }

    public static String map(String url, WritableByteChannel channel) {
        return XugglerIO.map(url, null, channel, true, true);
    }

    public static String map(ByteChannel channel) {
        return XugglerIO.map(XugglerIO.generateUniqueName(channel), channel, channel, true, true);
    }

    public static String map(String url, ByteChannel channel) {
        return XugglerIO.map(url, channel, channel, true, true);
    }

    public static String map(InputStream in) {
        return XugglerIO.map(XugglerIO.generateUniqueName(in), in, null, true, true);
    }

    public static String map(String url, InputStream in) {
        return XugglerIO.map(url, in, null, true, true);
    }

    public static String map(OutputStream out) {
        return XugglerIO.map(XugglerIO.generateUniqueName(out), null, out, true, true);
    }

    public static String map(String url, OutputStream out) {
        return XugglerIO.map(url, null, out, true, true);
    }

    public static String map(String url, DataInput in, DataOutput out, boolean unmapOnOpen, boolean closeOnClose) {
        return XugglerIO.map(url, new DataInputOutputHandler(in, out, closeOnClose));
    }

    public static String map(String url, ReadableByteChannel in, WritableByteChannel out, boolean unmapOnOpen, boolean closeOnClose) {
        return XugglerIO.map(url, new ReadableWritableChannelHandler(in, out, closeOnClose));
    }

    public static String map(String url, InputStream in, OutputStream out, boolean unmapOnOpen, boolean closeOnClose) {
        return XugglerIO.map(url, new InputOutputStreamHandler(in, out, closeOnClose));
    }

    public static String map(String url, IURLProtocolHandler handler, boolean unmapUrlOnOpen) {
        if (mFactory.mapIO(url, handler, unmapUrlOnOpen) != null) {
            throw new RuntimeException("url is already mapped: " + url);
        }
        return "xuggler:" + URLProtocolManager.getResourceFromURL(url);
    }

    public static IURLProtocolHandler unmap(String url) {
        return mFactory.unmapIO(url);
    }

    public IURLProtocolHandler mapIO(String url, IURLProtocolHandler handler, boolean unmapUrlOnOpen) {
        RegistrationInformation tuple;
        if (url == null || url.length() <= 0) {
            throw new IllegalArgumentException("must pass in non-zero url");
        }
        if (handler == null) {
            throw new IllegalArgumentException("must pass in a non null handler");
        }
        String streamName = URLProtocolManager.getResourceFromURL(url);
        RegistrationInformation oldTuple = this.mURLs.putIfAbsent(streamName, tuple = new RegistrationInformation(streamName, handler, unmapUrlOnOpen));
        return oldTuple == null ? null : oldTuple.getHandler();
    }

    public IURLProtocolHandler unmapIO(String url) {
        if (url == null || url.length() <= 0) {
            throw new IllegalArgumentException("must pass in non-zero url");
        }
        String streamName = URLProtocolManager.getResourceFromURL(url);
        RegistrationInformation oldTuple = (RegistrationInformation)this.mURLs.remove(streamName);
        return oldTuple == null ? null : oldTuple.getHandler();
    }

    @Override
    public IURLProtocolHandler getHandler(String protocol, String url, int flags) {
        String streamName = URLProtocolManager.getResourceFromURL(url);
        RegistrationInformation tuple = (RegistrationInformation)this.mURLs.get(streamName);
        if (tuple != null) {
            IURLProtocolHandler handler = tuple.getHandler();
            if (tuple.isUnmappingOnOpen()) {
                IURLProtocolHandler oldHandler = this.unmapIO(tuple.getName());
                if (handler != null && !handler.equals(oldHandler)) {
                    this.log.error("stream {} already unmapped; it was likely already opened", (Object)tuple.getName());
                    return null;
                }
            }
            return handler;
        }
        return null;
    }

    static {
        XugglerIO.registerFactory(DEFAULT_PROTOCOL);
    }

    private static class RegistrationInformation {
        private final String mName;
        private final boolean mIsUnmappingOnOpen;
        private final IURLProtocolHandler mHandler;

        public RegistrationInformation(String streamName, IURLProtocolHandler handler, boolean unmapUrlOnOpen) {
            this.mName = streamName;
            this.mHandler = handler;
            this.mIsUnmappingOnOpen = unmapUrlOnOpen;
        }

        public String getName() {
            return this.mName;
        }

        public boolean isUnmappingOnOpen() {
            return this.mIsUnmappingOnOpen;
        }

        public IURLProtocolHandler getHandler() {
            return this.mHandler;
        }
    }
}

