/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.xuggler;

import com.xuggle.ferry.IBuffer;
import com.xuggle.ferry.RefCounted;
import com.xuggle.xuggler.IContainer;
import com.xuggle.xuggler.IIndexEntry;
import com.xuggle.xuggler.IMetaData;
import com.xuggle.xuggler.IPacket;
import com.xuggle.xuggler.IRational;
import com.xuggle.xuggler.IStreamCoder;
import com.xuggle.xuggler.XugglerJNI;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;

public class IStream
extends RefCounted {
    private volatile long swigCPtr;

    private void noop() {
        IBuffer.make(null, 1);
    }

    protected IStream(long cPtr, boolean cMemoryOwn) {
        super(XugglerJNI.SWIGIStreamUpcast(cPtr), cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    protected IStream(long cPtr, boolean cMemoryOwn, AtomicLong ref) {
        super(XugglerJNI.SWIGIStreamUpcast(cPtr), cMemoryOwn, ref);
        this.swigCPtr = cPtr;
    }

    public static long getCPtr(IStream obj) {
        if (obj == null) {
            return 0L;
        }
        return obj.getMyCPtr();
    }

    @Override
    public long getMyCPtr() {
        if (this.swigCPtr == 0L) {
            throw new IllegalStateException("underlying native object already deleted");
        }
        return this.swigCPtr;
    }

    @Override
    public IStream copyReference() {
        if (this.swigCPtr == 0L) {
            return null;
        }
        return new IStream(this.swigCPtr, this.swigCMemOwn, this.getJavaRefCount());
    }

    public boolean equals(Object obj) {
        boolean equal = false;
        if (obj instanceof IStream) {
            equal = ((IStream)obj).swigCPtr == this.swigCPtr;
        }
        return equal;
    }

    public int hashCode() {
        return (int)this.swigCPtr;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getName() + "@" + this.hashCode() + "[");
        result.append("index:" + this.getIndex() + ";");
        result.append("id:" + this.getId() + ";");
        result.append("streamcoder:" + this.getStreamCoder() + ";");
        result.append("framerate:" + this.getFrameRate() + ";");
        result.append("timebase:" + this.getTimeBase() + ";");
        result.append("direction:" + (Object)((Object)this.getDirection()) + ";");
        result.append("]");
        return result.toString();
    }

    public List<IIndexEntry> getIndexEntries() {
        int numEntries = this.getNumIndexEntries();
        ArrayList<IIndexEntry> retval = new ArrayList<IIndexEntry>(Math.max(numEntries, 10));
        for (int i = 0; i < numEntries; ++i) {
            IIndexEntry entry = this.getIndexEntry(i);
            if (entry == null) continue;
            retval.add(entry);
        }
        return retval;
    }

    public Direction getDirection() {
        return Direction.swigToEnum(XugglerJNI.IStream_getDirection(this.swigCPtr, this));
    }

    public int getIndex() {
        return XugglerJNI.IStream_getIndex(this.swigCPtr, this);
    }

    public int getId() {
        return XugglerJNI.IStream_getId(this.swigCPtr, this);
    }

    public IStreamCoder getStreamCoder() {
        long cPtr = XugglerJNI.IStream_getStreamCoder(this.swigCPtr, this);
        return cPtr == 0L ? null : new IStreamCoder(cPtr, false);
    }

    public IRational getFrameRate() {
        long cPtr = XugglerJNI.IStream_getFrameRate(this.swigCPtr, this);
        return cPtr == 0L ? null : new IRational(cPtr, false);
    }

    public IRational getTimeBase() {
        long cPtr = XugglerJNI.IStream_getTimeBase(this.swigCPtr, this);
        return cPtr == 0L ? null : new IRational(cPtr, false);
    }

    public long getStartTime() {
        return XugglerJNI.IStream_getStartTime(this.swigCPtr, this);
    }

    public long getDuration() {
        return XugglerJNI.IStream_getDuration(this.swigCPtr, this);
    }

    public long getCurrentDts() {
        return XugglerJNI.IStream_getCurrentDts(this.swigCPtr, this);
    }

    public int getNumIndexEntries() {
        return XugglerJNI.IStream_getNumIndexEntries(this.swigCPtr, this);
    }

    public long getNumFrames() {
        return XugglerJNI.IStream_getNumFrames(this.swigCPtr, this);
    }

    public IRational getSampleAspectRatio() {
        long cPtr = XugglerJNI.IStream_getSampleAspectRatio(this.swigCPtr, this);
        return cPtr == 0L ? null : new IRational(cPtr, false);
    }

    public void setSampleAspectRatio(IRational newRatio) {
        XugglerJNI.IStream_setSampleAspectRatio(this.swigCPtr, this, IRational.getCPtr(newRatio), newRatio);
    }

    public String getLanguage() {
        return XugglerJNI.IStream_getLanguage(this.swigCPtr, this);
    }

    public void setLanguage(String language) {
        XugglerJNI.IStream_setLanguage(this.swigCPtr, this, language);
    }

    public IContainer getContainer() {
        long cPtr = XugglerJNI.IStream_getContainer(this.swigCPtr, this);
        return cPtr == 0L ? null : new IContainer(cPtr, false);
    }

    public int setStreamCoder(IStreamCoder newCoder) {
        return XugglerJNI.IStream_setStreamCoder__SWIG_0(this.swigCPtr, this, IStreamCoder.getCPtr(newCoder), newCoder);
    }

    public ParseType getParseType() {
        return ParseType.swigToEnum(XugglerJNI.IStream_getParseType(this.swigCPtr, this));
    }

    public void setParseType(ParseType type) {
        XugglerJNI.IStream_setParseType(this.swigCPtr, this, type.swigValue());
    }

    public IMetaData getMetaData() {
        long cPtr = XugglerJNI.IStream_getMetaData(this.swigCPtr, this);
        return cPtr == 0L ? null : new IMetaData(cPtr, false);
    }

    public void setMetaData(IMetaData data) {
        XugglerJNI.IStream_setMetaData(this.swigCPtr, this, IMetaData.getCPtr(data), data);
    }

    public int stampOutputPacket(IPacket packet) {
        return XugglerJNI.IStream_stampOutputPacket(this.swigCPtr, this, IPacket.getCPtr(packet), packet);
    }

    public int setStreamCoder(IStreamCoder newCoder, boolean assumeOnlyStream) {
        return XugglerJNI.IStream_setStreamCoder__SWIG_1(this.swigCPtr, this, IStreamCoder.getCPtr(newCoder), newCoder, assumeOnlyStream);
    }

    public IIndexEntry findTimeStampEntryInIndex(long wantedTimeStamp, int flags) {
        long cPtr = XugglerJNI.IStream_findTimeStampEntryInIndex(this.swigCPtr, this, wantedTimeStamp, flags);
        return cPtr == 0L ? null : new IIndexEntry(cPtr, false);
    }

    public int findTimeStampPositionInIndex(long wantedTimeStamp, int flags) {
        return XugglerJNI.IStream_findTimeStampPositionInIndex(this.swigCPtr, this, wantedTimeStamp, flags);
    }

    public IIndexEntry getIndexEntry(int position) {
        long cPtr = XugglerJNI.IStream_getIndexEntry(this.swigCPtr, this, position);
        return cPtr == 0L ? null : new IIndexEntry(cPtr, false);
    }

    public int addIndexEntry(IIndexEntry entry) {
        return XugglerJNI.IStream_addIndexEntry(this.swigCPtr, this, IIndexEntry.getCPtr(entry), entry);
    }

    public static enum ParseType {
        PARSE_NONE,
        PARSE_FULL,
        PARSE_HEADERS,
        PARSE_TIMESTAMPS;

        private final int swigValue;

        public final int swigValue() {
            return this.swigValue;
        }

        public static ParseType swigToEnum(int swigValue) {
            ParseType[] swigValues = (ParseType[])ParseType.class.getEnumConstants();
            if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue) {
                return swigValues[swigValue];
            }
            for (ParseType swigEnum : swigValues) {
                if (swigEnum.swigValue != swigValue) continue;
                return swigEnum;
            }
            throw new IllegalArgumentException("No enum " + ParseType.class + " with value " + swigValue);
        }

        private ParseType() {
            this.swigValue = SwigNext.next++;
        }

        private ParseType(int swigValue) {
            this.swigValue = swigValue;
            SwigNext.next = swigValue + 1;
        }

        private ParseType(ParseType swigEnum) {
            this.swigValue = swigEnum.swigValue;
            SwigNext.next = this.swigValue + 1;
        }

        private static class SwigNext {
            private static int next = 0;

            private SwigNext() {
            }
        }
    }

    public static enum Direction {
        INBOUND,
        OUTBOUND;

        private final int swigValue;

        public final int swigValue() {
            return this.swigValue;
        }

        public static Direction swigToEnum(int swigValue) {
            Direction[] swigValues = (Direction[])Direction.class.getEnumConstants();
            if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue) {
                return swigValues[swigValue];
            }
            for (Direction swigEnum : swigValues) {
                if (swigEnum.swigValue != swigValue) continue;
                return swigEnum;
            }
            throw new IllegalArgumentException("No enum " + Direction.class + " with value " + swigValue);
        }

        private Direction() {
            this.swigValue = SwigNext.next++;
        }

        private Direction(int swigValue) {
            this.swigValue = swigValue;
            SwigNext.next = swigValue + 1;
        }

        private Direction(Direction swigEnum) {
            this.swigValue = swigEnum.swigValue;
            SwigNext.next = this.swigValue + 1;
        }

        private static class SwigNext {
            private static int next = 0;

            private SwigNext() {
            }
        }
    }
}

