/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.xuggler;

import com.xuggle.ferry.IBuffer;
import com.xuggle.ferry.RefCounted;
import com.xuggle.xuggler.IAudioSamples;
import com.xuggle.xuggler.IContainerFormat;
import com.xuggle.xuggler.IPixelFormat;
import com.xuggle.xuggler.IRational;
import com.xuggle.xuggler.XugglerJNI;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;

public class ICodec
extends RefCounted {
    private volatile long swigCPtr;

    private void noop() {
        IBuffer.make(null, 1);
    }

    protected ICodec(long cPtr, boolean cMemoryOwn) {
        super(XugglerJNI.SWIGICodecUpcast(cPtr), cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    protected ICodec(long cPtr, boolean cMemoryOwn, AtomicLong ref) {
        super(XugglerJNI.SWIGICodecUpcast(cPtr), cMemoryOwn, ref);
        this.swigCPtr = cPtr;
    }

    public static long getCPtr(ICodec obj) {
        if (obj == null) {
            return 0L;
        }
        return obj.getMyCPtr();
    }

    @Override
    public long getMyCPtr() {
        if (this.swigCPtr == 0L) {
            throw new IllegalStateException("underlying native object already deleted");
        }
        return this.swigCPtr;
    }

    @Override
    public ICodec copyReference() {
        if (this.swigCPtr == 0L) {
            return null;
        }
        return new ICodec(this.swigCPtr, this.swigCMemOwn, this.getJavaRefCount());
    }

    public boolean equals(Object obj) {
        boolean equal = false;
        if (obj instanceof ICodec) {
            equal = ((ICodec)obj).swigCPtr == this.swigCPtr;
        }
        return equal;
    }

    public int hashCode() {
        return (int)this.swigCPtr;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getName() + "@" + this.hashCode() + "[");
        result.append("type=" + (Object)((Object)this.getType()) + ";");
        result.append("id=" + (Object)((Object)this.getID()) + ";");
        result.append("name=" + this.getName() + ";");
        result.append("]");
        return result.toString();
    }

    public static Collection<ICodec> getInstalledCodecs() {
        HashSet<ICodec> retval = new HashSet<ICodec>();
        int count = ICodec.getNumInstalledCodecs();
        for (int i = 0; i < count; ++i) {
            ICodec codec = ICodec.getInstalledCodec(i);
            if (codec == null) continue;
            retval.add(codec);
        }
        return retval;
    }

    public List<IRational> getSupportedVideoFrameRates() {
        LinkedList<IRational> retval = new LinkedList<IRational>();
        int count = this.getNumSupportedVideoFrameRates();
        for (int i = 0; i < count; ++i) {
            IRational rate = this.getSupportedVideoFrameRate(i);
            if (rate == null) continue;
            retval.add(rate);
        }
        return retval;
    }

    public List<IPixelFormat.Type> getSupportedVideoPixelFormats() {
        LinkedList<IPixelFormat.Type> retval = new LinkedList<IPixelFormat.Type>();
        int count = this.getNumSupportedVideoPixelFormats();
        for (int i = 0; i < count; ++i) {
            IPixelFormat.Type type = this.getSupportedVideoPixelFormat(i);
            if (type == null || type == IPixelFormat.Type.NONE) continue;
            retval.add(type);
        }
        return retval;
    }

    public List<Integer> getSupportedAudioSampleRates() {
        LinkedList<Integer> retval = new LinkedList<Integer>();
        int count = this.getNumSupportedAudioSampleRates();
        for (int i = 0; i < count; ++i) {
            int rate = this.getSupportedAudioSampleRate(i);
            if (rate == 0) continue;
            retval.add(rate);
        }
        return retval;
    }

    public List<IAudioSamples.Format> getSupportedAudioSampleFormats() {
        LinkedList<IAudioSamples.Format> retval = new LinkedList<IAudioSamples.Format>();
        int count = this.getNumSupportedAudioSampleFormats();
        for (int i = 0; i < count; ++i) {
            IAudioSamples.Format fmt = this.getSupportedAudioSampleFormat(i);
            if (fmt == null || fmt == IAudioSamples.Format.FMT_NONE) continue;
            retval.add(fmt);
        }
        return retval;
    }

    public List<Long> getSupportedAudioChannelLayouts() {
        LinkedList<Long> retval = new LinkedList<Long>();
        int count = this.getNumSupportedAudioChannelLayouts();
        for (int i = 0; i < count; ++i) {
            long layout = this.getSupportedAudioChannelLayout(i);
            if (layout == 0L) continue;
            retval.add(layout);
        }
        return retval;
    }

    public String getName() {
        return XugglerJNI.ICodec_getName(this.swigCPtr, this);
    }

    public int getIDAsInt() {
        return XugglerJNI.ICodec_getIDAsInt(this.swigCPtr, this);
    }

    public ID getID() {
        return ID.swigToEnum(XugglerJNI.ICodec_getID(this.swigCPtr, this));
    }

    public Type getType() {
        return Type.swigToEnum(XugglerJNI.ICodec_getType(this.swigCPtr, this));
    }

    public boolean canDecode() {
        return XugglerJNI.ICodec_canDecode(this.swigCPtr, this);
    }

    public boolean canEncode() {
        return XugglerJNI.ICodec_canEncode(this.swigCPtr, this);
    }

    public static ICodec findEncodingCodec(ID id) {
        long cPtr = XugglerJNI.ICodec_findEncodingCodec(id.swigValue());
        return cPtr == 0L ? null : new ICodec(cPtr, false);
    }

    public static ICodec findEncodingCodecByIntID(int id) {
        long cPtr = XugglerJNI.ICodec_findEncodingCodecByIntID(id);
        return cPtr == 0L ? null : new ICodec(cPtr, false);
    }

    public static ICodec findEncodingCodecByName(String id) {
        long cPtr = XugglerJNI.ICodec_findEncodingCodecByName(id);
        return cPtr == 0L ? null : new ICodec(cPtr, false);
    }

    public static ICodec findDecodingCodec(ID id) {
        long cPtr = XugglerJNI.ICodec_findDecodingCodec(id.swigValue());
        return cPtr == 0L ? null : new ICodec(cPtr, false);
    }

    public static ICodec findDecodingCodecByIntID(int id) {
        long cPtr = XugglerJNI.ICodec_findDecodingCodecByIntID(id);
        return cPtr == 0L ? null : new ICodec(cPtr, false);
    }

    public static ICodec findDecodingCodecByName(String id) {
        long cPtr = XugglerJNI.ICodec_findDecodingCodecByName(id);
        return cPtr == 0L ? null : new ICodec(cPtr, false);
    }

    public static ICodec guessEncodingCodec(IContainerFormat fmt, String shortName, String url, String mimeType, Type type) {
        long cPtr = XugglerJNI.ICodec_guessEncodingCodec(IContainerFormat.getCPtr(fmt), fmt, shortName, url, mimeType, type.swigValue());
        return cPtr == 0L ? null : new ICodec(cPtr, false);
    }

    public String getLongName() {
        return XugglerJNI.ICodec_getLongName(this.swigCPtr, this);
    }

    public int getCapabilities() {
        return XugglerJNI.ICodec_getCapabilities(this.swigCPtr, this);
    }

    public boolean hasCapability(Capabilities capability) {
        return XugglerJNI.ICodec_hasCapability(this.swigCPtr, this, capability.swigValue());
    }

    public static int getNumInstalledCodecs() {
        return XugglerJNI.ICodec_getNumInstalledCodecs();
    }

    public static ICodec getInstalledCodec(int index) {
        long cPtr = XugglerJNI.ICodec_getInstalledCodec(index);
        return cPtr == 0L ? null : new ICodec(cPtr, false);
    }

    public int getNumSupportedVideoFrameRates() {
        return XugglerJNI.ICodec_getNumSupportedVideoFrameRates(this.swigCPtr, this);
    }

    public IRational getSupportedVideoFrameRate(int index) {
        long cPtr = XugglerJNI.ICodec_getSupportedVideoFrameRate(this.swigCPtr, this, index);
        return cPtr == 0L ? null : new IRational(cPtr, false);
    }

    public int getNumSupportedVideoPixelFormats() {
        return XugglerJNI.ICodec_getNumSupportedVideoPixelFormats(this.swigCPtr, this);
    }

    public IPixelFormat.Type getSupportedVideoPixelFormat(int index) {
        return IPixelFormat.Type.swigToEnum(XugglerJNI.ICodec_getSupportedVideoPixelFormat(this.swigCPtr, this, index));
    }

    public int getNumSupportedAudioSampleRates() {
        return XugglerJNI.ICodec_getNumSupportedAudioSampleRates(this.swigCPtr, this);
    }

    public int getSupportedAudioSampleRate(int index) {
        return XugglerJNI.ICodec_getSupportedAudioSampleRate(this.swigCPtr, this, index);
    }

    public int getNumSupportedAudioSampleFormats() {
        return XugglerJNI.ICodec_getNumSupportedAudioSampleFormats(this.swigCPtr, this);
    }

    public IAudioSamples.Format getSupportedAudioSampleFormat(int index) {
        return IAudioSamples.Format.swigToEnum(XugglerJNI.ICodec_getSupportedAudioSampleFormat(this.swigCPtr, this, index));
    }

    public int getNumSupportedAudioChannelLayouts() {
        return XugglerJNI.ICodec_getNumSupportedAudioChannelLayouts(this.swigCPtr, this);
    }

    public long getSupportedAudioChannelLayout(int index) {
        return XugglerJNI.ICodec_getSupportedAudioChannelLayout(this.swigCPtr, this, index);
    }

    public static enum Capabilities {
        CAP_DRAW_HORIZ_BAND(XugglerJNI.ICodec_CAP_DRAW_HORIZ_BAND_get()),
        CAP_DR1(XugglerJNI.ICodec_CAP_DR1_get()),
        CAP_PARSE_ONLY(XugglerJNI.ICodec_CAP_PARSE_ONLY_get()),
        CAP_TRUNCATED(XugglerJNI.ICodec_CAP_TRUNCATED_get()),
        CAP_HWACCEL(XugglerJNI.ICodec_CAP_HWACCEL_get()),
        CAP_DELAY(XugglerJNI.ICodec_CAP_DELAY_get()),
        CAP_SMALL_LAST_FRAME(XugglerJNI.ICodec_CAP_SMALL_LAST_FRAME_get()),
        CAP_HWACCEL_VDPAU(XugglerJNI.ICodec_CAP_HWACCEL_VDPAU_get());

        private final int swigValue;

        public final int swigValue() {
            return this.swigValue;
        }

        public static Capabilities swigToEnum(int swigValue) {
            Capabilities[] swigValues = (Capabilities[])Capabilities.class.getEnumConstants();
            if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue) {
                return swigValues[swigValue];
            }
            for (Capabilities swigEnum : swigValues) {
                if (swigEnum.swigValue != swigValue) continue;
                return swigEnum;
            }
            throw new IllegalArgumentException("No enum " + Capabilities.class + " with value " + swigValue);
        }

        private Capabilities() {
            this.swigValue = SwigNext.next++;
        }

        private Capabilities(int swigValue) {
            this.swigValue = swigValue;
            SwigNext.next = swigValue + 1;
        }

        private Capabilities(Capabilities swigEnum) {
            this.swigValue = swigEnum.swigValue;
            SwigNext.next = this.swigValue + 1;
        }

        private static class SwigNext {
            private static int next = 0;

            private SwigNext() {
            }
        }
    }

    public static enum Type {
        CODEC_TYPE_UNKNOWN(XugglerJNI.ICodec_CODEC_TYPE_UNKNOWN_get()),
        CODEC_TYPE_VIDEO,
        CODEC_TYPE_AUDIO,
        CODEC_TYPE_DATA,
        CODEC_TYPE_SUBTITLE,
        CODEC_TYPE_ATTACHMENT;

        private final int swigValue;

        public final int swigValue() {
            return this.swigValue;
        }

        public static Type swigToEnum(int swigValue) {
            Type[] swigValues = (Type[])Type.class.getEnumConstants();
            if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue) {
                return swigValues[swigValue];
            }
            for (Type swigEnum : swigValues) {
                if (swigEnum.swigValue != swigValue) continue;
                return swigEnum;
            }
            throw new IllegalArgumentException("No enum " + Type.class + " with value " + swigValue);
        }

        private Type() {
            this.swigValue = SwigNext.next++;
        }

        private Type(int swigValue) {
            this.swigValue = swigValue;
            SwigNext.next = swigValue + 1;
        }

        private Type(Type swigEnum) {
            this.swigValue = swigEnum.swigValue;
            SwigNext.next = this.swigValue + 1;
        }

        private static class SwigNext {
            private static int next = 0;

            private SwigNext() {
            }
        }
    }

    public static enum ID {
        CODEC_ID_NONE,
        CODEC_ID_MPEG1VIDEO,
        CODEC_ID_MPEG2VIDEO,
        CODEC_ID_MPEG2VIDEO_XVMC,
        CODEC_ID_H261,
        CODEC_ID_H263,
        CODEC_ID_RV10,
        CODEC_ID_RV20,
        CODEC_ID_MJPEG,
        CODEC_ID_MJPEGB,
        CODEC_ID_LJPEG,
        CODEC_ID_SP5X,
        CODEC_ID_JPEGLS,
        CODEC_ID_MPEG4,
        CODEC_ID_RAWVIDEO,
        CODEC_ID_MSMPEG4V1,
        CODEC_ID_MSMPEG4V2,
        CODEC_ID_MSMPEG4V3,
        CODEC_ID_WMV1,
        CODEC_ID_WMV2,
        CODEC_ID_H263P,
        CODEC_ID_H263I,
        CODEC_ID_FLV1,
        CODEC_ID_SVQ1,
        CODEC_ID_SVQ3,
        CODEC_ID_DVVIDEO,
        CODEC_ID_HUFFYUV,
        CODEC_ID_CYUV,
        CODEC_ID_H264,
        CODEC_ID_INDEO3,
        CODEC_ID_VP3,
        CODEC_ID_THEORA,
        CODEC_ID_ASV1,
        CODEC_ID_ASV2,
        CODEC_ID_FFV1,
        CODEC_ID_4XM,
        CODEC_ID_VCR1,
        CODEC_ID_CLJR,
        CODEC_ID_MDEC,
        CODEC_ID_ROQ,
        CODEC_ID_INTERPLAY_VIDEO,
        CODEC_ID_XAN_WC3,
        CODEC_ID_XAN_WC4,
        CODEC_ID_RPZA,
        CODEC_ID_CINEPAK,
        CODEC_ID_WS_VQA,
        CODEC_ID_MSRLE,
        CODEC_ID_MSVIDEO1,
        CODEC_ID_IDCIN,
        CODEC_ID_8BPS,
        CODEC_ID_SMC,
        CODEC_ID_FLIC,
        CODEC_ID_TRUEMOTION1,
        CODEC_ID_VMDVIDEO,
        CODEC_ID_MSZH,
        CODEC_ID_ZLIB,
        CODEC_ID_QTRLE,
        CODEC_ID_SNOW,
        CODEC_ID_TSCC,
        CODEC_ID_ULTI,
        CODEC_ID_QDRAW,
        CODEC_ID_VIXL,
        CODEC_ID_QPEG,
        CODEC_ID_XVID,
        CODEC_ID_PNG,
        CODEC_ID_PPM,
        CODEC_ID_PBM,
        CODEC_ID_PGM,
        CODEC_ID_PGMYUV,
        CODEC_ID_PAM,
        CODEC_ID_FFVHUFF,
        CODEC_ID_RV30,
        CODEC_ID_RV40,
        CODEC_ID_VC1,
        CODEC_ID_WMV3,
        CODEC_ID_LOCO,
        CODEC_ID_WNV1,
        CODEC_ID_AASC,
        CODEC_ID_INDEO2,
        CODEC_ID_FRAPS,
        CODEC_ID_TRUEMOTION2,
        CODEC_ID_BMP,
        CODEC_ID_CSCD,
        CODEC_ID_MMVIDEO,
        CODEC_ID_ZMBV,
        CODEC_ID_AVS,
        CODEC_ID_SMACKVIDEO,
        CODEC_ID_NUV,
        CODEC_ID_KMVC,
        CODEC_ID_FLASHSV,
        CODEC_ID_CAVS,
        CODEC_ID_JPEG2000,
        CODEC_ID_VMNC,
        CODEC_ID_VP5,
        CODEC_ID_VP6,
        CODEC_ID_VP6F,
        CODEC_ID_TARGA,
        CODEC_ID_DSICINVIDEO,
        CODEC_ID_TIERTEXSEQVIDEO,
        CODEC_ID_TIFF,
        CODEC_ID_GIF,
        CODEC_ID_FFH264,
        CODEC_ID_DXA,
        CODEC_ID_DNXHD,
        CODEC_ID_THP,
        CODEC_ID_SGI,
        CODEC_ID_C93,
        CODEC_ID_BETHSOFTVID,
        CODEC_ID_PTX,
        CODEC_ID_TXD,
        CODEC_ID_VP6A,
        CODEC_ID_AMV,
        CODEC_ID_VB,
        CODEC_ID_PCX,
        CODEC_ID_SUNRAST,
        CODEC_ID_INDEO4,
        CODEC_ID_INDEO5,
        CODEC_ID_MIMIC,
        CODEC_ID_RL2,
        CODEC_ID_8SVX_EXP,
        CODEC_ID_8SVX_FIB,
        CODEC_ID_ESCAPE124,
        CODEC_ID_DIRAC,
        CODEC_ID_BFI,
        CODEC_ID_CMV,
        CODEC_ID_MOTIONPIXELS,
        CODEC_ID_TGV,
        CODEC_ID_TGQ,
        CODEC_ID_TQI,
        CODEC_ID_AURA,
        CODEC_ID_AURA2,
        CODEC_ID_V210X,
        CODEC_ID_TMV,
        CODEC_ID_V210,
        CODEC_ID_DPX,
        CODEC_ID_MAD,
        CODEC_ID_FRWU,
        CODEC_ID_FLASHSV2,
        CODEC_ID_CDGRAPHICS,
        CODEC_ID_R210,
        CODEC_ID_ANM,
        CODEC_ID_BINKVIDEO,
        CODEC_ID_PCM_S16LE(XugglerJNI.ICodec_CODEC_ID_PCM_S16LE_get()),
        CODEC_ID_PCM_S16BE,
        CODEC_ID_PCM_U16LE,
        CODEC_ID_PCM_U16BE,
        CODEC_ID_PCM_S8,
        CODEC_ID_PCM_U8,
        CODEC_ID_PCM_MULAW,
        CODEC_ID_PCM_ALAW,
        CODEC_ID_PCM_S32LE,
        CODEC_ID_PCM_S32BE,
        CODEC_ID_PCM_U32LE,
        CODEC_ID_PCM_U32BE,
        CODEC_ID_PCM_S24LE,
        CODEC_ID_PCM_S24BE,
        CODEC_ID_PCM_U24LE,
        CODEC_ID_PCM_U24BE,
        CODEC_ID_PCM_S24DAUD,
        CODEC_ID_PCM_ZORK,
        CODEC_ID_PCM_S16LE_PLANAR,
        CODEC_ID_PCM_DVD,
        CODEC_ID_PCM_F32BE,
        CODEC_ID_PCM_F32LE,
        CODEC_ID_PCM_F64BE,
        CODEC_ID_PCM_F64LE,
        CODEC_ID_PCM_BLURAY,
        CODEC_ID_ADPCM_IMA_QT(XugglerJNI.ICodec_CODEC_ID_ADPCM_IMA_QT_get()),
        CODEC_ID_ADPCM_IMA_WAV,
        CODEC_ID_ADPCM_IMA_DK3,
        CODEC_ID_ADPCM_IMA_DK4,
        CODEC_ID_ADPCM_IMA_WS,
        CODEC_ID_ADPCM_IMA_SMJPEG,
        CODEC_ID_ADPCM_MS,
        CODEC_ID_ADPCM_4XM,
        CODEC_ID_ADPCM_XA,
        CODEC_ID_ADPCM_ADX,
        CODEC_ID_ADPCM_EA,
        CODEC_ID_ADPCM_G726,
        CODEC_ID_ADPCM_CT,
        CODEC_ID_ADPCM_SWF,
        CODEC_ID_ADPCM_YAMAHA,
        CODEC_ID_ADPCM_SBPRO_4,
        CODEC_ID_ADPCM_SBPRO_3,
        CODEC_ID_ADPCM_SBPRO_2,
        CODEC_ID_ADPCM_THP,
        CODEC_ID_ADPCM_IMA_AMV,
        CODEC_ID_ADPCM_EA_R1,
        CODEC_ID_ADPCM_EA_R3,
        CODEC_ID_ADPCM_EA_R2,
        CODEC_ID_ADPCM_IMA_EA_SEAD,
        CODEC_ID_ADPCM_IMA_EA_EACS,
        CODEC_ID_ADPCM_EA_XAS,
        CODEC_ID_ADPCM_EA_MAXIS_XA,
        CODEC_ID_ADPCM_IMA_ISS,
        CODEC_ID_AMR_NB(XugglerJNI.ICodec_CODEC_ID_AMR_NB_get()),
        CODEC_ID_AMR_WB,
        CODEC_ID_RA_144(XugglerJNI.ICodec_CODEC_ID_RA_144_get()),
        CODEC_ID_RA_288,
        CODEC_ID_ROQ_DPCM(XugglerJNI.ICodec_CODEC_ID_ROQ_DPCM_get()),
        CODEC_ID_INTERPLAY_DPCM,
        CODEC_ID_XAN_DPCM,
        CODEC_ID_SOL_DPCM,
        CODEC_ID_MP2(XugglerJNI.ICodec_CODEC_ID_MP2_get()),
        CODEC_ID_MP3,
        CODEC_ID_AAC,
        CODEC_ID_AC3,
        CODEC_ID_DTS,
        CODEC_ID_VORBIS,
        CODEC_ID_DVAUDIO,
        CODEC_ID_WMAV1,
        CODEC_ID_WMAV2,
        CODEC_ID_MACE3,
        CODEC_ID_MACE6,
        CODEC_ID_VMDAUDIO,
        CODEC_ID_SONIC,
        CODEC_ID_SONIC_LS,
        CODEC_ID_FLAC,
        CODEC_ID_MP3ADU,
        CODEC_ID_MP3ON4,
        CODEC_ID_SHORTEN,
        CODEC_ID_ALAC,
        CODEC_ID_WESTWOOD_SND1,
        CODEC_ID_GSM,
        CODEC_ID_QDM2,
        CODEC_ID_COOK,
        CODEC_ID_TRUESPEECH,
        CODEC_ID_TTA,
        CODEC_ID_SMACKAUDIO,
        CODEC_ID_QCELP,
        CODEC_ID_WAVPACK,
        CODEC_ID_DSICINAUDIO,
        CODEC_ID_IMC,
        CODEC_ID_MUSEPACK7,
        CODEC_ID_MLP,
        CODEC_ID_GSM_MS,
        CODEC_ID_ATRAC3,
        CODEC_ID_VOXWARE,
        CODEC_ID_APE,
        CODEC_ID_NELLYMOSER,
        CODEC_ID_MUSEPACK8,
        CODEC_ID_SPEEX,
        CODEC_ID_WMAVOICE,
        CODEC_ID_WMAPRO,
        CODEC_ID_WMALOSSLESS,
        CODEC_ID_ATRAC3P,
        CODEC_ID_EAC3,
        CODEC_ID_SIPR,
        CODEC_ID_MP1,
        CODEC_ID_TWINVQ,
        CODEC_ID_TRUEHD,
        CODEC_ID_MP4ALS,
        CODEC_ID_ATRAC1,
        CODEC_ID_BINKAUDIO_RDFT,
        CODEC_ID_BINKAUDIO_DCT,
        CODEC_ID_DVD_SUBTITLE(XugglerJNI.ICodec_CODEC_ID_DVD_SUBTITLE_get()),
        CODEC_ID_DVB_SUBTITLE,
        CODEC_ID_TEXT,
        CODEC_ID_XSUB,
        CODEC_ID_SSA,
        CODEC_ID_MOV_TEXT,
        CODEC_ID_HDMV_PGS_SUBTITLE,
        CODEC_ID_DVB_TELETEXT,
        CODEC_ID_TTF(XugglerJNI.ICodec_CODEC_ID_TTF_get()),
        CODEC_ID_PROBE(XugglerJNI.ICodec_CODEC_ID_PROBE_get()),
        CODEC_ID_MPEG2TS(XugglerJNI.ICodec_CODEC_ID_MPEG2TS_get());

        private final int swigValue;

        public final int swigValue() {
            return this.swigValue;
        }

        public static ID swigToEnum(int swigValue) {
            ID[] swigValues = (ID[])ID.class.getEnumConstants();
            if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue) {
                return swigValues[swigValue];
            }
            for (ID swigEnum : swigValues) {
                if (swigEnum.swigValue != swigValue) continue;
                return swigEnum;
            }
            throw new IllegalArgumentException("No enum " + ID.class + " with value " + swigValue);
        }

        private ID() {
            this.swigValue = SwigNext.next++;
        }

        private ID(int swigValue) {
            this.swigValue = swigValue;
            SwigNext.next = swigValue + 1;
        }

        private ID(ID swigEnum) {
            this.swigValue = swigEnum.swigValue;
            SwigNext.next = this.swigValue + 1;
        }

        private static class SwigNext {
            private static int next = 0;

            private SwigNext() {
            }
        }
    }
}

