/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics;

import org.opensourcephysics.numerics.InvertibleFunction;
import org.opensourcephysics.numerics.Util;

public final class LogBase10Function
implements InvertibleFunction {
    public final double evaluate(double d) {
        if (d <= 0.0) {
            d = 1.4E-45f;
        }
        return Math.log(d) / Util.LOG10;
    }

    public final double getInverse(double d) {
        return Math.pow(10.0, d);
    }
}

