/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control;

import java.util.Enumeration;
import java.util.Vector;
import org.colos.ejs.library.control.ControlElement;
import org.colos.ejs.library.control.DataCollector;
import org.colos.ejs.library.control.MethodWithOneParameter;
import org.colos.ejs.library.control.value.DoubleValue;
import org.colos.ejs.library.control.value.Value;

public class GroupVariable {
    private String name;
    private Value value;
    private boolean definedInModel = false;
    private boolean obsolete = false;
    private Vector<Item> elementList;
    private Vector<MethodWithOneParameter> methodList;

    public GroupVariable(String string, Value value) {
        this.name = string;
        this.elementList = new Vector();
        this.methodList = new Vector();
        this.value = value != null ? value.cloneValue() : new DoubleValue(0.0);
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public void setValue(Value value) {
        if (this.value.getClass() != value.getClass()) {
            this.value = value.cloneValue();
        } else {
            this.value.copyValue(value);
        }
    }

    public Value getValue() {
        return this.value;
    }

    public void setDefinedInModel(boolean bl) {
        this.definedInModel = bl;
    }

    public boolean isDefinedInModel() {
        return this.definedInModel;
    }

    public void setValueObsolete(boolean bl) {
        this.obsolete = bl;
    }

    public boolean isValueObsolete() {
        return this.obsolete;
    }

    public void addElementListener(ControlElement controlElement, int n) {
        this.elementList.add(new Item(controlElement, n));
    }

    public boolean hasElementsRegistered() {
        return !this.elementList.isEmpty();
    }

    public void removeElementListener(ControlElement controlElement, int n) {
        for (Item item : this.elementList) {
            if (item.element != controlElement || item.index != n) continue;
            this.elementList.removeElement(item);
            return;
        }
    }

    public void propagateValue(ControlElement controlElement, boolean bl) {
        if (bl) {
            Enumeration<Item> enumeration = this.elementList.elements();
            while (enumeration.hasMoreElements()) {
                Item item = enumeration.nextElement();
                if (!(item.element instanceof DataCollector)) continue;
                item.element.setActive(false);
                if (item.element.myMethodsForProperties[item.index] != null) {
                    item.element.setValue(item.index, item.element.myMethodsForProperties[item.index].invoke(2, null));
                } else if (item.element.myExpressionsForProperties[item.index] != null) {
                    item.element.setValue(item.index, item.element.myExpressionsForProperties[item.index]);
                } else {
                    item.element.setValue(item.index, this.value);
                }
                item.element.setActive(true);
            }
        } else {
            Enumeration<Item> enumeration = this.elementList.elements();
            while (enumeration.hasMoreElements()) {
                Item item = enumeration.nextElement();
                if (item.element == controlElement) continue;
                item.element.setActive(false);
                if (item.element.myMethodsForProperties[item.index] != null) {
                    item.element.setValue(item.index, item.element.myMethodsForProperties[item.index].invoke(2, null));
                } else if (item.element.myExpressionsForProperties[item.index] != null) {
                    item.element.setValue(item.index, item.element.myExpressionsForProperties[item.index]);
                } else {
                    item.element.setValue(item.index, this.value);
                }
                item.element.setActive(true);
            }
        }
    }

    public void addListener(Object object, String string) {
        this.addListener(object, string, null);
    }

    public void addListener(Object object, String string, Object object2) {
        this.methodList.add(new MethodWithOneParameter(1, object, string, null, null, object2));
    }

    public void removeListener(Object object, String string) {
        for (MethodWithOneParameter methodWithOneParameter : this.methodList) {
            if (!methodWithOneParameter.equals(1, object, string)) continue;
            this.methodList.removeElement(methodWithOneParameter);
            return;
        }
    }

    public void invokeListeners(ControlElement controlElement) {
        for (MethodWithOneParameter methodWithOneParameter : this.methodList) {
            methodWithOneParameter.invoke(1, controlElement);
        }
    }

    private class Item {
        public ControlElement element;
        public int index;

        Item(ControlElement controlElement, int n) {
            this.element = controlElement;
            this.index = n;
        }
    }
}

