/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.text.DecimalFormat;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.filechooser.FileSystemView;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.html.HTMLEditorKit;
import org.colos.ejs.library.Animation;
import org.colos.ejs.library.EmersionLink;
import org.colos.ejs.library.Experiment;
import org.colos.ejs.library.LauncherApplet;
import org.colos.ejs.library.Memory;
import org.colos.ejs.library.Model;
import org.colos.ejs.library.control.ControlElement;
import org.colos.ejs.library.control.EjsControl;
import org.colos.ejs.library.control.MethodWithOneParameter;
import org.colos.ejs.library.control.SpecialRender;
import org.colos.ejs.library.utils.FileUtils;
import org.colos.ejs.library.utils.HtmlPageInfo;
import org.colos.ejs.library.utils.LocaleItem;
import org.colos.ejs.library.utils.LocaleListener;
import org.colos.ejs.library.utils.VideoUtil;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.desktop.OSPDesktop;
import org.opensourcephysics.display.DisplayRes;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.display.dialogs.DialogsRes;
import org.opensourcephysics.tools.Diagnostics;
import org.opensourcephysics.tools.EjsTool;
import org.opensourcephysics.tools.FontSizer;
import org.opensourcephysics.tools.Resource;
import org.opensourcephysics.tools.ResourceLoader;
import org.opensourcephysics.tools.SnapshotTool;
import org.opensourcephysics.tools.ToolsRes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Simulation
extends Animation
implements LocaleListener {
    public static ResourceBundle ejsRes = ResourceBundle.getBundle("org.colos.ejs.library.resources.ejs_res", Locale.getDefault());
    private static String pathToLibrary = "";
    private static AWTEventListener focusListener = null;
    private static List<File> resourcesExtracted = new ArrayList<File>();
    private static String homeDir = null;
    private static String userDir = null;
    private boolean isUnderEjs = false;
    private Component parentComponent = null;
    private String parentComponentName = null;
    private String captureElement = null;
    private URL codebase = null;
    private LocaleItem currentLocaleItem = LocaleItem.getDefaultLocaleItem();
    private List<String> stateVariablesList = null;
    private JLabel increaseFontButton;
    private JLabel decreaseFontButton;
    private JLabel openPageButton;
    protected VideoUtil videoUtil;
    private Set<LocaleItem> availableLocales = new HashSet<LocaleItem>();
    private boolean showDescriptionOnStart = true;
    private JFrame descriptionDialog = null;
    private JTabbedPane descriptionPanel = null;
    private List<EditorAndScroll> descriptionPagesList = null;
    private static final String dummy = "";
    private static final Class<?> strClass = "".getClass();
    private static Hashtable<String, Object> memory = new Hashtable();
    protected EmersionLink eMersion = null;
    private MethodWithOneParameter _init_ = null;
    private LauncherApplet javascriptControledApplet = null;
    protected JPopupMenu popupMenu = null;
    private JMenu elementsMenu = null;
    private AbstractList<Object> popupMenuExtraEntries = null;
    private Component popupTriggeredBy = null;
    protected Experiment currentExperiment = null;
    JMenuItem snapshotMenuItem;

    public static String getEjsString(String string) {
        try {
            return ejsRes.getString(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return string;
        }
    }

    public static String getPathToLibrary() {
        return pathToLibrary;
    }

    public static void setPathToLibrary(String string) {
        try {
            File file = new File(string);
            if (file.exists() && file.isDirectory()) {
                pathToLibrary = string;
            }
        }
        catch (Exception exception) {}
    }

    public static String getUserDir() {
        if (userDir == null) {
            try {
                userDir = System.getProperty("user.dir").replace('\\', '/');
                if (!userDir.endsWith("/")) {
                    userDir = String.valueOf(userDir) + "/";
                }
            }
            catch (Exception exception) {
                return dummy;
            }
        }
        return userDir;
    }

    public static String getHomeDir() {
        if (homeDir == null) {
            try {
                homeDir = System.getProperty("user.home").replace('\\', '/');
                if (!homeDir.endsWith("/")) {
                    homeDir = String.valueOf(homeDir) + "/";
                }
            }
            catch (Exception exception) {
                return dummy;
            }
        }
        return homeDir;
    }

    public static String getTemporaryDir() {
        try {
            return String.valueOf(Simulation.getHomeDir()) + ".Ejs.tmp/";
        }
        catch (Exception exception) {
            return dummy;
        }
    }

    public static File extractToTempFile(String string) {
        int n = string.lastIndexOf(46);
        String string2 = n >= 0 ? string.substring(n) : ".tmp";
        try {
            int n2;
            File file = File.createTempFile("ejs_tmp_", string2);
            file.deleteOnExit();
            InputStream inputStream = ResourceLoader.openInputStream(string);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            while ((n2 = bufferedInputStream.read()) != -1) {
                fileOutputStream.write(n2);
            }
            bufferedInputStream.close();
            fileOutputStream.close();
            System.out.println("Ejs simulation: resource " + string + " extracted into " + file.getAbsolutePath());
            return file;
        }
        catch (Exception exception) {
            System.out.println("Ejs simulation: resource " + string + " could NOT be extracted");
            exception.printStackTrace();
            return null;
        }
    }

    public static File extractToDirectory(String string, File file, boolean bl) {
        try {
            int n;
            File file2 = new File(file, string);
            file2.deleteOnExit();
            file2.getParentFile().mkdirs();
            InputStream inputStream = ResourceLoader.openInputStream(string);
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            while ((n = bufferedInputStream.read()) != -1) {
                fileOutputStream.write(n);
            }
            bufferedInputStream.close();
            fileOutputStream.close();
            if (bl) {
                System.out.println("Ejs simulation: resource " + string + " extracted into " + file2.getAbsolutePath());
            }
            return file2;
        }
        catch (Exception exception) {
            System.out.println("Ejs simulation: resource " + string + " could NOT be extracted");
            exception.printStackTrace();
            return null;
        }
    }

    public static File requiresResourceFile(String string) {
        return Simulation.requiresResourceFile(string, string);
    }

    public static File requiresResourceFile(String string, String string2) {
        File file = null;
        Resource resource = ResourceLoader.getResource(string);
        if (resource != null) {
            file = resource.getFile();
        }
        if (file != null && file.exists()) {
            return file;
        }
        if (string2.startsWith("/")) {
            string2 = string2.substring(1);
        }
        return Simulation.extractResource(string, String.valueOf(Simulation.getTemporaryDir()) + string2);
    }

    public static File extractResource(String string, String string2) {
        File file = new File(string2);
        try {
            int n;
            InputStream inputStream = ResourceLoader.openInputStream(string);
            file.getParentFile().mkdirs();
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            while ((n = bufferedInputStream.read()) != -1) {
                fileOutputStream.write(n);
            }
            bufferedInputStream.close();
            fileOutputStream.close();
            resourcesExtracted.add(file);
            System.out.println("Ejs simulation: resource " + string + " extracted into " + string2);
            return file;
        }
        catch (Exception exception) {
            System.out.println("Ejs simulation: resource " + string + " could NOT be extracted into " + string2);
            exception.printStackTrace();
            return null;
        }
    }

    private static void cleanExtractedResources() {
        if (resourcesExtracted.size() <= 0) {
            return;
        }
        System.out.println("Ejs simulation: Cleaning extracted files.");
        for (File file : resourcesExtracted) {
            System.out.println("Ejs simulation: wants to delete " + file.getPath());
            if (!file.exists()) continue;
            System.out.println("Ejs simulation: Removing extracted resource " + file.getPath());
            file.delete();
        }
        resourcesExtracted.clear();
        Simulation.removeEmptyDirs(new File(Simulation.getTemporaryDir()), true);
    }

    public static void removeEmptyDirs(File file, boolean bl) {
        if (!file.isDirectory() || !file.exists()) {
            return;
        }
        FileSystemView fileSystemView = FileSystemView.getFileSystemView();
        if (bl) {
            Simulation.recursiveRemoveEmptyDirs(file, fileSystemView);
        } else {
            File[] fileArray = fileSystemView.getFiles(file, false);
            int n = 0;
            while (n < fileArray.length) {
                if (fileArray[n].isDirectory()) {
                    Simulation.recursiveRemoveEmptyDirs(fileArray[n], fileSystemView);
                }
                ++n;
            }
        }
    }

    private static void recursiveRemoveEmptyDirs(File file, FileSystemView fileSystemView) {
        File[] fileArray = fileSystemView.getFiles(file, false);
        if (fileArray.length == 0) {
            file.delete();
            return;
        }
        int n = 0;
        while (n < fileArray.length) {
            if (fileArray[n].isDirectory()) {
                Simulation.recursiveRemoveEmptyDirs(fileArray[n], fileSystemView);
            }
            ++n;
        }
        fileArray = fileSystemView.getFiles(file, false);
        if (fileArray.length == 0) {
            file.delete();
        }
    }

    @Override
    protected void userDefinedReset() {
        if (this.resetFile != null) {
            this.readState(this.resetFile);
        }
    }

    @Override
    protected void userDefinedViewUpdate() {
        this.videoUtil.captureVideoImage();
    }

    private String getClassname() {
        String string = this.getClass().getName();
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            string = string.substring(n + 1);
        }
        return string;
    }

    private String getModelClassname() {
        String string = this.model.getClass().getName();
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            string = string.substring(n + 1);
        }
        return string;
    }

    private void errorMessage(String string) {
        System.err.println(String.valueOf(this.getClassname()) + ": " + string);
    }

    private void errorMessage(Exception exception) {
        System.err.println(String.valueOf(this.getClassname()) + ": Exception caught! Text follows:");
        exception.printStackTrace(System.err);
    }

    public void setParentComponent(Component component) {
        this.parentComponent = component;
    }

    public void setParentComponent(String string) {
        this.parentComponentName = string;
        this.parentComponent = null;
    }

    public Component getParentComponent() {
        if (this.parentComponent == null && this.view != null) {
            this.parentComponent = this.view.getComponent(this.parentComponentName);
        }
        return this.parentComponent;
    }

    public void setCodebase(URL uRL) {
        this.codebase = uRL;
    }

    public URL getCodebase() {
        return this.codebase;
    }

    public void addAvailableLocale(String string) {
        LocaleItem localeItem = LocaleItem.getLocaleItem(string);
        if (localeItem != null) {
            this.availableLocales.add(localeItem);
        } else {
            System.out.println("Warning! Html editor is ignoring unrecognized locale name : " + string + "\n");
        }
    }

    public Set<LocaleItem> getAvailableLocales() {
        return this.availableLocales;
    }

    public String translateString(String string, String string2) {
        return Model._getTranslatorUtil().translateString(string, string2);
    }

    public String translateString(String string) {
        return Model._getTranslatorUtil().translateString(string);
    }

    @Override
    public void setLocaleItem(LocaleItem localeItem) {
        this.setLocaleItem(localeItem, true);
    }

    protected void setLocaleItem(LocaleItem localeItem, boolean bl) {
        this.currentLocaleItem = localeItem;
        Locale locale = localeItem.getLocale();
        if (locale == null) {
            locale = Locale.getDefault();
        }
        ToolsRes.setLocale(locale);
        DisplayRes.setLocale(locale);
        DialogsRes.setLocale(locale);
        ejsRes = ResourceBundle.getBundle("org.colos.ejs.library.resources.ejs_res", locale);
        Model._getTranslatorUtil().setLocaleItem(this.currentLocaleItem);
        this.setViewLocale();
        this.popupMenu = null;
        this.resetDescriptionPages();
        if (bl) {
            this.model._reset();
        }
    }

    public LocaleItem getLocaleItem() {
        return this.currentLocaleItem;
    }

    public void setLocale(String string) {
        LocaleItem localeItem = LocaleItem.getLocaleItem(string);
        if (localeItem != null) {
            this.setLocaleItem(localeItem);
        } else {
            System.out.println("Warning! Html editor is ignoring unrecognized locale name : " + string + "\n");
            this.setLocaleItem(LocaleItem.getDefaultItem());
        }
    }

    public Locale getLocale() {
        Locale locale = this.currentLocaleItem.getLocale();
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return locale;
    }

    protected void setViewLocale() {
        this.elementsMenu = null;
        this.popupMenuExtraEntries = null;
        if (this.view instanceof EjsControl) {
            ((EjsControl)((Object)this.view)).addElementsMenuEntries();
        }
        this.view.update();
        this.view.finalUpdate();
    }

    @Override
    public void onExit() {
        Simulation.cleanExtractedResources();
        super.onExit();
    }

    public void addDescriptionPage(String string, int n, int n2) {
        JComponent jComponent;
        Serializable serializable;
        Object object;
        Object object2;
        HtmlPageInfo htmlPageInfo = this.model._getHtmlPageInfo(string, this.currentLocaleItem);
        if (htmlPageInfo == null) {
            JOptionPane.showMessageDialog(this.popupTriggeredBy, "Html file not found: " + string, "Description Error", 0);
            return;
        }
        if (this.descriptionDialog == null) {
            this.descriptionPanel = new JTabbedPane();
            object2 = BorderFactory.createEmptyBorder(1, 1, 1, 1);
            object = BorderFactory.createLineBorder(new Color(128, 64, 255), 1);
            serializable = Cursor.getPredefinedCursor(12);
            this.increaseFontButton = new JLabel(ResourceLoader.getIcon("/org/colos/ejs/library/resources/fontUp.gif"));
            this.increaseFontButton.setBorder((Border)object2);
            this.increaseFontButton.setCursor((Cursor)serializable);
            this.increaseFontButton.setToolTipText(DisplayRes.getString("DrawingFrame.IncreaseFontSize_menu_item"));
            this.increaseFontButton.addMouseListener(new MouseAdapter((Border)object, (Border)object2){
                private final /* synthetic */ Border val$clickedBorder;
                private final /* synthetic */ Border val$border;
                {
                    this.val$clickedBorder = border;
                    this.val$border = border2;
                }

                public void mousePressed(final MouseEvent mouseEvent) {
                    ((JComponent)mouseEvent.getComponent()).setBorder(this.val$clickedBorder);
                    Timer timer = new Timer(1000, new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            ((JComponent)mouseEvent.getComponent()).setBorder(val$border);
                        }
                    });
                    timer.setRepeats(false);
                    timer.start();
                    if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                if (Simulation.this.descriptionPagesList == null) {
                                    return;
                                }
                                for (EditorAndScroll editorAndScroll : Simulation.this.descriptionPagesList) {
                                    Font font = editorAndScroll.editorPane.getFont();
                                    float f = font.getSize2D() * 1.1f;
                                    editorAndScroll.editorPane.setFont(font.deriveFont(f));
                                }
                            }
                        });
                    }
                }
            });
            this.decreaseFontButton = new JLabel(ResourceLoader.getIcon("/org/colos/ejs/library/resources/fontDown.gif"));
            this.decreaseFontButton.setBorder((Border)object2);
            this.decreaseFontButton.setCursor((Cursor)serializable);
            this.decreaseFontButton.setToolTipText(DisplayRes.getString("DrawingFrame.DecreaseFontSize_menu_item"));
            this.decreaseFontButton.addMouseListener(new MouseAdapter((Border)object, (Border)object2){
                private final /* synthetic */ Border val$clickedBorder;
                private final /* synthetic */ Border val$border;
                {
                    this.val$clickedBorder = border;
                    this.val$border = border2;
                }

                public void mousePressed(final MouseEvent mouseEvent) {
                    ((JComponent)mouseEvent.getComponent()).setBorder(this.val$clickedBorder);
                    Timer timer = new Timer(1000, new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            ((JComponent)mouseEvent.getComponent()).setBorder(val$border);
                        }
                    });
                    timer.setRepeats(false);
                    timer.start();
                    if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                if (Simulation.this.descriptionPagesList == null) {
                                    return;
                                }
                                for (EditorAndScroll editorAndScroll : Simulation.this.descriptionPagesList) {
                                    Font font = editorAndScroll.editorPane.getFont();
                                    float f = Math.max(10.0f, font.getSize2D() / 1.1f);
                                    editorAndScroll.editorPane.setFont(font.deriveFont(f));
                                }
                            }
                        });
                    }
                }
            });
            this.openPageButton = new JLabel(ResourceLoader.getIcon("/org/colos/ejs/library/resources/fullScreen.gif"));
            this.openPageButton.setBorder((Border)object2);
            this.openPageButton.setCursor((Cursor)serializable);
            this.openPageButton.setToolTipText(Memory.getResource("DescriptionPages.OpenExternalBrowser"));
            this.openPageButton.addMouseListener(new MouseAdapter((Border)object, (Border)object2){
                private final /* synthetic */ Border val$clickedBorder;
                private final /* synthetic */ Border val$border;
                {
                    this.val$clickedBorder = border;
                    this.val$border = border2;
                }

                public void mousePressed(final MouseEvent mouseEvent) {
                    ((JComponent)mouseEvent.getComponent()).setBorder(this.val$clickedBorder);
                    Timer timer = new Timer(1000, new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            ((JComponent)mouseEvent.getComponent()).setBorder(val$border);
                        }
                    });
                    timer.setRepeats(false);
                    timer.start();
                    if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                if (Simulation.this.descriptionPagesList == null) {
                                    return;
                                }
                                Component component = Simulation.this.descriptionPanel.getSelectedComponent();
                                for (EditorAndScroll editorAndScroll : Simulation.this.descriptionPagesList) {
                                    if (component != editorAndScroll.scrollPane) continue;
                                    if (!Simulation.this.openDescriptionPageInBrowser(editorAndScroll.name)) {
                                        JOptionPane.showMessageDialog(Simulation.this.openPageButton, Memory.getResource("DescriptionPages.ErrorOpeningFiles"), Memory.getResource("Error"), 0);
                                    }
                                    return;
                                }
                                System.err.println("DescriptionPages : Could not find the selected page.");
                            }
                        });
                    }
                }
            });
            jComponent = new JPanel(new FlowLayout(1));
            jComponent.add(this.increaseFontButton);
            jComponent.add(this.decreaseFontButton);
            jComponent.add(this.openPageButton);
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.setBorder(new EtchedBorder(1));
            JComponent jComponent2 = Model._getTranslatorUtil().getSelectorComponent(this);
            if (jComponent2 != null) {
                jComponent2.setBorder(new EmptyBorder(0, 0, 0, 2));
                jPanel.add((Component)jComponent, "West");
                jPanel.add((Component)jComponent2, "East");
            } else {
                jPanel.add((Component)jComponent, "Center");
            }
            this.descriptionDialog = new JFrame(String.valueOf(Memory.getResource("DescriptionFor")) + " " + this.getModelClassname());
            this.descriptionDialog.getContentPane().add((Component)this.descriptionPanel, "Center");
            this.descriptionDialog.getContentPane().add((Component)jPanel, "South");
            if (n <= 0) {
                n = 600;
            }
            if (n2 <= 0) {
                n2 = 400;
            }
            Rectangle rectangle = EjsControl.getDefaultScreenBounds();
            n = Math.min(n, rectangle.width - 10);
            n2 = Math.min(n2, rectangle.height - 10);
            this.descriptionDialog.setLocation(rectangle.x + (rectangle.width - n) / 2, rectangle.y + (rectangle.height - n2) / 2);
        }
        if ((object2 = ResourceLoader.getResource(htmlPageInfo.getLink())) != null) {
            try {
                object = new JEditorPane(){};
                serializable = new HTMLEditorKit();
                ((JEditorPane)object).setEditorKit((EditorKit)serializable);
                ((JTextComponent)object).setDocument(serializable.createDefaultDocument());
                ((JComponent)object).putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
                ((JTextComponent)object).setEditable(false);
                ((JEditorPane)object).addHyperlinkListener(new HyperlinkListener(){

                    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                            Simulation.this.openURL(hyperlinkEvent.getSource(), hyperlinkEvent.getURL(), Simulation.this.getView().getComponent(Simulation.this.getMainWindow()), Simulation.this.model._getApplet() != null);
                        }
                    }
                });
                ((JEditorPane)object).setPage(((Resource)object2).getURL());
                jComponent = new JScrollPane((Component)object);
                jComponent.setPreferredSize(new Dimension(n, n2));
                this.descriptionPanel.add(htmlPageInfo.getTitle(), jComponent);
                this.descriptionDialog.pack();
                if (this.descriptionPagesList == null) {
                    this.descriptionPagesList = new ArrayList<EditorAndScroll>();
                }
                this.descriptionPagesList.add(new EditorAndScroll(string, (JEditorPane)object, (JScrollPane)jComponent));
            }
            catch (IOException iOException) {
                System.err.println("Attempted to read a bad URL: " + ((Resource)object2).getURL());
            }
        } else {
            System.err.println("Couldn't find description file: " + string);
        }
    }

    public void addDescriptionPage(String string, String string2, int n, int n2) {
        this.addDescriptionPage(string2, n, n2);
    }

    @Override
    protected void resetDescriptionPages() {
        if (this.descriptionPagesList == null) {
            return;
        }
        try {
            for (EditorAndScroll editorAndScroll : this.descriptionPagesList) {
                HtmlPageInfo htmlPageInfo = this.model._getHtmlPageInfo(editorAndScroll.name, this.currentLocaleItem);
                if (htmlPageInfo == null) continue;
                Resource resource = ResourceLoader.getResource(htmlPageInfo.getLink());
                URL uRL = resource.getURL();
                if (editorAndScroll.editorPane.getPage() == uRL) continue;
                editorAndScroll.editorPane.setPage(uRL);
                this.descriptionPanel.setTitleAt(this.descriptionPanel.indexOfComponent(editorAndScroll.scrollPane), htmlPageInfo.getTitle());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this.increaseFontButton != null) {
            this.descriptionDialog.setTitle(String.valueOf(Memory.getResource("DescriptionFor")) + " " + this.getModelClassname());
            this.increaseFontButton.setToolTipText(DisplayRes.getString("DrawingFrame.IncreaseFontSize_menu_item"));
            this.decreaseFontButton.setToolTipText(DisplayRes.getString("DrawingFrame.DecreaseFontSize_menu_item"));
            this.openPageButton.setToolTipText(Memory.getResource("DescriptionPages.OpenExternalBrowser"));
        }
    }

    public void showDescriptionAtStartUp(boolean bl) {
        this.showDescriptionOnStart = bl;
    }

    public void showDescription() {
        this.showDescription(true);
    }

    public void showDescription(boolean bl) {
        if (this.descriptionDialog != null) {
            this.descriptionDialog.setVisible(bl);
        }
    }

    public URL getDescriptionPageURL(String string) {
        HtmlPageInfo htmlPageInfo = this.model._getHtmlPageInfo(string, this.currentLocaleItem);
        if (htmlPageInfo == null) {
            return null;
        }
        return ResourceLoader.getResource(htmlPageInfo.getLink()).getURL();
    }

    public boolean openDescriptionPagesInBrowser() {
        File file = this.extractResources();
        if (file == null) {
            return false;
        }
        boolean bl = false;
        for (EditorAndScroll editorAndScroll : this.descriptionPagesList) {
            HtmlPageInfo htmlPageInfo = this.model._getHtmlPageInfo(editorAndScroll.name, this.currentLocaleItem);
            if (htmlPageInfo == null) {
                System.err.println("DescriptionPages : Could not find the page: " + editorAndScroll.name);
                bl = true;
            }
            if (this.openExternalBrowser(file, htmlPageInfo)) continue;
            bl = true;
        }
        return bl;
    }

    public boolean openDescriptionPageInBrowser(String string) {
        File file = this.extractResources();
        if (file == null) {
            return false;
        }
        HtmlPageInfo htmlPageInfo = this.model._getHtmlPageInfo(string, this.currentLocaleItem);
        if (htmlPageInfo == null) {
            System.err.println("DescriptionPages : Could not find the page: " + string);
            return false;
        }
        return this.openExternalBrowser(file, htmlPageInfo);
    }

    private File extractResources() {
        if (OSPRuntime.appletMode) {
            return null;
        }
        File file = new File(String.valueOf(Simulation.getTemporaryDir()) + "DescriptionPages/");
        if (!file.exists() && !file.mkdirs()) {
            System.err.println("DescriptionPages : Could not create directory : " + file.getAbsolutePath());
            JOptionPane.showMessageDialog(this.openPageButton, Memory.getResource("DescriptionPages.CannotExtractFiles"), Memory.getResource("Error"), 0);
            return null;
        }
        for (String string : this.model._getClassEjsResources()) {
            if (Simulation.extractToDirectory(string, file, false) != null) continue;
            return null;
        }
        Simulation.extractToDirectory("/_ejs_library/css/ejsPage.css", file, false);
        return file;
    }

    private boolean openExternalBrowser(File file, HtmlPageInfo htmlPageInfo) {
        String string = htmlPageInfo.getLink();
        if (string.startsWith("./")) {
            string = String.valueOf(this.model._getClassModelDirectory()) + string.substring(2);
        }
        if (Simulation.extractToDirectory(string, file, false) == null) {
            return false;
        }
        string = "file:///" + FileUtils.correctUrlString(String.valueOf(FileUtils.getPath(file)) + string);
        return OSPDesktop.displayURL(string);
    }

    public void openURL(Object object, URL uRL, Component component, boolean bl) {
        try {
            String string = uRL.toString();
            int n = string.indexOf("jar!");
            if (n < 0) {
                this.tellTheUserToWait();
                OSPDesktop.displayURL(uRL.toString());
                return;
            }
            if ((string = string.substring(n + 4)).startsWith("/")) {
                string = string.substring(1);
            }
            if (bl) {
                this.tellTheUserToWait();
                OSPDesktop.displayURL(uRL.toString());
            } else {
                boolean bl2;
                String string2 = string.toLowerCase();
                boolean bl3 = bl2 = string2.indexOf(".html") < 0 && string2.indexOf(".htm") < 0;
                if (bl2) {
                    File file = Simulation.requiresResourceFile(string);
                    if (file == null) {
                        JOptionPane.showMessageDialog(component, String.valueOf(ejsRes.getString("Simulation.ErrorWhenOpening")) + ":\n  " + uRL.getFile());
                    } else {
                        this.tellTheUserToWait();
                        OSPDesktop.displayURL(file.toURI().toString());
                    }
                } else {
                    int n2 = string.indexOf(35);
                    String string3 = n2 >= 0 ? string.substring(0, n2) : string;
                    for (EditorAndScroll editorAndScroll : this.descriptionPagesList) {
                        if (!string3.equals(editorAndScroll.name)) continue;
                        this.descriptionPanel.setSelectedComponent(editorAndScroll.scrollPane);
                        if (editorAndScroll.editorPane.getPage() != uRL) {
                            editorAndScroll.editorPane.setPage(uRL);
                        }
                        if (uRL.getRef() != null) {
                            editorAndScroll.editorPane.scrollToReference(uRL.getRef());
                        }
                        return;
                    }
                    ((JEditorPane)object).setPage(uRL);
                }
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(component, String.valueOf(ejsRes.getString("Simulation.ErrorWhenOpening")) + ":\n  " + uRL.getFile());
            exception.printStackTrace();
        }
    }

    private void tellTheUserToWait() {
        final JDialog jDialog = new JDialog((Frame)this.descriptionDialog, ejsRes.getString("Simulation.Opening"));
        final JLabel jLabel = new JLabel(ejsRes.getString("Simulation.Opening"));
        jLabel.setBorder(new EmptyBorder(5, 5, 5, 5));
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                jDialog.getContentPane().setLayout(new BorderLayout());
                jDialog.getContentPane().add((Component)jLabel, "Center");
                jDialog.validate();
                jDialog.pack();
                jDialog.setLocationRelativeTo(Simulation.this.descriptionDialog);
                jDialog.setModal(false);
                jDialog.setVisible(true);
            }
        });
        Timer timer = new Timer(3000, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.setVisible(false);
                jDialog.dispose();
            }
        });
        timer.setRepeats(false);
        timer.start();
    }

    public String getVariable(String string) {
        return this.getVariable(string, ",");
    }

    public String getVariable(String string, String string2) {
        if (this.model == null) {
            return null;
        }
        try {
            Field field = this.model.getClass().getField(string);
            if (field.getType().isArray()) {
                String string3 = dummy;
                Object object = field.get(this.model);
                int n = Array.getLength(object);
                int n2 = 0;
                while (n2 < n) {
                    string3 = n2 > 0 ? String.valueOf(string3) + string2 + Array.get(object, n2).toString() : String.valueOf(string3) + Array.get(object, n2).toString();
                    ++n2;
                }
                return string3;
            }
            return field.get(this.model).toString();
        }
        catch (Exception exception) {
            this.errorMessage(exception);
            return null;
        }
    }

    public boolean setVariable(String string, String string2) {
        return this.setVariable(string, string2, ",");
    }

    public boolean setVariable(String string, String string2, String string3) {
        if (this.model == null) {
            return false;
        }
        try {
            Field field = this.model.getClass().getField(string);
            if (field.getType().isArray()) {
                boolean bl = true;
                Object object = field.get(this.model);
                int n = 0;
                int n2 = Array.getLength(object);
                Class<?> clazz = field.getType().getComponentType();
                StringTokenizer stringTokenizer = new StringTokenizer(string2, string3);
                if (n2 < stringTokenizer.countTokens()) {
                    this.errorMessage("Warning: there are less elements in the array than values provided!");
                } else if (n2 > stringTokenizer.countTokens()) {
                    this.errorMessage("Warning: there are more elements in the array than values provided!");
                }
                while (stringTokenizer.hasMoreTokens() && n < n2) {
                    String string4 = stringTokenizer.nextToken();
                    if (clazz.equals(Double.TYPE)) {
                        Array.setDouble(object, n, Double.parseDouble(string4));
                    } else if (clazz.equals(Float.TYPE)) {
                        Array.setFloat(object, n, Float.parseFloat(string4));
                    } else if (clazz.equals(Byte.TYPE)) {
                        Array.setByte(object, n, Byte.parseByte(string4));
                    } else if (clazz.equals(Short.TYPE)) {
                        Array.setShort(object, n, Short.parseShort(string4));
                    } else if (clazz.equals(Integer.TYPE)) {
                        Array.setInt(object, n, Integer.parseInt(string4));
                    } else if (clazz.equals(Long.TYPE)) {
                        Array.setLong(object, n, Long.parseLong(string4));
                    } else if (clazz.equals(Boolean.TYPE)) {
                        if (string4.trim().toLowerCase().equals("true")) {
                            Array.setBoolean(object, n, true);
                        } else {
                            Array.setBoolean(object, n, false);
                        }
                    } else if (clazz.equals(Character.TYPE)) {
                        Array.setChar(object, n, string4.charAt(0));
                    } else if (clazz.equals(strClass)) {
                        Array.set(object, n, string4);
                    } else {
                        bl = false;
                    }
                    ++n;
                }
                return bl;
            }
            Class<?> clazz = field.getType();
            if (clazz.equals(Double.TYPE)) {
                field.setDouble(this.model, Double.parseDouble(string2));
            } else if (clazz.equals(Float.TYPE)) {
                field.setFloat(this.model, Float.parseFloat(string2));
            } else if (clazz.equals(Byte.TYPE)) {
                field.setByte(this.model, Byte.parseByte(string2));
            } else if (clazz.equals(Short.TYPE)) {
                field.setShort(this.model, Short.parseShort(string2));
            } else if (clazz.equals(Integer.TYPE)) {
                field.setInt(this.model, Integer.parseInt(string2));
            } else if (clazz.equals(Long.TYPE)) {
                field.setLong(this.model, Long.parseLong(string2));
            } else if (clazz.equals(Boolean.TYPE)) {
                if (string2.trim().toLowerCase().equals("true")) {
                    field.setBoolean(this.model, true);
                } else {
                    field.setBoolean(this.model, false);
                }
            } else if (clazz.equals(Character.TYPE)) {
                field.setChar(this.model, string2.charAt(0));
            } else if (clazz.equals(strClass)) {
                field.set(this.model, string2);
            } else {
                return false;
            }
            return true;
        }
        catch (Exception exception) {
            this.errorMessage(exception);
            return false;
        }
    }

    public boolean setVariables(String string) {
        return this.setVariables(string, ";", ",");
    }

    public boolean setVariables(String string, String string2, String string3) {
        boolean bl = true;
        String string4 = dummy;
        String string5 = dummy;
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        while (stringTokenizer.hasMoreTokens()) {
            String string6 = stringTokenizer.nextToken();
            int n = string6.indexOf(61);
            if (n < 0) {
                bl = false;
                continue;
            }
            string4 = string6.substring(0, n).trim();
            boolean bl2 = this.setVariable(string4, string5 = string6.substring(n + 1).trim(), string3);
            if (bl2) continue;
            bl = false;
        }
        this.update();
        return bl;
    }

    public LauncherApplet initEmersion() {
        LauncherApplet launcherApplet = this.model._getApplet();
        if (launcherApplet == null) {
            return null;
        }
        try {
            String string = launcherApplet.getParameter("init");
            if (string != null) {
                this._init_ = new MethodWithOneParameter(0, launcherApplet._model, string, null, null, launcherApplet);
                this._init_.invoke(0, launcherApplet);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return launcherApplet;
    }

    public boolean isEmersionConnected() {
        if (this.eMersion == null) {
            return false;
        }
        return this.eMersion.isConnected();
    }

    private boolean javascriptControlMode() {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isImageFormatSupported(String string) {
        try {
            String[] stringArray = ImageIO.getWriterFormatNames();
            int n = 0;
            while (true) {
                if (n >= stringArray.length) {
                    return false;
                }
                if (stringArray[n].equalsIgnoreCase(string)) {
                    return true;
                }
                ++n;
            }
        }
        catch (Exception exception) {}
        return false;
    }

    protected void setUnderEjs(boolean bl) {
        this.isUnderEjs = bl;
    }

    public List<Experiment> getExperiments() {
        return null;
    }

    public Experiment createExperiment(String string) {
        return null;
    }

    public void runExperiment(Experiment experiment) {
        if (experiment == null) {
            return;
        }
        if (this.currentExperiment != null) {
            this.currentExperiment._abortExperiment();
        }
        this.currentExperiment = experiment;
        experiment._runExperiment();
    }

    public void runExperiment(String string) {
        this.runExperiment(this.createExperiment(string));
    }

    public void killExperiment() {
        if (this.currentExperiment != null) {
            this.currentExperiment._abortExperiment();
        }
        this.currentExperiment = null;
    }

    public void addMenuEntries(List<Object> list) {
        if (this.popupMenuExtraEntries == null) {
            this.popupMenuExtraEntries = new ArrayList<Object>();
        }
        this.popupMenuExtraEntries.addAll(list);
        this.popupMenu = null;
    }

    public void addElementMenuEntries(String string, List<Object> list) {
        Serializable serializable;
        if (this.elementsMenu == null) {
            this.elementsMenu = new JMenu(this.getMenuText("ejs_res:MenuItem.Elements"));
            serializable = new ArrayList();
            serializable.add(this.elementsMenu);
            this.addMenuEntries((List<Object>)((Object)serializable));
        }
        serializable = new JMenu(string);
        for (Object object : list) {
            this.addMenuItem((JComponent)serializable, object);
        }
        this.addMenuItem(this.elementsMenu, serializable);
    }

    public Component getTopLevelComponent(Component component) {
        Component component2 = component;
        while (component2.getParent() != null) {
            component2 = component2.getParent();
        }
        return component2;
    }

    public void getPopupMenu(Component component, String string) {
        this.getPopupMenu(component, -1, -1, string);
    }

    public void getPopupMenu(final Component component, int n, int n2, String string) {
        this.captureElement = string;
        if (this.popupMenu == null) {
            Object object;
            Object object222;
            boolean bl = true;
            try {
                System.getProperty("user.home");
            }
            catch (Exception exception) {
                bl = false;
            }
            this.popupMenu = new JPopupMenu();
            List<Experiment> list = this.getExperiments();
            if (list != null) {
                object222 = new JMenu(this.getMenuText("tools_res:MenuItem.Experiments"));
                for (final Experiment object3 : list) {
                    String string2 = this.translateString(object3._getName());
                    String string3 = this.translateString(object3._getDescription());
                    AbstractAction abstractAction = new AbstractAction(string2){

                        public void actionPerformed(ActionEvent actionEvent) {
                            Simulation.this.runExperiment(object3);
                        }
                    };
                    abstractAction.putValue("ShortDescription", string3);
                    ((JMenu)object222).add(abstractAction);
                }
                this.popupMenu.add((JMenuItem)object222);
                object = new JMenuItem(this.getMenuText("tools_res:MenuItem.KillExperiment"));
                ((AbstractButton)object).addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        Simulation.this.killExperiment();
                    }
                });
                this.popupMenu.add((JMenuItem)object);
                this.popupMenu.addSeparator();
            }
            if (this.descriptionDialog != null) {
                this.popupMenu.add(new AbstractAction(Memory.getResource("ShowDescription")){

                    public void actionPerformed(ActionEvent actionEvent) {
                        Simulation.this.descriptionDialog.setVisible(true);
                    }
                });
            }
            if (this.popupMenuExtraEntries != null && this.popupMenuExtraEntries.size() > 0) {
                for (Object object222 : this.popupMenuExtraEntries) {
                    this.addMenuItem(this.popupMenu, object222);
                }
                this.popupMenu.addSeparator();
            }
            this.extraAction2();
            if (bl || this.isEmersionConnected()) {
                object222 = new JMenu(this.getMenuText("ejs_res:MenuItem.SnapshotTools"));
                ((JMenu)object222).add(new AbstractAction(this.getMenuText("ejs_res:MenuItem.SnapshotTool")){

                    public void actionPerformed(ActionEvent actionEvent) {
                        boolean bl = Simulation.this.isPlaying();
                        if (bl) {
                            Simulation.this.pause();
                        }
                        Simulation.this.saveImageAs(Simulation.this.captureElement);
                        if (bl) {
                            Simulation.this.play();
                        }
                    }
                });
                this.popupMenu.add((JMenuItem)object222);
                this.snapshotMenuItem = new JMenuItem(this.getMenuText("tools_res:MenuItem.Snapshot"));
                this.snapshotMenuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        ((DrawingPanel)Simulation.this.view.getElement(Simulation.this.captureElement).getVisual()).snapshot();
                    }
                });
                ((JMenu)object222).add(this.snapshotMenuItem);
                if (this.videoUtil.isFullClass()) {
                    ((JMenu)object222).add(new AbstractAction(this.getMenuText("ejs_res:MenuItem.TakeEPSSnapshot")){

                        public void actionPerformed(ActionEvent actionEvent) {
                            Simulation.this.videoUtil.takeSnapshot(Simulation.this.getTopLevelComponent(component));
                        }
                    });
                    ((JMenu)object222).add(new AbstractAction(this.getMenuText("ejs_res:MenuItem.TakeEPSSnapshotWindow")){

                        public void actionPerformed(ActionEvent actionEvent) {
                            focusListener = new AWTEventListener(){

                                public void eventDispatched(AWTEvent aWTEvent) {
                                    WindowEvent windowEvent = (WindowEvent)aWTEvent;
                                    if (windowEvent.getID() == 207) {
                                        Toolkit.getDefaultToolkit().removeAWTEventListener(focusListener);
                                        (this).Simulation.this.videoUtil.takeSnapshot(windowEvent.getWindow());
                                    }
                                }
                            };
                            System.out.println("Put the focus on the window you want to capture");
                            Toolkit.getDefaultToolkit().addAWTEventListener(focusListener, 64L);
                        }
                    });
                    ((JMenu)object222).add(new AbstractAction(this.getMenuText("tools_res:MenuItem.Video")){

                        public void actionPerformed(ActionEvent actionEvent) {
                            Simulation.this.videoUtil.startVideoTool(Simulation.this.getView(), Simulation.this.captureElement);
                        }
                    });
                }
                object = new JMenu(this.getMenuText("ejs_res:MenuItem.StateIO"));
                ((JMenu)object).add(new AbstractAction(this.getMenuText("tools_res:MenuItem.SaveState")){

                    public void actionPerformed(ActionEvent actionEvent) {
                        Simulation.this.saveState(null);
                    }
                });
                ((JMenu)object).add(new AbstractAction(this.getMenuText("tools_res:MenuItem.ReadState")){

                    public void actionPerformed(ActionEvent actionEvent) {
                        Simulation.this.updateView = false;
                        Simulation.this.readState(null);
                        Simulation.this.updateView = true;
                        Simulation.this.updateAfterModelAction();
                    }
                });
                ((JMenu)object).add(new AbstractAction(this.getMenuText("ejs_res:MenuItem.DefaultResetState")){

                    public void actionPerformed(ActionEvent actionEvent) {
                        Simulation.this.resetFile = null;
                        Simulation.this.reset();
                    }
                });
                this.popupMenu.add((JMenuItem)object);
            }
            object222 = new JMenu(ejsRes.getString("MenuItem.GUI"));
            Model._getTranslatorUtil().addToMenu((JMenu)object222, this);
            object = new JMenu(DisplayRes.getString("DrawingFrame.Font_menu_title"));
            ((JMenu)object).add(new AbstractAction(DisplayRes.getString("DrawingFrame.IncreaseFontSize_menu_item")){

                public void actionPerformed(ActionEvent actionEvent) {
                    FontSizer.levelUp();
                    for (String string : Simulation.this.getWindowsList()) {
                        FontSizer.setFonts(Simulation.this.getView().getComponent(string), FontSizer.getLevel());
                    }
                }
            });
            ((JMenu)object).add(new AbstractAction(DisplayRes.getString("DrawingFrame.DecreaseFontSize_menu_item")){

                public void actionPerformed(ActionEvent actionEvent) {
                    FontSizer.levelDown();
                    for (String string : Simulation.this.getWindowsList()) {
                        FontSizer.setFonts(Simulation.this.getView().getComponent(string), FontSizer.getLevel());
                    }
                }
            });
            ((JMenu)object222).add((JMenuItem)object);
            this.popupMenu.add((JMenuItem)object222);
            this.popupMenu.addSeparator();
            if (bl && EjsTool.hasEjsModel(this.getModel().getClass())) {
                this.popupMenu.add(new AbstractAction(ejsRes.getString("Simulation.OpenEjsModel")){

                    public void actionPerformed(ActionEvent actionEvent) {
                        String string;
                        try {
                            string = System.getProperty("launcher.password");
                        }
                        catch (Exception exception) {
                            string = null;
                        }
                        boolean bl = EjsTool.runEjs(Simulation.this.getModel().getClass(), string);
                        if (!Simulation.this.model._isApplet() && !OSPRuntime.isLauncherMode() && bl) {
                            System.exit(0);
                        }
                    }
                });
            }
            if (!this.isUnderEjs && bl && !this.model._isApplet()) {
                this.popupMenu.add(new AbstractAction(Memory.getResource("CreateHTMLPage")){

                    public void actionPerformed(ActionEvent actionEvent) {
                        Simulation.this.createHTMLpage();
                    }
                });
            }
            if (bl) {
                JMenu jMenu = new JMenu(Memory.getResource("Diagnostics.Menu"));
                jMenu.add(new AbstractAction(this.getMenuText("tools_res:Diagnostics.OS.About.Title")){

                    public void actionPerformed(ActionEvent actionEvent) {
                        Diagnostics.aboutOS();
                    }
                });
                jMenu.add(new AbstractAction(this.getMenuText("tools_res:Diagnostics.Java.About.Title")){

                    public void actionPerformed(ActionEvent actionEvent) {
                        Diagnostics.aboutJava();
                    }
                });
                jMenu.add(new AbstractAction(this.getMenuText("tools_res:Diagnostics.Java3D.About.Title")){

                    public void actionPerformed(ActionEvent actionEvent) {
                        Diagnostics.aboutJava3D();
                    }
                });
                jMenu.add(new AbstractAction(this.getMenuText("tools_res:Diagnostics.QTJava.About.Title")){

                    public void actionPerformed(ActionEvent actionEvent) {
                        Diagnostics.aboutQTJava();
                    }
                });
                this.popupMenu.add(jMenu);
            }
            this.popupMenu.add(new AbstractAction("OSP " + ToolsRes.getString("MenuItem.Log")){

                public void actionPerformed(ActionEvent actionEvent) {
                    OSPLog oSPLog = OSPLog.getOSPLog();
                    if (oSPLog != null) {
                        oSPLog.setLocationRelativeTo(Simulation.this.parentComponent);
                    }
                    OSPLog.showLog();
                }
            });
        }
        if (this.snapshotMenuItem != null) {
            this.snapshotMenuItem.setVisible(component instanceof DrawingPanel);
        }
        Model._getTranslatorUtil().refreshMenu();
        this.popupTriggeredBy = component;
        if (n >= 0 && n2 >= 0) {
            this.popupMenu.show(component, n, n2);
        } else {
            this.popupMenu.show(component, (component.getWidth() - this.popupMenu.getWidth()) / 2, (component.getHeight() - this.popupMenu.getHeight()) / 2);
        }
    }

    private String getMenuText(String string) {
        String string2 = string.startsWith("ejs_res:") ? ejsRes.getString(string.substring(string.indexOf(58) + 1)) : (string.startsWith("tools_res:") ? ToolsRes.getString(string.substring(string.indexOf(58) + 1)) : (string.startsWith("display_res:") ? DisplayRes.getString(string.substring(string.indexOf(58) + 1)) : ToolsRes.getString(string)));
        if (string2.startsWith("!") && string2.endsWith("!")) {
            string2 = DisplayRes.getString(string);
        }
        if (string2.startsWith("!") && string2.endsWith("!")) {
            string2 = string;
        }
        return string2;
    }

    private void processMenuTexts(Object object) {
        if (object instanceof JMenu) {
            JMenu jMenu = (JMenu)object;
            jMenu.setText(this.getMenuText(jMenu.getActionCommand()));
            int n = 0;
            int n2 = jMenu.getItemCount();
            while (n < n2) {
                this.processMenuTexts(jMenu.getItem(n));
                ++n;
            }
        } else if (object instanceof JMenuItem) {
            JMenuItem jMenuItem = (JMenuItem)object;
            jMenuItem.setText(this.getMenuText(jMenuItem.getActionCommand()));
        }
    }

    private void addMenuItem(JComponent jComponent, Object object) {
        if (object instanceof Action) {
            final Action action = (Action)object;
            String string = (String)action.getValue("Name");
            String string2 = this.getMenuText(string);
            AbstractAction abstractAction = new AbstractAction(string2){
                private static final long serialVersionUID = 1L;

                public void actionPerformed(ActionEvent actionEvent) {
                    action.actionPerformed(actionEvent);
                }
            };
            abstractAction.putValue("ShortDescription", string2);
            if (jComponent instanceof JMenu) {
                ((JMenu)jComponent).add(abstractAction);
            } else if (jComponent instanceof JPopupMenu) {
                ((JPopupMenu)jComponent).add(abstractAction);
            }
        } else if (object instanceof JMenu) {
            JMenu jMenu = (JMenu)object;
            this.processMenuTexts(jMenu);
            if (jComponent instanceof JMenu) {
                ((JMenu)jComponent).add(jMenu);
            } else if (jComponent instanceof JPopupMenu) {
                ((JPopupMenu)jComponent).add(jMenu);
            }
        } else if (object instanceof JMenuItem) {
            JMenuItem jMenuItem = (JMenuItem)object;
            this.processMenuTexts(jMenuItem);
            if (jComponent instanceof JMenu) {
                ((JMenu)jComponent).add(jMenuItem);
            } else if (jComponent instanceof JPopupMenu) {
                ((JPopupMenu)jComponent).add(jMenuItem);
            }
        }
    }

    public List<String> getWindowsList() {
        return new ArrayList<String>();
    }

    public String getMainWindow() {
        return null;
    }

    public String getJarName() {
        URL uRL = this.getClass().getResource(String.valueOf(this.getClass().getSimpleName()) + ".class");
        if (uRL != null) {
            try {
                URLConnection uRLConnection = uRL.openConnection();
                if (uRLConnection instanceof JarURLConnection) {
                    JarURLConnection jarURLConnection = (JarURLConnection)uRLConnection;
                    String string = jarURLConnection.getJarFileURL().getPath();
                    int n = string.lastIndexOf(47);
                    if (n >= 0) {
                        string = string.substring(n + 1);
                    }
                    return string;
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return null;
    }

    public void createHTMLpage() {
        String string;
        JFileChooser jFileChooser = OSPRuntime.createChooser("HTML", new String[]{"html"});
        jFileChooser.setSelectedFile(new File(String.valueOf(this.getModelClassname()) + ".html"));
        String string2 = OSPRuntime.chooseFilename(jFileChooser, this.popupTriggeredBy, true);
        if (string2 == null) {
            return;
        }
        if (string2.lastIndexOf(46) < 0) {
            string2 = String.valueOf(string2) + ".html";
        }
        Component component = this.getView().getComponent(this.getMainWindow());
        Dimension dimension = new Dimension(100, 100);
        if (component != null) {
            dimension = component.getSize();
        }
        if ((string = this.getClass().getName()).endsWith("Simulation")) {
            string = string.substring(0, string.length() - 10);
        }
        string = String.valueOf(string) + "Applet.class";
        String string3 = this.getJarName();
        String string4 = this.getModelClassname();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<html>\n");
        stringBuffer.append("  <head>\n");
        stringBuffer.append("    <title>" + string4 + " HTML</title>\n");
        stringBuffer.append("  </head>\n");
        stringBuffer.append("  <body >\n");
        stringBuffer.append("    <applet code=\"" + string + "\"\n");
        stringBuffer.append("            codebase=\".\" archive=\"" + string3 + "\"\n");
        stringBuffer.append("            name=\"" + string4 + "\"  id=\"" + string4 + "\"\n");
        stringBuffer.append("            width=\"" + dimension.width + "\" height=\"" + dimension.height + "\">\n");
        stringBuffer.append("  </applet>\n");
        stringBuffer.append("  </body>\n");
        stringBuffer.append("</html>\n");
        try {
            FileWriter fileWriter = new FileWriter(string2);
            fileWriter.write(stringBuffer.toString());
            fileWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            JOptionPane.showMessageDialog(this.popupTriggeredBy, "Error saving file: " + string2, "File Error", 0);
        }
    }

    public boolean saveImage(String string) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        DecimalFormat decimalFormat = new DecimalFormat("00");
        String string2 = String.valueOf(gregorianCalendar.get(1)) + decimalFormat.format(gregorianCalendar.get(2)) + decimalFormat.format(gregorianCalendar.get(5)) + "_" + decimalFormat.format(gregorianCalendar.get(11)) + decimalFormat.format(gregorianCalendar.get(12)) + decimalFormat.format(gregorianCalendar.get(13));
        return this.saveImage(String.valueOf(this.getClassname()) + "_" + string2 + ".jpg", string);
    }

    public boolean saveImageAs(String string) {
        return this.saveImage(null, string);
    }

    public boolean saveImage(String string, String string2) {
        if (this.view == null) {
            return false;
        }
        ControlElement controlElement = this.view.getElement(string2);
        if (controlElement == null) {
            System.err.println("Component not found: " + string2);
            return false;
        }
        Component component = controlElement.getComponent();
        if (this.isEmersionConnected() || this.javascriptControlMode()) {
            OutputStream outputStream;
            block20: {
                boolean bl;
                Object object;
                BufferedImage bufferedImage;
                block19: {
                    if (component instanceof JFrame) {
                        component = ((JFrame)component).getContentPane();
                    } else if (component instanceof JDialog) {
                        component = ((JDialog)component).getContentPane();
                    }
                    bufferedImage = new BufferedImage(component.getWidth(), component.getHeight(), 5);
                    if (controlElement instanceof SpecialRender) {
                        ((SpecialRender)((Object)controlElement)).render(bufferedImage);
                    } else {
                        object = bufferedImage.getGraphics();
                        component.paint((Graphics)object);
                        ((Graphics)object).dispose();
                    }
                    if (string == null) {
                        string = "default.gif";
                    }
                    if (this.isEmersionConnected()) {
                        return this.eMersion.saveImage(string, "GIF image", bufferedImage) != null;
                    }
                    try {
                        object = "jpg";
                        int n = string.lastIndexOf(46);
                        if (n >= 0) {
                            object = string.substring(n + 1).toLowerCase();
                        } else {
                            string = String.valueOf(string) + "." + (String)object;
                        }
                        bl = Simulation.isImageFormatSupported((String)object);
                        if (bl || this.videoUtil.isFullClass() && "gif".equalsIgnoreCase((String)object)) break block19;
                        System.err.println("Format not supported : " + (String)object);
                        return false;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        return false;
                    }
                }
                outputStream = null;
                outputStream = this.javascriptControlMode() || string.startsWith("ejs:") ? new ByteArrayOutputStream() : new FileOutputStream(string);
                boolean bl2 = true;
                bl2 = bl ? ImageIO.write((RenderedImage)bufferedImage, (String)object, outputStream) : this.videoUtil.writeGIF(outputStream, bufferedImage);
                outputStream.close();
                if (bl2) break block20;
                return false;
            }
            if (string.startsWith("ejs:")) {
                memory.put(string, ((ByteArrayOutputStream)outputStream).toByteArray());
            } else if (this.javascriptControlMode()) {
                this.javascriptControledApplet.setImageByteArray(((ByteArrayOutputStream)outputStream).toByteArray());
            }
            return true;
        }
        return SnapshotTool.getTool().saveImage(string, component, null);
    }

    public void processArguments(String[] stringArray) {
        LauncherApplet launcherApplet = this.model._getApplet();
        if (launcherApplet == null) {
            int n;
            if (stringArray != null && stringArray.length > 0) {
                n = 0;
                while (n < stringArray.length) {
                    if (stringArray[n].toLowerCase().endsWith(".xml")) {
                        this.resetFile = stringArray[n];
                        this.readState(this.resetFile);
                    } else if (stringArray[n].equals("-_initialState")) {
                        this.resetFile = stringArray[++n];
                        this.readState(this.resetFile);
                    }
                    ++n;
                }
            }
            int n2 = n = this.isUnderEjs ? 0 : 1;
            if (OSPRuntime.isLauncherMode()) {
                n = 0;
            } else {
                try {
                    if ("true".equals(System.getProperty("osp_launcher"))) {
                        n = 0;
                    }
                }
                catch (Exception exception) {}
            }
            if (n != 0 && this.showDescriptionOnStart) {
                this.showDescription();
            }
        }
    }

    public static List<String> toArrayList(String string) {
        if (string == null) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ;,");
        ArrayList<String> arrayList = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        return arrayList;
    }

    public List<String> getStateVariablesList() {
        return this.stateVariablesList;
    }

    public void setStateVariablesList(List<String> list) {
        this.stateVariablesList = list;
    }

    public void setStateVariablesList(String string) {
        this.stateVariablesList = Simulation.toArrayList(string);
    }

    public boolean saveState(String string) {
        return this.saveVariables(string, this.stateVariablesList);
    }

    public boolean readState(String string) {
        return this.readVariables(string, this.stateVariablesList);
    }

    public boolean readState(String string, URL uRL) {
        return this.readVariables(string, this.stateVariablesList);
    }

    public boolean saveVariables(String string, String string2) {
        return this.saveVariables(string, Simulation.toArrayList(string2));
    }

    public boolean readVariables(String string, URL uRL, String string2) {
        return this.readVariables(string, Simulation.toArrayList(string2));
    }

    public boolean readVariables(String string, URL uRL, List<String> list) {
        return this.readVariables(string, list);
    }

    public boolean readVariables(String string, List<String> list) {
        boolean bl;
        if (this.model == null) {
            return false;
        }
        if (string == null) {
            JFileChooser jFileChooser = OSPRuntime.createChooser("XML", new String[]{"xml"});
            jFileChooser.setSelectedFile(new File(String.valueOf(this.getModelClassname()) + "_Variables.xml"));
            string = OSPRuntime.chooseFilename(jFileChooser, this.popupTriggeredBy, false);
            if (string == null) {
                return false;
            }
        }
        if (bl = this.justReadVariables(string, list)) {
            if (this.view != null) {
                this.view.initialize();
            }
            this.updateAfterModelAction();
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive exception aggregation
     */
    private boolean justReadVariables(String string, List<String> list) {
        try {
            Object object;
            Object object2;
            Object object3;
            boolean bl = true;
            URLConnection uRLConnection = null;
            Reader reader = null;
            if (string.startsWith("ejs:")) {
                bl = memory.get(string) != null;
            } else if (!this.isEmersionConnected()) {
                if (string.startsWith("url:")) {
                    object3 = string.substring(4);
                    try {
                        uRLConnection = new URL((String)object3).openConnection();
                    }
                    catch (Exception exception) {
                        bl = false;
                    }
                } else {
                    reader = ResourceLoader.openReader(string);
                    boolean bl2 = bl = reader != null;
                }
            }
            if (!bl) {
                this.errorMessage("File does not exist " + string);
                return false;
            }
            object3 = null;
            ObjectInputStream objectInputStream = null;
            if (string.toLowerCase().endsWith(".xml")) {
                void var8_13;
                Object var8_9 = null;
                object2 = null;
                if (uRLConnection != null) {
                    object2 = new InputStreamReader((InputStream)uRLConnection.getContent());
                } else if (string.startsWith("ejs:")) {
                    object2 = new CharArrayReader((char[])memory.get(string));
                } else if (this.isEmersionConnected()) {
                    String string2 = this.eMersion.readXML(string);
                } else {
                    object2 = reader;
                }
                if (object2 != null) {
                    object = new LineNumberReader((Reader)object2);
                    StringBuffer stringBuffer = new StringBuffer();
                    String string3 = ((LineNumberReader)object).readLine();
                    while (string3 != null) {
                        stringBuffer.append(String.valueOf(string3) + "\n");
                        string3 = ((LineNumberReader)object).readLine();
                    }
                    ((Reader)object2).close();
                    String string4 = stringBuffer.toString();
                }
                if (!((XMLControlElement)(object3 = new XMLControlElement(this.getClass()))).readXMLForClass((String)var8_13, this.getClass())) {
                    return true;
                }
            } else {
                void var8_18;
                if (uRLConnection != null) {
                    InputStream inputStream = uRLConnection.getInputStream();
                } else if (string.startsWith("ejs:")) {
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream((byte[])memory.get(string));
                } else if (this.isEmersionConnected()) {
                    object2 = this.eMersion.readBinary(string);
                    if (object2 == null) {
                        return false;
                    }
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream((byte[])object2);
                } else {
                    FileInputStream fileInputStream = new FileInputStream(string);
                }
                if (var8_18 == null) {
                    return false;
                }
                objectInputStream = new ObjectInputStream(new BufferedInputStream((InputStream)var8_18));
            }
            Field[] fieldArray = this.model.getClass().getFields();
            if (list == null) {
                int n = 0;
                while (n < fieldArray.length) {
                    if (fieldArray[n].get(this.model) instanceof Serializable) {
                        if (object3 != null) {
                            object = ((XMLControlElement)object3).getObject(fieldArray[n].getName());
                            if (object != null) {
                                fieldArray[n].set(this.model, object);
                            }
                        } else if (objectInputStream != null) {
                            fieldArray[n].set(this.model, objectInputStream.readObject());
                        }
                    }
                    ++n;
                }
            } else {
                int n = 0;
                int n2 = list.size();
                while (n < n2) {
                    String string5 = list.get(n).trim();
                    int n3 = 0;
                    while (n3 < fieldArray.length) {
                        if (fieldArray[n3].get(this.model) instanceof Serializable && fieldArray[n3].getName().equals(string5)) {
                            if (object3 != null) {
                                Object object4 = ((XMLControlElement)object3).getObject(string5);
                                if (object4 == null) break;
                                fieldArray[n3].set(this.model, object4);
                                break;
                            }
                            if (objectInputStream == null) break;
                            fieldArray[n3].set(this.model, objectInputStream.readObject());
                            break;
                        }
                        ++n3;
                    }
                    ++n;
                }
            }
            if (objectInputStream != null) {
                objectInputStream.close();
            }
            return true;
        }
        catch (Exception exception) {
            this.errorMessage("Error when trying to read " + string);
            exception.printStackTrace(System.err);
            JOptionPane.showMessageDialog(this.getParentComponent(), exception.getLocalizedMessage());
            return false;
        }
    }

    public boolean saveVariables(String string, List<String> list) {
        Object object;
        Object object2;
        if (this.model == null) {
            return false;
        }
        boolean bl = true;
        if (string == null) {
            if (this.isEmersionConnected()) {
                string = "Unnamed.xml";
            } else {
                object2 = OSPRuntime.createChooser("XML", new String[]{"xml"});
                ((JFileChooser)object2).setSelectedFile(new File(String.valueOf(this.getModelClassname()) + "_Variables.xml"));
                object = new MyXMLAccessory((JFileChooser)object2);
                ((JFileChooser)object2).setAccessory((JComponent)object);
                ((JFileChooser)object2).addActionListener(new ActionListener((MyXMLAccessory)object){
                    private final /* synthetic */ MyXMLAccessory val$accesory;
                    {
                        this.val$accesory = myXMLAccessory;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        JFileChooser jFileChooser = (JFileChooser)actionEvent.getSource();
                        String string = actionEvent.getActionCommand();
                        if (string.equals("ApproveSelection")) {
                            File file = jFileChooser.getSelectedFile();
                            String string2 = file.getName();
                            boolean bl = false;
                            if (this.val$accesory.saveAsXML()) {
                                if (!string2.toLowerCase().endsWith(".xml")) {
                                    jFileChooser.setSelectedFile(new File(file.getParent(), String.valueOf(string2) + ".xml"));
                                    bl = true;
                                }
                            } else if (string2.toLowerCase().endsWith(".xml")) {
                                jFileChooser.setSelectedFile(new File(file.getParent(), String.valueOf(string2) + ".bin"));
                                bl = true;
                            }
                            if (bl) {
                                JOptionPane.showMessageDialog(Simulation.this.popupTriggeredBy, String.valueOf(ejsRes.getString("Simulation.XMLFileRenamed")) + ":\n  " + jFileChooser.getSelectedFile().getName());
                            }
                        }
                    }
                });
                string = OSPRuntime.chooseFilename((JFileChooser)object2, this.popupTriggeredBy, true);
                if (string == null) {
                    return false;
                }
                bl = ((MyXMLAccessory)object).saveAsXML();
            }
        } else {
            bl = string.toLowerCase().endsWith(".xml");
        }
        try {
            int n;
            Object object3;
            object2 = null;
            object = null;
            ObjectOutputStream objectOutputStream = null;
            if (bl) {
                object2 = new XMLControlElement(this.getClass());
            } else {
                object = this.javascriptControlMode() || string.startsWith("ejs:") || this.isEmersionConnected() ? new ByteArrayOutputStream() : new FileOutputStream(string);
                object3 = new BufferedOutputStream((OutputStream)object);
                objectOutputStream = new ObjectOutputStream((OutputStream)object3);
            }
            object3 = this.model.getClass().getFields();
            if (list == null) {
                n = 0;
                while (n < ((Field[])object3).length) {
                    if (object3[n].get(this.model) instanceof Serializable) {
                        if (object2 != null) {
                            ((XMLControlElement)object2).setValue(object3[n].getName(), object3[n].get(this.model));
                        } else if (objectOutputStream != null) {
                            objectOutputStream.writeObject(object3[n].get(this.model));
                        }
                    }
                    ++n;
                }
            } else {
                n = 0;
                int n2 = list.size();
                while (n < n2) {
                    String string2 = list.get(n).trim();
                    int n3 = 0;
                    while (n3 < ((Field[])object3).length) {
                        if (object3[n3].get(this.model) instanceof Serializable && object3[n3].getName().equals(string2)) {
                            if (object2 != null) {
                                ((XMLControlElement)object2).setValue(object3[n3].getName(), object3[n3].get(this.model));
                                break;
                            }
                            if (objectOutputStream == null) break;
                            objectOutputStream.writeObject(object3[n3].get(this.model));
                            break;
                        }
                        ++n3;
                    }
                    ++n;
                }
            }
            if (object2 != null) {
                Writer writer;
                if (string.startsWith("ejs:")) {
                    writer = new CharArrayWriter();
                } else {
                    if (this.isEmersionConnected()) {
                        return this.eMersion.saveXML(string, "XML file", ((XMLControlElement)object2).toXML()) != null;
                    }
                    writer = new FileWriter(string);
                }
                ((XMLControlElement)object2).write(writer);
                if (string.startsWith("ejs:")) {
                    memory.put(string, ((CharArrayWriter)writer).toCharArray());
                }
            } else {
                if (objectOutputStream != null) {
                    objectOutputStream.close();
                }
                if (object != null) {
                    if (string.startsWith("ejs:")) {
                        memory.put(string, ((ByteArrayOutputStream)object).toByteArray());
                    } else {
                        if (this.isEmersionConnected()) {
                            return this.eMersion.saveBinary(string, "Binary data", ((ByteArrayOutputStream)object).toByteArray()) != null;
                        }
                        if (this.javascriptControlMode()) {
                            this.javascriptControledApplet.setStateByteArray(((ByteArrayOutputStream)object).toByteArray());
                        }
                    }
                }
            }
            return true;
        }
        catch (Exception exception) {
            this.errorMessage("Error when trying to save " + string);
            exception.printStackTrace(System.err);
            return false;
        }
    }

    public String getVariablesXML(String string) {
        return this.getVariablesXML(Simulation.toArrayList(string));
    }

    public String getVariablesXML(List<String> list) {
        if (this.model == null) {
            return null;
        }
        try {
            int n;
            XMLControlElement xMLControlElement = new XMLControlElement(this.getClass());
            Field[] fieldArray = this.model.getClass().getFields();
            if (list == null) {
                n = 0;
                while (n < fieldArray.length) {
                    if (fieldArray[n].get(this.model) instanceof Serializable) {
                        xMLControlElement.setValue(fieldArray[n].getName(), fieldArray[n].get(this.model));
                    }
                    ++n;
                }
            } else {
                n = 0;
                int n2 = list.size();
                while (n < n2) {
                    String string = list.get(n).trim();
                    int n3 = 0;
                    while (n3 < fieldArray.length) {
                        if (fieldArray[n3].get(this.model) instanceof Serializable && fieldArray[n3].getName().equals(string)) {
                            xMLControlElement.setValue(fieldArray[n3].getName(), fieldArray[n3].get(this.model));
                            break;
                        }
                        ++n3;
                    }
                    ++n;
                }
            }
            CharArrayWriter charArrayWriter = new CharArrayWriter();
            xMLControlElement.write(charArrayWriter);
            return charArrayWriter.toString();
        }
        catch (Exception exception) {
            this.errorMessage("Error when trying to get XML of variables!");
            exception.printStackTrace(System.err);
            return null;
        }
    }

    public boolean saveText(String string, String string2) {
        try {
            Writer writer;
            if (string.startsWith("ejs:")) {
                writer = new CharArrayWriter();
            } else {
                if (this.isEmersionConnected()) {
                    if (string.toLowerCase().endsWith(".xml")) {
                        return this.eMersion.saveXML(string, "XML file", string2) != null;
                    }
                    return this.eMersion.saveText(string, "Text file", string2) != null;
                }
                writer = new FileWriter(string);
            }
            BufferedWriter bufferedWriter = new BufferedWriter(writer);
            bufferedWriter.write(string2);
            bufferedWriter.close();
            if (string.startsWith("ejs:")) {
                memory.put(string, ((CharArrayWriter)writer).toCharArray());
            }
            return true;
        }
        catch (Exception exception) {
            System.err.println("Error when trying to save" + string);
            exception.printStackTrace(System.err);
            return false;
        }
    }

    public boolean saveText(String string, StringBuffer stringBuffer) {
        return this.saveText(string, stringBuffer.toString());
    }

    public String readText(String string) {
        return this.readText(string, null);
    }

    public String readText(String string, URL uRL) {
        if (string.startsWith("url:")) {
            String string2 = string.substring(4);
            if (uRL != null && !string2.startsWith("http:")) {
                string2 = uRL + string2;
            }
            try {
                return (String)new URL(string2).getContent();
            }
            catch (Exception exception) {
                System.err.println("Error when trying to read " + string);
                exception.printStackTrace(System.err);
                return null;
            }
        }
        try {
            Reader reader;
            if (string.startsWith("ejs:")) {
                reader = new CharArrayReader((char[])memory.get(string));
            } else {
                if (this.isEmersionConnected()) {
                    if (string.toLowerCase().endsWith(".xml")) {
                        return this.eMersion.readXML(string);
                    }
                    return this.eMersion.readText(string);
                }
                reader = new FileReader(string);
            }
            LineNumberReader lineNumberReader = new LineNumberReader(reader);
            StringBuffer stringBuffer = new StringBuffer();
            String string3 = lineNumberReader.readLine();
            while (string3 != null) {
                stringBuffer.append(String.valueOf(string3) + "\n");
                string3 = lineNumberReader.readLine();
            }
            reader.close();
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            System.err.println("Error when trying to read " + string);
            exception.printStackTrace(System.err);
            return null;
        }
    }

    protected void extraAction2() {
    }

    protected void extraAction3() {
    }

    private static class EditorAndScroll {
        String name;
        JEditorPane editorPane;
        JScrollPane scrollPane;

        EditorAndScroll(String string, JEditorPane jEditorPane, JScrollPane jScrollPane) {
            this.name = string;
            this.editorPane = jEditorPane;
            this.scrollPane = jScrollPane;
        }
    }

    private static class MyXMLAccessory
    extends JPanel {
        private JRadioButton xmlButton = new JRadioButton("XML", true);

        public MyXMLAccessory(JFileChooser jFileChooser) {
            JRadioButton jRadioButton = new JRadioButton("BIN", false);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.xmlButton);
            buttonGroup.add(jRadioButton);
            this.setLayout(new BoxLayout(this, 1));
            this.add(new JLabel(ejsRes.getString("Simulation.StateFormat")));
            this.add(this.xmlButton);
            this.add(jRadioButton);
        }

        public boolean saveAsXML() {
            return this.xmlButton.isSelected();
        }
    }
}

