/*
 * Decompiled with CFR 0.152.
 */
package users.ntnu.fkh.musicalkeyboard_pkg;

import fkh.SoundGenerator;
import java.awt.Frame;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.Set;
import org.colos.ejs.library.AbstractModel;
import org.colos.ejs.library.LauncherApplet;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.View;
import org.colos.ejs.library.control.EjsControl;
import org.colos.ejs.library.external.ExternalApp;
import org.colos.ejs.library.external.ExternalAppsHandler;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.tools.ResourceLoader;
import users.ntnu.fkh.musicalkeyboard_pkg.musicalkeyboardSimulation;
import users.ntnu.fkh.musicalkeyboard_pkg.musicalkeyboardView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class musicalkeyboard
extends AbstractModel {
    public musicalkeyboardSimulation _simulation = null;
    public musicalkeyboardView _view = null;
    public musicalkeyboard _model = this;
    private ExternalAppsHandler _external = new ExternalAppsHandler(this);
    public double frequence = 215.21800000000002;
    public double amplitude = 1.5;
    public SoundGenerator sound = new SoundGenerator(this.frequence, this.amplitude);
    public boolean splay = true;
    public int npt = 500;
    public double pi = Math.PI;
    public double omega = 2.0 * this.pi * this.frequence;
    public double t = 0.0;
    public double tmax = 10.0;
    public double dt = 5.0E-4;
    public double[][] wave;
    public double[] bf;
    public int nk = 5;
    public int n = this.nk * 7;
    public int n2 = this.nk * 7;
    public double[] x;
    public double[] x2;
    public double[] f;
    public double[] f2;
    public double[] fn;
    public double[] fn2;
    public double[] fc;
    public boolean[] show2;
    public int id = -1;
    public int id2 = -1;
    public int fid = 0;
    public int fjd = 0;
    public double fplay = 330.0;
    public double range = 2.0;
    public double xmin = -this.range;
    public double xmax = this.range;
    public double ymin = -this.range / 8.0;
    public double ymax = this.range / 8.0;
    public double w = (this.xmax - this.xmin) / (double)this.n;
    public double h = this.w * 5.0;
    public double h2 = this.w * 3.0;
    public double stroke = 2.0;
    private boolean _isEnabled_initialization1 = true;

    @Override
    public int _getStepsPerDisplay() {
        return 1;
    }

    public static String _getEjsModel() {
        return "users/ntnu/fkh/musicalkeyboard.xml";
    }

    public static String _getModelDirectory() {
        return "users/ntnu/fkh/";
    }

    public static Set<String> _getEjsResources() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("users/ntnu/fkh/_jar/fkhSoundGenerator.jar");
        return hashSet;
    }

    public static void main(String[] stringArray) {
        int n;
        String string = null;
        boolean bl = true;
        if (stringArray != null) {
            for (n = 0; n < stringArray.length; ++n) {
                if (stringArray[n].equals("-_lookAndFeel")) {
                    string = stringArray[++n];
                    continue;
                }
                if (stringArray[n].equals("-_decorateWindows")) {
                    bl = true;
                    continue;
                }
                if (!stringArray[n].equals("-_doNotDecorateWindows")) continue;
                bl = false;
            }
        }
        if (string != null) {
            OSPRuntime.setLookAndFeel(bl, string);
        }
        ResourceLoader.addSearchPath("users/ntnu/fkh/");
        n = 0;
        try {
            if (System.getProperty("osp_ejs") != null) {
                Simulation.setPathToLibrary("D:/EJS_4.2/bin/config/");
                n = 1;
            }
        }
        catch (Exception exception) {
            n = 0;
        }
        try {
            EjsControl.setDefaultScreen(Integer.parseInt(System.getProperty("screen")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n == 0) {
            Simulation.setPathToLibrary("D:/EJS_4.2/bin/config/");
        }
        musicalkeyboard musicalkeyboard2 = new musicalkeyboard(stringArray);
    }

    public musicalkeyboard() {
        this(null, null, null, null, null, false);
    }

    public musicalkeyboard(String[] stringArray) {
        this(null, null, null, null, stringArray, true);
    }

    public musicalkeyboard(String string, Frame frame, URL uRL, LauncherApplet launcherApplet, String[] stringArray, boolean bl) {
        this.__theArguments = stringArray;
        this.__theApplet = launcherApplet;
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)numberFormat).getDecimalFormatSymbols().setDecimalSeparator('.');
        }
        this._simulation = new musicalkeyboardSimulation(this, string, frame, uRL, bl);
        this._view = (musicalkeyboardView)this._simulation.getView();
        this._simulation.processArguments(stringArray);
    }

    @Override
    public View getView() {
        return this._view;
    }

    @Override
    public Simulation getSimulation() {
        return this._simulation;
    }

    @Override
    public void _resetSolvers() {
        this._external.resetIC();
    }

    @Override
    public String _externalInitCommand(String string) {
        return null;
    }

    @Override
    public void _externalSetValues(boolean bl, ExternalApp externalApp) {
    }

    @Override
    public void _externalGetValues(boolean bl, ExternalApp externalApp) {
    }

    public void _setPageEnabled(String string, boolean bl) {
        boolean bl2 = false;
        if ("Init Page".equals(string)) {
            bl2 = true;
            this._isEnabled_initialization1 = bl;
        }
        if (!bl2) {
            System.out.println("_setPageEnabled() warning. Page not found: " + string);
        }
    }

    public void _initialization1() {
        int n;
        double d = this.tmax / (double)this.npt;
        for (n = 0; n < this.npt; ++n) {
            this.wave[n][0] = (double)n * d;
        }
        for (n = 0; n < this.n; ++n) {
            this.fid = n / 7;
            this.fjd = n % 7;
            this.f[n] = this.fc[this.fid] * this.fn[this.fjd];
            this.f2[n] = this.fc[this.fid] * this.fn2[this.fjd];
            this.x[n] = this.xmin + ((double)n + 0.5) * this.w;
            this.x2[n] = this.x[n] + this.w / 2.0;
            this.show2[n] = this.fn2[n % 7] != 0.0;
        }
    }

    public void playnote(int n, double d) {
        this.fplay = d;
        this.sound.setBaseFrequency(d);
        this.sound.play();
    }

    public void pausenote() {
        this.sound.stop();
    }

    public void _method_for_slidera_dragaction() {
        this.sound.setAmplitude(this.amplitude);
    }

    public void _method_for_buttonreset_action() {
        this.sound.stop();
        this._reset();
    }

    public double _method_for_keymain_y() {
        return 0.0;
    }

    public void _method_for_keymain_pressAction() {
        this.playnote(this.id, this.f[this.id]);
    }

    public void _method_for_keymain_dragAction() {
        this.x[this.id] = this.xmin + ((double)this.id + 0.5) * this.w;
    }

    public void _method_for_keymain_releaseAction() {
        this.pausenote();
    }

    public double _method_for_keymain2_y() {
        return (this.h - this.h2) / 2.0;
    }

    public double _method_for_keymain2_sizeX() {
        return this.w / 2.0;
    }

    public void _method_for_keymain2_pressAction() {
        this.playnote(this.id2, this.f2[this.id2]);
    }

    public void _method_for_keymain2_dragAction() {
        this.x2[this.id2] = this.xmin + (double)(this.id2 + 1) * this.w;
    }

    public void _method_for_keymain2_releaseAction() {
        this.pausenote();
    }

    @Override
    public void reset() {
        int n;
        this._isEnabled_initialization1 = true;
        this.frequence = 215.21800000000002;
        this.amplitude = 1.5;
        this.sound = new SoundGenerator(this.frequence, this.amplitude);
        this.splay = true;
        this.npt = 500;
        this.pi = Math.PI;
        this.omega = 2.0 * this.pi * this.frequence;
        this.t = 0.0;
        this.tmax = 10.0;
        this.dt = 5.0E-4;
        this.wave = new double[this.npt][2];
        this.bf = new double[]{262.0, 277.0, 294.0, 311.0, 330.0, 349.0, 370.0, 392.0, 415.0, 440.0, 466.0, 494.0};
        this.nk = 5;
        this.n = this.nk * 7;
        this.n2 = this.nk * 7;
        this.x = new double[this.n];
        for (n = 0; n < this.n; ++n) {
            this.x[n] = 0.0;
        }
        this.x2 = new double[this.n2];
        for (n = 0; n < this.n2; ++n) {
            this.x2[n] = 0.0;
        }
        this.f = new double[this.n];
        for (n = 0; n < this.n; ++n) {
            this.f[n] = 262.0;
        }
        this.f2 = new double[this.n2];
        for (n = 0; n < this.n2; ++n) {
            this.f2[n] = 277.0;
        }
        this.fn = new double[]{262.0, 294.0, 330.0, 349.0, 392.0, 440.0, 494.0};
        this.fn2 = new double[]{277.0, 311.0, 0.0, 370.0, 415.0, 466.0, 0.0};
        this.fc = new double[]{0.25, 0.5, 1.0, 2.0, 4.0};
        this.show2 = new boolean[this.n2];
        for (n = 0; n < this.n2; ++n) {
            this.show2[n] = true;
        }
        this.id = -1;
        this.id2 = -1;
        this.fid = 0;
        this.fjd = 0;
        this.fplay = 330.0;
        this.range = 2.0;
        this.xmin = -this.range;
        this.xmax = this.range;
        this.ymin = -this.range / 8.0;
        this.ymax = this.range / 8.0;
        this.w = (this.xmax - this.xmin) / (double)this.n;
        this.h = this.w * 5.0;
        this.h2 = this.w * 3.0;
        this.stroke = 2.0;
    }

    @Override
    public void initialize() {
        if (this._isEnabled_initialization1) {
            this._initialization1();
        }
        this._resetSolvers();
    }

    @Override
    public void step() {
    }

    @Override
    public void update() {
    }

    @Override
    public void _freeMemory() {
        this.wave = null;
        this.bf = null;
        this.x = null;
        this.x2 = null;
        this.f = null;
        this.f2 = null;
        this.fn = null;
        this.fn2 = null;
        this.fc = null;
        this.show2 = null;
        System.gc();
    }
}

