/*
 * Decompiled with CFR 0.152.
 */
package fkh;

import java.io.InputStream;
import sun.audio.AudioData;
import sun.audio.AudioPlayer;
import sun.audio.ContinuousAudioDataStream;

public class SoundGenerator {
    private static double UNIT = 8000.0;
    private int period;
    private double baseF = 440.0;
    private double omega;
    private byte[] record;
    private double[] Y;
    private InputStream soundStream = null;
    private boolean playstatus = false;
    private double amplitude = 10.0;
    private double y;
    private double amplitudeCST = 1000.0;
    private double A;
    private int maxK = 20;
    private int maxi;
    private double[] cosCoeff = new double[this.maxK];
    private double[] sinCoeff = new double[this.maxK];

    public void setBaseFrequency(double d) {
        this.baseF = d;
        if (this.baseF < 100.0) {
            this.baseF = 100.0;
        } else if (this.baseF > 2000.0) {
            this.baseF = 2000.0;
        }
        this.period = (int)(UNIT / this.baseF);
        this.record = new byte[this.period];
        this.Y = new double[this.period];
        this.omega = Math.PI * 2 / (double)this.period;
        this.setit();
    }

    public void setAmplitude(double d) {
        this.amplitude = d;
        this.setit();
    }

    private void setit() {
        if (this.soundStream != null) {
            this.stop();
            this.playstatus = true;
        }
        this.calc();
        if (this.playstatus) {
            this.play();
        }
    }

    public void setCosCoeff(double[] dArray) {
        this.maxi = dArray.length < this.maxK ? dArray.length : this.maxK;
        int n = 0;
        while (n < this.maxi) {
            this.cosCoeff[n] = dArray[n];
            ++n;
        }
    }

    public void setSinCoeff(double[] dArray) {
        this.maxi = dArray.length < this.maxK ? dArray.length : this.maxK;
        int n = 0;
        while (n < this.maxi) {
            this.sinCoeff[n] = dArray[n];
            ++n;
        }
    }

    public void setFourier(double[] dArray, double[] dArray2) {
        this.setCosCoeff(dArray2);
        this.setSinCoeff(dArray);
        this.calFourier();
    }

    public void setCosCoeff(int n, double d) {
        if (n < this.maxK) {
            this.cosCoeff[n] = d;
        }
    }

    public void setSinCoeff(int n, double d) {
        if (n < this.maxK) {
            this.sinCoeff[n] = d;
        }
    }

    public void calFourier() {
        if (this.soundStream != null) {
            this.stop();
            this.playstatus = true;
        }
        int n = 0;
        while (n < this.period) {
            this.y = this.cosCoeff[0];
            int n2 = 1;
            while (n2 < this.maxi) {
                this.y += this.cosCoeff[n2] * Math.cos((double)(n * n2) * this.omega) + this.sinCoeff[n2] * Math.sin((double)(n * n2) * this.omega);
                ++n2;
            }
            this.Y[n] = this.amplitude * this.y;
            ++n;
        }
        this.setWave(this.Y);
        if (this.playstatus) {
            this.play();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void play() {
        try {
            if (this.soundStream == null) {
                this.soundStream = new ContinuousAudioDataStream(new AudioData(this.record));
            }
            AudioPlayer.player.start(this.soundStream);
            this.playstatus = true;
            return;
        }
        catch (SecurityException securityException) {
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void pause() {
        if (this.soundStream == null) return;
        try {
            AudioPlayer.player.stop(this.soundStream);
            this.playstatus = false;
            return;
        }
        catch (SecurityException securityException) {
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stop() {
        if (this.soundStream != null) {
            try {
                AudioPlayer.player.stop(this.soundStream);
                this.soundStream = null;
            }
            catch (SecurityException securityException) {
            }
        }
        this.playstatus = false;
    }

    private void calc() {
        this.A = this.amplitude * this.amplitudeCST;
        int n = 0;
        while (n < this.period) {
            this.y = this.A * Math.sin((double)n * this.omega);
            this.record[n] = SoundGenerator.int2ulaw((int)this.y);
            this.Y[n] = this.y;
            ++n;
        }
    }

    public void setbaseLevel(double d) {
        this.amplitudeCST = d;
    }

    public void setWave(double[] dArray) {
        this.setWave(dArray, 1.0);
    }

    public void setWave(double[] dArray, double d) {
        if (this.period != dArray.length) {
            this.period = dArray.length;
            this.record = new byte[this.period];
            this.Y = new double[this.period];
        }
        int n = 0;
        while (n < this.period) {
            this.Y[n] = dArray[n] * d * this.amplitudeCST;
            this.record[n] = SoundGenerator.int2ulaw((int)this.Y[n]);
            ++n;
        }
    }

    public void changeLevel(double d) {
        int n = 0;
        while (n < this.period) {
            this.Y[n] = this.Y[n] * d;
            this.record[n] = SoundGenerator.int2ulaw((int)this.Y[n]);
            ++n;
        }
    }

    public static byte int2ulaw(int n) {
        int n2;
        if (n < 0) {
            n = -n;
            n2 = 127;
        } else {
            n2 = 255;
        }
        n = n < 32 ? 0xF0 | 15 - n / 2 : (n < 96 ? 0xE0 | 15 - (n - 32) / 4 : (n < 224 ? 0xD0 | 15 - (n - 96) / 8 : (n < 480 ? 0xC0 | 15 - (n - 224) / 16 : (n < 992 ? 0xB0 | 15 - (n - 480) / 32 : (n < 2016 ? 0xA0 | 15 - (n - 992) / 64 : (n < 4064 ? 0x90 | 15 - (n - 2016) / 128 : (n < 8160 ? 0x80 | 15 - (n - 4064) / 256 : 128)))))));
        return (byte)(n2 & n);
    }

    public SoundGenerator() {
        this.amplitude = 1.0;
        this.baseF = 440.0;
        this.setBaseFrequency(this.baseF);
    }

    public SoundGenerator(double d) {
        this.amplitude = 1.0;
        this.setBaseFrequency(d);
    }

    public SoundGenerator(double d, double d2) {
        this.amplitude = d2;
        this.setBaseFrequency(d);
    }
}

