/*
 * Decompiled with CFR 0.152.
 */
package users.ntnu.fkh.firework_pkg;

import java.awt.Color;
import java.awt.Frame;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.Set;
import org.colos.ejs.library.AbstractModel;
import org.colos.ejs.library.LauncherApplet;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.View;
import org.colos.ejs.library.control.EjsControl;
import org.colos.ejs.library.external.ExternalApp;
import org.colos.ejs.library.external.ExternalAppsHandler;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.numerics.ODE;
import org.opensourcephysics.numerics.ODEMultistepSolver;
import org.opensourcephysics.tools.ResourceLoader;
import org.opensourcephysics.tools.ToolForData;
import org.opensourcephysics.tools.ToolForDataFull;
import users.ntnu.fkh.firework_pkg.fireworkSimulation;
import users.ntnu.fkh.firework_pkg.fireworkView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class firework
extends AbstractModel {
    public fireworkSimulation _simulation = null;
    public fireworkView _view = null;
    public firework _model = this;
    private ExternalAppsHandler _external = new ExternalAppsHandler(this);
    public double range = 20.0;
    public double xmin = -this.range / 2.0;
    public double xmax = this.range / 2.0;
    public double ymin = -this.range / 2.0;
    public double ymax = this.range / 2.0;
    public double t = 0.0;
    public double dt = 0.05;
    public double size = this.range / 25.0;
    public double size2 = this.size / 2.0;
    public double stroke = 2.0;
    public double pi = Math.PI;
    public double npt = 30.0;
    public int n = 36;
    public double[] x;
    public double[] y;
    public double[] vx;
    public double[] vy;
    public Object[] clr;
    public int cid;
    public Object clri = null;
    public double g = 9.8;
    public double ctai;
    public double cta = this.ctai = this.pi / 8.0;
    public double vi = this.ymax * 1.5;
    public double ti;
    public boolean fired = false;
    public double vf = this.ymax;
    public double c;
    public double dc = this.pi * 2.0 / (double)this.n;
    public int count = 0;
    public double sc;
    public double cs;
    public double xi;
    public double tf;
    public double t0 = 2.0 * this.dt;
    public boolean clear = false;
    public boolean sound1 = false;
    public boolean sound2 = false;
    public double ts = 10.0;
    public double td = 1.0;
    public double delta = 0.8;
    public double t2 = 0.0;
    private _ODE_evolution1 _ODEi_evolution1;

    @Override
    public int _getStepsPerDisplay() {
        return 1;
    }

    public static String _getEjsModel() {
        return "users/ntnu/fkh/firework.xml";
    }

    public static String _getModelDirectory() {
        return "users/ntnu/fkh/";
    }

    public static Set<String> _getEjsResources() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("users/ntnu/fkh/_data/fireworkfire.wav");
        hashSet.add("users/ntnu/fkh/_data/fireworkfire3.wav");
        return hashSet;
    }

    public static void main(String[] stringArray) {
        int n;
        String string = null;
        boolean bl = true;
        if (stringArray != null) {
            for (n = 0; n < stringArray.length; ++n) {
                if (stringArray[n].equals("-_lookAndFeel")) {
                    string = stringArray[++n];
                    continue;
                }
                if (stringArray[n].equals("-_decorateWindows")) {
                    bl = true;
                    continue;
                }
                if (!stringArray[n].equals("-_doNotDecorateWindows")) continue;
                bl = false;
            }
        }
        if (string != null) {
            OSPRuntime.setLookAndFeel(bl, string);
        }
        ResourceLoader.addSearchPath("users/ntnu/fkh/");
        n = 0;
        try {
            if (System.getProperty("osp_ejs") != null) {
                Simulation.setPathToLibrary("E:/EJS_4.1/bin/config/");
                n = 1;
            }
        }
        catch (Exception exception) {
            n = 0;
        }
        try {
            EjsControl.setDefaultScreen(Integer.parseInt(System.getProperty("screen")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n == 0) {
            Simulation.setPathToLibrary("E:/EJS_4.1/bin/config/");
        }
        firework firework2 = new firework(stringArray);
    }

    public firework() {
        this(null, null, null, null, null, false);
    }

    public firework(String[] stringArray) {
        this(null, null, null, null, stringArray, true);
    }

    public firework(String string, Frame frame, URL uRL, LauncherApplet launcherApplet, String[] stringArray, boolean bl) {
        this.__theArguments = stringArray;
        this.__theApplet = launcherApplet;
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)numberFormat).getDecimalFormatSymbols().setDecimalSeparator('.');
        }
        this._simulation = new fireworkSimulation(this, string, frame, uRL, bl);
        this._view = (fireworkView)this._simulation.getView();
        this._simulation.processArguments(stringArray);
    }

    @Override
    public View getView() {
        return this._view;
    }

    @Override
    public Simulation getSimulation() {
        return this._simulation;
    }

    @Override
    public void _resetSolvers() {
        this._ODEi_evolution1.resetSolver();
        this._external.resetIC();
    }

    @Override
    public String _externalInitCommand(String string) {
        return null;
    }

    @Override
    public synchronized void _externalSetValues(boolean bl, ExternalApp externalApp) {
    }

    @Override
    public synchronized void _externalGetValues(boolean bl, ExternalApp externalApp) {
    }

    public void _initialization1() {
        this.xi = this.xmin / 4.0 + this.xmax / 2.0 * Math.random();
        this.cta = this.ctai * (Math.random() - 0.5);
        this.cs = Math.cos(this.cta);
        this.sc = Math.sin(this.cta);
        this.clri = new Color((float)Math.random(), (float)Math.random(), (float)Math.random());
        for (int i = 0; i < this.n; ++i) {
            this.x[i] = this.xi;
            this.y[i] = this.ymin;
            this.vx[i] = this.vi * this.sc;
            this.vy[i] = this.vi * this.cs;
            this.clr[i] = this.clri;
        }
        this.ti = 10.0 / this.vi + Math.random() * 0.8;
        this.tf = this.ti + 0.5 + Math.random() * 8.0 / this.vf;
        this.fired = false;
        this.t = 0.0;
        this.stroke = 2.0;
    }

    public void _constraints1() {
        int n;
        this.t2 = this.t - this.delta;
        this.sound1 = this.t2 > this.td && this.t2 < this.ts;
        this.sound2 = this.t2 > this.ts;
        if (this.t > this.ti && !this.fired) {
            this.clri = new Color((float)Math.random(), (float)Math.random(), (float)Math.random());
            for (n = 0; n < this.n; ++n) {
                this.c = (double)n * this.dc;
                int n2 = n;
                this.vx[n2] = this.vx[n2] + this.vf * Math.cos(this.c);
                int n3 = n;
                this.vy[n3] = this.vy[n3] + this.vf * Math.sin(this.c);
                this.clr[n] = this.clri;
            }
            this.stroke = 1.0;
            this.fired = true;
            this.ts = this.t + this.td;
        }
        this.count = 0;
        for (n = 0; n < this.n; ++n) {
            if (!(this.y[n] < this.ymin) && !(this.x[n] > this.xmax) && !(this.x[n] < this.xmin)) continue;
            ++this.count;
        }
        this.clear = this.t < this.dt;
        if (this.count >= this.n || this.t2 > this.tf && this.t2 > this.ts + this.td) {
            this.clear = true;
            this._initialize();
        }
    }

    public boolean _method_for_traceSet_visible() {
        return this.t < this.tf;
    }

    public boolean _method_for_traceSet_active() {
        return this._isPlaying();
    }

    public boolean _method_for_traceSet_connected() {
        return this._isPlaying();
    }

    public void _method_for_resetButton_action() {
        this._simulation.disableLoop();
        this._reset();
        this._simulation.enableLoop();
    }

    public void _method_for_playPauseButton_actionOn() {
        this._simulation.disableLoop();
        this._play();
        this._simulation.enableLoop();
    }

    public void _method_for_playPauseButton_actionOff() {
        this._simulation.disableLoop();
        this._pause();
        this._simulation.enableLoop();
    }

    @Override
    public synchronized void reset() {
        this.range = 20.0;
        this.xmin = -this.range / 2.0;
        this.xmax = this.range / 2.0;
        this.ymin = -this.range / 2.0;
        this.ymax = this.range / 2.0;
        this.t = 0.0;
        this.dt = 0.05;
        this.size = this.range / 25.0;
        this.size2 = this.size / 2.0;
        this.stroke = 2.0;
        this.pi = Math.PI;
        this.npt = 30.0;
        this.n = 36;
        this.x = new double[this.n];
        this.y = new double[this.n];
        this.vx = new double[this.n];
        this.vy = new double[this.n];
        this.clr = new Object[this.n];
        this.g = 9.8;
        this.cta = this.ctai = this.pi / 8.0;
        this.vi = this.ymax * 1.5;
        this.fired = false;
        this.vf = this.ymax;
        this.dc = this.pi * 2.0 / (double)this.n;
        this.count = 0;
        this.t0 = 2.0 * this.dt;
        this.clear = false;
        this.sound1 = false;
        this.sound2 = false;
        this.ts = 10.0;
        this.td = 1.0;
        this.delta = 0.8;
        this.t2 = 0.0;
        this._ODEi_evolution1 = new _ODE_evolution1();
    }

    @Override
    public synchronized void initialize() {
        this._initialization1();
        this._resetSolvers();
    }

    @Override
    public synchronized void step() {
        this._ODEi_evolution1.step();
    }

    @Override
    public synchronized void update() {
        this._constraints1();
    }

    @Override
    public void _freeMemory() {
        this.x = null;
        this.y = null;
        this.vx = null;
        this.vy = null;
        this.clr = null;
        this._ODEi_evolution1 = null;
        System.gc();
    }

    static {
        ToolForData.setTool(new ToolForDataFull());
    }

    private class _ODE_evolution1
    implements ODE {
        private ODEMultistepSolver __solver = null;
        private double[] __state = null;
        private double[] _x;
        private double[] _y;
        private double[] _vy;

        _ODE_evolution1() {
            this.initArrays();
            this.resetSolver();
        }

        private void initArrays() {
            this.__state = new double[1 + firework.this.x.length + firework.this.y.length + firework.this.vy.length];
            this._x = new double[firework.this.x.length];
            this._y = new double[firework.this.y.length];
            this._vy = new double[firework.this.vy.length];
        }

        private boolean arraysChanged() {
            if (firework.this.x.length != this._x.length) {
                return true;
            }
            if (firework.this.y.length != this._y.length) {
                return true;
            }
            return firework.this.vy.length != this._vy.length;
        }

        void resetSolver() {
            if (this.arraysChanged()) {
                this.initArrays();
            }
            int n = 0;
            System.arraycopy(firework.this.x, 0, this.__state, n, firework.this.x.length);
            System.arraycopy(firework.this.y, 0, this.__state, n += firework.this.x.length, firework.this.y.length);
            System.arraycopy(firework.this.vy, 0, this.__state, n += firework.this.y.length, firework.this.vy.length);
            n += firework.this.vy.length;
            this.__state[n++] = firework.this.t;
            this.__solver = new ODEMultistepSolver(this);
            this.__solver.initialize(firework.this.dt);
        }

        void step() {
            if (this.arraysChanged()) {
                this.resetSolver();
            }
            if (0.001 != this.__solver.getTolerance()) {
                this.__solver.setTolerance(0.001);
            }
            if (firework.this.dt != this.__solver.getStepSize()) {
                this.__solver.setStepSize(firework.this.dt);
            }
            int n = 0;
            System.arraycopy(firework.this.x, 0, this.__state, n, firework.this.x.length);
            System.arraycopy(firework.this.y, 0, this.__state, n += firework.this.x.length, firework.this.y.length);
            System.arraycopy(firework.this.vy, 0, this.__state, n += firework.this.y.length, firework.this.vy.length);
            n += firework.this.vy.length;
            this.__state[n++] = firework.this.t;
            this.__solver.step();
            n = 0;
            System.arraycopy(this.__state, n, firework.this.x, 0, firework.this.x.length);
            System.arraycopy(this.__state, n += firework.this.x.length, firework.this.y, 0, firework.this.y.length);
            System.arraycopy(this.__state, n += firework.this.y.length, firework.this.vy, 0, firework.this.vy.length);
            n += firework.this.vy.length;
            firework.this.t = this.__state[n++];
        }

        public double[] getState() {
            return this.__state;
        }

        public void getRate(double[] dArray, double[] dArray2) {
            int n;
            int n2 = 0;
            double[] dArray3 = this._x;
            System.arraycopy(dArray, n2, this._x, 0, this._x.length);
            double[] dArray4 = this._y;
            System.arraycopy(dArray, n2 += this._x.length, this._y, 0, this._y.length);
            double[] dArray5 = this._vy;
            System.arraycopy(dArray, n2 += this._y.length, this._vy, 0, this._vy.length);
            n2 += this._vy.length;
            double d = dArray[n2++];
            n2 = 0;
            int n3 = this._x.length;
            for (n = 0; n < n3; ++n) {
                dArray2[n2++] = firework.this.vx[n];
            }
            n3 = this._y.length;
            for (n = 0; n < n3; ++n) {
                dArray2[n2++] = dArray5[n];
            }
            n3 = this._vy.length;
            for (n = 0; n < n3; ++n) {
                dArray2[n2++] = -firework.this.g;
            }
            dArray2[n2++] = 1.0;
        }
    }
}

