/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.swing;

import java.applet.AudioClip;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import org.colos.ejs.library.control.swing.ControlCheckBox;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.tools.ResourceLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlSound
extends ControlCheckBox {
    static final int SOUND_VARIABLE = 5;
    static final int SOUND_SELECTED = 6;
    private AudioClip clip = null;
    private String audioFile = null;
    private boolean playing = false;
    private static List<String> infoList = null;

    public ControlSound() {
        this.checkbox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (ControlSound.this.checkbox.isSelected()) {
                    ControlSound.this.play();
                } else {
                    ControlSound.this.stop();
                }
            }
        });
    }

    @Override
    protected int getVariableIndex() {
        return 5;
    }

    @Override
    protected int getValueIndex() {
        return 6;
    }

    public void setAudioClip(String string, String string2) {
        if (string2 == null) {
            this.stop();
            this.clip = null;
            return;
        }
        this.clip = ResourceLoader.getAudioClip(string2);
    }

    @Override
    public void destroy() {
        if (this.clip != null) {
            this.clip.stop();
        }
        this.clip = null;
        super.destroy();
    }

    public void play() {
        if (this.clip == null) {
            return;
        }
        this.clip.loop();
    }

    public void stop() {
        if (this.clip != null) {
            this.clip.stop();
        }
    }

    @Override
    public List<String> getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList<String>();
            infoList.add("audiofile");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    @Override
    public String getPropertyInfo(String string) {
        if (string.equals("audiofile")) {
            return "File|String TRANSLATABLE";
        }
        return super.getPropertyInfo(string);
    }

    @Override
    public void setValue(int n, Value value) {
        switch (n) {
            case 0: {
                this.setAudioFile(value.getString());
                break;
            }
            case 5: {
                if (value.getBoolean() != this.playing) {
                    this.playing = value.getBoolean();
                    if (this.playing) {
                        this.play();
                    } else {
                        this.stop();
                    }
                }
                super.setValue(4, value);
                break;
            }
            default: {
                super.setValue(n - 1, value);
            }
        }
    }

    @Override
    public void setDefaultValue(int n) {
        switch (n) {
            case 0: {
                this.setAudioClip(null, null);
                this.audioFile = null;
                break;
            }
            default: {
                super.setDefaultValue(n - 1);
            }
        }
    }

    @Override
    public String getDefaultValueString(int n) {
        switch (n) {
            case 0: {
                return "<none>";
            }
        }
        return super.getDefaultValueString(n - 1);
    }

    @Override
    public Value getValue(int n) {
        switch (n) {
            case 0: {
                return null;
            }
        }
        return super.getValue(n - 1);
    }

    private void setAudioFile(String string) {
        if (this.audioFile != null && this.audioFile.equals(string)) {
            return;
        }
        this.audioFile = string;
        if (this.getProperty("_ejs_codebase") != null) {
            this.setAudioClip(this.getProperty("_ejs_codebase"), string);
        } else if (this.getSimulation() != null && this.getSimulation().getCodebase() != null) {
            this.setAudioClip(this.getSimulation().getCodebase().toString(), string);
        } else {
            this.setAudioClip(null, string);
        }
    }
}

