/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics;

import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import org.opensourcephysics.numerics.InvertibleFunction;

public final class FunctionTransform
extends AffineTransform {
    double m00;
    double m10 = 1.0;
    double m01 = 1.0;
    double m11;
    double m02;
    double m12;
    double[] flatmatrix = new double[6];
    InvertibleFunction xFunction;
    InvertibleFunction yFunction;
    boolean applyXFunction = false;
    boolean applyYFunction = false;

    public FunctionTransform() {
    }

    public FunctionTransform(double d, double d2, double d3, double d4, double d5, double d6) {
        super(d, d2, d3, d4, d5, d6);
        this.m00 = d;
        this.m10 = d2;
        this.m01 = d3;
        this.m11 = d4;
        this.m02 = d5;
        this.m12 = d6;
    }

    public void setXFunction(InvertibleFunction invertibleFunction) {
        if (invertibleFunction == null) {
            throw new NullPointerException("x function can not be null.");
        }
        this.xFunction = invertibleFunction;
    }

    public void setYFunction(InvertibleFunction invertibleFunction) {
        if (invertibleFunction == null) {
            throw new NullPointerException("y function can not be null.");
        }
        this.yFunction = invertibleFunction;
    }

    public void setApplyXFunction(boolean bl) {
        this.applyXFunction = bl;
    }

    public void setApplyYFunction(boolean bl) {
        this.applyYFunction = bl;
    }

    public void translate(double d, double d2) {
        super.translate(d, d2);
        this.updateMatrix();
    }

    public void rotate(double d) {
        super.rotate(d);
        this.updateMatrix();
    }

    public void rotate(double d, double d2, double d3) {
        super.rotate(d, d2, d3);
        this.updateMatrix();
    }

    public void scale(double d, double d2) {
        super.scale(d, d2);
        this.updateMatrix();
    }

    public void shear(double d, double d2) {
        super.shear(d, d2);
        this.updateMatrix();
    }

    public void setToIdentity() {
        super.setToIdentity();
        this.updateMatrix();
    }

    public void setToTranslation(double d, double d2) {
        super.setToTranslation(d, d2);
        this.updateMatrix();
    }

    public void setToRotation(double d) {
        super.setToRotation(d);
        this.updateMatrix();
    }

    public void setToRotation(double d, double d2, double d3) {
        super.setToRotation(d, d2, d3);
        this.updateMatrix();
    }

    public void setToScale(double d, double d2) {
        super.setToScale(d, d2);
        this.updateMatrix();
    }

    public void setToShear(double d, double d2) {
        super.setToShear(d, d2);
        this.updateMatrix();
    }

    public void setTransform(AffineTransform affineTransform) {
        super.setTransform(affineTransform);
        this.updateMatrix();
    }

    public void setTransform(double d, double d2, double d3, double d4, double d5, double d6) {
        super.setTransform(d, d2, d3, d4, d5, d6);
        this.updateMatrix();
    }

    public void concatenate(AffineTransform affineTransform) {
        super.concatenate(affineTransform);
        this.updateMatrix();
    }

    public void preConcatenate(AffineTransform affineTransform) {
        super.preConcatenate(affineTransform);
        this.updateMatrix();
    }

    public AffineTransform createInverse() throws NoninvertibleTransformException {
        AffineTransform affineTransform = super.createInverse();
        FunctionTransform functionTransform = new FunctionTransform();
        functionTransform.setTransform(affineTransform);
        InvertibleFunction invertibleFunction = new InvertibleFunction(){

            public double evaluate(double d) {
                return FunctionTransform.this.xFunction.getInverse(d);
            }

            public double getInverse(double d) {
                return FunctionTransform.this.xFunction.evaluate(d);
            }
        };
        InvertibleFunction invertibleFunction2 = new InvertibleFunction(){

            public double evaluate(double d) {
                return FunctionTransform.this.yFunction.getInverse(d);
            }

            public double getInverse(double d) {
                return FunctionTransform.this.yFunction.evaluate(d);
            }
        };
        functionTransform.setXFunction(invertibleFunction);
        functionTransform.setYFunction(invertibleFunction2);
        return functionTransform;
    }

    public Point2D transform(Point2D point2D, Point2D point2D2) {
        if (point2D2 == null) {
            point2D2 = point2D instanceof Point2D.Double ? new Point2D.Double() : new Point2D.Float();
        }
        double d = point2D.getX();
        double d2 = point2D.getY();
        if (this.applyXFunction) {
            d = this.xFunction.evaluate(d);
        }
        if (this.applyYFunction) {
            d2 = this.yFunction.evaluate(d2);
        }
        point2D2.setLocation(d * this.m00 + d2 * this.m01 + this.m02, d * this.m10 + d2 * this.m11 + this.m12);
        return point2D2;
    }

    public void transform(Point2D[] point2DArray, int n, Point2D[] point2DArray2, int n2, int n3) {
        while (--n3 >= 0) {
            Point2D point2D;
            Point2D point2D2 = point2DArray[n++];
            double d = point2D2.getX();
            double d2 = point2D2.getY();
            if (this.applyXFunction) {
                d = this.xFunction.evaluate(d);
            }
            if (this.applyYFunction) {
                d2 = this.yFunction.evaluate(d2);
            }
            if ((point2D = point2DArray2[n2++]) == null) {
                point2D = point2D2 instanceof Point2D.Double ? new Point2D.Double() : new Point2D.Float();
                point2DArray2[n2 - 1] = point2D;
            }
            point2D.setLocation(d * this.m00 + d2 * this.m01 + this.m02, d * this.m10 + d2 * this.m11 + this.m12);
        }
    }

    public void transform(float[] fArray, int n, float[] fArray2, int n2, int n3) {
        if (fArray2 == fArray && n2 > n && n2 < n + n3 * 2) {
            System.arraycopy(fArray, n, fArray2, n2, n3 * 2);
            n = n2;
        }
        double d = this.m00;
        double d2 = this.m01;
        double d3 = this.m02;
        double d4 = this.m10;
        double d5 = this.m11;
        double d6 = this.m12;
        while (--n3 >= 0) {
            double d7 = fArray[n++];
            double d8 = fArray[n++];
            if (this.applyXFunction) {
                d7 = this.xFunction.evaluate(d7);
            }
            if (this.applyYFunction) {
                d8 = this.yFunction.evaluate(d8);
            }
            fArray2[n2++] = (float)(d * d7 + d2 * d8 + d3);
            fArray2[n2++] = (float)(d4 * d7 + d5 * d8 + d6);
        }
    }

    public void transform(double[] dArray, int n, double[] dArray2, int n2, int n3) {
        if (dArray2 == dArray && n2 > n && n2 < n + n3 * 2) {
            System.arraycopy(dArray, n, dArray2, n2, n3 * 2);
            n = n2;
        }
        double d = this.m00;
        double d2 = this.m01;
        double d3 = this.m02;
        double d4 = this.m10;
        double d5 = this.m11;
        double d6 = this.m12;
        while (--n3 >= 0) {
            double d7 = dArray[n++];
            double d8 = dArray[n++];
            if (this.applyXFunction) {
                d7 = this.xFunction.evaluate(d7);
            }
            if (this.applyYFunction) {
                d8 = this.yFunction.evaluate(d8);
            }
            dArray2[n2++] = d * d7 + d2 * d8 + d3;
            dArray2[n2++] = d4 * d7 + d5 * d8 + d6;
        }
    }

    public void transform(float[] fArray, int n, double[] dArray, int n2, int n3) {
        double d = this.m00;
        double d2 = this.m01;
        double d3 = this.m02;
        double d4 = this.m10;
        double d5 = this.m11;
        double d6 = this.m12;
        while (--n3 >= 0) {
            double d7 = fArray[n++];
            double d8 = fArray[n++];
            if (this.applyXFunction) {
                d7 = this.xFunction.evaluate(d7);
            }
            if (this.applyYFunction) {
                d8 = this.yFunction.evaluate(d8);
            }
            dArray[n2++] = d * d7 + d2 * d8 + d3;
            dArray[n2++] = d4 * d7 + d5 * d8 + d6;
        }
    }

    public void transform(double[] dArray, int n, float[] fArray, int n2, int n3) {
        double d = this.m00;
        double d2 = this.m01;
        double d3 = this.m02;
        double d4 = this.m10;
        double d5 = this.m11;
        double d6 = this.m12;
        while (--n3 >= 0) {
            double d7 = dArray[n++];
            double d8 = dArray[n++];
            if (this.applyXFunction) {
                d7 = this.xFunction.evaluate(d7);
            }
            if (this.applyYFunction) {
                d8 = this.yFunction.evaluate(d8);
            }
            fArray[n2++] = (float)(d * d7 + d2 * d8 + d3);
            fArray[n2++] = (float)(d4 * d7 + d5 * d8 + d6);
        }
    }

    public Point2D inverseTransform(Point2D point2D, Point2D point2D2) throws NoninvertibleTransformException {
        if (point2D2 == null) {
            point2D2 = point2D instanceof Point2D.Double ? new Point2D.Double() : new Point2D.Float();
        }
        return point2D2;
    }

    public void inverseTransform(double[] dArray, int n, double[] dArray2, int n2, int n3) throws NoninvertibleTransformException {
        double d;
        if (dArray2 == dArray && n2 > n && n2 < n + n3 * 2) {
            System.arraycopy(dArray, n, dArray2, n2, n3 * 2);
            n = n2;
        }
        if (Math.abs(d = this.m00 * this.m11 - this.m01 * this.m10) <= Double.MIN_VALUE) {
            throw new NoninvertibleTransformException("Determinant is " + d);
        }
    }

    public Point2D deltaTransform(Point2D point2D, Point2D point2D2) {
        if (point2D2 == null) {
            point2D2 = point2D instanceof Point2D.Double ? new Point2D.Double() : new Point2D.Float();
        }
        double d = point2D.getX();
        double d2 = point2D.getY();
        if (this.applyXFunction) {
            d = this.xFunction.evaluate(d);
        }
        if (this.applyYFunction) {
            d2 = this.yFunction.evaluate(d2);
        }
        point2D2.setLocation(d * this.m00 + d2 * this.m01, d * this.m10 + d2 * this.m11);
        return point2D2;
    }

    public void deltaTransform(double[] dArray, int n, double[] dArray2, int n2, int n3) {
        if (dArray2 == dArray && n2 > n && n2 < n + n3 * 2) {
            System.arraycopy(dArray, n, dArray2, n2, n3 * 2);
            n = n2;
        }
        double d = this.m00;
        double d2 = this.m01;
        double d3 = this.m10;
        double d4 = this.m11;
        while (--n3 >= 0) {
            double d5 = dArray[n++];
            double d6 = dArray[n++];
            if (this.applyXFunction) {
                d5 = this.xFunction.evaluate(d5);
            }
            if (this.applyYFunction) {
                d6 = this.yFunction.evaluate(d6);
            }
            dArray2[n2++] = d5 * d + d6 * d2;
            dArray2[n2++] = d5 * d3 + d6 * d4;
        }
    }

    public boolean equals(Object object) {
        if (object instanceof FunctionTransform) {
            FunctionTransform functionTransform = (FunctionTransform)object;
            double[] dArray = new double[6];
            functionTransform.getMatrix(dArray);
            if (this.m00 == dArray[0] && this.m01 == dArray[1] && this.m02 == dArray[2] && this.m10 == dArray[3] && this.m11 == dArray[4] && this.m12 == dArray[5] && this.applyXFunction == functionTransform.applyXFunction && this.applyYFunction == functionTransform.applyYFunction) {
                return this.xFunction.getClass() == functionTransform.xFunction.getClass() && this.yFunction.getClass() == functionTransform.yFunction.getClass();
            }
        } else if (object instanceof AffineTransform && !this.applyXFunction && !this.applyYFunction) {
            return super.equals(object);
        }
        return false;
    }

    private void updateMatrix() {
        this.getMatrix(this.flatmatrix);
        this.m00 = this.flatmatrix[0];
        this.m10 = this.flatmatrix[1];
        this.m01 = this.flatmatrix[2];
        this.m11 = this.flatmatrix[3];
        this.m02 = this.flatmatrix[4];
        this.m12 = this.flatmatrix[5];
    }
}

