/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.controls;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XML {
    public static String NEW_LINE = System.getProperty("line.separator", "\n");
    public static final String CDATA_PRE = "<![CDATA[";
    public static final String CDATA_POST = "]]>";
    public static final int INDENT = 4;
    private static Map<Class<?>, ObjectLoader> loaders = new HashMap();
    private static ObjectLoader defaultLoader;
    private static String dtdName;
    private static String dtd;
    private static String defaultName;
    private static ClassLoader classLoader;

    static {
        defaultName = "osp10.dtd";
        try {
            NEW_LINE = System.getProperty("line.separator", "/n");
        }
        catch (SecurityException securityException) {}
        XML.setLoader(Color.class, new ObjectLoader(){

            public void saveObject(XMLControl xMLControl, Object object) {
                Color color = (Color)object;
                xMLControl.setValue("red", color.getRed());
                xMLControl.setValue("green", color.getGreen());
                xMLControl.setValue("blue", color.getBlue());
                xMLControl.setValue("alpha", color.getAlpha());
            }

            public Object createObject(XMLControl xMLControl) {
                int n = xMLControl.getInt("red");
                int n2 = xMLControl.getInt("green");
                int n3 = xMLControl.getInt("blue");
                int n4 = xMLControl.getInt("alpha");
                return new Color(n, n2, n3, n4);
            }

            public Object loadObject(XMLControl xMLControl, Object object) {
                int n = xMLControl.getInt("red");
                int n2 = xMLControl.getInt("green");
                int n3 = xMLControl.getInt("blue");
                int n4 = xMLControl.getInt("alpha");
                return new Color(n, n2, n3, n4);
            }
        });
        XML.setLoader(Double.class, new ObjectLoader(){

            public void saveObject(XMLControl xMLControl, Object object) {
                Double d = (Double)object;
                xMLControl.setValue("value", d);
            }

            public Object createObject(XMLControl xMLControl) {
                double d = xMLControl.getDouble("value");
                return new Double(d);
            }

            public Object loadObject(XMLControl xMLControl, Object object) {
                Double d = (Double)object;
                double d2 = xMLControl.getDouble("value");
                if (d == d2) {
                    return d;
                }
                return new Double(d2);
            }
        });
        XML.setLoader(Integer.class, new ObjectLoader(){

            public void saveObject(XMLControl xMLControl, Object object) {
                Integer n = (Integer)object;
                xMLControl.setValue("value", n);
            }

            public Object createObject(XMLControl xMLControl) {
                int n = xMLControl.getInt("value");
                return new Integer(n);
            }

            public Object loadObject(XMLControl xMLControl, Object object) {
                Integer n = (Integer)object;
                int n2 = xMLControl.getInt("value");
                if (n == n2) {
                    return n;
                }
                return new Integer(n2);
            }
        });
        XML.setLoader(Boolean.class, new ObjectLoader(){

            public void saveObject(XMLControl xMLControl, Object object) {
                Boolean bl = (Boolean)object;
                xMLControl.setValue("value", bl);
            }

            public Object createObject(XMLControl xMLControl) {
                boolean bl = xMLControl.getBoolean("value");
                return new Boolean(bl);
            }

            public Object loadObject(XMLControl xMLControl, Object object) {
                Boolean bl = (Boolean)object;
                boolean bl2 = xMLControl.getBoolean("value");
                if (bl == bl2) {
                    return bl;
                }
                return new Boolean(bl2);
            }
        });
        XML.setLoader(Dimension.class, new ObjectLoader(){

            public void saveObject(XMLControl xMLControl, Object object) {
                Dimension dimension = (Dimension)object;
                xMLControl.setValue("dimensions", new int[]{dimension.width, dimension.height});
            }

            public Object createObject(XMLControl xMLControl) {
                return new Dimension();
            }

            public Object loadObject(XMLControl xMLControl, Object object) {
                Dimension dimension = (Dimension)object;
                int[] nArray = (int[])xMLControl.getObject("dimensions");
                dimension.width = nArray[0];
                dimension.height = nArray[1];
                return dimension;
            }
        });
        XML.setLoader(Point.class, new ObjectLoader(){

            public void saveObject(XMLControl xMLControl, Object object) {
                Point point = (Point)object;
                xMLControl.setValue("location", new int[]{point.x, point.y});
            }

            public Object createObject(XMLControl xMLControl) {
                return new Point();
            }

            public Object loadObject(XMLControl xMLControl, Object object) {
                Point point = (Point)object;
                int[] nArray = (int[])xMLControl.getObject("location");
                point.x = nArray[0];
                point.y = nArray[1];
                return point;
            }
        });
    }

    private XML() {
    }

    public static void setLoader(Class<?> clazz, ObjectLoader objectLoader) {
        loaders.put(clazz, objectLoader);
    }

    public static ObjectLoader getLoader(Class<?> clazz) {
        ObjectLoader objectLoader = loaders.get(clazz);
        if (objectLoader == null) {
            try {
                Method method = clazz.getMethod("getLoader", null);
                if (method != null && Modifier.isStatic(method.getModifiers()) && (objectLoader = (ObjectLoader)method.invoke(null, null)) != null) {
                    XML.setLoader(clazz, objectLoader);
                }
            }
            catch (Exception exception) {}
        }
        if (objectLoader == null) {
            if (defaultLoader == null) {
                defaultLoader = new XMLLoader();
            }
            objectLoader = defaultLoader;
        }
        return objectLoader;
    }

    public static void setDefaultLoader(ObjectLoader objectLoader) {
        defaultLoader = objectLoader;
    }

    public static String getDataType(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return "string";
        }
        if (object instanceof Collection) {
            return "collection";
        }
        if (object.getClass().isArray()) {
            Class<?> clazz = object.getClass().getComponentType();
            while (clazz.isArray()) {
                clazz = clazz.getComponentType();
            }
            String string = clazz.getName();
            if (string.indexOf(".") == -1 && "intdoubleboolean".indexOf(string) == -1) {
                return null;
            }
            return "array";
        }
        if (object instanceof Double) {
            return "double";
        }
        if (object instanceof Integer) {
            return "int";
        }
        return "object";
    }

    public static String[] getDataTypes() {
        return new String[]{"object", "array", "collection", "string", "int", "double", "boolean"};
    }

    public static boolean requiresCDATA(String string) {
        return string.indexOf("\"") != -1 || string.indexOf("<") != -1 || string.indexOf(">") != -1 || string.indexOf("&") != -1 || string.indexOf("'") != -1;
    }

    public static String getDTD(String string) {
        if (dtdName != string) {
            dtdName = defaultName;
            try {
                String string2 = "/org/opensourcephysics/resources/controls/doctypes/";
                URL uRL = XML.class.getResource(String.valueOf(string2) + string);
                if (uRL == null) {
                    return dtd;
                }
                Object object = uRL.getContent();
                if (object instanceof InputStream) {
                    String string3;
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)object));
                    StringBuffer stringBuffer = new StringBuffer(0);
                    while ((string3 = bufferedReader.readLine()) != null) {
                        stringBuffer.append(String.valueOf(string3) + NEW_LINE);
                    }
                    dtd = stringBuffer.toString();
                    dtdName = string;
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return dtd;
    }

    public static void setClassLoader(ClassLoader classLoader) {
        XML.classLoader = classLoader;
    }

    public static ClassLoader getClassLoader() {
        return classLoader;
    }

    public static String forwardSlash(String string) {
        if (string == null) {
            return "";
        }
        int n = string.indexOf("\\");
        while (n != -1) {
            string = String.valueOf(string.substring(0, n)) + "/" + string.substring(n + 1);
            n = string.indexOf("\\");
        }
        return string;
    }

    public static String getName(String string) {
        if (string == null) {
            return "";
        }
        int n = string.lastIndexOf("/");
        if (n == -1) {
            n = string.lastIndexOf("\\");
        }
        if (n != -1) {
            return string.substring(n + 1);
        }
        return string;
    }

    public static String getExtension(String string) {
        if (string == null) {
            return null;
        }
        int n = string.lastIndexOf(46);
        int n2 = XML.forwardSlash(string).lastIndexOf(47);
        if (n > 0 && n < string.length() - 1 && n > n2) {
            return string.substring(n + 1);
        }
        return null;
    }

    public static String getSimpleClassName(Class<?> clazz) {
        String string = clazz.getName();
        int n = string.indexOf(";");
        if (n > -1) {
            string = string.substring(0, n);
        }
        while (string.startsWith("[")) {
            string = string.substring(1);
            string = String.valueOf(string) + "[]";
        }
        String string2 = XML.getExtension(string);
        if (string2 != null) {
            string = string2;
        }
        if ((n = string.indexOf("[")) > -1) {
            String string3 = string.substring(0, n);
            if (string3.equals("I")) {
                string3 = "int";
            } else if (string3.equals("D")) {
                string3 = "double";
            } else if (string3.equals("Z")) {
                string3 = "boolean";
            }
            string = String.valueOf(string3) + string.substring(n);
        }
        return string;
    }

    public static String stripExtension(String string) {
        if (string == null) {
            return null;
        }
        int n = string.lastIndexOf(46);
        if (n > 0 && n < string.length() - 1) {
            string = string.substring(0, n);
        }
        while (string.lastIndexOf(46) == string.length() - 1 && string.length() > 0) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public static String getPathRelativeTo(String string, String string2) {
        if (string2 == null || string2.equals("")) {
            string2 = XML.getUserDirectory();
        }
        string = XML.forwardSlash(string);
        string2 = XML.forwardSlash(string2);
        if (!string.startsWith("/") && string.indexOf(":") == -1) {
            return string;
        }
        if (!string2.startsWith("/") && string2.indexOf(":") == -1) {
            return string;
        }
        int n = string.indexOf("jar!");
        if (n > -1) {
            string = string.substring(n + 5);
            return string;
        }
        String string3 = "";
        if (string2.endsWith("/")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        int n2 = 0;
        while (n2 < 6) {
            if (n2 > 0) {
                int n3 = string2.lastIndexOf("/");
                if (n3 != -1) {
                    string2 = string2.substring(0, n3);
                    string3 = String.valueOf(string3) + "../";
                } else {
                    if (string2.equals("")) break;
                    string2 = "";
                    string3 = String.valueOf(string3) + "../";
                }
            }
            if (!string2.equals("") && string.startsWith(string2)) {
                String string4 = string.substring(string2.length());
                int n4 = string4.indexOf("/");
                if (n4 == 0) {
                    string4 = string4.substring(1);
                }
                string3 = String.valueOf(string3) + string4;
                return string3;
            }
            ++n2;
        }
        return string;
    }

    public static String getRelativePath(String string) {
        return XML.getPathRelativeTo(string, XML.getUserDirectory());
    }

    public static String getUserDirectory() {
        String string = System.getProperty("user.dir", ".");
        return string;
    }

    public static String getDirectoryPath(String string) {
        if (string == null) {
            return "";
        }
        int n = (string = XML.forwardSlash(string)).lastIndexOf("/");
        if (n != -1) {
            return string.substring(0, n);
        }
        return "";
    }

    public static String getAbsolutePath(File file) {
        if (file == null) {
            return null;
        }
        String string = XML.forwardSlash(file.getAbsolutePath());
        int n = string.indexOf("/../");
        while (n > -1) {
            String string2 = string.substring(0, n);
            int n2 = string2.lastIndexOf("/");
            if (n2 <= -1) continue;
            String string3 = string.substring(n + 3);
            string = String.valueOf(string2.substring(0, n2)) + string3;
            n = string.indexOf("/../");
        }
        n = string.indexOf("/./");
        while (n > -1) {
            string = String.valueOf(string.substring(0, n)) + string.substring(n + 2);
            n = string.indexOf("/./");
        }
        return string;
    }

    public static String getResolvedPath(String string, String string2) {
        if (string2 != null && string2.endsWith("/")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        if ((string = XML.forwardSlash(string)).startsWith("/") || string.indexOf(":/") != -1) {
            return string;
        }
        string2 = XML.forwardSlash(string2);
        while (string.startsWith("../") && !string2.equals("")) {
            if (string2.indexOf("/") == -1) {
                string2 = "/" + string2;
            }
            string = string.substring(3);
            string2 = string2.substring(0, string2.lastIndexOf("/"));
        }
        if (string.startsWith("./")) {
            string = string.substring(2);
        }
        if (string.equals(".")) {
            string = "";
        }
        if (string2.equals("")) {
            return string;
        }
        if (string2.endsWith("/")) {
            return String.valueOf(string2) + string;
        }
        return String.valueOf(string2) + "/" + string;
    }

    public static void createFolders(String string) {
        File file2 = new File(string);
        ArrayList<File> arrayList = new ArrayList<File>();
        while (!file2.exists()) {
            arrayList.add(0, file2);
            int n = string.lastIndexOf("/");
            if (n == -1) break;
            string = string.substring(0, n);
            file2 = new File(string);
        }
        for (File file2 : arrayList) {
            file2.mkdir();
        }
    }

    public static interface ObjectLoader {
        public void saveObject(XMLControl var1, Object var2);

        public Object createObject(XMLControl var1);

        public Object loadObject(XMLControl var1, Object var2);
    }
}

