/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.swing;

import java.applet.AudioClip;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import org.colos.ejs.library.control.swing.ControlCheckBox;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.tools.ResourceLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlSound
extends ControlCheckBox {
    private static final int SOUND_ADDED = 2;
    static final int SOUND_VARIABLE = 6;
    static final int SOUND_SELECTED = 7;
    private AudioClip clip = null;
    private String audioFile = null;
    private boolean playing = false;
    private boolean shouldLoop = true;
    private static List<String> infoList = null;

    public ControlSound() {
        this.checkbox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ControlSound.this.playing = ControlSound.this.checkbox.isSelected();
                if (ControlSound.this.playing) {
                    ControlSound.this.play();
                } else {
                    ControlSound.this.stop();
                }
            }
        });
    }

    @Override
    protected int getVariableIndex() {
        return 6;
    }

    @Override
    protected int getValueIndex() {
        return 7;
    }

    public void setAudioClip(String string, String string2) {
        if (string2 == null) {
            this.stop();
            this.clip = null;
            return;
        }
        this.clip = ResourceLoader.getAudioClip(string2);
    }

    @Override
    public void destroy() {
        if (this.clip != null) {
            this.clip.stop();
        }
        this.clip = null;
        super.destroy();
    }

    public void play() {
        if (this.clip == null) {
            return;
        }
        if (this.shouldLoop) {
            this.clip.loop();
        } else {
            this.clip.play();
        }
    }

    public void stop() {
        if (this.clip != null) {
            this.clip.stop();
        }
    }

    @Override
    public List<String> getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList<String>();
            infoList.add("audiofile");
            infoList.add("loop");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    @Override
    public String getPropertyInfo(String string) {
        if (string.equals("audiofile")) {
            return "File|String TRANSLATABLE";
        }
        if (string.equals("loop")) {
            return "boolean";
        }
        return super.getPropertyInfo(string);
    }

    @Override
    public void setValue(int n, Value value) {
        switch (n) {
            case 0: {
                this.setAudioFile(value.getString());
                break;
            }
            case 1: {
                if (this.shouldLoop == value.getBoolean()) break;
                this.shouldLoop = value.getBoolean();
                if (!this.playing) break;
                this.stop();
                this.play();
                break;
            }
            case 6: {
                if (value.getBoolean() != this.playing) {
                    this.playing = value.getBoolean();
                    if (this.playing) {
                        this.play();
                    } else {
                        this.stop();
                    }
                }
                super.setValue(4, value);
                break;
            }
            default: {
                super.setValue(n - 2, value);
            }
        }
    }

    @Override
    public void setDefaultValue(int n) {
        switch (n) {
            case 0: {
                this.setAudioClip(null, null);
                this.audioFile = null;
                break;
            }
            case 1: {
                if (this.shouldLoop) break;
                this.shouldLoop = true;
                if (!this.playing) break;
                this.stop();
                this.play();
                break;
            }
            default: {
                super.setDefaultValue(n - 2);
            }
        }
    }

    @Override
    public String getDefaultValueString(int n) {
        switch (n) {
            case 0: {
                return "<none>";
            }
            case 1: {
                return "true";
            }
        }
        return super.getDefaultValueString(n - 2);
    }

    @Override
    public Value getValue(int n) {
        switch (n) {
            case 0: 
            case 1: {
                return null;
            }
        }
        return super.getValue(n - 2);
    }

    private void setAudioFile(String string) {
        if (this.audioFile != null && this.audioFile.equals(string)) {
            return;
        }
        this.audioFile = string;
        if (this.getProperty("_ejs_codebase") != null) {
            this.setAudioClip(this.getProperty("_ejs_codebase"), string);
        } else if (this.getSimulation() != null && this.getSimulation().getCodebase() != null) {
            this.setAudioClip(this.getSimulation().getCodebase().toString(), string);
        } else {
            this.setAudioClip(null, string);
        }
    }
}

