/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library;

import java.awt.GraphicsConfiguration;
import java.io.File;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.colos.ejs.library.Input;
import org.colos.ejs.library.LauncherApplet;
import org.colos.ejs.library.Memory;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.View;
import org.colos.ejs.library.utils.HtmlPageInfo;
import org.colos.ejs.library.utils.LocaleItem;
import org.colos.ejs.library.utils.TranslatorUtil;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.numerics.Function;
import org.opensourcephysics.tools.ToolForData;

public abstract class Model {
    protected static TranslatorUtil __translatorUtil;
    private static GraphicsConfiguration __graphicConfiguration;
    protected String[] __theArguments = null;
    protected LauncherApplet __theApplet = null;
    public ToolForData _tools = ToolForData.getTool();
    public Memory _memory = new Memory();
    protected Input _input = new Input();
    protected List<?> _scheduledConditionsList = new ArrayList();
    protected Hashtable<?, ?> _scheduledEventsList = new Hashtable();
    protected boolean __shouldBreak = false;
    public static final Function _ZERO_FUNCTION;
    private _ControlSimulationExperimentClass _cSE = new _ControlSimulationExperimentClass();

    static {
        __graphicConfiguration = null;
        _ZERO_FUNCTION = new Function(){

            @Override
            public double evaluate(double x) {
                return 0.0;
            }
        };
    }

    public static final TranslatorUtil _getTranslatorUtil() {
        return __translatorUtil;
    }

    public static final GraphicsConfiguration getGraphicsConfiguration() {
        return __graphicConfiguration;
    }

    public String _getStringProperty(String _property) {
        return __translatorUtil.translateString(_property);
    }

    public abstract View _getView();

    public View getView() {
        return this._getView();
    }

    public abstract Simulation _getSimulation();

    public Simulation getSimulation() {
        return this._getSimulation();
    }

    public abstract int _getPreferredStepsPerDisplay();

    public abstract void _resetModel();

    public abstract void _initializeModel();

    public abstract void _automaticResetSolvers();

    public abstract void _resetSolvers();

    public abstract void _stepModel();

    public abstract void _updateModel();

    public abstract void _freeMemory();

    public void _addToHTMLOutputData(Map<String, Object> dataMap) {
    }

    public int _firstThreadIndex(int _rawFirstIndex, int _rawLastIndex) {
        return _rawFirstIndex;
    }

    public int _lastThreadIndex(int _rawFirstIndex, int _rawLastIndex) {
        return _rawLastIndex;
    }

    public LauncherApplet _getApplet() {
        return this.__theApplet;
    }

    public void _play() {
        this._getSimulation().play();
    }

    public void _playAndWait() {
        this._play();
        this._cSE._controlForSimulation();
    }

    public void _pause() {
        this._getSimulation().pause();
        this._cSE._controlForExperiment();
    }

    public void _breakAfterThisPage() {
        this.__shouldBreak = true;
    }

    public void _step() {
        this._pause();
        this._getSimulation().step();
    }

    public void _setFPS(int _fps) {
        this._getSimulation().setFPS(_fps);
    }

    public void _setFPS(Integer _fps) {
        this._getSimulation().setFPS(_fps);
    }

    public void _setDelay(int _delay) {
        this._getSimulation().setDelay(_delay);
    }

    public int _getDelay() {
        if (this._getSimulation() != null) {
            return this._getSimulation().getDelay();
        }
        return 0;
    }

    public void _resetRealTime() {
        this._getSimulation().resetRealTime();
    }

    protected double _getRealTime() {
        return Double.NaN;
    }

    public void _reset() {
        this._getSimulation().reset();
    }

    public void _initialize() {
        this._getSimulation().initialize();
    }

    public boolean _isApplet() {
        return this.__theApplet != null;
    }

    public boolean _isPlaying() {
        return this._getSimulation().isPlaying();
    }

    public boolean _isPaused() {
        return this._getSimulation().isPaused();
    }

    public void _resetView() {
        if (this._getView() != null) {
            this._getView().reset();
            this._getView().initialize();
        }
    }

    public void _clearView() {
        if (this._getView() != null) {
            this._getView().initialize();
        }
    }

    public void _setStepsPerDisplay(int _steps) {
        this._setSPD(_steps);
    }

    public void _setSPD(int _steps) {
        this._getSimulation().setStepsPerDisplay(_steps);
    }

    public void _setUpdateView(boolean _update) {
        this._getSimulation().setUpdateView(_update);
    }

    public void _showDescriptionAtStartUp(boolean _show) {
        this._getSimulation().showDescriptionAtStartUp(_show);
    }

    public void _showDescription(boolean _show) {
        this._getSimulation().showDescription(_show);
    }

    public URL _getDescriptionPageURL(String pageName) {
        return this._getSimulation().getDescriptionPageURL(pageName);
    }

    public void _setParentComponent(String _parent) {
        this._getSimulation().setParentComponent(_parent);
    }

    public abstract HtmlPageInfo _getHtmlPageInfo(String var1, LocaleItem var2);

    public Set<String> _getClassEjsResources() {
        return new HashSet<String>();
    }

    public String _getClassEjsModel() {
        return null;
    }

    public String _getClassModelDirectory() {
        return "";
    }

    public String[] _getArguments() {
        return this.__theArguments;
    }

    public boolean _hasDefaultState() {
        return this._getSimulation().hasDefaultState();
    }

    public boolean _readDefaultState() {
        return this._getSimulation().readDefaultState();
    }

    public boolean _saveDefaultStateToJar() {
        return this._saveDefaultStateToJar(null);
    }

    public boolean _saveDefaultStateToJar(String filenames) {
        if (this._getSimulation().isUnderEjs()) {
            return false;
        }
        File jarFile = null;
        try {
            URL url = Simulation.class.getProtectionDomain().getCodeSource().getLocation();
            jarFile = new File(url.toURI());
        }
        catch (Exception exc) {
            exc.printStackTrace();
            JFileChooser chooser = OSPRuntime.createChooser("JAR", new String[]{"jar"});
            String filename = OSPRuntime.chooseFilename(chooser, this._getSimulation().getParentComponent(), false);
            if (filename == null) {
                return false;
            }
            jarFile = new File(filename);
        }
        return this._getSimulation().saveDefaultStateToJar(jarFile, filenames);
    }

    public boolean _saveState(String _filename) {
        return this._getSimulation().saveState(_filename);
    }

    public boolean _readState(String _filename) {
        return this._getSimulation().readState(_filename);
    }

    public boolean _saveVariables(String _filename, String _varList) {
        return this._getSimulation().saveVariables(_filename, _varList);
    }

    public boolean _saveVariables(String _filename, List<String> _varList) {
        return this._getSimulation().saveVariables(_filename, _varList);
    }

    public boolean _readVariables(String _filename, String _varList) {
        return this._getSimulation().readVariables(_filename, null, _varList);
    }

    public boolean _readVariables(String _filename, List<String> _varList) {
        URL codebase = null;
        if (this.__theApplet != null) {
            codebase = this.__theApplet.getCodeBase();
        }
        return this._getSimulation().readVariables(_filename, codebase, _varList);
    }

    public boolean _saveText(String _filename, String _text) {
        return this._getSimulation().saveText(_filename, _text);
    }

    public boolean _saveText(String _filename, StringBuffer _text) {
        return this._getSimulation().saveText(_filename, _text);
    }

    public String _readText(String _filename) {
        return this._getSimulation().readText(_filename);
    }

    public boolean _saveImage(String _filename, String _element) {
        return this._getSimulation().saveImage(_filename, _element);
    }

    public void _alert(String _panel, String _title, String _message) {
        if (this._getView() != null) {
            JOptionPane.showMessageDialog(this._getView().getComponent(_panel), _message, _title, 1);
        } else {
            JOptionPane.showMessageDialog(this._getSimulation().getParentComponent(), _message, _title, 1);
        }
    }

    public String _format(double _value, String _pattern) {
        return new DecimalFormat(_pattern).format(_value);
    }

    public void _print(String _txt) {
        if (this._getView() != null) {
            this._getView().print(_txt);
        } else {
            System.out.print(_txt);
        }
    }

    public void _println(String _txt) {
        if (this._getView() != null) {
            this._getView().println(_txt);
        } else {
            System.out.print(_txt);
        }
    }

    public void _println() {
        if (this._getView() != null) {
            this._getView().println();
        } else {
            System.out.println();
        }
    }

    public void _clearMessages() {
        if (this._getView() != null) {
            this._getView().clearMessages();
        }
    }

    public boolean _isMoodleConnected() {
        return this._getSimulation().isMoodleConnected();
    }

    public String _getParameter(String _name) {
        if (this.__theApplet != null) {
            return this.__theApplet.getParameter(_name);
        }
        if (this.__theArguments == null) {
            return null;
        }
        int i = 0;
        while (i < this.__theArguments.length) {
            if (this.__theArguments[i].equals("-" + _name) && i + 1 < this.__theArguments.length) {
                return this.__theArguments[i + 1];
            }
            ++i;
        }
        return null;
    }

    public boolean _setVariables(String _command, String _delim, String _arrayDelim) {
        return this._getSimulation().setVariables(_command, _delim, _arrayDelim);
    }

    public boolean _setVariables(String _command) {
        return this._getSimulation().setVariables(_command);
    }

    public String _getVariable(String _varName) {
        return this._getSimulation().getVariable(_varName);
    }

    public void _resetIC() {
        this._resetSolvers();
    }

    private class _ControlSimulationExperimentClass {
        private _ControlSimulationExperimentClass() {
        }

        public synchronized void _controlForSimulation() {
            try {
                this.wait();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public synchronized void _controlForExperiment() {
            this.notify();
        }
    }
}

