/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics.ode_solvers.rk;

import org.opensourcephysics.numerics.ode_interpolation.EulerIntervalData;
import org.opensourcephysics.numerics.ode_interpolation.IntervalData;
import org.opensourcephysics.numerics.ode_solvers.InterpolatorEventSolver;
import org.opensourcephysics.numerics.ode_solvers.SolverEngineDiscreteTime;

public class Euler
extends SolverEngineDiscreteTime {
    @Override
    protected int getNumberOfEvaluations() {
        return 1;
    }

    @Override
    protected void allocateOtherArrays() {
    }

    @Override
    protected void computeIntermediateStep(double step, double[] state) {
        int i = 0;
        while (i < this.mDimension) {
            state[i] = this.mInitialState[i] + step * this.mInitialRate[i];
            ++i;
        }
    }

    @Override
    protected InterpolatorEventSolver.DISCONTINUITY_CODE computeIntermediateStep(InterpolatorEventSolver eventSolver, double step, double[] state) {
        this.computeIntermediateStep(step, state);
        return eventSolver.checkDiscontinuity(state, true);
    }

    @Override
    protected IntervalData computeFinalRateAndCreateIntervalData() {
        this.mODE.getRate(this.mFinalState, this.mFinalRate);
        return new EulerIntervalData(this.mInitialState, this.mInitialRate, this.mFinalState[this.mTimeIndex]);
    }
}

