/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing2d;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.Toolkit;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import org.opensourcephysics.drawing2d.DrawingPanel;
import org.opensourcephysics.drawing2d.Element;
import org.opensourcephysics.tools.ResourceLoader;

public class Style {
    public static final int DEFAULT_SENSITIVITY = 5;
    public static final int CHANGED_LINE_COLOR = 0;
    public static final int CHANGED_LINE_WIDTH = 1;
    public static final int CHANGED_FILL_COLOR = 2;
    public static final int CHANGED_DRAWING_FILL = 3;
    public static final int CHANGED_DRAWING_LINES = 4;
    public static final int CHANGED_RELATIVE_POSITION = 5;
    public static final int CHANGED_SENSITIVITY = 6;
    public static final int CHANGED_EXTRA_COLOR = 7;
    public static final int CENTERED = 0;
    public static final int NORTH = 1;
    public static final int SOUTH = 2;
    public static final int EAST = 3;
    public static final int WEST = 4;
    public static final int NORTH_EAST = 5;
    public static final int NORTH_WEST = 6;
    public static final int SOUTH_EAST = 7;
    public static final int SOUTH_WEST = 8;
    private boolean drawsFill = true;
    private boolean drawsLines = true;
    private Color lineColor = Color.black;
    private float lineWidth = 1.0f;
    private Paint fillColor = Color.blue;
    private Color extraColor = Color.black;
    private int sensitivity = 5;
    int position = 0;
    private Element element = null;
    private Stroke lineStroke = new BasicStroke(this.lineWidth);

    Style(Element _element) {
        this.element = _element;
    }

    public Style clone() {
        Style newStyle = new Style(this.element);
        newStyle.drawsFill = this.drawsFill;
        newStyle.drawsLines = this.drawsLines;
        newStyle.fillColor = this.fillColor;
        newStyle.lineColor = this.lineColor;
        newStyle.lineStroke = this.lineStroke;
        newStyle.lineWidth = this.lineWidth;
        newStyle.position = this.position;
        newStyle.sensitivity = this.sensitivity;
        newStyle.extraColor = this.extraColor;
        return newStyle;
    }

    public void copyTo(Element targetElement) {
        Style targetStyle = targetElement.getStyle();
        targetStyle.setDrawingFill(this.drawsFill);
        targetStyle.setDrawingLines(this.drawsLines);
        targetStyle.setFillColor(this.fillColor);
        targetStyle.setLineColor(this.lineColor);
        targetStyle.setLineWidth(this.lineWidth);
        targetStyle.setRelativePosition(this.position);
        targetStyle.setSensitivity(this.sensitivity);
        targetStyle.setExtraColor(this.extraColor);
    }

    public final void setLineColor(Color _color) {
        if (_color == null) {
            return;
        }
        this.lineColor = _color;
        if (this.element != null) {
            this.element.styleChanged(0);
        }
    }

    public final Color getLineColor() {
        return this.lineColor;
    }

    public final void setLineStroke(Stroke _stroke) {
        if (this.lineStroke == _stroke) {
            return;
        }
        this.lineStroke = _stroke;
        if (this.element != null) {
            this.element.styleChanged(1);
        }
    }

    public final void setLineWidth(float _width) {
        if (this.lineWidth == _width) {
            return;
        }
        this.lineWidth = _width;
        this.lineStroke = new BasicStroke(this.lineWidth);
        if (this.element != null) {
            this.element.styleChanged(1);
        }
    }

    public final float getLineWidth() {
        return this.lineWidth;
    }

    final Stroke getLineStroke() {
        return this.lineStroke;
    }

    public final void setFillColor(Paint _fill) {
        if (_fill == null) {
            return;
        }
        this.fillColor = _fill;
        if (this.element != null) {
            this.element.styleChanged(2);
        }
    }

    public final Paint getFillColor() {
        return this.fillColor;
    }

    public final void setExtraColor(Color _color) {
        if (_color == null) {
            return;
        }
        this.extraColor = _color;
        if (this.element != null) {
            this.element.styleChanged(7);
        }
    }

    public final Color getExtraColor() {
        return this.extraColor;
    }

    public final boolean isDrawingFill() {
        return this.drawsFill;
    }

    public final void setDrawingFill(boolean _drawsFill) {
        this.drawsFill = _drawsFill;
        if (this.element != null) {
            this.element.styleChanged(3);
        }
    }

    public final boolean isDrawingLines() {
        return this.drawsLines;
    }

    public final void setDrawingLines(boolean _drawsLines) {
        this.drawsLines = _drawsLines;
        if (this.element != null) {
            this.element.styleChanged(4);
        }
    }

    public final void setRelativePosition(int _position) {
        this.position = _position;
        this.element.styleChanged(5);
    }

    public final int getRelativePosition() {
        return this.position;
    }

    public final void setSensitivity(int _s) {
        this.sensitivity = _s;
    }

    public final int getSensitivity() {
        return this.sensitivity;
    }

    public final void setPaint(String filename) {
        this.setPaint(filename, 0.0, 0.0);
    }

    public final void setPaint(String filename, double width, double height) {
        DrawingPanel panel;
        if (filename == null) {
            return;
        }
        BufferedImage image = ResourceLoader.getBufferedImage(filename);
        if (image != null && (panel = this.element.getPanel()) != null) {
            Toolkit.getDefaultToolkit().prepareImage(image, -1, -1, panel.getComponent());
            if (width <= 0.0) {
                width = image.getWidth();
            }
            if (height <= 0.0) {
                height = image.getHeight();
            }
            this.fillColor = new TexturePaint(image, new Rectangle2D.Double(0.0, 0.0, width, height));
        }
    }
}

