/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.swing;

import java.applet.AudioClip;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import org.colos.ejs.library.control.swing.ControlCheckBox;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.tools.ResourceLoader;

public class ControlSound
extends ControlCheckBox {
    private static final int SOUND_ADDED = 2;
    static final int SOUND_VARIABLE = 6;
    static final int SOUND_SELECTED = 7;
    private AudioClip clip = null;
    private String audioFile = null;
    private boolean playing = false;
    private boolean shouldLoop = true;
    private static List<String> infoList = null;

    public ControlSound() {
        this.checkbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent _e) {
                ControlSound.this.playing = ControlSound.this.checkbox.isSelected();
                if (ControlSound.this.playing) {
                    ControlSound.this.play();
                } else {
                    ControlSound.this.stop();
                }
            }
        });
    }

    @Override
    protected int getVariableIndex() {
        return 6;
    }

    @Override
    protected int getValueIndex() {
        return 7;
    }

    public void setAudioClip(String _codebase, String _audioFile) {
        if (_audioFile == null) {
            this.stop();
            this.clip = null;
            return;
        }
        this.clip = ResourceLoader.getAudioClip(_audioFile);
    }

    @Override
    public void destroy() {
        if (this.clip != null) {
            this.clip.stop();
        }
        this.clip = null;
        super.destroy();
    }

    public void play() {
        if (this.clip == null) {
            return;
        }
        if (this.shouldLoop) {
            this.clip.loop();
        } else {
            this.clip.play();
        }
    }

    public void stop() {
        if (this.clip != null) {
            this.clip.stop();
        }
    }

    @Override
    public List<String> getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList<String>();
            infoList.add("audiofile");
            infoList.add("loop");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    @Override
    public String getPropertyInfo(String _property) {
        if (_property.equals("audiofile")) {
            return "File|String TRANSLATABLE";
        }
        if (_property.equals("loop")) {
            return "boolean";
        }
        return super.getPropertyInfo(_property);
    }

    @Override
    public void setValue(int _index, Value _value) {
        switch (_index) {
            case 0: {
                this.setAudioFile(_value.getString());
                break;
            }
            case 1: {
                if (this.shouldLoop == _value.getBoolean()) break;
                this.shouldLoop = _value.getBoolean();
                if (!this.playing) break;
                this.stop();
                this.play();
                break;
            }
            case 6: {
                if (_value.getBoolean() != this.playing) {
                    this.playing = _value.getBoolean();
                    if (this.playing) {
                        this.play();
                    } else {
                        this.stop();
                    }
                }
                super.setValue(4, _value);
                break;
            }
            default: {
                super.setValue(_index - 2, _value);
            }
        }
    }

    @Override
    public void setDefaultValue(int _index) {
        switch (_index) {
            case 0: {
                this.setAudioClip(null, null);
                this.audioFile = null;
                break;
            }
            case 1: {
                if (this.shouldLoop) break;
                this.shouldLoop = true;
                if (!this.playing) break;
                this.stop();
                this.play();
                break;
            }
            default: {
                super.setDefaultValue(_index - 2);
            }
        }
    }

    @Override
    public String getDefaultValueString(int _index) {
        switch (_index) {
            case 0: {
                return "<none>";
            }
            case 1: {
                return "true";
            }
        }
        return super.getDefaultValueString(_index - 2);
    }

    @Override
    public Value getValue(int _index) {
        switch (_index) {
            case 0: 
            case 1: {
                return null;
            }
        }
        return super.getValue(_index - 2);
    }

    private void setAudioFile(String _audio) {
        if (this.audioFile != null && this.audioFile.equals(_audio)) {
            return;
        }
        this.audioFile = _audio;
        if (this.getProperty("_ejs_codebase") != null) {
            this.setAudioClip(this.getProperty("_ejs_codebase"), _audio);
        } else if (this.getSimulation() != null && this.getSimulation().getCodebase() != null) {
            this.setAudioClip(this.getSimulation().getCodebase().toString(), _audio);
        } else {
            this.setAudioClip(null, _audio);
        }
    }
}

