/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.swing;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.colos.ejs.library.control.swing.ControlNumberField;
import org.opensourcephysics.numerics.Util;

public class ControlParsedNumberField
extends ControlNumberField {
    @Override
    protected void fixTheFormat(DecimalFormat _format) {
        _format.setDecimalFormatSymbols(new DecimalFormatSymbols(new Locale("en")));
    }

    @Override
    protected void acceptValue() {
        double value;
        String valStr = this.textfield.getText();
        int index = valStr.lastIndexOf(61);
        if (index >= 0) {
            valStr = valStr.substring(index + 1);
        }
        try {
            value = Double.parseDouble(valStr);
        }
        catch (NumberFormatException ex) {
            value = Util.evalMath(valStr);
        }
        if (Double.isNaN(value)) {
            this.setColor(this.errorColor);
        } else {
            this.setColor(this.defaultColor);
            this.setInternalValue(value);
            if (this.isUnderEjs) {
                this.setFieldListValueWithAlternative(0, 1, this.internalValue);
            }
        }
    }
}

