/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.swing;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.control.ConstantParser;
import org.colos.ejs.library.control.ControlElement;
import org.colos.ejs.library.control.swing.ControlDrawable;
import org.colos.ejs.library.control.swing.ControlDrawablesParent;
import org.colos.ejs.library.control.swing.MyCoordinateStringBuilder;
import org.colos.ejs.library.control.swing.UpdateHotSpot2DDelayedAction;
import org.colos.ejs.library.control.swing.UpdateHotSpotDelayedAction;
import org.colos.ejs.library.control.value.DoubleValue;
import org.colos.ejs.library.control.value.IntegerValue;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.display.InteractiveMouseHandler;
import org.opensourcephysics.display.InteractivePanel;
import org.opensourcephysics.displayejs.HasDataObjectInterface;
import org.opensourcephysics.displayejs.InteractionEvent;
import org.opensourcephysics.displayejs.InteractionSource;
import org.opensourcephysics.displayejs.Point3D;
import org.opensourcephysics.drawing2d.DrawingPanel2D;
import org.opensourcephysics.drawing2d.Element;
import org.opensourcephysics.drawing2d.interaction.InteractionTarget;

public class ControlDrawingPanel
extends ControlDrawablesParent
implements InteractiveMouseHandler {
    public static final int DP_ADDED = 30;
    private static final int[] posIndex = new int[]{6, 7};
    private static final int KEY_INDEX = 17;
    private static final int ALIASING = 28;
    private static final int FONT_FACTOR = 29;
    protected boolean reportDrag = false;
    protected boolean reportKey = false;
    protected DrawingPanel2D drawingPanel;
    private Rectangle myGutters = null;
    private DoubleValue[] posValues = new DoubleValue[]{new DoubleValue(0.0), new DoubleValue(0.0)};
    private IntegerValue keyPressedValue = new IntegerValue(-1);
    protected MyCoordinateStringBuilder strBuilder;
    private double fontFactor = 1.0;
    private static List<String> infoList = null;
    private org.opensourcephysics.displayejs.InteractionTarget targetHit = null;
    private InteractionSource sourceLingered = null;
    private InteractionTarget target2D = null;
    private InteractionTarget target2DEntered = null;

    @Override
    protected Component createVisual() {
        this.drawingPanel = new DrawingPanel2D();
        this.drawingPanel.enableInspector(false);
        this.drawingPanel.setSquareAspect(false);
        this.drawingPanel.setBuffered(true);
        this.drawingPanel.removeOptionController();
        this.minX = Double.NaN;
        this.maxX = Double.NaN;
        this.minY = Double.NaN;
        this.maxY = Double.NaN;
        this.autoX = this.drawingPanel.isAutoscaleX();
        this.autoY = this.drawingPanel.isAutoscaleY();
        this.drawingPanel.render();
        this.drawingPanel.setInteractiveMouseHandler(this);
        this.strBuilder = new MyCoordinateStringBuilder();
        this.drawingPanel.setCoordinateStringBuilder(this.strBuilder);
        this.drawingPanel.setFocusable(true);
        this.drawingPanel.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent _e) {
                ((ControlDrawingPanel)ControlDrawingPanel.this).keyPressedValue.value = _e.getKeyCode();
                if (ControlDrawingPanel.this.reportKey) {
                    ControlDrawingPanel.this.variableChanged(17, ControlDrawingPanel.this.keyPressedValue);
                    ControlDrawingPanel.this.invokeActions(30);
                }
            }

            @Override
            public void keyReleased(KeyEvent _e) {
                if (ControlDrawingPanel.this.reportKey) {
                    ControlDrawingPanel.this.variableChanged(17, ControlDrawingPanel.this.keyPressedValue);
                }
            }
        });
        return this.drawingPanel;
    }

    protected int[] getPosIndex() {
        return posIndex;
    }

    @Override
    public List<String> getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList<String>();
            infoList.add("autoscaleX");
            infoList.add("autoscaleY");
            infoList.add("minimumX");
            infoList.add("maximumX");
            infoList.add("minimumY");
            infoList.add("maximumY");
            infoList.add("x");
            infoList.add("y");
            infoList.add("pressaction");
            infoList.add("dragaction");
            infoList.add("action");
            infoList.add("square");
            infoList.add("showCoordinates");
            infoList.add("gutters");
            infoList.add("xFormat");
            infoList.add("yFormat");
            infoList.add("keyAction");
            infoList.add("keyPressed");
            infoList.add("enteredAction");
            infoList.add("exitedAction");
            infoList.add("xyExpression");
            infoList.add("xyFormat");
            infoList.add("xMarginPercentage");
            infoList.add("yMarginPercentage");
            infoList.add("TLmessage");
            infoList.add("TRmessage");
            infoList.add("BLmessage");
            infoList.add("BRmessage");
            infoList.add("aliasing");
            infoList.add("fontFactor");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    @Override
    public String getPropertyCommonName(String _property) {
        if (_property.equals("pressaction")) {
            return "pressAction";
        }
        if (_property.equals("dragaction")) {
            return "dragAction";
        }
        if (_property.equals("action")) {
            return "releaseAction";
        }
        if (_property.equals("square")) {
            return "squareAspect";
        }
        return super.getPropertyCommonName(_property);
    }

    @Override
    public String getPropertyInfo(String _property) {
        if (_property.equals("autoscaleX")) {
            return "boolean";
        }
        if (_property.equals("autoscaleY")) {
            return "boolean";
        }
        if (_property.equals("minimumX")) {
            return "int|double";
        }
        if (_property.equals("maximumX")) {
            return "int|double";
        }
        if (_property.equals("minimumY")) {
            return "int|double";
        }
        if (_property.equals("maximumY")) {
            return "int|double";
        }
        if (_property.equals("x")) {
            return "int|double";
        }
        if (_property.equals("y")) {
            return "int|double";
        }
        if (_property.equals("action")) {
            return "Action CONSTANT";
        }
        if (_property.equals("pressaction")) {
            return "Action CONSTANT";
        }
        if (_property.equals("dragaction")) {
            return "Action CONSTANT";
        }
        if (_property.equals("square")) {
            return "boolean";
        }
        if (_property.equals("showCoordinates")) {
            return "boolean";
        }
        if (_property.equals("gutters")) {
            return "Margins|Object";
        }
        if (_property.equals("xFormat")) {
            return "Format|Object|String TRANSLATABLE";
        }
        if (_property.equals("yFormat")) {
            return "Format|Object|String TRANSLATABLE";
        }
        if (_property.equals("keyAction")) {
            return "Action CONSTANT";
        }
        if (_property.equals("keyPressed")) {
            return "int";
        }
        if (_property.equals("enteredAction")) {
            return "Action CONSTANT";
        }
        if (_property.equals("exitedAction")) {
            return "Action CONSTANT";
        }
        if (_property.equals("xyExpression")) {
            return "Object|String";
        }
        if (_property.equals("xyFormat")) {
            return "Format|Object|String TRANSLATABLE";
        }
        if (_property.equals("xMarginPercentage")) {
            return "int|double";
        }
        if (_property.equals("yMarginPercentage")) {
            return "int|double";
        }
        if (_property.equals("TLmessage")) {
            return "String TRANSLATABLE";
        }
        if (_property.equals("TRmessage")) {
            return "String TRANSLATABLE";
        }
        if (_property.equals("BLmessage")) {
            return "String TRANSLATABLE";
        }
        if (_property.equals("BRmessage")) {
            return "String TRANSLATABLE";
        }
        if (_property.equals("aliasing")) {
            return "boolean";
        }
        if (_property.equals("fontFactor")) {
            return "int|double";
        }
        return super.getPropertyInfo(_property);
    }

    @Override
    public ControlElement setProperty(String _property, String _value) {
        if ((_property = _property.trim()).equals("x") || _property.equals("y") || _property.equals("dragaction")) {
            if (_value != null) {
                Value constant = Value.parseConstant(_value, true);
                if (!this.reportDrag) {
                    this.reportDrag = constant == null;
                }
            }
        } else if ((_property.equals("keyAction") || _property.equals("keyPressed")) && _value != null) {
            Value constant = Value.parseConstant(_value, true);
            if (!this.reportKey) {
                this.reportKey = constant == null;
            }
        }
        return super.setProperty(_property, _value);
    }

    @Override
    public void setValue(int _index, Value _value) {
        switch (_index) {
            case 0: {
                this.autoX = _value.getBoolean();
                this.updateAutoscale();
                break;
            }
            case 1: {
                this.autoY = _value.getBoolean();
                this.updateAutoscale();
                break;
            }
            case 2: {
                if (_value.getDouble() == this.minX && this.xminSet) break;
                this.minX = _value.getDouble();
                this.xminSet = true;
                this.updateExtrema();
                break;
            }
            case 3: {
                if (_value.getDouble() == this.maxX && this.xmaxSet) break;
                this.maxX = _value.getDouble();
                this.xmaxSet = true;
                this.updateExtrema();
                break;
            }
            case 4: {
                if (_value.getDouble() == this.minY && this.yminSet) break;
                this.minY = _value.getDouble();
                this.yminSet = true;
                this.updateExtrema();
                break;
            }
            case 5: {
                if (_value.getDouble() == this.maxY && this.ymaxSet) break;
                this.maxY = _value.getDouble();
                this.ymaxSet = true;
                this.updateExtrema();
                break;
            }
            case 6: {
                this.posValues[0].value = _value.getDouble();
                break;
            }
            case 7: {
                this.posValues[1].value = _value.getDouble();
                break;
            }
            case 8: {
                this.removeAction(10, this.getProperty("pressaction"));
                this.addAction(10, _value.getString());
                break;
            }
            case 9: {
                this.removeAction(1, this.getProperty("dragaction"));
                this.addAction(1, _value.getString());
                break;
            }
            case 10: {
                this.removeAction(0, this.getProperty("action"));
                this.addAction(0, _value.getString());
                break;
            }
            case 11: {
                this.drawingPanel.setSquareAspect(_value.getBoolean());
                break;
            }
            case 12: {
                this.drawingPanel.setShowCoordinates(_value.getBoolean());
                break;
            }
            case 13: {
                Rectangle rect;
                if (!(_value.getObject() instanceof Rectangle) || (rect = (Rectangle)_value.getObject()) == this.myGutters) break;
                this.drawingPanel.setGutters(rect.x, rect.y, rect.width, rect.height);
                this.myGutters = rect;
                break;
            }
            case 14: {
                if (_value.getObject() instanceof DecimalFormat) {
                    this.strBuilder.setXFormat((DecimalFormat)_value.getObject());
                    break;
                }
                this.strBuilder.setXFormat((DecimalFormat)ConstantParser.formatConstant(_value.getString()).getObject());
                break;
            }
            case 15: {
                if (_value.getObject() instanceof DecimalFormat) {
                    this.strBuilder.setYFormat((DecimalFormat)_value.getObject());
                    break;
                }
                this.strBuilder.setYFormat((DecimalFormat)ConstantParser.formatConstant(_value.getString()).getObject());
                break;
            }
            case 16: {
                this.removeAction(30, this.getProperty("keyAction"));
                this.addAction(30, _value.getString());
                break;
            }
            case 17: {
                this.keyPressedValue.value = _value.getInteger();
                break;
            }
            case 18: {
                this.removeAction(31, this.getProperty("enteredAction"));
                this.addAction(31, _value.getString());
                break;
            }
            case 19: {
                this.removeAction(32, this.getProperty("exitedAction"));
                this.addAction(32, _value.getString());
                break;
            }
            case 20: {
                this.strBuilder.setExpression(_value.getString());
                break;
            }
            case 21: {
                if (_value.getObject() instanceof DecimalFormat) {
                    this.strBuilder.setExpressionFormat((DecimalFormat)_value.getObject());
                    break;
                }
                this.strBuilder.setExpressionFormat((DecimalFormat)ConstantParser.formatConstant(_value.getString()).getObject());
                break;
            }
            case 22: {
                this.drawingPanel.setXMarginPercentage(_value.getDouble());
                break;
            }
            case 23: {
                this.drawingPanel.setYMarginPercentage(_value.getDouble());
                break;
            }
            case 24: {
                this.drawingPanel.setMessage(_value.getString(), 3);
                break;
            }
            case 25: {
                this.drawingPanel.setMessage(_value.getString(), 2);
                break;
            }
            case 26: {
                this.drawingPanel.setMessage(_value.getString(), 0);
                break;
            }
            case 27: {
                this.drawingPanel.setMessage(_value.getString(), 1);
                break;
            }
            case 28: {
                boolean on = _value.getBoolean();
                this.drawingPanel.setAntialiasTextOn(on);
                this.drawingPanel.setAntialiasShapeOn(on);
                break;
            }
            case 29: {
                if (this.fontFactor == _value.getDouble()) break;
                this.fontFactor = _value.getDouble();
                this.drawingPanel.setFontFactor(this.fontFactor);
                break;
            }
            default: {
                super.setValue(_index - 30, _value);
            }
        }
    }

    @Override
    public void setDefaultValue(int _index) {
        switch (_index) {
            case 0: {
                this.autoX = false;
                this.updateAutoscale();
                break;
            }
            case 1: {
                this.autoY = false;
                this.updateAutoscale();
                break;
            }
            case 2: {
                this.minX = Double.NaN;
                this.xminSet = false;
                this.updateExtrema();
                break;
            }
            case 3: {
                this.maxX = Double.NaN;
                this.xmaxSet = false;
                this.updateExtrema();
                break;
            }
            case 4: {
                this.minY = Double.NaN;
                this.yminSet = false;
                this.updateExtrema();
                break;
            }
            case 5: {
                this.maxY = Double.NaN;
                this.ymaxSet = false;
                this.updateExtrema();
                break;
            }
            case 6: {
                this.posValues[0].value = (this.minX + this.maxX) / 2.0;
                break;
            }
            case 7: {
                this.posValues[1].value = (this.minY + this.maxY) / 2.0;
                break;
            }
            case 8: {
                this.removeAction(10, this.getProperty("pressaction"));
                break;
            }
            case 9: {
                this.removeAction(1, this.getProperty("dragaction"));
                break;
            }
            case 10: {
                this.removeAction(0, this.getProperty("action"));
                break;
            }
            case 11: {
                this.drawingPanel.setSquareAspect(false);
                break;
            }
            case 12: {
                this.drawingPanel.setShowCoordinates(true);
                break;
            }
            case 13: {
                this.drawingPanel.setGutters(0, 0, 0, 0);
                this.myGutters = null;
                break;
            }
            case 14: {
                this.strBuilder.setXFormat(new DecimalFormat("x=0.000;x=-0.000"));
                break;
            }
            case 15: {
                this.strBuilder.setYFormat(new DecimalFormat("y=0.000;y=-0.000"));
                break;
            }
            case 16: {
                this.removeAction(30, this.getProperty("keyAction"));
                break;
            }
            case 17: {
                this.keyPressedValue.value = -1;
                break;
            }
            case 18: {
                this.removeAction(31, this.getProperty("enteredAction"));
                break;
            }
            case 19: {
                this.removeAction(32, this.getProperty("exitedAction"));
                break;
            }
            case 20: {
                this.strBuilder.setExpression(null);
                break;
            }
            case 21: {
                this.strBuilder.setXFormat(new DecimalFormat("0.000;-0.000"));
                break;
            }
            case 22: {
                this.drawingPanel.setXMarginPercentage(0.0);
                break;
            }
            case 23: {
                this.drawingPanel.setYMarginPercentage(0.0);
                break;
            }
            case 24: {
                this.drawingPanel.setMessage("", 3);
                break;
            }
            case 25: {
                this.drawingPanel.setMessage("", 2);
                break;
            }
            case 26: {
                this.drawingPanel.setMessage("", 0);
                break;
            }
            case 27: {
                this.drawingPanel.setMessage("", 1);
                break;
            }
            case 28: {
                this.drawingPanel.setAntialiasTextOn(false);
                this.drawingPanel.setAntialiasShapeOn(false);
                break;
            }
            case 29: {
                this.fontFactor = 1.0;
                this.drawingPanel.setFontFactor(1.0);
                break;
            }
            default: {
                super.setDefaultValue(_index - 30);
            }
        }
    }

    @Override
    public String getDefaultValueString(int _index) {
        switch (_index) {
            case 0: 
            case 1: {
                return "false";
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return "<none>";
            }
            case 6: 
            case 7: {
                return "<none>";
            }
            case 8: 
            case 9: 
            case 10: {
                return "<no_action>";
            }
            case 11: {
                return "false";
            }
            case 12: {
                return "true";
            }
            case 13: {
                return "0,0,0,0";
            }
            case 14: {
                return "x=0.000;x=-0.000";
            }
            case 15: {
                return "y=0.000;y=-0.000";
            }
            case 16: {
                return "<no_action>";
            }
            case 17: {
                return "<none>";
            }
            case 18: 
            case 19: {
                return "<no_action>";
            }
            case 20: {
                return "<none>";
            }
            case 21: {
                return "0.000;-0.000";
            }
            case 22: 
            case 23: {
                return "0.0";
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                return "<none>";
            }
            case 28: {
                return "false";
            }
        }
        return super.getDefaultValueString(_index - 30);
    }

    @Override
    public Value getValue(int _index) {
        switch (_index) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                return null;
            }
            case 6: {
                return this.posValues[0];
            }
            case 7: {
                return this.posValues[1];
            }
            case 17: {
                return this.keyPressedValue;
            }
        }
        return super.getValue(_index - 30);
    }

    @Override
    public ControlDrawable getSelectedDrawable() {
        Object data;
        if (this.targetHit != null && this.targetHit.getSource() instanceof HasDataObjectInterface) {
            Object data2 = ((HasDataObjectInterface)((Object)this.targetHit.getSource())).getDataObject();
            if (data2 instanceof ControlDrawable) {
                return (ControlDrawable)data2;
            }
        } else if (this.target2D != null && (data = this.target2D.getElement().getDataObject()) instanceof ControlDrawable) {
            return (ControlDrawable)data;
        }
        return null;
    }

    private final void invokeTheAction(InteractionTarget _target2D, int _action, MouseEvent _evt) {
        Element element = _target2D.getElement();
        element.invokeActions(new org.opensourcephysics.drawing2d.interaction.InteractionEvent((Object)element, _action, _target2D.getActionCommand(), _target2D, _evt));
    }

    @Override
    public void handleMouseAction(InteractivePanel _panel, MouseEvent _evt) {
        switch (_panel.getMouseAction()) {
            case 1: {
                Interactive interactiveDrawable = _panel.getInteractive();
                if (interactiveDrawable instanceof org.opensourcephysics.displayejs.InteractionTarget) {
                    this.targetHit = (org.opensourcephysics.displayejs.InteractionTarget)interactiveDrawable;
                    this.targetHit.getSource().invokeActions(new InteractionEvent((Object)this.targetHit.getSource(), 2000, null, this.targetHit));
                    break;
                }
                if (interactiveDrawable instanceof InteractionTarget) {
                    this.target2D = (InteractionTarget)interactiveDrawable;
                    this.invokeTheAction(this.target2D, 2000, _evt);
                    break;
                }
                this.targetHit = null;
                this.target2D = null;
                this.mousePressed(_panel.getMouseX(), _panel.getMouseY());
                break;
            }
            case 3: {
                if (this.targetHit != null) {
                    Point3D trackerPoint = new Point3D(_panel.getMouseX(), _panel.getMouseY(), 0.0);
                    Simulation sim = this.getSimulation();
                    if (sim != null) {
                        sim.invokeMethodWhenIdle(new UpdateHotSpotDelayedAction(this.targetHit, _panel, trackerPoint));
                        if (!sim.isPaused()) break;
                        _panel.render();
                        break;
                    }
                    this.targetHit.updateHotspot(_panel, trackerPoint);
                    _panel.render();
                    break;
                }
                if (this.target2D != null) {
                    double[] point = new double[]{_panel.getMouseX(), _panel.getMouseY(), 0.0};
                    Simulation sim = this.getSimulation();
                    if (sim != null) {
                        sim.invokeMethodWhenIdle(new UpdateHotSpot2DDelayedAction(this.target2D, (double[])point.clone(), _evt));
                        if (!sim.isPaused()) break;
                        _panel.render();
                        break;
                    }
                    this.target2D.getElement().updateHotSpot(this.target2D, point);
                    this.invokeTheAction(this.target2D, 2001, _evt);
                    _panel.render();
                    break;
                }
                this.mouseDragged(_panel.getMouseX(), _panel.getMouseY());
                break;
            }
            case 2: {
                if (this.targetHit != null) {
                    this.targetHit.getSource().invokeActions(new InteractionEvent((Object)this.targetHit.getSource(), 2002, null, this.targetHit));
                    Simulation sim = this.getSimulation();
                    if (sim == null || sim.isPaused()) {
                        _panel.invalidateImage();
                        _panel.repaint();
                    }
                } else if (this.target2D != null) {
                    this.invokeTheAction(this.target2D, 2002, _evt);
                    Simulation sim = this.getSimulation();
                    if (sim == null || sim.isPaused()) {
                        _panel.invalidateImage();
                        _panel.repaint();
                    }
                } else {
                    this.mouseReleased(_panel.getMouseX(), _panel.getMouseY());
                }
                this.targetHit = null;
                this.target2D = null;
                break;
            }
            case 5: {
                this.invokeActions(31);
                break;
            }
            case 6: {
                this.invokeActions(32);
                this.targetHit = null;
                this.target2D = null;
                if (this.sourceLingered != null) {
                    this.sourceLingered.invokeActions(new InteractionEvent((Object)this.sourceLingered, 2004, null, this.sourceLingered));
                } else if (this.target2DEntered != null) {
                    this.invokeTheAction(this.target2DEntered, 2004, _evt);
                }
                this.sourceLingered = null;
                this.target2DEntered = null;
                break;
            }
            case 7: {
                Interactive interactiveDrawableLingered = _panel.getInteractive();
                if (interactiveDrawableLingered != null) {
                    _panel.setMouseCursor(Cursor.getPredefinedCursor(12));
                    if (interactiveDrawableLingered instanceof org.opensourcephysics.displayejs.InteractionTarget) {
                        if (this.sourceLingered == ((org.opensourcephysics.displayejs.InteractionTarget)interactiveDrawableLingered).getSource()) break;
                        if (this.sourceLingered != null) {
                            this.sourceLingered.invokeActions(new InteractionEvent((Object)this.sourceLingered, 2004, null, this.sourceLingered));
                        }
                        this.sourceLingered = ((org.opensourcephysics.displayejs.InteractionTarget)interactiveDrawableLingered).getSource();
                        this.sourceLingered.invokeActions(new InteractionEvent((Object)this.sourceLingered, 2003, null, interactiveDrawableLingered));
                        break;
                    }
                    if (!(interactiveDrawableLingered instanceof InteractionTarget) || this.target2DEntered != null && this.target2DEntered == interactiveDrawableLingered) break;
                    if (this.target2DEntered != null) {
                        this.invokeTheAction(this.target2DEntered, 2004, _evt);
                    }
                    this.target2DEntered = (InteractionTarget)interactiveDrawableLingered;
                    this.invokeTheAction(this.target2DEntered, 2003, _evt);
                    break;
                }
                _panel.setMouseCursor(Cursor.getPredefinedCursor(1));
                if (this.sourceLingered != null) {
                    this.sourceLingered.invokeActions(new InteractionEvent((Object)this.sourceLingered, 2004, null, this.sourceLingered));
                } else if (this.target2DEntered != null) {
                    this.invokeTheAction(this.target2DEntered, 2004, _evt);
                }
                this.sourceLingered = null;
                this.target2DEntered = null;
            }
        }
    }

    public void mousePressed(double _x, double _y) {
        this.drawingPanel.requestFocus();
        this.invokeActions(10);
        this.mouseDragged(_x, _y);
    }

    public void mouseDragged(double _x, double _y) {
        this.posValues[0].value = _x;
        this.posValues[1].value = _y;
        if (this.reportDrag) {
            this.variablesChanged(this.getPosIndex(), this.posValues);
            if (this.isUnderEjs) {
                this.setFieldListValues(this.getPosIndex(), this.posValues);
            }
        }
    }

    public void mouseReleased(double _x, double _y) {
        this.invokeActions(0);
    }
}

