/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing2d;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.drawing2d.Element;
import org.opensourcephysics.tools.Resource;
import org.opensourcephysics.tools.ResourceLoader;

public class ElementImage
extends Element {
    private String imageFile = null;
    private boolean trueSize = false;
    private Resource resource = null;
    private Image image = null;
    private double[] coordinates = new double[2];
    private double[] pixel = new double[2];
    private double[] pixelSize = new double[2];
    private AffineTransform imageTransform = new AffineTransform();
    private AffineTransform trueSizeTransform = new AffineTransform();
    private Shape shape;
    private double tempSizeX;
    private double tempSizeY;

    public ElementImage() {
        this.setSize(new double[]{0.1, 0.1});
        this.setImageFile("/org/opensourcephysics/resources/controls/images/window.gif");
    }

    private void setTheImage(Image _image, int _relPos) {
        double y1;
        double x1;
        int b1;
        int a1;
        this.image = _image;
        if (this.image == null) {
            return;
        }
        int width = Math.max(this.image.getWidth(null), 1);
        int height = Math.max(this.image.getHeight(null), 1);
        switch (_relPos) {
            default: {
                a1 = -width / 2;
                b1 = -height / 2;
                break;
            }
            case 1: {
                a1 = -width / 2;
                b1 = 0;
                break;
            }
            case 2: {
                a1 = -width / 2;
                b1 = -height;
                break;
            }
            case 3: {
                a1 = -width;
                b1 = -height / 2;
                break;
            }
            case 4: {
                a1 = 0;
                b1 = -height / 2;
                break;
            }
            case 5: {
                a1 = -width;
                b1 = 0;
                break;
            }
            case 6: {
                a1 = 0;
                b1 = 0;
                break;
            }
            case 7: {
                a1 = -width;
                b1 = -height;
                break;
            }
            case 8: {
                a1 = 0;
                b1 = -height;
            }
        }
        this.imageTransform = AffineTransform.getScaleInstance(1.0 / (double)width, -1.0 / (double)height);
        this.imageTransform.concatenate(AffineTransform.getTranslateInstance(a1, b1));
        switch (_relPos) {
            default: {
                x1 = -0.5;
                y1 = -0.5;
                break;
            }
            case 1: {
                x1 = -0.5;
                y1 = -1.0;
                break;
            }
            case 2: {
                x1 = -0.5;
                y1 = 0.0;
                break;
            }
            case 3: {
                x1 = -1.0;
                y1 = -0.5;
                break;
            }
            case 4: {
                x1 = 0.0;
                y1 = -0.5;
                break;
            }
            case 5: {
                x1 = -1.0;
                y1 = -1.0;
                break;
            }
            case 6: {
                x1 = 0.0;
                y1 = -1.0;
                break;
            }
            case 7: {
                x1 = -1.0;
                y1 = 0.0;
                break;
            }
            case 8: {
                x1 = 0.0;
                y1 = 0.0;
            }
        }
        this.shape = new Rectangle2D.Double(x1, y1, 1.0, 1.0);
        this.setNeedToProject(true);
    }

    public void setImageFile(String file) {
        if (this.imageFile != null && this.imageFile.equals(file)) {
            return;
        }
        this.imageFile = file;
        if (file != null) {
            this.resource = ResourceLoader.getResource(file);
            if (this.resource != null) {
                this.image = this.resource.getImage();
                Component comp = null;
                if (this.getPanel() != null) {
                    comp = this.getPanel().getComponent();
                }
                Toolkit.getDefaultToolkit().prepareImage(this.image, -1, -1, comp);
                this.setTheImage(this.resource.getImage(), this.getStyle().getRelativePosition());
            }
        }
    }

    public String getImageFile() {
        return this.imageFile;
    }

    public void setImage(Image _image) {
        this.imageFile = null;
        if (_image != this.image) {
            this.image = _image;
            Component comp = null;
            if (this.getPanel() != null) {
                comp = this.getPanel().getComponent();
            }
            Toolkit.getDefaultToolkit().prepareImage(this.image, -1, -1, comp);
            this.setTheImage(_image, this.getStyle().getRelativePosition());
            if (this.trueSize) {
                this.setTrueSize(true);
            }
        }
    }

    public void setTrueSize(boolean _s) {
        this.trueSize = _s;
        if (this.trueSize) {
            this.tempSizeX = this.getSizeX();
            this.tempSizeY = this.getSizeY();
            if (this.image != null) {
                super.setSizeXY(this.image.getWidth(null), this.image.getHeight(null));
            }
        } else {
            super.setSizeXY(this.tempSizeX, this.tempSizeY);
        }
        this.setNeedToProject(true);
    }

    public boolean isTrueSize() {
        return this.trueSize;
    }

    @Override
    public void setSizeX(double _sizeX) {
        if (this.trueSize) {
            this.tempSizeX = _sizeX;
            this.setElementChanged();
        } else {
            super.setSizeX(_sizeX);
        }
    }

    @Override
    public void setSizeY(double _sizeY) {
        if (this.trueSize) {
            this.tempSizeY = _sizeY;
            this.setElementChanged();
        } else {
            super.setSizeY(_sizeY);
        }
    }

    @Override
    public void setSizeXY(double _sizeX, double _sizeY) {
        if (this.trueSize) {
            this.tempSizeX = _sizeX;
            this.tempSizeY = _sizeY;
            this.setElementChanged();
        } else {
            super.setSizeXY(_sizeX, _sizeY);
        }
    }

    @Override
    public void setSize(double[] _size) {
        if (this.trueSize) {
            this.tempSizeX = _size[0];
            this.tempSizeY = _size[0];
            this.setElementChanged();
        } else {
            super.setSize(_size);
        }
    }

    @Override
    protected void styleChanged(int styleThatChanged) {
        if (styleThatChanged == 5) {
            this.setTheImage(this.image, this.getStyle().getRelativePosition());
        }
    }

    @Override
    protected int getCorners(double[] _corners) {
        if (this.trueSize) {
            _corners[1] = 0.0;
            _corners[0] = 0.0;
            return 1;
        }
        switch (this.getStyle().getRelativePosition()) {
            default: {
                _corners[0] = -0.5;
                _corners[1] = -0.5;
                break;
            }
            case 1: {
                _corners[0] = -0.5;
                _corners[1] = -1.0;
                break;
            }
            case 2: {
                _corners[0] = -0.5;
                _corners[1] = 0.0;
                break;
            }
            case 3: {
                _corners[0] = -1.0;
                _corners[1] = -0.5;
                break;
            }
            case 4: {
                _corners[0] = 0.0;
                _corners[1] = -0.5;
                break;
            }
            case 5: {
                _corners[0] = -1.0;
                _corners[1] = -1.0;
                break;
            }
            case 6: {
                _corners[0] = 0.0;
                _corners[1] = -1.0;
                break;
            }
            case 7: {
                _corners[0] = -1.0;
                _corners[1] = 0.0;
                break;
            }
            case 8: {
                _corners[0] = 0.0;
                _corners[1] = 0.0;
            }
        }
        _corners[4] = _corners[2] = _corners[0] + 1.0;
        _corners[6] = _corners[0];
        _corners[3] = _corners[1];
        _corners[5] = _corners[7] = _corners[1] + 1.0;
        return 4;
    }

    @Override
    public void draw(DrawingPanel _panel, Graphics _g) {
        AffineTransform tr;
        if (this.image == null || !this.isReallyVisible()) {
            return;
        }
        Graphics2D g2 = (Graphics2D)_g;
        if (this.trueSize) {
            if (this.hasChanged() || this.needsToProject()) {
                this.projectPoints();
            }
            tr = new AffineTransform(this.trueSizeTransform);
            tr.preConcatenate(this.getPixelTransform(_panel));
        } else {
            tr = this.getPixelTransform(_panel);
        }
        tr.concatenate(this.imageTransform);
        g2.drawImage(this.image, tr, _panel);
    }

    @Override
    public Interactive findInteractive(DrawingPanel _panel, int _xpix, int _ypix) {
        int sensitivity;
        if (!this.targetPosition.isEnabled()) {
            return null;
        }
        if (this.image == null || !this.isReallyVisible()) {
            return null;
        }
        if (this.hasChanged() || this.needsToProject()) {
            this.projectPoints();
        }
        if ((sensitivity = this.getStyle().getSensitivity()) <= 0) {
            AffineTransform tr;
            if (this.trueSize) {
                tr = new AffineTransform(this.trueSizeTransform);
                tr.preConcatenate(this.getPixelTransform(_panel));
            } else {
                tr = this.getPixelTransform(_panel);
            }
            Shape trShape = tr.createTransformedShape(this.shape);
            if (trShape.contains(_xpix, _ypix)) {
                return this.targetPosition;
            }
        } else if (Math.abs(this.pixel[0] - (double)_xpix) < (double)sensitivity && Math.abs(this.pixel[1] - (double)_ypix) < (double)sensitivity) {
            return this.targetPosition;
        }
        return null;
    }

    private void projectPoints() {
        if (this.image == null) {
            return;
        }
        this.coordinates[0] = 0.0;
        this.coordinates[1] = 0.0;
        this.getTotalTransform().transform(this.coordinates, 0, this.coordinates, 0, 1);
        this.getPanel().projectPosition(this.coordinates, this.pixel);
        if (this.trueSize) {
            int width = this.image.getWidth(null);
            int height = this.image.getHeight(null);
            this.getPanel().projectSize(this.coordinates, this.getSize(), this.pixelSize);
            this.trueSizeTransform = AffineTransform.getScaleInstance(this.pixelSize[0] == 0.0 ? 0.0 : (double)width / this.pixelSize[0], this.pixelSize[1] == 0.0 ? 0.0 : (double)height / this.pixelSize[1]);
        }
        this.setNeedToProject(false);
    }
}

