/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display2d;

import org.opensourcephysics.numerics.Function;

public class ZExpansion
implements Function {
    double expansion = 1.0;
    double k = 1.0;
    double min = -1.0;
    double max = 1.0;
    double center = 0.0;
    double a1;
    double a2 = 1.0;

    public ZExpansion(double d) {
        this.expansion = Math.abs(d);
    }

    public void setExpansion(double d) {
        this.expansion = Math.abs(d);
        this.setMinMax(this.min, this.max);
    }

    public void setMinMax(double d, double d2) {
        this.min = d;
        this.max = d2;
        if (d == d2) {
            this.k = 0.0;
            this.a2 = this.center = d;
            this.a1 = this.center;
        } else if (d <= 0.0 && d2 >= 0.0) {
            this.center = 0.0;
            this.k = this.expansion / Math.max(-d, d2);
            this.a1 = d2 / (1.0 - Math.exp(-this.k * d2));
            this.a2 = -d / (1.0 - Math.exp(this.k * d));
        } else if (d > 0.0) {
            this.center = d;
            this.k = this.expansion / (d2 - d);
            this.a1 = this.a2 = d2 / (1.0 - Math.exp(-this.k * (d2 - d)));
        } else {
            this.center = d2;
            this.k = this.expansion / (d2 - d);
            this.a1 = this.a2 = -d / (1.0 - Math.exp(this.k * (d2 - d)));
        }
    }

    @Override
    public double evaluate(double d) {
        if ((d -= this.center) >= 0.0) {
            return this.a1 * (1.0 - Math.exp(-this.k * d));
        }
        return -this.a2 * (1.0 - Math.exp(this.k * d));
    }
}

