/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.value;

import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.colos.ejs.library.control.value.ParserException;

public final class ParserSuryono {
    private int var_count;
    private String[] var_name;
    private double[] var_value;
    private double[] number;
    private String function = "";
    private String postfix_code = "";
    private boolean valid = false;
    private int error;
    private boolean ISBOOLEAN = false;
    private boolean INRELATION = false;
    private int position;
    private int start;
    private int num;
    private char character;
    private int numberindex;
    private double[] refvalue = null;
    private static final String[] constname = new String[]{"Math.E", "Math.PI"};
    private static final double[] constvalue = new double[]{Math.E, Math.PI};
    private static final String[] funcnameNoParam = new String[]{"Math.random"};
    private static final String[] funcname = new String[]{"Math.abs", "Math.acos", "Math.asin", "Math.atan", "Math.ceil", "Math.cos", "Math.exp", "Math.floor", "Math.log", "Math.rint", "Math.round", "Math.sin", "Math.sqrt", "Math.tan", "Math.toDegrees", "Math.toRadians"};
    private static final String[] extfunc = new String[]{"Math.atan2", "Math.IEEEremainder", "Math.max", "Math.min", "Math.pow"};
    private static final int MAX_NUM = 200;
    private static final int NO_CONST = constname.length;
    private static final int NO_FUNCSNOPARAM = funcnameNoParam.length;
    private static final int NO_FUNCS = funcname.length;
    private static final int NO_EXT_FUNCS = extfunc.length;
    private static final int STACK_SIZE = 50;
    private double[] stack = new double[50];
    private Hashtable<String, String> references = null;
    private Vector<String> refnames = null;
    public static final int NO_ERROR = 0;
    public static final int SYNTAX_ERROR = 1;
    public static final int PAREN_EXPECTED = 2;
    public static final int UNCOMPILED_FUNCTION = 3;
    public static final int EXPRESSION_EXPECTED = 4;
    public static final int UNKNOWN_IDENTIFIER = 5;
    public static final int OPERATOR_EXPECTED = 6;
    public static final int PAREN_NOT_MATCH = 7;
    public static final int CODE_DAMAGED = 8;
    public static final int STACK_OVERFLOW = 9;
    public static final int TOO_MANY_CONSTS = 10;
    public static final int COMMA_EXPECTED = 11;
    public static final int INVALID_OPERAND = 12;
    public static final int INVALID_OPERATOR = 13;
    public static final int NO_FUNC_DEFINITION = 14;
    public static final int REF_NAME_EXPECTED = 15;
    private static final int FUNC_OFFSET = 1000;
    private static final int EXT_FUNC_OFFSET = 1000 + NO_FUNCS;
    private static final int FUNCNOPARAM_OFFSET = EXT_FUNC_OFFSET + NO_EXT_FUNCS;
    private static final int VAR_OFFSET = 2000;
    private static final int REF_OFFSET = 3000;
    private static final char CONST_OFFSET = '\u00fd';
    private static final char NUMERIC = '\u012c';
    private static final char JUMP_CODE = '\u0001';
    private static final char LESS_THAN = '\u0002';
    private static final char GREATER_THAN = '\u0003';
    private static final char LESS_EQUAL = '\u0004';
    private static final char GREATER_EQUAL = '\u0005';
    private static final char NOT_EQUAL = '\u0006';
    private static final char EQUAL = '\u0007';
    private static final char IF_CODE = '\b';
    private static final char ENDIF = '\t';
    private static final char AND_CODE = '\n';
    private static final char OR_CODE = '\u000b';
    private static final char NOT_CODE = '\f';

    /*
     * Unable to fully structure code
     */
    public static boolean isKeyword(String token) {
        try {
            Double.parseDouble(token);
            return true;
        }
        catch (Exception var1_1) {
            i = 0;
            ** while (i < ParserSuryono.NO_CONST)
        }
lbl-1000:
        // 1 sources

        {
            if (token.equals(ParserSuryono.constname[i])) {
                return true;
            }
            ++i;
            continue;
        }
lbl12:
        // 1 sources

        i = 0;
        while (i < ParserSuryono.NO_FUNCS) {
            if (token.equals(ParserSuryono.funcname[i])) {
                return true;
            }
            ++i;
        }
        i = 0;
        while (i < ParserSuryono.NO_EXT_FUNCS) {
            if (token.equals(ParserSuryono.extfunc[i])) {
                return true;
            }
            ++i;
        }
        i = 0;
        while (i < ParserSuryono.NO_FUNCSNOPARAM) {
            if (token.equals(ParserSuryono.funcnameNoParam[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String[] getVariableList(String _expression) {
        Vector<String> varlist = ParserSuryono.getVariableList(_expression, new Vector<String>());
        if (varlist.size() < 1) {
            return new String[0];
        }
        return varlist.toArray(new String[1]);
    }

    public static Vector<String> getVariableList(String _expression, Vector<String> varlist) {
        StringTokenizer tkn = new StringTokenizer(_expression, "() \t+-*/,<>=&|");
        while (tkn.hasMoreTokens()) {
            String token = tkn.nextToken();
            if (ParserSuryono.isKeyword(token) || varlist.contains(token)) continue;
            varlist.add(token);
        }
        return varlist;
    }

    public ParserSuryono(int variablecount) {
        this.var_count = variablecount;
        this.references = new Hashtable();
        this.refnames = new Vector();
        this.var_name = new String[variablecount];
        this.var_value = new double[variablecount];
        this.number = new double[200];
    }

    public void defineVariable(int index, String name) {
        this.var_name[index] = name;
    }

    public void setVariable(int index, double value) {
        this.var_value[index] = value;
    }

    public void define(String definition) {
        this.function = definition;
        this.valid = false;
    }

    public void parse() {
        int index;
        String allFunction = new String(this.function);
        String orgFunction = new String(this.function);
        if (this.valid) {
            return;
        }
        this.num = 0;
        this.error = 0;
        this.references.clear();
        this.refnames.removeAllElements();
        while ((index = allFunction.lastIndexOf(";")) != -1) {
            this.function = String.valueOf(allFunction.substring(index + 1)) + ')';
            allFunction = allFunction.substring(0, index++);
            String refname = null;
            int separator = this.function.indexOf(":");
            if (separator == -1) {
                this.error = 14;
                this.position = 0;
                while (this.position < this.function.length()) {
                    if (this.function.charAt(this.position) != ' ') break;
                    ++this.position;
                }
                ++this.position;
            } else {
                refname = this.function.substring(0, separator);
                this.function = this.function.substring(separator + 1);
                if ((refname = refname.trim()).equals("")) {
                    this.error = 15;
                    this.position = 1;
                } else {
                    index += ++separator;
                    this.parseSubFunction();
                }
            }
            if (this.error != 0) {
                this.position += index;
                break;
            }
            this.references.put(refname, this.postfix_code);
            this.refnames.addElement(refname);
        }
        if (this.error == 0) {
            this.function = String.valueOf(allFunction) + ')';
            this.parseSubFunction();
        }
        this.function = orgFunction;
        this.valid = this.error == 0;
    }

    public double evaluate() {
        double result;
        int size = this.refnames.size();
        if (!this.valid) {
            this.error = 3;
            return 0.0;
        }
        this.error = 0;
        this.numberindex = 0;
        if (size != 0) {
            String orgPFC = this.postfix_code;
            this.refvalue = new double[size];
            int i = 0;
            while (i < this.refnames.size()) {
                String name = this.refnames.elementAt(i);
                this.postfix_code = this.references.get(name);
                result = this.evaluateSubFunction();
                if (this.error != 0) {
                    this.postfix_code = orgPFC;
                    this.refvalue = null;
                    return result;
                }
                this.refvalue[i] = result;
                ++i;
            }
            this.postfix_code = orgPFC;
        }
        result = this.evaluateSubFunction();
        this.refvalue = null;
        if (Double.isNaN(result)) {
            result = 0.0;
        }
        return result;
    }

    public int getErrorCode() {
        return this.error;
    }

    public String getErrorString() {
        return ParserSuryono.toErrorString(this.error);
    }

    public int getErrorPosition() {
        return this.position;
    }

    public static String toErrorString(int errorcode) {
        String s = "";
        switch (errorcode) {
            case 0: {
                s = "no error";
                break;
            }
            case 1: {
                s = "syntax error";
                break;
            }
            case 2: {
                s = "parenthesis expected";
                break;
            }
            case 3: {
                s = "uncompiled function";
                break;
            }
            case 4: {
                s = "expression expected";
                break;
            }
            case 5: {
                s = "unknown identifier";
                break;
            }
            case 6: {
                s = "operator expected";
                break;
            }
            case 7: {
                s = "parentheses not match";
                break;
            }
            case 8: {
                s = "internal code damaged";
                break;
            }
            case 9: {
                s = "execution stack overflow";
                break;
            }
            case 10: {
                s = "too many constants";
                break;
            }
            case 11: {
                s = "comma expected";
                break;
            }
            case 12: {
                s = "invalid operand type";
                break;
            }
            case 13: {
                s = "invalid operator";
                break;
            }
            case 14: {
                s = "bad reference definition (: expected)";
                break;
            }
            case 15: {
                s = "reference name expected";
            }
        }
        return s;
    }

    private void skipSpaces() throws ParserException {
        try {
            while (this.function.charAt(this.position - 1) == ' ') {
                ++this.position;
            }
            this.character = this.function.charAt(this.position - 1);
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new ParserException(7);
        }
    }

    private void getNextCharacter() throws ParserException {
        ++this.position;
        try {
            this.character = this.function.charAt(this.position - 1);
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new ParserException(7);
        }
    }

    private void addCode(char code) {
        this.postfix_code = String.valueOf(this.postfix_code) + code;
    }

    private void scanNumber() throws ParserException {
        double value;
        String numstr = "";
        if (this.num == 200) {
            throw new ParserException(10);
        }
        if (this.character != '.') {
            do {
                numstr = String.valueOf(numstr) + this.character;
                this.getNextCharacter();
            } while (this.character >= '0' && this.character <= '9');
        } else {
            numstr = String.valueOf(numstr) + '0';
        }
        if (this.character == '.') {
            do {
                numstr = String.valueOf(numstr) + this.character;
                this.getNextCharacter();
            } while (this.character >= '0' && this.character <= '9');
        }
        if (this.character == 'e' || this.character == 'E') {
            numstr = String.valueOf(numstr) + 'e';
            this.getNextCharacter();
            if (this.character == '+' || this.character == '-') {
                numstr = String.valueOf(numstr) + this.character;
                this.getNextCharacter();
            }
            while (this.character >= '0' && this.character <= '9') {
                numstr = String.valueOf(numstr) + this.character;
                this.getNextCharacter();
            }
        }
        try {
            value = Double.valueOf(numstr);
        }
        catch (NumberFormatException e) {
            this.position = this.start;
            throw new ParserException(1);
        }
        this.number[this.num++] = value;
        this.addCode('\u012c');
    }

    private void scanNonNumeric() throws ParserException {
        String stream = "";
        if (this.character == '*' || this.character == '/' || this.character == ')' || this.character == '!' || this.character == ',' || this.character == '<' || this.character == '>' || this.character == '=' || this.character == '&' || this.character == '|') {
            throw new ParserException(1);
        }
        do {
            stream = String.valueOf(stream) + this.character;
            this.getNextCharacter();
        } while (this.character != ' ' && this.character != '+' && this.character != '-' && this.character != '*' && this.character != '/' && this.character != '!' && this.character != '(' && this.character != ')' && this.character != ',' && this.character != '<' && this.character != '>' && this.character != '=' && this.character != '&' && this.character != '|');
        int i = 0;
        while (i < NO_CONST) {
            if (stream.equals(constname[i])) {
                this.addCode((char)(i + 253));
                return;
            }
            ++i;
        }
        i = 0;
        while (i < NO_FUNCS) {
            if (stream.equals(funcname[i])) {
                this.skipSpaces();
                if (this.character != '(') {
                    throw new ParserException(2);
                }
                this.scanAndParse();
                if (this.character != ')') {
                    throw new ParserException(2);
                }
                this.getNextCharacter();
                this.addCode((char)(i + 1000));
                return;
            }
            ++i;
        }
        i = 0;
        while (i < NO_EXT_FUNCS) {
            if (stream.equals(extfunc[i])) {
                this.skipSpaces();
                if (this.character != '(') {
                    throw new ParserException(2);
                }
                this.scanAndParse();
                if (this.character != ',') {
                    throw new ParserException(11);
                }
                String savecode = new String(this.postfix_code);
                this.postfix_code = "";
                this.scanAndParse();
                if (this.character != ')') {
                    throw new ParserException(2);
                }
                this.getNextCharacter();
                savecode = String.valueOf(savecode) + this.postfix_code;
                this.postfix_code = new String(savecode);
                this.addCode((char)(i + EXT_FUNC_OFFSET));
                return;
            }
            ++i;
        }
        i = 0;
        while (i < NO_FUNCSNOPARAM) {
            if (stream.equals(funcnameNoParam[i])) {
                this.skipSpaces();
                if (this.character != '(') {
                    throw new ParserException(2);
                }
                this.skipSpaces();
                this.getNextCharacter();
                if (this.character != ')') {
                    throw new ParserException(2);
                }
                this.getNextCharacter();
                this.addCode((char)(i + FUNCNOPARAM_OFFSET));
                return;
            }
            ++i;
        }
        i = 0;
        while (i < this.var_count) {
            if (stream.equals(this.var_name[i])) {
                this.addCode((char)(i + 2000));
                return;
            }
            ++i;
        }
        int index = this.refnames.indexOf(stream);
        if (index != -1) {
            this.addCode((char)(index + 3000));
            return;
        }
        this.position = this.start;
        throw new ParserException(5);
    }

    private boolean getIdentifier() throws ParserException {
        boolean negate = false;
        this.getNextCharacter();
        this.skipSpaces();
        if (this.character == '!') {
            this.getNextCharacter();
            this.skipSpaces();
            if (this.character != '(') {
                throw new ParserException(2);
            }
            this.scanAndParse();
            if (this.character != ')') {
                throw new ParserException(2);
            }
            if (!this.ISBOOLEAN) {
                throw new ParserException(12);
            }
            this.addCode('\f');
            this.getNextCharacter();
            return false;
        }
        this.ISBOOLEAN = false;
        while (this.character == '+' || this.character == '-') {
            if (this.character == '-') {
                negate = !negate;
            }
            this.getNextCharacter();
            this.skipSpaces();
        }
        this.start = this.position;
        if (this.character >= '0' && this.character <= '9' || this.character == '.') {
            this.scanNumber();
        } else if (this.character == '(') {
            this.scanAndParse();
            this.getNextCharacter();
        } else {
            this.scanNonNumeric();
        }
        this.skipSpaces();
        return negate;
    }

    private void arithmeticLevel2() throws ParserException {
        if (this.ISBOOLEAN) {
            throw new ParserException(12);
        }
        do {
            char operator = this.character;
            boolean negate = this.getIdentifier();
            if (this.ISBOOLEAN) {
                throw new ParserException(12);
            }
            if (negate) {
                this.addCode('_');
            }
            this.addCode(operator);
        } while (this.character == '*' || this.character == '/');
    }

    private void arithmeticLevel1() throws ParserException {
        if (this.ISBOOLEAN) {
            throw new ParserException(12);
        }
        do {
            char operator = this.character;
            boolean negate = this.getIdentifier();
            if (this.ISBOOLEAN) {
                throw new ParserException(12);
            }
            if (this.character == '*' || this.character == '/') {
                if (negate) {
                    this.addCode('_');
                }
                this.arithmeticLevel2();
            }
            this.addCode(operator);
        } while (this.character == '+' || this.character == '-');
    }

    private void relationLevel() throws ParserException {
        int code = 0;
        if (this.INRELATION) {
            throw new ParserException(13);
        }
        this.INRELATION = true;
        if (this.ISBOOLEAN) {
            throw new ParserException(12);
        }
        switch (this.character) {
            case '!': {
                code = 12;
                this.getNextCharacter();
                if (this.character == '=') {
                    code = 6;
                    break;
                }
                --this.position;
                break;
            }
            case '=': {
                code = 7;
                this.getNextCharacter();
                if (this.character == '=') {
                    code = 7;
                    break;
                }
                --this.position;
                break;
            }
            case '<': {
                code = 2;
                this.getNextCharacter();
                if (this.character == '>') {
                    code = 6;
                    break;
                }
                if (this.character == '=') {
                    code = 4;
                    break;
                }
                --this.position;
                break;
            }
            case '>': {
                code = 3;
                this.getNextCharacter();
                if (this.character == '=') {
                    code = 5;
                    break;
                }
                --this.position;
            }
        }
        this.scanAndParse();
        this.INRELATION = false;
        if (this.ISBOOLEAN) {
            throw new ParserException(12);
        }
        this.addCode((char)code);
        this.ISBOOLEAN = true;
    }

    private void booleanLevel() throws ParserException {
        if (!this.ISBOOLEAN) {
            throw new ParserException(12);
        }
        char operator = this.character;
        this.scanAndParse();
        if (!this.ISBOOLEAN) {
            throw new ParserException(12);
        }
        switch (operator) {
            case '&': {
                this.addCode('\n');
                break;
            }
            case '|': {
                this.addCode('\u000b');
            }
        }
    }

    private void scanAndParse() throws ParserException {
        boolean negate = this.getIdentifier();
        if (negate) {
            this.addCode('_');
        }
        block7: while (true) {
            switch (this.character) {
                case '+': 
                case '-': {
                    this.arithmeticLevel1();
                    continue block7;
                }
                case '*': 
                case '/': {
                    this.arithmeticLevel2();
                    continue block7;
                }
                case ')': 
                case ',': {
                    return;
                }
                case '!': 
                case '<': 
                case '=': 
                case '>': {
                    this.relationLevel();
                    continue block7;
                }
                case '&': 
                case '|': {
                    this.booleanLevel();
                    continue block7;
                }
            }
            break;
        }
        throw new ParserException(6);
    }

    private void parseSubFunction() {
        block3: {
            this.position = 0;
            this.postfix_code = "";
            this.INRELATION = false;
            this.ISBOOLEAN = false;
            try {
                this.scanAndParse();
            }
            catch (ParserException e) {
                this.error = e.getErrorCode();
                if (this.error != 1 || this.postfix_code != "") break block3;
                this.error = 4;
            }
        }
        if (this.error == 0 && this.position != this.function.length()) {
            this.error = 7;
        }
    }

    private double builtInFunction(int _function, double parameter) {
        switch (_function) {
            case 0: {
                return Math.abs(parameter);
            }
            case 1: {
                return Math.acos(parameter);
            }
            case 2: {
                return Math.asin(parameter);
            }
            case 3: {
                return Math.atan(parameter);
            }
            case 4: {
                return Math.ceil(parameter);
            }
            case 5: {
                return Math.cos(parameter);
            }
            case 6: {
                return Math.exp(parameter);
            }
            case 7: {
                return Math.floor(parameter);
            }
            case 8: {
                return Math.log(parameter);
            }
            case 9: {
                return Math.rint(parameter);
            }
            case 10: {
                return Math.round(parameter);
            }
            case 11: {
                return Math.sin(parameter);
            }
            case 12: {
                return Math.sqrt(parameter);
            }
            case 13: {
                return Math.tan(parameter);
            }
            case 14: {
                return Math.toDegrees(parameter);
            }
            case 15: {
                return Math.toRadians(parameter);
            }
        }
        this.error = 8;
        return Double.NaN;
    }

    private double builtInFunctionNoParam(int _function) {
        switch (_function) {
            case 0: {
                return Math.random();
            }
        }
        this.error = 8;
        return Double.NaN;
    }

    private double builtInExtFunction(int _function, double param1, double param2) {
        switch (_function) {
            case 0: {
                return Math.atan2(param1, param2);
            }
            case 1: {
                return Math.IEEEremainder(param1, param2);
            }
            case 2: {
                return Math.max(param1, param2);
            }
            case 3: {
                return Math.min(param1, param2);
            }
            case 4: {
                return Math.pow(param1, param2);
            }
        }
        this.error = 8;
        return Double.NaN;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private double evaluateSubFunction() {
        stack_pointer = -1;
        code_pointer = 0;
        codeLength = this.postfix_code.length();
        while (true) {
            try {
                if (code_pointer == codeLength) {
                    return this.stack[0];
                }
                code = this.postfix_code.charAt(code_pointer++);
            }
            catch (StringIndexOutOfBoundsException e) {
                return this.stack[0];
            }
            try {
                switch (code) {
                    case '+': {
                        v0 = stack_pointer - 1;
                        this.stack[v0] = this.stack[v0] + this.stack[stack_pointer];
                        --stack_pointer;
                        break;
                    }
                    case '-': {
                        v1 = stack_pointer - 1;
                        this.stack[v1] = this.stack[v1] - this.stack[stack_pointer];
                        --stack_pointer;
                        break;
                    }
                    case '*': {
                        v2 = stack_pointer - 1;
                        this.stack[v2] = this.stack[v2] * this.stack[stack_pointer];
                        --stack_pointer;
                        break;
                    }
                    case '/': {
                        if (this.stack[stack_pointer] != 0.0) {
                            v3 = stack_pointer - 1;
                            this.stack[v3] = this.stack[v3] / this.stack[stack_pointer];
                        } else {
                            v4 = stack_pointer - 1;
                            this.stack[v4] = this.stack[v4] / 1.0E-128;
                        }
                        --stack_pointer;
                        break;
                    }
                    case '_': {
                        this.stack[stack_pointer] = -this.stack[stack_pointer];
                        break;
                    }
                    case '\u0001': {
                        destination = code_pointer + this.postfix_code.charAt(code_pointer++);
                        while (code_pointer < destination) {
                            if (this.postfix_code.charAt(code_pointer++) != '\u012c') continue;
                            ++this.numberindex;
                        }
                        break;
                    }
                    case '\u0002': {
                        v5 = this.stack[--stack_pointer] < this.stack[stack_pointer + 1] ? 1.0 : 0.0;
                        this.stack[stack_pointer] = v5;
                        break;
                    }
                    case '\u0003': {
                        v6 = this.stack[--stack_pointer] > this.stack[stack_pointer + 1] ? 1.0 : 0.0;
                        this.stack[stack_pointer] = v6;
                        break;
                    }
                    case '\u0004': {
                        v7 = this.stack[--stack_pointer] <= this.stack[stack_pointer + 1] ? 1.0 : 0.0;
                        this.stack[stack_pointer] = v7;
                        break;
                    }
                    case '\u0005': {
                        v8 = this.stack[--stack_pointer] >= this.stack[stack_pointer + 1] ? 1.0 : 0.0;
                        this.stack[stack_pointer] = v8;
                        break;
                    }
                    case '\u0007': {
                        v9 = this.stack[--stack_pointer] == this.stack[stack_pointer + 1] ? 1.0 : 0.0;
                        this.stack[stack_pointer] = v9;
                        break;
                    }
                    case '\u0006': {
                        v10 = this.stack[--stack_pointer] != this.stack[stack_pointer + 1] ? 1.0 : 0.0;
                        this.stack[stack_pointer] = v10;
                        break;
                    }
                    case '\b': {
                        if (this.stack[stack_pointer--] != 0.0) ** GOTO lbl76
                        destination = code_pointer + this.postfix_code.charAt(code_pointer++);
                        if (true) ** GOTO lbl130
lbl76:
                        // 1 sources

                        ++code_pointer;
                        break;
                    }
                    case '\t': {
                        break;
                    }
                    case '\n': {
                        if (this.stack[--stack_pointer] != 0.0 && this.stack[stack_pointer + 1] != 0.0) {
                            this.stack[stack_pointer] = 1.0;
                            break;
                        }
                        this.stack[stack_pointer] = 0.0;
                        break;
                    }
                    case '\u000b': {
                        if (this.stack[--stack_pointer] != 0.0 || this.stack[stack_pointer + 1] != 0.0) {
                            this.stack[stack_pointer] = 1.0;
                            break;
                        }
                        this.stack[stack_pointer] = 0.0;
                        break;
                    }
                    case '\f': {
                        this.stack[stack_pointer] = this.stack[stack_pointer] == 0.0 ? 1.0 : 0.0;
                        break;
                    }
                    case '\u012c': {
                        this.stack[++stack_pointer] = this.number[this.numberindex++];
                        break;
                    }
                    default: {
                        if (code >= '\u0bb8') {
                            this.stack[++stack_pointer] = this.refvalue[code - 3000];
                            break;
                        }
                        if (code >= '\u07d0') {
                            this.stack[++stack_pointer] = this.var_value[code - 2000];
                            break;
                        }
                        if (code >= ParserSuryono.FUNCNOPARAM_OFFSET) {
                            this.stack[++stack_pointer] = this.builtInFunctionNoParam(code - ParserSuryono.FUNCNOPARAM_OFFSET);
                            break;
                        }
                        if (code >= ParserSuryono.EXT_FUNC_OFFSET) {
                            this.stack[stack_pointer - 1] = this.builtInExtFunction(code - ParserSuryono.EXT_FUNC_OFFSET, this.stack[stack_pointer - 1], this.stack[stack_pointer]);
                            --stack_pointer;
                            break;
                        }
                        if (code >= '\u03e8') {
                            this.stack[stack_pointer] = this.builtInFunction(code - 1000, this.stack[stack_pointer]);
                            break;
                        }
                        if (code < '\u00fd') {
                            this.error = 8;
                            return NaN;
                        }
                        this.stack[++stack_pointer] = ParserSuryono.constvalue[code - 253];
                        break;
                    }
                }
                continue;
            }
            catch (ArrayIndexOutOfBoundsException oe) {
                this.error = 9;
                return NaN;
            }
            catch (NullPointerException ne) {
                this.error = 8;
                return NaN;
            }
            do {
                if (this.postfix_code.charAt(code_pointer++) != '\u012c') continue;
                ++this.numberindex;
lbl130:
                // 3 sources

            } while (code_pointer < destination);
        }
    }
}

