/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JMenuBar;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import org.colos.ejs.library.control.ControlElement;
import org.colos.ejs.library.control.EjsControl;
import org.colos.ejs.library.control.swing.ControlSwingElement;
import org.colos.ejs.library.control.swing.ControlWindow;
import org.colos.ejs.library.control.value.BooleanValue;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.display.TeXParser;

public class ControlDialog
extends ControlWindow {
    private static final int DIALOG_ADDED = 4;
    protected JDialog dialog;
    private static List<String> infoList = null;

    @Override
    protected Component createVisual() {
        return this.createDialog(null);
    }

    @Override
    public String getObjectClassname() {
        return "javax.swing.JDialog";
    }

    @Override
    public Object getObject() {
        return this.dialog;
    }

    @Override
    protected JRootPane getRootPane() {
        return this.dialog.getRootPane();
    }

    @Override
    public JMenuBar getJMenuBar() {
        return this.dialog.getJMenuBar();
    }

    @Override
    public void replaceVisual(Frame _owner) {
        this.dialog.dispose();
        this.myVisual = this.createDialog(_owner);
        this.adjustBorder();
        this.dialog.repaint();
    }

    private Component createDialog(Frame _owner) {
        this.startingup = true;
        this.dialog = new JDialog(_owner, "", false, EjsControl.getDefaultGraphicsConfiguration());
        this.dialog.getContentPane().setLayout(new BorderLayout());
        this.dialog.getContentPane().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent _e) {
                if (_e.isControlDown() && ControlDialog.this.getSimulation() != null) {
                    if (_e.getKeyCode() == 77) {
                        ControlDialog.this.getPopupMenu(0, 0);
                    } else if (_e.getKeyCode() == 80) {
                        ControlDialog.this.printScreen();
                    }
                }
            }
        });
        this.dialog.getContentPane().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent _evt) {
                if (ControlDialog.this.getSimulation() != null && OSPRuntime.isPopupTrigger(_evt)) {
                    ControlDialog.this.getPopupMenu(_evt.getX(), _evt.getY());
                }
            }
        });
        this.internalValue = new BooleanValue(true);
        this.setListeners();
        if (this.menubar != null) {
            this.dialog.setJMenuBar(this.menubar);
        }
        return this.dialog.getContentPane();
    }

    @Override
    protected int getVisibleIndex() {
        return 14;
    }

    @Override
    protected int getLocationIndex() {
        return 5;
    }

    @Override
    protected int getSizeIndex() {
        return 15;
    }

    @Override
    public Component getComponent() {
        return this.dialog;
    }

    @Override
    public Container getContainer() {
        return this.dialog.getContentPane();
    }

    @Override
    public void add(final ControlElement _child) {
        if (!(_child.getVisual() instanceof JMenuBar)) {
            super.add(_child);
            return;
        }
        this.children.add(_child);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ControlDialog.this.menubar = (JMenuBar)_child.getVisual();
                ControlDialog.this.dialog.setJMenuBar(ControlDialog.this.menubar);
                ControlDialog.this.adjustSize();
            }
        });
        ((ControlSwingElement)_child).setControlWindow(this);
        this.propagateProperty(_child, "font", this.getPropagatedProperty("font"));
        this.propagateProperty(_child, "foreground", this.getPropagatedProperty("foreground"));
        this.propagateProperty(_child, "background", this.getPropagatedProperty("background"));
    }

    @Override
    public void remove(ControlElement _child) {
        if (!(_child.getVisual() instanceof JMenuBar)) {
            super.remove(_child);
            return;
        }
        this.children.remove(_child);
        ((ControlSwingElement)_child).setControlWindow(null);
        this.menubar = null;
        this.dialog.setJMenuBar(null);
        this.adjustSize();
        this.dialog.validate();
        this.dialog.repaint();
    }

    @Override
    public List<String> getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList<String>();
            infoList.add("title");
            infoList.add("resizable");
            infoList.add("closable");
            infoList.add("modal");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    @Override
    public String getPropertyInfo(String _property) {
        if (_property.equals("title")) {
            return "String TRANSLATABLE";
        }
        if (_property.equals("resizable")) {
            return "boolean";
        }
        if (_property.equals("closable")) {
            return "boolean";
        }
        if (_property.equals("modal")) {
            return "boolean";
        }
        return super.getPropertyInfo(_property);
    }

    @Override
    public void setValue(int _index, Value _value) {
        switch (_index) {
            case 0: {
                String ejsWindow = this.getProperty("_ejs_window_");
                if (ejsWindow != null) {
                    this.dialog.setTitle(String.valueOf(TeXParser.parseTeX(_value.getString())) + " " + ejsWindow);
                    break;
                }
                this.dialog.setTitle(TeXParser.parseTeX(_value.getString()));
                break;
            }
            case 1: {
                this.dialog.setResizable(_value.getBoolean());
                break;
            }
            case 2: {
                if (_value.getBoolean()) {
                    this.dialog.setDefaultCloseOperation(1);
                    break;
                }
                this.dialog.setDefaultCloseOperation(0);
                break;
            }
            case 3: {
                if (this.isUnderEjs) break;
                this.dialog.setModal(_value.getBoolean());
                break;
            }
            default: {
                super.setValue(_index - 4, _value);
            }
        }
    }

    @Override
    public void setDefaultValue(int _index) {
        switch (_index) {
            case 0: {
                String ejsWindow = this.getProperty("_ejs_window_");
                if (ejsWindow != null) {
                    this.dialog.setTitle(ejsWindow);
                    break;
                }
                this.dialog.setTitle("");
                break;
            }
            case 1: {
                this.dialog.setResizable(true);
                break;
            }
            case 2: {
                this.dialog.setDefaultCloseOperation(1);
                break;
            }
            case 3: {
                this.dialog.setModal(false);
                break;
            }
            default: {
                super.setDefaultValue(_index - 4);
            }
        }
    }

    @Override
    public String getDefaultValueString(int _index) {
        switch (_index) {
            case 0: {
                return "<none>";
            }
            case 1: {
                return "true";
            }
            case 2: {
                return "true";
            }
            case 3: {
                return "false";
            }
        }
        return super.getDefaultValueString(_index - 4);
    }

    @Override
    public Value getValue(int _index) {
        switch (_index) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return null;
            }
        }
        return super.getValue(_index - 4);
    }
}

