/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.drawables;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.control.drawables.ControlDrawable2D;
import org.colos.ejs.library.control.drawables.Plot2DWrapper;
import org.colos.ejs.library.control.swing.ControlDrawablesParent;
import org.colos.ejs.library.control.swing.ControlParentOfDrawables;
import org.colos.ejs.library.control.swing.NeedsPreUpdate;
import org.colos.ejs.library.control.value.IntegerValue;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display2d.ColorMapper;
import org.opensourcephysics.display2d.ContourPlot;
import org.opensourcephysics.display2d.GridPlot;
import org.opensourcephysics.display2d.GridPointData;
import org.opensourcephysics.display2d.GridTableFrame;
import org.opensourcephysics.display2d.InterpolatedPlot;
import org.opensourcephysics.display2d.Plot2D;
import org.opensourcephysics.display2d.SurfacePlot;
import org.opensourcephysics.display2d.SurfacePlotMouseController;
import org.opensourcephysics.display2d.TestData;

public class ControlScalarField
extends ControlDrawable2D
implements NeedsPreUpdate {
    private static final int SCALAR_FIELD_ADDED = 19;
    protected static final int X_MINIMUM = 0;
    protected static final int X_MAXIMUM = 1;
    protected static final int Y_MINIMUM = 2;
    protected static final int Y_MAXIMUM = 3;
    protected static final int DATA = 4;
    private Plot2D plot;
    private Plot2DWrapper wrapper;
    private JFrame legendFrame;
    private GridPointData pointdata;
    private boolean auto;
    private int levels;
    private int colormode;
    protected double minX;
    protected double maxX;
    protected double minY;
    protected double maxY;
    private double minZ;
    private double maxZ;
    private Color floorColor;
    private Color ceilingColor;
    protected int plotType;
    protected double minAbcise;
    protected double maxAbcise;
    protected double minOrdinate;
    protected double maxOrdinate;
    protected boolean mustUpdate;
    protected boolean typeChanged;
    protected boolean showGridLines;
    protected boolean visibility;
    private boolean showLegend;
    private boolean showLegendChanged;
    protected double[][] dataArray;
    protected Color[] palette;
    protected Color gridColor;
    protected double expandedFactor;
    private SurfacePlotMouseController controller;
    private static List<String> infoList = null;
    private GridTableFrame tableFrame = null;

    @Override
    protected Drawable createDrawable() {
        this.plotType = 0;
        return this.doCreateTheDrawable();
    }

    protected final Drawable doCreateTheDrawable() {
        this.maxY = Double.NaN;
        this.minY = Double.NaN;
        this.maxX = Double.NaN;
        this.minX = Double.NaN;
        this.dataArray = null;
        this.legendFrame = null;
        this.showLegend = false;
        this.showLegendChanged = false;
        this.auto = true;
        this.minZ = -1.0;
        this.maxZ = 1.0;
        this.colormode = 0;
        this.levels = 16;
        this.palette = new Color[0];
        this.floorColor = Color.darkGray;
        this.ceilingColor = Color.lightGray;
        this.showGridLines = true;
        this.gridColor = Color.lightGray;
        this.expandedFactor = 0.0;
        this.visibility = true;
        this.expandedFactor = 0.0;
        this.pointdata = new GridPointData(30, 30, 1);
        this.pointdata.setCellScale(-1.0, 1.0, -1.0, 1.0);
        this.wrapper = new Plot2DWrapper();
        this.mustUpdate = true;
        this.typeChanged = true;
        this.checkPlotType();
        return this.wrapper;
    }

    @Override
    public void setParent(ControlParentOfDrawables _dp) {
        if (this.myParent != null && this.controller != null) {
            this.myParent.getDrawingPanel().removeMouseListener(this.controller);
            this.myParent.getDrawingPanel().removeMouseMotionListener(this.controller);
            this.controller = null;
        }
        if (_dp != null && _dp instanceof ControlDrawablesParent && this.plot instanceof SurfacePlot) {
            DrawingPanel panel = ((ControlDrawablesParent)_dp).getDrawingPanel();
            this.controller = new SurfacePlotMouseController(panel, this.plot);
            panel.addMouseListener(this.controller);
            panel.addMouseMotionListener(this.controller);
        }
        super.setParent(_dp);
        if (Double.isNaN(this.minX) || Double.isNaN(this.maxX) || Double.isNaN(this.minY) || Double.isNaN(this.maxY)) {
            this.mustUpdate = true;
            this.preupdate();
        }
    }

    @Override
    public List<String> getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList<String>();
            infoList.add("minimumX");
            infoList.add("maximumX");
            infoList.add("minimumY");
            infoList.add("maximumY");
            infoList.add("z");
            infoList.add("autoscaleZ");
            infoList.add("minimumZ");
            infoList.add("maximumZ");
            infoList.add("levels");
            infoList.add("colormode");
            infoList.add("floorcolor");
            infoList.add("ceilingcolor");
            infoList.add("showgrid");
            infoList.add("gridcolor");
            infoList.add("visible");
            infoList.add("plotType");
            infoList.add("showLegend");
            infoList.add("expandedZ");
            infoList.add("symmetricZ");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    @Override
    public String getPropertyInfo(String _property) {
        if (_property.equals("minimumX")) {
            return "int|double ";
        }
        if (_property.equals("maximumX")) {
            return "int|double ";
        }
        if (_property.equals("minimumY")) {
            return "int|double ";
        }
        if (_property.equals("maximumY")) {
            return "int|double ";
        }
        if (_property.equals("z")) {
            return "double[][]";
        }
        if (_property.equals("autoscaleZ")) {
            return "boolean";
        }
        if (_property.equals("minimumZ")) {
            return "int|double";
        }
        if (_property.equals("maximumZ")) {
            return "int|double";
        }
        if (_property.equals("levels")) {
            return "int";
        }
        if (_property.equals("colormode")) {
            return "ColorMode|int|Object[]";
        }
        if (_property.equals("floorcolor")) {
            return "Color|Object";
        }
        if (_property.equals("ceilingcolor")) {
            return "Color|Object";
        }
        if (_property.equals("showgrid")) {
            return "boolean";
        }
        if (_property.equals("gridcolor")) {
            return "Color|Object";
        }
        if (_property.equals("visible")) {
            return "boolean";
        }
        if (_property.equals("plotType")) {
            return "Plot2DType|int";
        }
        if (_property.equals("showLegend")) {
            return "boolean";
        }
        if (_property.equals("expandedZ")) {
            return "int|double ";
        }
        if (_property.equals("symmetricZ")) {
            return "boolean";
        }
        return super.getPropertyInfo(_property);
    }

    @Override
    public Value parseConstant(String _propertyType, String _value) {
        if (_value == null) {
            return null;
        }
        if (_propertyType.indexOf("Plot2DType") >= 0) {
            if ((_value = _value.trim().toLowerCase()).equals("grid")) {
                return new IntegerValue(0);
            }
            if (_value.equals("interpolated")) {
                return new IntegerValue(1);
            }
            if (_value.equals("contour")) {
                return new IntegerValue(2);
            }
            if (_value.equals("surface")) {
                return new IntegerValue(3);
            }
        }
        return super.parseConstant(_propertyType, _value);
    }

    @Override
    public void setValue(int _index, Value _value) {
        switch (_index) {
            case 0: {
                if (this.minX == _value.getDouble()) break;
                this.minX = _value.getDouble();
                this.mustUpdate = true;
                break;
            }
            case 1: {
                if (this.maxX == _value.getDouble()) break;
                this.maxX = _value.getDouble();
                this.mustUpdate = true;
                break;
            }
            case 2: {
                if (this.minY == _value.getDouble()) break;
                this.minY = _value.getDouble();
                this.mustUpdate = true;
                break;
            }
            case 3: {
                if (this.maxY == _value.getDouble()) break;
                this.maxY = _value.getDouble();
                this.mustUpdate = true;
                break;
            }
            case 4: {
                if (!(_value.getObject() instanceof double[][])) break;
                this.dataArray = (double[][])_value.getObject();
                double min = Double.POSITIVE_INFINITY;
                double max = Double.NEGATIVE_INFINITY;
                int i = 0;
                while (i < this.dataArray.length) {
                    int j = 0;
                    while (j < this.dataArray[0].length) {
                        min = Math.min(min, this.dataArray[i][j]);
                        max = Math.max(max, this.dataArray[i][j]);
                        ++j;
                    }
                    ++i;
                }
                this.mustUpdate = true;
                break;
            }
            case 5: {
                if (this.auto == _value.getBoolean()) break;
                this.auto = _value.getBoolean();
                this.plot.setAutoscaleZ(this.auto, this.minZ, this.maxZ);
                break;
            }
            case 6: {
                if (this.minZ == _value.getDouble()) break;
                this.minZ = _value.getDouble();
                this.plot.setAutoscaleZ(this.auto, this.minZ, this.maxZ);
                break;
            }
            case 7: {
                if (this.maxZ == _value.getDouble()) break;
                this.maxZ = _value.getDouble();
                this.plot.setAutoscaleZ(this.auto, this.minZ, this.maxZ);
                break;
            }
            case 8: {
                if (this.plot instanceof ContourPlot) {
                    if (this.levels == _value.getInteger()) break;
                    this.levels = _value.getInteger();
                    ((ContourPlot)this.plot).setNumberOfLevels(this.levels);
                    if (this.colormode < 0) break;
                    this.plot.setColorPalette(ColorMapper.getColorPalette(this.levels, this.colormode));
                    this.plot.setFloorCeilColor(this.floorColor, this.ceilingColor);
                    break;
                }
                if (_value.getInteger() == this.levels || this.colormode < 0) break;
                this.levels = _value.getInteger();
                this.plot.setColorPalette(ColorMapper.getColorPalette(this.levels, this.colormode));
                this.plot.setFloorCeilColor(this.floorColor, this.ceilingColor);
                break;
            }
            case 9: {
                if (_value.getObject() instanceof Object[]) {
                    this.colormode = -1;
                    Object[] newPalette = (Object[])_value.getObject();
                    if (newPalette.length != this.palette.length) {
                        this.palette = new Color[newPalette.length];
                    }
                    boolean differentPalette = false;
                    int i = 0;
                    int n = this.palette.length;
                    while (i < n) {
                        if (this.palette[i] != (Color)newPalette[i]) {
                            this.palette[i] = (Color)newPalette[i];
                            differentPalette = true;
                        }
                        ++i;
                    }
                    if (!differentPalette) break;
                    this.plot.setColorPalette(this.palette);
                    this.plot.setFloorCeilColor(this.floorColor, this.ceilingColor);
                    break;
                }
                if (this.colormode == _value.getInteger()) break;
                this.colormode = _value.getInteger();
                this.plot.setPaletteType(this.colormode);
                this.plot.setFloorCeilColor(this.floorColor, this.ceilingColor);
                break;
            }
            case 10: {
                if (!(_value.getObject() instanceof Color) || this.floorColor == (Color)_value.getObject()) break;
                this.floorColor = (Color)_value.getObject();
                this.plot.setFloorCeilColor(this.floorColor, this.ceilingColor);
                break;
            }
            case 11: {
                if (!(_value.getObject() instanceof Color) || this.ceilingColor == (Color)_value.getObject()) break;
                this.ceilingColor = (Color)_value.getObject();
                this.plot.setFloorCeilColor(this.floorColor, this.ceilingColor);
                break;
            }
            case 12: {
                this.showGridLines = _value.getBoolean();
                this.plot.setShowGridLines(this.showGridLines);
                break;
            }
            case 13: {
                if (!(_value.getObject() instanceof Color)) break;
                this.gridColor = (Color)_value.getObject();
                this.plot.setGridLineColor(this.gridColor);
                break;
            }
            case 14: {
                this.visibility = _value.getBoolean();
                this.plot.setVisible(this.visibility);
                break;
            }
            case 15: {
                if (_value.getInteger() == this.plotType) break;
                this.plotType = _value.getInteger();
                this.typeChanged = true;
                break;
            }
            case 16: {
                if (this.showLegend == _value.getBoolean()) break;
                this.showLegend = _value.getBoolean();
                this.showLegendChanged = true;
                break;
            }
            case 17: {
                if (_value.getDouble() == this.expandedFactor) break;
                this.expandedFactor = _value.getDouble();
                this.plot.setExpandedZ(true, this.expandedFactor);
                break;
            }
            case 18: {
                this.plot.setSymmetricZ(_value.getBoolean());
                break;
            }
            default: {
                super.setValue(_index - 19, _value);
            }
        }
        if (this.isUnderEjs) {
            this.plot.update();
        }
    }

    @Override
    public void setDefaultValue(int _index) {
        switch (_index) {
            case 0: {
                this.minX = Double.NaN;
                this.mustUpdate = true;
                break;
            }
            case 1: {
                this.maxX = Double.NaN;
                this.mustUpdate = true;
                break;
            }
            case 2: {
                this.minY = Double.NaN;
                this.mustUpdate = true;
                break;
            }
            case 3: {
                this.maxY = Double.NaN;
                this.mustUpdate = true;
                break;
            }
            case 4: {
                this.pointdata = new GridPointData(30, 30, 1);
                this.plot.setGridData(this.pointdata);
                this.dataArray = null;
                this.mustUpdate = true;
                break;
            }
            case 5: {
                this.auto = true;
                this.plot.setAutoscaleZ(true, this.minZ, this.maxZ);
                break;
            }
            case 6: {
                this.minZ = -1.0;
                this.plot.setAutoscaleZ(this.auto, -1.0, this.maxZ);
                break;
            }
            case 7: {
                this.maxZ = 1.0;
                this.plot.setAutoscaleZ(this.auto, this.minZ, 1.0);
                break;
            }
            case 8: {
                this.levels = 16;
                if (this.plot instanceof ContourPlot) {
                    ((ContourPlot)this.plot).setNumberOfLevels(this.levels);
                    break;
                }
                if (this.colormode < 0) break;
                this.plot.setColorPalette(ColorMapper.getColorPalette(this.levels, this.colormode));
                this.plot.setFloorCeilColor(this.floorColor, this.ceilingColor);
                break;
            }
            case 9: {
                this.colormode = 0;
                this.plot.setPaletteType(0);
                this.plot.setFloorCeilColor(this.floorColor, this.ceilingColor);
                break;
            }
            case 10: {
                this.floorColor = Color.darkGray;
                this.plot.setFloorCeilColor(this.floorColor, this.ceilingColor);
                break;
            }
            case 11: {
                this.ceilingColor = Color.lightGray;
                this.plot.setFloorCeilColor(this.floorColor, this.ceilingColor);
                break;
            }
            case 12: {
                this.showGridLines = true;
                this.plot.setShowGridLines(true);
                break;
            }
            case 13: {
                this.gridColor = Color.lightGray;
                this.plot.setGridLineColor(this.gridColor);
                break;
            }
            case 14: {
                this.visibility = true;
                this.plot.setVisible(true);
                break;
            }
            case 15: {
                this.plotType = 0;
                this.typeChanged = true;
                break;
            }
            case 16: {
                this.showLegend = false;
                this.showLegendChanged = true;
                break;
            }
            case 17: {
                this.expandedFactor = 0.0;
                this.plot.setExpandedZ(true, 0.0);
                break;
            }
            case 18: {
                this.plot.setSymmetricZ(false);
                break;
            }
            default: {
                super.setDefaultValue(_index - 19);
            }
        }
        if (this.isUnderEjs) {
            this.preupdate();
        }
    }

    @Override
    public String getDefaultValueString(int _index) {
        switch (_index) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return "<none>";
            }
            case 4: {
                return "<none>";
            }
            case 5: {
                return "true";
            }
            case 6: {
                return "-1.0";
            }
            case 7: {
                return "1.0";
            }
            case 8: {
                return "16";
            }
            case 9: {
                return "SPECTRUM";
            }
            case 10: {
                return "DARKGRAY";
            }
            case 11: {
                return "LIGHTGRAY";
            }
            case 12: {
                return "true";
            }
            case 13: {
                return "LIGHTGRAY";
            }
            case 14: {
                return "true";
            }
            case 15: {
                return "GRID_PLOT";
            }
            case 16: {
                return "false";
            }
            case 17: {
                return "0";
            }
            case 18: {
                return "false";
            }
        }
        return super.getDefaultValueString(_index - 19);
    }

    @Override
    public Value getValue(int _index) {
        switch (_index) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                return null;
            }
        }
        return super.getValue(_index - 19);
    }

    @Override
    public void destroy() {
        if (this.legendFrame != null) {
            this.legendFrame.setVisible(false);
        }
        super.destroy();
    }

    @Override
    public void preupdate() {
        if (!this.visibility) {
            return;
        }
        if (this.myParent == null) {
            return;
        }
        this.computeMinMax();
        this.commonPreupdate();
    }

    protected final void computeMinMax() {
        this.minAbcise = this.minX;
        this.maxAbcise = this.maxX;
        this.minOrdinate = this.minY;
        this.maxOrdinate = this.maxY;
        if (this.myParent != null) {
            DrawingPanel panel = this.myParent.getDrawingPanel();
            if (Double.isNaN(this.minAbcise)) {
                this.minAbcise = panel.getPreferredXMin();
            }
            if (Double.isNaN(this.maxAbcise)) {
                this.maxAbcise = panel.getPreferredXMax();
            }
            if (Double.isNaN(this.minOrdinate)) {
                this.minOrdinate = panel.getPreferredYMin();
            }
            if (Double.isNaN(this.maxOrdinate)) {
                this.maxOrdinate = panel.getPreferredYMax();
            }
        }
    }

    private void checkPlotType() {
        if (this.typeChanged) {
            switch (this.plotType) {
                case 1: {
                    this.plot = new InterpolatedPlot(this.pointdata);
                    break;
                }
                case 2: {
                    this.plot = new ContourPlot(this.pointdata);
                    ((ContourPlot)this.plot).setNumberOfLevels(this.levels);
                    break;
                }
                case 3: {
                    this.plot = new SurfacePlot(this.pointdata);
                    if (this.myParent == null) break;
                    DrawingPanel panel = this.myParent.getDrawingPanel();
                    if (this.controller != null) {
                        panel.removeMouseListener(this.controller);
                        panel.removeMouseMotionListener(this.controller);
                    }
                    this.controller = new SurfacePlotMouseController(this.myParent.getDrawingPanel(), this.plot);
                    panel.addMouseListener(this.controller);
                    panel.addMouseMotionListener(this.controller);
                    break;
                }
                default: {
                    this.plot = new GridPlot(this.pointdata);
                }
            }
            this.plot.setAutoscaleZ(this.auto, this.minZ, this.maxZ);
            if (this.palette.length > 0) {
                this.plot.setColorPalette(this.palette);
            } else {
                this.plot.setColorPalette(ColorMapper.getColorPalette(this.levels, this.colormode));
            }
            this.plot.setFloorCeilColor(this.floorColor, this.ceilingColor);
            this.plot.setShowGridLines(this.showGridLines);
            this.plot.setGridLineColor(this.gridColor);
            this.plot.setExpandedZ(true, this.expandedFactor);
            this.plot.setVisible(this.visibility);
            this.wrapper.setPlot2D(this.plot);
            this.showLegendChanged = true;
            if (this.legendFrame != null) {
                this.legendFrame.setVisible(false);
            }
            this.legendFrame = null;
            this.typeChanged = false;
            this.mustUpdate = true;
            if (this.myParent != null) {
                this.myParent.getDrawingPanel().invalidateImage();
            }
        }
    }

    protected void commonPreupdate() {
        this.checkPlotType();
        if (this.mustUpdate) {
            if (this.dataArray == null) {
                if (this.pointdata.getLeft() != this.minAbcise || this.pointdata.getRight() != this.maxAbcise || this.pointdata.getBottom() != this.maxOrdinate || this.pointdata.getTop() != this.minOrdinate) {
                    if (this.plot instanceof GridPlot) {
                        this.pointdata.setCellScale(this.minAbcise, this.maxAbcise, this.maxOrdinate, this.minOrdinate);
                    } else {
                        this.pointdata.setScale(this.minAbcise, this.maxAbcise, this.maxOrdinate, this.minOrdinate);
                    }
                }
                double[][][] data = this.pointdata.getData();
                int i = 0;
                int mx = data.length;
                while (i < mx) {
                    int j = 0;
                    int my = data[0].length;
                    while (j < my) {
                        data[i][j][2] = TestData.gaussian(data[i][j][0], data[i][j][1], 0.1);
                        ++j;
                    }
                    ++i;
                }
            } else {
                int nx = this.dataArray.length;
                int ny = this.dataArray[0].length;
                if (this.pointdata.getNx() != nx || this.pointdata.getNy() != ny) {
                    this.pointdata = new GridPointData(nx, ny, 1);
                    if (this.plot instanceof GridPlot) {
                        this.pointdata.setCellScale(this.minAbcise, this.maxAbcise, this.maxOrdinate, this.minOrdinate);
                    } else {
                        this.pointdata.setScale(this.minAbcise, this.maxAbcise, this.maxOrdinate, this.minOrdinate);
                    }
                    double[][][] data = this.pointdata.getData();
                    int i = 0;
                    while (i < nx) {
                        int j = 0;
                        while (j < ny) {
                            data[i][j][2] = this.dataArray[i][j];
                            ++j;
                        }
                        ++i;
                    }
                    this.plot.setGridData(this.pointdata);
                } else {
                    if (this.pointdata.getLeft() != this.minAbcise || this.pointdata.getRight() != this.maxAbcise || this.pointdata.getBottom() != this.maxOrdinate || this.pointdata.getTop() != this.minOrdinate) {
                        if (this.plot instanceof GridPlot) {
                            this.pointdata.setCellScale(this.minAbcise, this.maxAbcise, this.maxOrdinate, this.minOrdinate);
                        } else {
                            this.pointdata.setScale(this.minAbcise, this.maxAbcise, this.maxOrdinate, this.minOrdinate);
                        }
                    }
                    double[][][] data = this.pointdata.getData();
                    int i = 0;
                    while (i < nx) {
                        int j = 0;
                        while (j < ny) {
                            data[i][j][2] = this.dataArray[i][j];
                            ++j;
                        }
                        ++i;
                    }
                }
            }
            this.mustUpdate = false;
        }
        if (this.showLegendChanged) {
            if (this.showLegend) {
                if (this.legendFrame == null) {
                    this.legendFrame = this.plot.showLegend();
                }
                this.legendFrame.setVisible(true);
            } else if (this.legendFrame != null) {
                this.legendFrame.setVisible(false);
            }
            this.showLegendChanged = false;
        }
        this.plot.update();
    }

    @Override
    public void addMenuEntries() {
        if (this.getMenuNameEntry() == null) {
            return;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(new AbstractAction(Simulation.getEjsString("InteractiveTrace.ShowDataTable")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ControlScalarField.this.showDataTable(true);
            }
        });
        this.getSimulation().addElementMenuEntries(this.getMenuNameEntry(), list);
    }

    public synchronized void showDataTable(boolean show) {
        if (show) {
            if (this.tableFrame == null || !this.tableFrame.isDisplayable()) {
                if (this.plot.getGridData() == null) {
                    return;
                }
                this.tableFrame = new GridTableFrame(this.plot.getGridData());
                this.tableFrame.setTitle(String.valueOf(this.getProperty("name")) + " Data");
                this.tableFrame.setDefaultCloseOperation(2);
            }
            this.tableFrame.refreshTable();
            this.tableFrame.setVisible(true);
        } else {
            this.tableFrame.setVisible(false);
            this.tableFrame.dispose();
            this.tableFrame = null;
        }
    }
}

