var _isEPub = false;
var _isApp = false;

var __base64Images = [];
__base64Images["./Mirror3D/Screen Shot 2018-02-13 at 5.17.13 PM.png"]="data:image/png;base64,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";
