var _isEPub = false;
var _isApp = false;

var __base64Images = [];
__base64Images["./Transversewave/2015-07-23_1102s.png"]="data:image/png;base64,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";
__base64Images["./Transversewave/Screenshot 2019-01-02 at 10.17.39 AM (2).png"]="data:image/png;base64,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";
