/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.applet.AudioClip;
import java.awt.Component;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.tools.JarTool;
import org.opensourcephysics.tools.Resource;
import org.opensourcephysics.tools.ToolsRes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceLoader {
    public static final FileFilter OSP_CACHE_FILTER;
    protected static final String WIN_XP_DEFAULT_CACHE = "/Local Settings/Application Data/OSP/Cache";
    protected static final String WINDOWS_DEFAULT_CACHE = "/AppData/Local/OSP/Cache";
    protected static final String OSX_DEFAULT_CACHE = "/Library/Caches/OSP";
    protected static final String LINUX_DEFAULT_CACHE = "/Downloads/OSP/Cache";
    protected static final String SEARCH_CACHE_SUBDIRECTORY = "Search";
    protected static ArrayList<String> searchPaths;
    protected static ArrayList<String> appletSearchPaths;
    protected static int maxPaths;
    protected static Hashtable<String, Resource> resources;
    protected static boolean cacheEnabled;
    protected static boolean canceled;
    protected static Map<String, URLClassLoader> zipLoaders;
    protected static URLClassLoader xsetZipLoader;
    protected static Set<String> extractExtensions;
    protected static ArrayList<String> pathsNotFound;
    protected static File ospCache;
    protected static boolean zipURLsOK;

    static {
        searchPaths = new ArrayList();
        appletSearchPaths = new ArrayList();
        maxPaths = 20;
        resources = new Hashtable();
        cacheEnabled = false;
        canceled = false;
        zipLoaders = new TreeMap<String, URLClassLoader>();
        extractExtensions = new TreeSet<String>();
        pathsNotFound = new ArrayList();
        OSP_CACHE_FILTER = new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory() && file.getName().startsWith("osp-");
            }
        };
    }

    private ResourceLoader() {
    }

    public static Resource getResource(String string) {
        return ResourceLoader.getResource(string, true);
    }

    public static Resource getResourceZipURLsOK(String string) {
        zipURLsOK = true;
        Resource resource = ResourceLoader.getResource(string, true);
        zipURLsOK = false;
        return resource;
    }

    public static Resource getResource(String string, boolean bl) {
        try {
            URL uRL = ResourceLoader.getAppletResourceURL(string);
            if (uRL != null) {
                return new Resource(uRL);
            }
        }
        catch (Exception exception) {}
        return ResourceLoader.getResource(string, Resource.class, bl);
    }

    public static Resource getResource(String string, Class<?> clazz) {
        return ResourceLoader.getResource(string, clazz, true);
    }

    public static Resource getResource(String string, Class<?> clazz, boolean bl) {
        Object object;
        Resource resource;
        if (string == null || string.equals("")) {
            return null;
        }
        pathsNotFound.clear();
        if (string.startsWith("\"")) {
            string = string.substring(1);
        }
        if (string.endsWith("\"")) {
            string = string.substring(0, string.length() - 1);
        }
        if (string.startsWith("./")) {
            string = string.substring(2);
        }
        if (OSPRuntime.isAppletMode() || OSPRuntime.applet != null) {
            resource = null;
            if (clazz == OSPRuntime.applet.getClass()) {
                try {
                    object = clazz.getResource(string);
                    resource = ResourceLoader.createResource((URL)object);
                    if (resource != null) {
                        return resource;
                    }
                }
                catch (Exception exception) {}
            }
            object = searchPaths.iterator();
            while (object.hasNext()) {
                String string2 = ResourceLoader.getPath((String)object.next(), string);
                resource = ResourceLoader.findResourceInClass(string2, clazz, bl);
                if (resource == null) continue;
                return resource;
            }
            resource = ResourceLoader.findResourceInClass(string, clazz, bl);
            if (resource != null) {
                return resource;
            }
        }
        if ((resource = ResourceLoader.findResource(string, clazz, bl)) != null) {
            return resource;
        }
        pathsNotFound.add(string);
        object = new StringBuffer("Not found: " + string);
        ((StringBuffer)object).append(" [searched " + string);
        for (String string2 : searchPaths) {
            String string3 = ResourceLoader.getPath(string2, string);
            if (pathsNotFound.contains(string3)) continue;
            resource = ResourceLoader.findResource(string3, clazz, bl);
            if (resource != null) {
                return resource;
            }
            pathsNotFound.add(string3);
            ((StringBuffer)object).append(";" + string3);
        }
        ((StringBuffer)object).append("]");
        OSPLog.fine(((StringBuffer)object).toString());
        return null;
    }

    public static Resource getResource(String string, String string2) {
        return ResourceLoader.getResource(string, string2, Resource.class);
    }

    public static Resource getResource(String string, String string2, boolean bl) {
        return ResourceLoader.getResource(string, string2, Resource.class, bl);
    }

    public static Resource getResource(String string, String string2, Class<Resource> clazz) {
        return ResourceLoader.getResource(string, string2, clazz, true);
    }

    public static Resource getResource(String string, String string2, Class<Resource> clazz, boolean bl) {
        Object object;
        if (string == null) {
            return ResourceLoader.getResource(string2, clazz);
        }
        if (string2.startsWith("./")) {
            string2 = string2.substring(2);
        }
        pathsNotFound.clear();
        String string3 = ResourceLoader.getPath(string, string2);
        Resource resource = ResourceLoader.findResource(string3, clazz, bl);
        if (resource != null) {
            return resource;
        }
        if (string.startsWith("/") || string.indexOf(":/") > -1) {
            return null;
        }
        pathsNotFound.add(string3);
        StringBuffer stringBuffer = new StringBuffer("Not found: " + string3);
        stringBuffer.append(" [searched " + string3);
        if (OSPRuntime.applet != null) {
            String string4;
            object = OSPRuntime.applet.getDocumentBase().toExternalForm();
            string3 = ResourceLoader.getPath(ResourceLoader.getPath((String)(object = String.valueOf(XML.getDirectoryPath((String)object)) + "/"), string), string2);
            if (!pathsNotFound.contains(string3)) {
                resource = ResourceLoader.findResource(string3, clazz, bl);
                if (resource != null) {
                    return resource;
                }
                pathsNotFound.add(string3);
                stringBuffer.append(";" + string3);
            }
            if (!(string4 = OSPRuntime.applet.getCodeBase().toExternalForm()).equals(object) && !pathsNotFound.contains(string3 = ResourceLoader.getPath(ResourceLoader.getPath(string4, string), string2))) {
                resource = ResourceLoader.findResource(string3, clazz, bl);
                if (resource != null) {
                    return resource;
                }
                pathsNotFound.add(string3);
                stringBuffer.append(";" + string3);
            }
        }
        object = searchPaths.iterator();
        while (object.hasNext()) {
            string3 = ResourceLoader.getPath(ResourceLoader.getPath((String)object.next(), string), string2);
            if (pathsNotFound.contains(string3)) continue;
            resource = ResourceLoader.findResource(string3, clazz, bl);
            if (resource != null) {
                return resource;
            }
            pathsNotFound.add(string3);
            stringBuffer.append(";" + string3);
        }
        stringBuffer.append("]");
        OSPLog.fine(stringBuffer.toString());
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addSearchPath(String string) {
        if (string == null || string.equals("") || maxPaths < 1) {
            return;
        }
        ArrayList<String> arrayList = searchPaths;
        synchronized (arrayList) {
            if (searchPaths.contains(string)) {
                searchPaths.remove(string);
            } else {
                OSPLog.fine("Added path: " + string);
            }
            searchPaths.add(0, string);
            while (searchPaths.size() > Math.max(maxPaths, 0)) {
                string = searchPaths.get(searchPaths.size() - 1);
                OSPLog.fine("Removed path: " + string);
                searchPaths.remove(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeSearchPath(String string) {
        if (string == null || string.equals("")) {
            return;
        }
        ArrayList<String> arrayList = searchPaths;
        synchronized (arrayList) {
            if (searchPaths.contains(string)) {
                OSPLog.fine("Removed path: " + string);
                searchPaths.remove(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addAppletSearchPath(String string) {
        if (string == null || maxPaths < 1) {
            return;
        }
        if (!(string = string.trim()).endsWith("/")) {
            string = String.valueOf(string) + "/";
        }
        ArrayList<String> arrayList = appletSearchPaths;
        synchronized (arrayList) {
            if (appletSearchPaths.contains(string)) {
                appletSearchPaths.remove(string);
            } else {
                OSPLog.fine("Applet search path added: " + string);
            }
            appletSearchPaths.add(0, string);
            while (appletSearchPaths.size() > Math.max(maxPaths, 0)) {
                string = appletSearchPaths.get(appletSearchPaths.size() - 1);
                OSPLog.fine("Removed path: " + string);
                appletSearchPaths.remove(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeAppletSearchPath(String string) {
        if (string == null || string.equals("")) {
            return;
        }
        ArrayList<String> arrayList = appletSearchPaths;
        synchronized (arrayList) {
            if (appletSearchPaths.contains(string)) {
                OSPLog.fine("Applet search path removed: " + string);
                appletSearchPaths.remove(string);
            }
        }
    }

    public static void setCacheEnabled(boolean bl) {
        cacheEnabled = bl;
    }

    public static boolean isCacheEnabled() {
        return cacheEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addExtractExtension(String string) {
        if (string == null || string.equals("")) {
            return;
        }
        if (!string.startsWith(".")) {
            string = "." + string;
        }
        OSPLog.finest("Added extension: " + string);
        Set<String> set = extractExtensions;
        synchronized (set) {
            extractExtensions.add(string);
        }
    }

    public static void setCanceled(boolean bl) {
        canceled = bl;
    }

    public static boolean isCanceled() {
        return canceled;
    }

    public static InputStream openInputStream(String string) {
        Resource resource = ResourceLoader.getResource(string);
        return resource == null ? null : resource.openInputStream();
    }

    public static Reader openReader(String string) {
        Resource resource = ResourceLoader.getResource(string);
        return resource == null ? null : resource.openReader();
    }

    public static String getString(String string) {
        Resource resource = ResourceLoader.getResource(string);
        return resource == null ? null : resource.getString();
    }

    public static ImageIcon getIcon(String string) {
        URL uRL = ResourceLoader.getAppletResourceURL(string);
        if (uRL != null) {
            return new ImageIcon(uRL);
        }
        Resource resource = ResourceLoader.getResource(string);
        return resource == null ? null : resource.getIcon();
    }

    public static Image getImage(String string) {
        URL uRL = ResourceLoader.getAppletResourceURL(string);
        if (uRL != null) {
            return new ImageIcon(uRL).getImage();
        }
        Resource resource = ResourceLoader.getResource(string);
        return resource == null ? null : resource.getImage();
    }

    public static BufferedImage getBufferedImage(String string) {
        Resource resource = ResourceLoader.getResource(string);
        return resource == null ? null : resource.getBufferedImage();
    }

    public static BufferedImage getBufferedImage(String string, int n) {
        Resource resource = ResourceLoader.getResource(string);
        return resource == null ? null : resource.getBufferedImage(n);
    }

    public static AudioClip getAudioClip(String string) {
        Resource resource = ResourceLoader.getResource(string);
        return resource == null ? null : resource.getAudioClip();
    }

    public static void setOSPCache(File file) {
        if (file != null && !file.equals(ospCache)) {
            if (ospCache != null && file.getAbsolutePath().contains(ospCache.getAbsolutePath())) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            if (!(file.exists() && file.isDirectory() || file.mkdirs())) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            if (!file.canWrite()) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            if (ospCache != null) {
                File file2;
                File[] fileArray;
                File[] fileArray2 = fileArray = ospCache.listFiles(OSP_CACHE_FILTER);
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    file2 = fileArray2[n2];
                    String string = file2.getName();
                    File file3 = new File(file, string);
                    ResourceLoader.copyAllFiles(file2, file3);
                    ++n2;
                }
                file2 = new File(ospCache, SEARCH_CACHE_SUBDIRECTORY);
                File file4 = new File(file, SEARCH_CACHE_SUBDIRECTORY);
                ResourceLoader.copyAllFiles(file2, file4);
                ResourceLoader.clearOSPCache(ospCache, true);
                File[] fileArray3 = ospCache.listFiles();
                if (fileArray3 != null && fileArray3.length == 0) {
                    ospCache.delete();
                }
            }
            ospCache = file;
        }
    }

    public static File getOSPCache() {
        return ospCache;
    }

    public static File getDefaultOSPCache() {
        String string = System.getProperty("java.io.tmpdir");
        String string2 = System.getProperty("user.home");
        if (string2 != null) {
            string2 = String.valueOf(string2) + "/";
            if (OSPRuntime.isMac()) {
                string = String.valueOf(string2) + OSX_DEFAULT_CACHE;
            } else if (OSPRuntime.isLinux()) {
                string = String.valueOf(string2) + LINUX_DEFAULT_CACHE;
            } else if (OSPRuntime.isWindows()) {
                String string3 = System.getProperty("os.name", "").toLowerCase();
                string = string3.indexOf("xp") > -1 ? String.valueOf(string2) + WIN_XP_DEFAULT_CACHE : String.valueOf(string2) + WINDOWS_DEFAULT_CACHE;
            }
        }
        if (string == null) {
            return null;
        }
        return new File(string);
    }

    public static File chooseOSPCache(Component component) {
        JFileChooser jFileChooser = new JFileChooser(ResourceLoader.getOSPCache());
        if (OSPRuntime.isMac()) {
            jFileChooser.setFileSelectionMode(2);
        } else {
            jFileChooser.setFileSelectionMode(1);
        }
        javax.swing.filechooser.FileFilter fileFilter = new javax.swing.filechooser.FileFilter(){

            public boolean accept(File file) {
                if (file == null) {
                    return false;
                }
                return file.isDirectory();
            }

            public String getDescription() {
                return ToolsRes.getString("LibraryTreePanel.FolderFileFilter.Description");
            }
        };
        jFileChooser.setAcceptAllFileFilterUsed(false);
        jFileChooser.addChoosableFileFilter(fileFilter);
        String string = ToolsRes.getString("ResourceLoader.FileChooser.Cache");
        jFileChooser.setDialogTitle(string);
        int n = jFileChooser.showDialog(component, string);
        if (n == 0) {
            return jFileChooser.getSelectedFile();
        }
        return null;
    }

    public static boolean isOSPCachePath(String string) {
        File file = ResourceLoader.getOSPCache();
        if (file == null) {
            file = new File(System.getProperty("java.io.tmpdir"));
        }
        String string2 = String.valueOf(XML.forwardSlash(file.getAbsolutePath())) + "/osp-";
        return XML.forwardSlash(string).contains(string2);
    }

    public static File getOSPCacheFile(String string) {
        return ResourceLoader.getOSPCacheFile(string, null);
    }

    public static File getOSPCacheFile(String string, String string2) {
        File file = ResourceLoader.getOSPCache();
        if (file == null) {
            file = new File(System.getProperty("java.io.tmpdir"));
        }
        return ResourceLoader.getCacheFile(file, string, string2);
    }

    public static File getSearchCache() {
        File file = ResourceLoader.getOSPCache();
        if (file == null) {
            file = ResourceLoader.getDefaultOSPCache();
        }
        if (file == null) {
            return null;
        }
        File file2 = new File(file, SEARCH_CACHE_SUBDIRECTORY);
        file2.mkdirs();
        return file2;
    }

    public static File getSearchCacheFile(String string) {
        String string2 = XML.getName(string);
        String string3 = XML.stripExtension(string2);
        String string4 = XML.getExtension(string2);
        if (string4 != null) {
            string3 = String.valueOf(string3) + "_" + string4;
        }
        string3 = string3.replace('&', '_').replace('?', '_').replace('=', '_');
        string2 = String.valueOf(string3) + ".xml";
        return ResourceLoader.getCacheFile(ResourceLoader.getSearchCache(), string, string2);
    }

    private static File getCacheFile(File file, String string, String string2) {
        String string3 = XML.forwardSlash(file.getAbsolutePath());
        string = ResourceLoader.getURIPath(string);
        String string4 = "";
        String string5 = "";
        String string6 = "";
        try {
            URL uRL = new URL(string);
            string4 = uRL.getHost().replace('.', '_');
            string5 = ResourceLoader.getNonURIPath(uRL.getPath());
            int n = string5.indexOf(string3);
            if (n > -1) {
                string5 = string5.substring(n + string3.length());
            }
            if ((n = string5.lastIndexOf(":")) > -1) {
                string5 = string5.substring(n + 1);
            }
            while (string5.startsWith("/")) {
                string5 = string5.substring(1);
            }
            String string7 = XML.getName(string5);
            if (!"".equals(string7)) {
                string5 = XML.getDirectoryPath(string5);
            }
            string5 = string5.replace('.', '_').replace("!", "");
            string6 = string2 == null ? string7 : string2;
        }
        catch (MalformedURLException malformedURLException) {}
        if ("".equals(string4)) {
            string4 = "local_machine";
        }
        if (!string5.startsWith("osp-")) {
            file = new File(file, "osp-" + string4);
        }
        if (!"".equals(string5)) {
            file = new File(file, string5);
        }
        if (!"".equals(string6)) {
            file = new File(file, string6);
        }
        return file;
    }

    public static File downloadToOSPCache(String string, String string2, boolean bl) {
        if (string2 == null) {
            return null;
        }
        File file = ResourceLoader.getOSPCacheFile(string, string2);
        File file2 = ResourceLoader.download(string, file, bl);
        if (file2 == null) {
            JOptionPane.showMessageDialog(null, String.valueOf(ToolsRes.getString("ResourceLoader.Dialog.FailedToDownload.Message1")) + "\n" + ToolsRes.getString("ResourceLoader.Dialog.FailedToDownload.Message2") + "\n" + ToolsRes.getString("ResourceLoader.Dialog.FailedToDownload.Message3"), ToolsRes.getString("ResourceLoader.Dialog.FailedToDownload.Title"), 0);
        }
        return file2;
    }

    public static String getHTMLCode(String string) {
        Resource resource = ResourceLoader.getResourceZipURLsOK(string);
        if (resource == null) {
            return null;
        }
        String string2 = resource.getString();
        if (string2 != null && string2.trim().startsWith("<!DOCTYPE html")) {
            return string2;
        }
        return null;
    }

    public static String getTitleFromHTMLCode(String string) {
        if (string == null) {
            return null;
        }
        String[] stringArray = string.split("<title>");
        if (stringArray.length > 1 && (stringArray = stringArray[1].split("</title>")).length > 1) {
            return stringArray[0].trim();
        }
        return null;
    }

    public static String getStyleSheetFromHTMLCode(String string) {
        if (string == null) {
            return null;
        }
        String[] stringArray = string.split("<head>");
        if (stringArray.length > 1 && (stringArray = stringArray[1].split("</head>")).length > 1 && (stringArray = stringArray[0].split("<link")).length > 1) {
            int n = 1;
            while (n < stringArray.length) {
                if (stringArray[n].contains("\"stylesheet\"") && (stringArray = stringArray[n].split("href")).length > 1 && (stringArray = stringArray[1].split("\"")).length > 1) {
                    return stringArray[1];
                }
                ++n;
            }
        }
        return null;
    }

    public static File copyHTMLToOSPCache(String string) {
        if (string == null) {
            return null;
        }
        String string2 = null;
        Resource resource = ResourceLoader.getResourceZipURLsOK(string);
        if (resource != null) {
            if (resource.getFile() != null && ResourceLoader.isOSPCachePath(string)) {
                return resource.getFile();
            }
            string2 = resource.getString();
        }
        if (string2 != null) {
            Object object;
            String string3;
            Object object2;
            String string4 = XML.getDirectoryPath(string);
            File file = ResourceLoader.getOSPCacheFile(string);
            File file2 = file.getParentFile();
            file2.mkdirs();
            File file3 = new File(file2, "images");
            String string5 = "<img ";
            String string6 = "src=\"";
            String string7 = "\"";
            String string8 = string2;
            int n = string8.indexOf(string5);
            if (n > -1) {
                file3.mkdirs();
            }
            while (n > -1) {
                File file4;
                string8 = string8.substring(n + string5.length());
                n = string8.indexOf(string6);
                if ((n = (string8 = string8.substring(n + string6.length())).indexOf(string7)) > -1 && (resource = ResourceLoader.getResourceZipURLsOK((String)(object2 = XML.getResolvedPath(string3 = string8.substring(0, n), string4)))) != null && (file4 = ResourceLoader.download((String)object2, new File(file3, (String)(object = XML.getName(string3))), false)) != null && !string3.equals(object2 = XML.getPathRelativeTo(file4.getAbsolutePath(), file2.getAbsolutePath()))) {
                    string2 = string2.replace(String.valueOf(string6) + string3 + string7, String.valueOf(string6) + (String)object2 + string7);
                }
                n = string8.indexOf(string5);
            }
            string3 = ResourceLoader.getStyleSheetFromHTMLCode(string2);
            if (string3 != null && !string3.startsWith("http:") && (resource = ResourceLoader.getResourceZipURLsOK(XML.getResolvedPath(string3, string4))) != null) {
                object2 = XML.getName(string3);
                object = new File(file2, (String)object2);
                object = ResourceLoader.download(resource.getAbsolutePath(), (File)object, false);
                if (object != null && !((String)object2).equals(string3)) {
                    string2 = string2.replace(string3, (CharSequence)object2);
                }
            }
            try {
                object2 = new FileWriter(file);
                ((Writer)object2).write(string2);
                ((OutputStreamWriter)object2).close();
                return file;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static boolean copyAllFiles(File var0, File var1_1) {
        block8: {
            if (!var0.isDirectory()) break block8;
            var1_1.mkdir();
            var2_2 = true;
            var6_4 = var0.listFiles();
            var5_6 = var6_4.length;
            var4_8 = 0;
            if (true) ** GOTO lbl40
        }
        var2_3 = new byte[16384];
        try {
            var3_11 = new FileInputStream(var0);
            var4_9 = new FileOutputStream(var1_1);
            while (true) {
                var5_7 = var2_3;
                // MONITORENTER : var2_3
                var6_5 = var3_11.read(var2_3);
                if (var6_5 == -1) {
                    // MONITOREXIT : var5_7
                    break;
                }
                var4_9.write(var2_3, 0, var6_5);
                // MONITOREXIT : var5_7
            }
            var3_11.close();
            var4_9.close();
            return true;
        }
        catch (IOException v1) {
            return false;
        }
        do {
            var3_10 = var6_4[var4_8];
            var7_12 = var3_10.getName();
            var8_13 = new File(var1_1, var7_12);
            var2_2 = var2_2 != false && ResourceLoader.copyAllFiles(var3_10, var8_13) != false;
            ++var4_8;
lbl40:
            // 2 sources

        } while (var4_8 < var5_6);
        return var2_2;
    }

    public static boolean clearOSPCache(File file, boolean bl) {
        File file2;
        if (file == null || !file.canWrite()) {
            return false;
        }
        boolean bl2 = true;
        File[] fileArray = file.listFiles(OSP_CACHE_FILTER);
        if (fileArray == null) {
            return true;
        }
        File[] fileArray2 = fileArray;
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            file2 = fileArray2[n2];
            bl2 = bl2 && ResourceLoader.deleteFile(file2);
            ++n2;
        }
        if (bl) {
            file2 = new File(file, SEARCH_CACHE_SUBDIRECTORY);
            boolean bl3 = bl2 = bl2 && ResourceLoader.deleteFile(file2);
        }
        if (!bl2) {
            JOptionPane.showMessageDialog(null, String.valueOf(ToolsRes.getString("ResourceLoader.Dialog.UnableToClearCache.Message1")) + "\n" + ToolsRes.getString("ResourceLoader.Dialog.UnableToClearCache.Message2"), ToolsRes.getString("ResourceLoader.Dialog.UnableToClearCache.Title"), 2);
        }
        return bl2;
    }

    public static boolean clearOSPCacheHost(File file) {
        if (file == null || !file.canWrite()) {
            return true;
        }
        if (!OSP_CACHE_FILTER.accept(file)) {
            return false;
        }
        boolean bl = ResourceLoader.deleteFile(file);
        if (!bl) {
            JOptionPane.showMessageDialog(null, String.valueOf(ToolsRes.getString("ResourceLoader.Dialog.UnableToClearCache.Message1")) + "\n" + ToolsRes.getString("ResourceLoader.Dialog.UnableToClearCache.Message2"), ToolsRes.getString("ResourceLoader.Dialog.UnableToClearCache.Title"), 2);
        }
        return bl;
    }

    public static boolean deleteFile(File file) {
        if (file.isDirectory()) {
            File[] fileArray;
            File[] fileArray2 = fileArray = file.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file2 = fileArray2[n2];
                ResourceLoader.deleteFile(file2);
                ++n2;
            }
        }
        return file.delete();
    }

    public static List<File> getFiles(File file, FileFilter fileFilter) {
        File[] fileArray;
        ArrayList<File> arrayList = new ArrayList<File>();
        if (file.isFile()) {
            arrayList.add(file);
            return arrayList;
        }
        File[] fileArray2 = fileArray = file.listFiles(fileFilter);
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file2 = fileArray2[n2];
            if (file2.isDirectory()) {
                List<File> list = ResourceLoader.getFiles(file2, fileFilter);
                arrayList.addAll(list);
            } else {
                arrayList.add(file2);
            }
            ++n2;
        }
        return arrayList;
    }

    public static Set<String> getZipContents(String string) {
        TreeSet<String> treeSet = new TreeSet<String>();
        try {
            URL uRL = new URL(ResourceLoader.getURIPath(string));
            OSPLog.finest("zip url: " + uRL.toExternalForm());
            BufferedInputStream bufferedInputStream = new BufferedInputStream(uRL.openStream());
            ZipInputStream zipInputStream = new ZipInputStream(bufferedInputStream);
            ZipEntry zipEntry = null;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                OSPLog.finest("zip entry: " + zipEntry);
                if (zipEntry.isDirectory()) continue;
                String string2 = zipEntry.getName();
                treeSet.add(string2);
            }
            zipInputStream.close();
        }
        catch (Exception exception) {}
        return treeSet;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Set<File> unzip(String string, File file, boolean bl) {
        if (file == null) {
            file = new File(System.getProperty("java.io.tmpdir"));
        }
        OSPLog.finer("unzipping " + string + " to " + file);
        try {
            URL uRL = new URL(ResourceLoader.getURIPath(string));
            BufferedInputStream bufferedInputStream = new BufferedInputStream(uRL.openStream());
            ZipInputStream zipInputStream = new ZipInputStream(bufferedInputStream);
            ZipEntry zipEntry = null;
            HashSet<File> hashSet = new HashSet<File>();
            byte[] byArray = new byte[1024];
            ResourceLoader.setCanceled(false);
            block2: while (true) {
                if ((zipEntry = zipInputStream.getNextEntry()) == null) {
                    zipInputStream.close();
                    return hashSet;
                }
                if (zipEntry.isDirectory()) continue;
                if (ResourceLoader.isCanceled()) {
                    zipInputStream.close();
                    return null;
                }
                String string2 = zipEntry.getName();
                File file2 = new File(file, string2);
                if (!bl && file2.exists()) {
                    hashSet.add(file2);
                    continue;
                }
                file2.getParentFile().mkdirs();
                FileOutputStream fileOutputStream = new FileOutputStream(file2);
                while (true) {
                    int n;
                    if ((n = zipInputStream.read(byArray)) == -1) {
                        fileOutputStream.close();
                        zipInputStream.closeEntry();
                        hashSet.add(file2);
                        continue block2;
                    }
                    fileOutputStream.write(byArray, 0, n);
                }
                break;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static File download(String string, File file, boolean bl) {
        string = ResourceLoader.getURIPath(string);
        file.getParentFile().mkdirs();
        if (bl || !file.exists()) {
            OSPLog.finer("downloading " + string + " to " + file);
            try {
                Resource resource = ResourceLoader.getResourceZipURLsOK(string);
                InputStream inputStream = resource.openInputStream();
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                byte[] byArray = new byte[65536];
                int n = 0;
                while ((n = inputStream.read(byArray)) > 0) {
                    fileOutputStream.write(byArray, 0, n);
                }
                fileOutputStream.close();
                inputStream.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (file.exists()) {
            return file;
        }
        return null;
    }

    public static File extractFileFromZIP(String string, File file, boolean bl) {
        if (!bl && file.exists()) {
            return file;
        }
        String string2 = XML.forwardSlash(string).toLowerCase();
        int n = string2.indexOf(".zip!/");
        if (n == -1) {
            n = string2.indexOf(".jar!/");
        }
        if (n == -1) {
            n = string2.indexOf(".trz!/");
        }
        if (n == -1) {
            return null;
        }
        String string3 = string.substring(n + 6);
        string = string.substring(0, n + 4);
        try {
            URL uRL = new URL(string);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(uRL.openStream());
            ZipInputStream zipInputStream = new ZipInputStream(bufferedInputStream);
            ZipEntry zipEntry = null;
            byte[] byArray = new byte[1024];
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                int n2;
                String string4;
                if (zipEntry.isDirectory() || !string3.contains(string4 = zipEntry.getName())) continue;
                file.getParentFile().mkdirs();
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                while ((n2 = zipInputStream.read(byArray)) != -1) {
                    fileOutputStream.write(byArray, 0, n2);
                }
                fileOutputStream.close();
                zipInputStream.closeEntry();
            }
            zipInputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        return file;
    }

    public static boolean isURLAvailable(String string) {
        try {
            URL uRL = new URL(string);
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.getContent();
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public static String getNonURIPath(String string) {
        if (string == null) {
            return null;
        }
        String string2 = string;
        boolean bl = false;
        if (string2.startsWith("jar:")) {
            string2 = string2.substring(4);
            bl = true;
        }
        if (string2.startsWith("file:")) {
            string2 = string2.substring(5);
            bl = true;
        }
        if (bl) {
            while (string2.startsWith("//")) {
                string2 = string2.substring(1);
            }
        }
        if (string2.startsWith("/") && string2.indexOf(":") > -1) {
            string2 = string2.substring(1);
        }
        int n = string2.indexOf("%20");
        while (n > -1) {
            String string3 = string2.substring(0, n);
            string2 = String.valueOf(string3) + " " + string2.substring(n + 3);
            n = string2.indexOf("%20");
        }
        return string2;
    }

    public static String getURIPath(String string) {
        String string2;
        if (string == null) {
            return null;
        }
        if (!(string = XML.forwardSlash(string.trim())).equals("") && XML.getExtension(string) == null && !string.endsWith("/")) {
            string = String.valueOf(string) + "/";
        }
        int n = string.indexOf(" ");
        while (n > -1) {
            string2 = string.substring(0, n);
            string = String.valueOf(string2) + "%20" + string.substring(n + 1);
            n = string.indexOf(" ");
        }
        if (!(string.equals("") || string.startsWith("http:") || string.startsWith("jar:") || string.startsWith("file:/"))) {
            string2 = OSPRuntime.isWindows() ? "file:/" : "file://";
            string = String.valueOf(string2) + string;
        }
        return string;
    }

    private static URL getAppletResourceURL(String string) {
        if (OSPRuntime.applet == null || string == null || string.trim().equals("")) {
            return null;
        }
        if (string.startsWith("http:") || string.startsWith("https:")) {
            try {
                return new URL(string);
            }
            catch (MalformedURLException malformedURLException) {}
        }
        if (!(string = string.trim()).startsWith("/")) {
            for (String string2 : appletSearchPaths) {
                String string3 = string;
                if (string3.startsWith("../")) {
                    string3 = string3.substring(3);
                    int n = (string2 = string2.substring(0, string2.length() - 1)).lastIndexOf("/");
                    string2 = n > 0 ? string2.substring(0, n) : "/";
                } else if (string3.startsWith("./")) {
                    string3 = string3.substring(2);
                }
                URL uRL = OSPRuntime.applet.getClass().getResource(String.valueOf(string2) + string3);
                if (uRL == null) continue;
                return uRL;
            }
        }
        return OSPRuntime.applet.getClass().getResource(string);
    }

    private static Resource createFileResource(String string) {
        if (OSPRuntime.applet != null) {
            return null;
        }
        if (string.indexOf(".zip") > -1 || string.indexOf(".jar") > -1 || string.indexOf(".trz") > -1) {
            return null;
        }
        File file = new File(string);
        try {
            if (file.exists() && file.canRead()) {
                Resource resource = new Resource(file);
                if (string.endsWith("xset")) {
                    xsetZipLoader = null;
                }
                OSPLog.finer("File: " + XML.forwardSlash(resource.getAbsolutePath()));
                return resource;
            }
        }
        catch (Exception exception) {}
        return null;
    }

    private static Resource createURLResource(String string) {
        URL uRL;
        if (!(zipURLsOK || string.indexOf(".zip") <= -1 && string.indexOf(".jar") <= -1 && string.indexOf(".trz") <= -1)) {
            return null;
        }
        Resource resource = null;
        if (OSPRuntime.applet != null) {
            try {
                uRL = ResourceLoader.getAppletResourceURL(string);
                resource = ResourceLoader.createResource(uRL);
            }
            catch (Exception exception) {}
        }
        if (resource == null) {
            if (string.indexOf(":/") > -1) {
                try {
                    uRL = new URL(ResourceLoader.getURIPath(string));
                    resource = ResourceLoader.createResource(uRL);
                }
                catch (Exception exception) {}
            } else if (OSPRuntime.applet != null && !string.startsWith("/")) {
                URL uRL2;
                Object object;
                uRL = OSPRuntime.applet.getDocumentBase();
                try {
                    object = uRL.toString();
                    int n = ((String)object).indexOf("?");
                    if (n > -1) {
                        uRL = new URL(((String)object).substring(0, n));
                    }
                    uRL2 = new URL(uRL, string);
                    resource = ResourceLoader.createResource(uRL2);
                }
                catch (Exception exception) {}
                if (resource == null) {
                    object = OSPRuntime.applet.getCodeBase();
                    String string2 = String.valueOf(XML.getDirectoryPath(uRL.toExternalForm())) + "/";
                    if (!((URL)object).toExternalForm().equals(string2)) {
                        try {
                            uRL2 = new URL((URL)object, string);
                            resource = ResourceLoader.createResource(uRL2);
                        }
                        catch (Exception exception) {}
                    }
                }
            }
        }
        if (resource != null) {
            if (string.endsWith(".xset")) {
                xsetZipLoader = null;
            }
            OSPLog.finer("URL: " + XML.forwardSlash(resource.getAbsolutePath()));
        }
        return resource;
    }

    private static Resource createZipResource(String string) {
        URL[] uRLArray;
        Object object3;
        Serializable serializable;
        boolean bl;
        string = ResourceLoader.getNonURIPath(string);
        Object object4 = null;
        String string2 = string;
        int n = string.indexOf("zip!/");
        if (n == -1) {
            n = string.indexOf("jar!/");
        }
        if (n == -1) {
            n = string.indexOf("exe!/");
        }
        if (n == -1) {
            n = string.indexOf("trz!/");
        }
        if (n > -1) {
            object4 = string.substring(0, n + 3);
            string2 = string.substring(n + 5);
        }
        if (object4 == null) {
            if (string.endsWith(".zip") || string.endsWith(".trz") || string.endsWith(".jar") || string.endsWith(".exe")) {
                String string3 = XML.stripExtension(XML.getName(string));
                object4 = string;
                string2 = String.valueOf(string3) + ".xset";
            } else if (string.endsWith(".xset")) {
                object4 = String.valueOf(string.substring(0, string.length() - 4)) + "zip";
            }
        }
        boolean bl2 = object4 != null && (object4.endsWith(".zip") || object4.endsWith(".jar") || object4.endsWith(".trz"));
        boolean bl3 = bl = ospCache == null;
        if (bl2 && string.startsWith("http:") && (serializable = ResourceLoader.downloadToOSPCache((String)object4, (String)(object3 = XML.getName((String)object4)), false)) != null) {
            if (bl) {
                ((File)serializable).deleteOnExit();
            }
            object4 = ((File)serializable).getAbsolutePath();
            string = String.valueOf(object4) + "!/" + string2;
        }
        object3 = null;
        serializable = null;
        if (object4 != null) {
            object3 = zipLoaders.get(object4);
            if (object3 != null) {
                serializable = ((URLClassLoader)object3).findResource(string2);
            } else {
                try {
                    URL object22;
                    uRLArray = new URL[]{new URL("file", null, (String)object4)};
                    object3 = new URLClassLoader(uRLArray);
                    serializable = ((URLClassLoader)object3).findResource(string2);
                    if (serializable == null && (object22 = Resource.class.getResource("/" + (String)object4)) != null) {
                        uRLArray = new URL[]{object22};
                        object3 = new URLClassLoader(uRLArray);
                        serializable = ((URLClassLoader)object3).findResource(string2);
                    }
                    if (serializable != null) {
                        zipLoaders.put((String)object4, (URLClassLoader)object3);
                    }
                }
                catch (Exception exception) {}
            }
        }
        if (serializable == null && xsetZipLoader != null && (serializable = xsetZipLoader.findResource(string2)) != null) {
            for (Object e : zipLoaders.keySet()) {
                if (zipLoaders.get(e) != xsetZipLoader) continue;
                object4 = (String)e;
                break;
            }
        }
        uRLArray = OSPRuntime.getLaunchJarPath();
        if (serializable == null && uRLArray != null) {
            object3 = zipLoaders.get(uRLArray);
            if (object3 != null) {
                serializable = ((URLClassLoader)object3).findResource(string2);
            } else {
                try {
                    URL uRL;
                    URL[] uRLArray2 = new URL[]{new URL("file", null, (String)uRLArray)};
                    object3 = new URLClassLoader(uRLArray2);
                    serializable = ((URLClassLoader)object3).findResource(string2);
                    if (serializable == null && (uRL = Resource.class.getResource("/" + (String)uRLArray)) != null) {
                        URL[] uRLArray3 = new URL[]{uRL};
                        object3 = new URLClassLoader(uRLArray3);
                        serializable = ((URLClassLoader)object3).findResource(string2);
                    }
                    if (serializable != null) {
                        zipLoaders.put((String)uRLArray, (URLClassLoader)object3);
                    }
                }
                catch (Exception exception) {}
            }
            if (serializable != null) {
                object4 = uRLArray;
            }
        }
        if (serializable != null) {
            Resource resource;
            block36: {
                for (String string3 : extractExtensions) {
                    File file;
                    if (!((URL)serializable).getFile().endsWith(string3)) continue;
                    File file2 = new File((String)object4);
                    String string4 = string2;
                    String string5 = file2.getParent();
                    if (string5 != null && !string4.startsWith("/") && string2.indexOf(":/") == -1) {
                        string4 = XML.getResolvedPath(string2, string5);
                    }
                    if (!(file = new File(string4)).exists()) {
                        file = JarTool.extract(file2, string2, string4);
                        if (bl) {
                            file.deleteOnExit();
                        }
                    }
                    return ResourceLoader.createFileResource(file.getAbsolutePath());
                }
                try {
                    resource = ResourceLoader.createResource((URL)serializable);
                    if (resource != null && resource.getAbsolutePath().indexOf(string) != -1) break block36;
                    return null;
                }
                catch (IOException iOException) {}
            }
            if (string2.endsWith("xset")) {
                xsetZipLoader = object3;
            }
            OSPLog.finer("Zip: " + XML.forwardSlash(resource.getAbsolutePath()));
            return resource;
        }
        return null;
    }

    private static Resource createClassResource(String string, Class<?> clazz) {
        Object object;
        if (string.indexOf(":/") != -1) {
            return null;
        }
        String string2 = string;
        int n = string.indexOf("jar!/");
        if (n == -1) {
            n = string.indexOf("exe!/");
        }
        if (n != -1) {
            string = string.substring(n + 5);
        }
        Resource resource = null;
        try {
            object = clazz.getResource("/" + string);
            resource = ResourceLoader.createResource((URL)object);
        }
        catch (Exception exception) {}
        if (resource == null) {
            try {
                object = clazz.getResource(string);
                resource = ResourceLoader.createResource((URL)object);
            }
            catch (Exception exception) {}
        }
        if (resource != null) {
            object = XML.forwardSlash(resource.getAbsolutePath());
            if (((String)object).indexOf("/jre") > -1 && ((String)object).indexOf("/lib") > -1) {
                return null;
            }
            if (!ResourceLoader.getNonURIPath((String)object).contains(string2) && !((String)object).contains(string2)) {
                return null;
            }
            if (string.endsWith("xset")) {
                xsetZipLoader = null;
            }
            OSPLog.finer("Class resource: " + (String)object);
            OSPRuntime.setLaunchJarPath((String)object);
        }
        return resource;
    }

    private static Resource createResource(URL uRL) throws IOException {
        InputStream inputStream;
        if (uRL == null) {
            return null;
        }
        String string = uRL.toExternalForm();
        URL uRL2 = uRL;
        String string2 = null;
        int n = string.toLowerCase().indexOf(".zip!/");
        if (n == -1) {
            n = string.toLowerCase().indexOf(".jar!/");
        }
        if (n == -1) {
            n = string.toLowerCase().indexOf(".trz!/");
        }
        if (n > -1 && string.startsWith("http")) {
            string2 = string.substring(n + 6);
            uRL2 = new URL(string.substring(0, n + 4));
        }
        if ((inputStream = uRL2.openStream()).read() == -1) {
            inputStream.close();
            return null;
        }
        inputStream.close();
        Resource resource = new Resource(uRL2, string2);
        return resource;
    }

    private static Resource findResourceInClass(String string, Class<?> clazz, boolean bl) {
        string = string.replaceAll("/\\./", "/");
        if (clazz == null) {
            clazz = Resource.class;
        }
        Resource resource = null;
        if (cacheEnabled && (resource = resources.get(string)) != null && (bl || resource.getFile() == null)) {
            OSPLog.finest("Found in cache: " + string);
            return resource;
        }
        resource = ResourceLoader.createClassResource(string, clazz);
        if (resource != null) {
            if (cacheEnabled) {
                resources.put(string, resource);
            }
            return resource;
        }
        return null;
    }

    private static Resource findResource(String string, Class<?> clazz, boolean bl) {
        string = string.replaceAll("/\\./", "/");
        if (clazz == null) {
            clazz = Resource.class;
        }
        Resource resource = null;
        if (cacheEnabled && (resource = resources.get(string)) != null && (bl || resource.getFile() == null)) {
            OSPLog.finest("Found in cache: " + string);
            return resource;
        }
        if (bl && (resource = ResourceLoader.createFileResource(string)) != null || (resource = ResourceLoader.createURLResource(string)) != null || (resource = ResourceLoader.createZipResource(string)) != null || (resource = ResourceLoader.createClassResource(string, clazz)) != null) {
            if (cacheEnabled) {
                resources.put(string, resource);
            }
            return resource;
        }
        return null;
    }

    private static String getPath(String string, String string2) {
        if (string == null) {
            string = "";
        }
        if (string.endsWith(".jar") || string.endsWith(".zip") || string.endsWith(".trz")) {
            string = String.valueOf(string) + "!";
        }
        String string3 = XML.getResolvedPath(string2, string);
        if (OSPRuntime.isMac() && string3.startsWith("file:/") && !string3.startsWith("file:///")) {
            string3 = string3.substring(6);
            while (string3.startsWith("/")) {
                string3 = string3.substring(1);
            }
            string3 = "file:///" + string3;
        }
        return string3;
    }
}

