/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.xuggle;

import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.media.core.VideoFileFilter;
import org.opensourcephysics.media.core.VideoIO;
import org.opensourcephysics.media.xuggle.XuggleVideoType;

public class XuggleIO {
    public static void registerWithVideoIO() {
        String xugglehome = System.getenv("XUGGLE_HOME");
        if (xugglehome != null) {
            try {
                VideoIO.addVideoEngine(new XuggleVideoType());
                String[] stringArray = VideoIO.VIDEO_EXTENSIONS;
                int n = VideoIO.VIDEO_EXTENSIONS.length;
                int n2 = 0;
                while (n2 < n) {
                    String ext = stringArray[n2];
                    VideoFileFilter filter = new VideoFileFilter(ext, new String[]{ext});
                    XuggleVideoType xuggleType = new XuggleVideoType(filter);
                    if (ext.equals("mov") || ext.equals("mp4")) {
                        xuggleType.setRecordable(false);
                    }
                    VideoIO.addVideoType(xuggleType);
                    ++n2;
                }
                VideoFileFilter filter = new VideoFileFilter("flv", new String[]{"flv"});
                VideoIO.addVideoType(new XuggleVideoType(filter));
                filter = new VideoFileFilter("asf", new String[]{"wmv"});
                VideoIO.addVideoType(new XuggleVideoType(filter));
                filter = new VideoFileFilter("dv", new String[]{"dv"});
                XuggleVideoType vidType = new XuggleVideoType(filter);
                vidType.setRecordable(false);
                VideoIO.addVideoType(vidType);
                filter = new VideoFileFilter("mts", new String[]{"mts"});
                vidType = new XuggleVideoType(filter);
                vidType.setRecordable(false);
                VideoIO.addVideoType(vidType);
            }
            catch (Exception ex) {
                OSPLog.config("Xuggle exception: " + ex.toString());
            }
            catch (Error er) {
                OSPLog.config("Xuggle error: " + er.toString());
            }
        } else {
            OSPLog.config("Xuggle not installed? (XUGGLE_HOME not found)");
        }
    }
}

