/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing3d.simple3d;

import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.List;
import org.opensourcephysics.drawing3d.DrawingPanel3D;
import org.opensourcephysics.drawing3d.ElementTrail;
import org.opensourcephysics.drawing3d.simple3d.Object3D;
import org.opensourcephysics.drawing3d.simple3d.SimpleElement;

public class SimpleElementTrail
extends SimpleElement {
    private static final int DEFAULT_SIZE = 100;
    private int[] connected;
    private int[] aCoord;
    private int[] bCoord;
    private double[][] points;
    private double[] pixel = new double[3];
    private List<ElementTrail.TrailPoint> trailPointsList = new ArrayList<ElementTrail.TrailPoint>();

    public SimpleElementTrail(ElementTrail _element) {
        super(_element);
        List<ElementTrail.TrailPoint> displayPoints = ((ElementTrail)this.element).getDisplayPoints();
        this.allocateArrays(Math.max(100, displayPoints.size()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processChanges(int _change, int _cummulativeChange) {
        if ((_cummulativeChange & 8) != 0) {
            List<ElementTrail.TrailPoint> list = this.trailPointsList;
            synchronized (list) {
                List<ElementTrail.TrailPoint> displayPoints;
                this.trailPointsList.clear();
                List<ElementTrail.TrailPoint> list2 = displayPoints = ((ElementTrail)this.element).getDisplayPoints();
                synchronized (list2) {
                    this.trailPointsList.addAll(displayPoints);
                }
                int numPoints = this.trailPointsList.size();
                if (numPoints >= this.objects.length) {
                    this.allocateArrays(numPoints + 100);
                } else if (numPoints <= 0 && this.objects.length > 100) {
                    this.allocateArrays(100);
                }
                this.computePositions();
                this.projectPoints();
            }
        }
        if ((_cummulativeChange & 0x136) != 0) {
            this.computePositions();
            this.projectPoints();
        } else if ((_cummulativeChange & 0x40) != 0) {
            this.projectPoints();
        }
    }

    @Override
    public void draw(Graphics2D _g2, int _index) {
        _g2.setStroke(this.style.getLineStroke());
        _g2.setColor(this.element.getPanel().projectColor(this.style.getLineColor(), this.objects[_index].getDistance()));
        if (_index == 0 || this.connected[_index] == 0) {
            _g2.drawLine(this.aCoord[_index], this.bCoord[_index], this.aCoord[_index], this.bCoord[_index]);
        } else {
            _g2.drawLine(this.aCoord[_index], this.bCoord[_index], this.aCoord[_index - 1], this.bCoord[_index - 1]);
        }
    }

    @Override
    public void drawQuickly(Graphics2D _g2) {
        _g2.setStroke(this.style.getLineStroke());
        _g2.setColor(this.style.getLineColor());
        int numPoints = this.trailPointsList.size();
        if (numPoints == 0) {
            return;
        }
        int aPrev = this.aCoord[0];
        int bPrev = this.bCoord[0];
        _g2.drawLine(aPrev, bPrev, aPrev, bPrev);
        int i = 1;
        while (i < numPoints) {
            int aCurrent = this.aCoord[i];
            int bCurrent = this.bCoord[i];
            switch (this.connected[i]) {
                default: {
                    _g2.drawLine(aCurrent, bCurrent, aPrev, bPrev);
                    break;
                }
                case 0: {
                    _g2.drawLine(aCurrent, bCurrent, aCurrent, bCurrent);
                }
            }
            aPrev = aCurrent;
            bPrev = bCurrent;
            ++i;
        }
    }

    private void allocateArrays(int _length) {
        this.objects = new Object3D[_length];
        this.points = new double[_length][3];
        this.connected = new int[_length];
        this.aCoord = new int[_length];
        this.bCoord = new int[_length];
        int i = 0;
        while (i < _length) {
            this.objects[i] = new Object3D(this, i);
            ++i;
        }
    }

    private void computePositions() {
        int numPoints = this.trailPointsList.size();
        int i = 0;
        while (i < numPoints) {
            ElementTrail.TrailPoint trailPoint = this.trailPointsList.get(i);
            System.arraycopy(trailPoint.getPoint(), 0, this.points[i], 0, 3);
            this.element.sizeAndToSpaceFrame(this.points[i]);
            this.connected[i] = trailPoint.getType();
            ++i;
        }
    }

    private void projectPoints() {
        DrawingPanel3D panel = this.element.getPanel();
        int numPoints = this.trailPointsList.size();
        int i = 0;
        while (i < numPoints) {
            System.arraycopy(this.points[i], 0, this.pixel, 0, 3);
            panel.projectPosition(this.pixel);
            this.aCoord[i] = (int)this.pixel[0];
            this.bCoord[i] = (int)this.pixel[1];
            this.objects[i].setDistance(this.pixel[2] * this.style.getDepthFactor());
            ++i;
        }
        i = numPoints;
        while (i < this.objects.length) {
            this.objects[i].setDistance(Double.NaN);
            ++i;
        }
    }
}

