/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing3d.simple3d;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.opensourcephysics.drawing3d.DrawingPanel3D;
import org.opensourcephysics.drawing3d.Element;
import org.opensourcephysics.drawing3d.simple3d.MessagesPanel;
import org.opensourcephysics.drawing3d.simple3d.Object3D;
import org.opensourcephysics.drawing3d.simple3d.SimpleElement;
import org.opensourcephysics.drawing3d.utils.ImplementingObject;
import org.opensourcephysics.drawing3d.utils.ImplementingPanel;
import org.opensourcephysics.tools.ResourceLoader;
import org.opensourcephysics.tools.VideoTool;

public class SimpleDrawingPanel3D
extends JPanel
implements ImplementingPanel,
Printable,
ActionListener {
    private boolean fastRedraw = false;
    private ArrayList<Object3D> list3D = new ArrayList();
    private Object3D.Comparator3D comparator = new Object3D.Comparator3D();
    private boolean needResize = true;
    private boolean needsToRecompute = true;
    private volatile boolean dirtyImage = true;
    private volatile BufferedImage offscreenImage;
    private BufferedImage workingImage = this.offscreenImage = new BufferedImage(1, 1, 1);
    private Timer updateTimer = new Timer(100, this);
    private Rectangle viewRect = null;
    private Image backgroundImage = null;
    private DrawingPanel3D panel3D;
    private MessagesPanel messagesPanel;

    public SimpleDrawingPanel3D(DrawingPanel3D _panel) {
        this.panel3D = _panel;
        super.setBackground(this.panel3D.getVisualizationHints().getBackgroundColor());
        this.messagesPanel = new MessagesPanel();
        this.setLayout(new BorderLayout());
        this.add((Component)this.messagesPanel, "Center");
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                SimpleDrawingPanel3D.this.needResize = true;
                SimpleDrawingPanel3D.this.dirtyImage = true;
            }
        });
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public void forceRefresh() {
        this.needsToRecompute = true;
        this.dirtyImage = true;
    }

    @Override
    public void update() {
        this.dirtyImage = true;
        this.updatePanel();
    }

    @Override
    public void setFastRedraw(boolean fast) {
        this.fastRedraw = fast;
    }

    @Override
    public void cameraChanged(int howItChanged) {
    }

    @Override
    public void setMessage(String msg) {
        this.messagesPanel.setMessage(msg);
    }

    @Override
    public void setMessage(String msg, int location) {
        this.messagesPanel.setMessage(msg, location);
    }

    @Override
    public BufferedImage render(BufferedImage image) {
        Graphics g = image.getGraphics();
        this.paintEverything(g, image.getWidth(null), image.getHeight(null));
        Rectangle thisViewRect = this.viewRect;
        if (thisViewRect != null) {
            Rectangle r = new Rectangle(0, 0, image.getWidth(null), image.getHeight(null));
            this.messagesPanel.setBounds(r);
            this.messagesPanel.render(g);
            this.messagesPanel.setBounds(thisViewRect);
        } else {
            this.messagesPanel.render(g);
        }
        g.dispose();
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BufferedImage render() {
        BufferedImage thisWorkingImage;
        if (!this.isShowing() || this.isIconified()) {
            this.needsToRecompute = true;
            return null;
        }
        BufferedImage bufferedImage = thisWorkingImage = this.checkImageSize(this.workingImage);
        synchronized (bufferedImage) {
            if (this.needResize) {
                this.panel3D.computeConstants(thisWorkingImage.getWidth(), thisWorkingImage.getHeight());
                this.needResize = false;
            }
            this.render(thisWorkingImage);
            this.workingImage = this.offscreenImage;
            this.offscreenImage = thisWorkingImage;
            this.dirtyImage = false;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.paintImmediately(this.getVisibleRect());
        } else {
            Runnable doNow = new Runnable(){

                @Override
                public void run() {
                    SimpleDrawingPanel3D.this.paintImmediately(SimpleDrawingPanel3D.this.getVisibleRect());
                }
            };
            try {
                SwingUtilities.invokeAndWait(doNow);
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        VideoTool vidCap = this.panel3D.getVideoTool();
        if (vidCap != null && this.offscreenImage != null && vidCap.isRecording()) {
            vidCap.addFrame(this.offscreenImage);
        }
        return thisWorkingImage;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (this.dirtyImage || this.needsUpdate()) {
            this.render();
        }
    }

    @Override
    public void setIgnoreRepaint(boolean ignoreRepaint) {
        this.messagesPanel.setIgnoreRepaint(ignoreRepaint);
        super.setIgnoreRepaint(ignoreRepaint);
    }

    @Override
    public void paintComponent(Graphics g) {
        this.viewRect = null;
        Container c = this.getParent();
        while (c != null) {
            if (c instanceof JViewport) {
                this.viewRect = ((JViewport)c).getViewRect();
                this.messagesPanel.setBounds(this.viewRect);
                break;
            }
            c = c.getParent();
        }
        int xoff = (this.getWidth() - this.offscreenImage.getWidth()) / 2;
        int yoff = (this.getHeight() - this.offscreenImage.getHeight()) / 2;
        g.drawImage(this.offscreenImage, xoff, yoff, null);
        if (this.dirtyImage || this.needsUpdate()) {
            this.updatePanel();
        }
    }

    @Override
    public void invalidate() {
        this.needResize = true;
        super.invalidate();
    }

    private void updatePanel() {
        if (this.getIgnoreRepaint()) {
            return;
        }
        this.updateTimer.setRepeats(false);
        this.updateTimer.setCoalesce(true);
        this.updateTimer.start();
    }

    private final boolean needsUpdate() {
        for (Element el : this.panel3D.getElements()) {
            if (!el.hasChanged()) continue;
            return true;
        }
        return false;
    }

    private BufferedImage checkImageSize(BufferedImage image) {
        int width = this.getWidth();
        int height = this.getHeight();
        if (width <= 2 || height <= 2) {
            return new BufferedImage(1, 1, 1);
        }
        if (image == null || width != image.getWidth() || height != image.getHeight()) {
            return this.getGraphicsConfiguration().createCompatibleImage(width, height);
        }
        return image;
    }

    private boolean isIconified() {
        Container c = this.getTopLevelAncestor();
        if (c instanceof Frame) {
            return (((Frame)c).getExtendedState() & 1) == 1;
        }
        return false;
    }

    private synchronized void paintEverything(Graphics g, int width, int height) {
        if (this.needsToRecompute || width != this.getWidth() || height != this.getHeight()) {
            this.panel3D.computeConstants(width, height);
        }
        List<Element> tempList = this.panel3D.getElements();
        tempList.addAll(this.panel3D.getDecoration().getElementList());
        if (this.backgroundImage != null) {
            AffineTransform transform = new AffineTransform();
            transform.scale(1.0 * (double)width / (double)this.backgroundImage.getWidth(this), 1.0 * (double)height / (double)this.backgroundImage.getHeight(this));
            ((Graphics2D)g).drawImage(this.backgroundImage, transform, this);
        } else {
            g.setColor(this.panel3D.getVisualizationHints().getBackgroundColor());
            g.fillRect(0, 0, width, height);
        }
        this.paintDrawableList(g, tempList);
    }

    private void paintDrawableList(Graphics g, List<Element> tempList) {
        Graphics2D g2 = (Graphics2D)g;
        if (this.fastRedraw || !this.panel3D.getVisualizationHints().isRemoveHiddenLines()) {
            for (Element el : tempList) {
                if (!el.isVisible()) continue;
                el.processChanges(0);
                ((SimpleElement)el.getImplementingObject()).drawQuickly(g2);
            }
            return;
        }
        this.list3D.clear();
        for (Element el : tempList) {
            if (!el.isVisible()) continue;
            ImplementingObject io = el.getImplementingObject();
            if (!(io instanceof SimpleElement)) {
                return;
            }
            el.processChanges(0);
            Object3D[] objects = ((SimpleElement)io).getObjects3D();
            if (objects == null) continue;
            int i = 0;
            int n = objects.length;
            while (i < n) {
                if (!Double.isNaN(objects[i].getDistance())) {
                    this.list3D.add(objects[i]);
                }
                ++i;
            }
        }
        if (this.list3D.size() <= 0) {
            return;
        }
        Object3D[] objects = this.list3D.toArray(new Object3D[0]);
        Arrays.sort(objects, this.comparator);
        int i = 0;
        int n = objects.length;
        while (i < n) {
            Object3D obj = objects[i];
            obj.getSimpleElement().draw(g2, obj.getIndex());
            ++i;
        }
    }

    @Override
    public int print(Graphics g, PageFormat pageFormat, int pageIndex) throws PrinterException {
        if (pageIndex >= 1) {
            return 1;
        }
        if (g == null) {
            return 1;
        }
        Graphics2D g2 = (Graphics2D)g;
        double scalex = pageFormat.getImageableWidth() / (double)this.getWidth();
        double scaley = pageFormat.getImageableHeight() / (double)this.getHeight();
        double scale = Math.min(scalex, scaley);
        g2.translate((int)pageFormat.getImageableX(), (int)pageFormat.getImageableY());
        g2.scale(scale, scale);
        this.paintEverything(g2, this.getWidth(), this.getHeight());
        return 0;
    }

    @Override
    public void visualizationChanged(int _change) {
        switch (_change) {
            case 7: {
                this.backgroundImage = this.panel3D.getVisualizationHints().getBackgroundImageFilename() != null ? ResourceLoader.getBufferedImage(this.panel3D.getVisualizationHints().getBackgroundImageFilename()) : this.panel3D.getVisualizationHints().getBackgroundImage();
                this.updatePanel();
            }
        }
    }
}

