/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing3d.java3d;

import javax.vecmath.Vector3f;
import org.opensourcephysics.drawing3d.ElementBox;
import org.opensourcephysics.drawing3d.java3d.Java3dAbstractTile;

public class Java3dElementBox
extends Java3dAbstractTile {
    public Java3dElementBox(ElementBox _element) {
        super(_element);
    }

    @Override
    protected double[][][] createStandardTile(int _nx, int _ny, int _nz) {
        ElementBox box = (ElementBox)this.element;
        return ElementBox.createStandardBox(_nx, _ny, _nz, box.isClosedTop(), box.isClosedBottom(), box.getSizeZReduction());
    }

    @Override
    protected Vector3f[] createStandardNormals(double[][][] data, int _nx, int _ny, int _nz) {
        int j;
        ElementBox box = (ElementBox)this.element;
        boolean bottom = box.isClosedBottom();
        boolean top = box.isClosedTop();
        int nTotal = 2 * _nx * _nz + 2 * _ny * _nz;
        if (bottom) {
            nTotal += _nx * _ny;
        }
        if (top) {
            nTotal += _nx * _ny;
        }
        Vector3f[] normals = new Vector3f[nTotal];
        int tile = 0;
        int i = 0;
        while (i < _nx) {
            j = 0;
            while (j < _ny) {
                if (bottom) {
                    normals[tile++] = new Vector3f(0.0f, 0.0f, 1.0f);
                }
                if (top) {
                    normals[tile++] = new Vector3f(0.0f, 0.0f, 1.0f);
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < _nx) {
            int k = 0;
            while (k < _nz) {
                normals[tile++] = new Vector3f(0.0f, -1.0f, 0.0f);
                normals[tile++] = new Vector3f(0.0f, -1.0f, 0.0f);
                ++k;
            }
            ++i;
        }
        int k = 0;
        while (k < _nz) {
            j = 0;
            while (j < _ny) {
                normals[tile++] = new Vector3f(-1.0f, 0.0f, 0.0f);
                normals[tile++] = new Vector3f(-1.0f, 0.0f, 0.0f);
                ++j;
            }
            ++k;
        }
        return normals;
    }
}

