/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing3d.java3d;

import javax.media.j3d.BranchGroup;
import javax.media.j3d.Geometry;
import javax.media.j3d.Node;
import javax.media.j3d.QuadArray;
import javax.media.j3d.Shape3D;
import javax.vecmath.TexCoord2f;
import javax.vecmath.Vector3f;
import org.opensourcephysics.drawing3d.Element;
import org.opensourcephysics.drawing3d.java3d.Java3dElement;
import org.opensourcephysics.drawing3d.utils.Resolution;

public abstract class Java3dAbstractTile
extends Java3dElement {
    protected static final int RECOMPUTE_VERTEX = 24;
    private int numberOfTiles = -1;
    private double[][][] standardTile = null;
    private Vector3f[] standardNormals = null;
    private QuadArray qa;
    private Shape3D shape;
    protected BranchGroup bg;
    private TexCoord2f[] texCoord = new TexCoord2f[]{new TexCoord2f(0.0f, 0.0f), new TexCoord2f(0.0f, 1.0f), new TexCoord2f(1.0f, 1.0f), new TexCoord2f(1.0f, 0.0f)};

    public Java3dAbstractTile(Element _element) {
        super(_element);
        this.shape = new Shape3D();
        this.shape.setAppearance(this.getAppearance());
        this.shape.setCapability(13);
        this.bg = new BranchGroup();
        this.bg.setCapability(17);
        this.bg.setCapability(14);
        this.bg.setCapability(12);
        this.bg.setCapability(13);
        this.prepareVertex();
        this.bg.addChild((Node)this.shape);
        this.addNode((Node)this.bg);
    }

    protected abstract double[][][] createStandardTile(int var1, int var2, int var3);

    protected abstract Vector3f[] createStandardNormals(double[][][] var1, int var2, int var3, int var4);

    @Override
    public void processChanges(int _change, int _cummulativeChange) {
        super.processChanges(_change, _cummulativeChange);
        if ((_change & 0x18) != 0) {
            this.prepareVertex();
        }
    }

    @Override
    public boolean isPrimitive() {
        return true;
    }

    protected void prepareVertex() {
        int nx = 1;
        int ny = 1;
        int nz = 1;
        Resolution res = this.element.getStyle().getResolution();
        if (res != null) {
            switch (res.getType()) {
                case 0: {
                    nx = Math.max(res.getN1(), 1);
                    ny = Math.max(res.getN2(), 1);
                    nz = Math.max(res.getN3(), 1);
                    break;
                }
                case 1: {
                    nx = Math.max((int)Math.round(0.49 + Math.abs(this.element.getSizeX()) / res.getMaxLength()), 1);
                    ny = Math.max((int)Math.round(0.49 + Math.abs(this.element.getSizeY()) / res.getMaxLength()), 1);
                    nz = Math.max((int)Math.round(0.49 + Math.abs(this.element.getSizeZ()) / res.getMaxLength()), 1);
                }
            }
        }
        this.standardTile = this.createStandardTile(nx, ny, nz);
        if (this.standardTile == null) {
            return;
        }
        this.numberOfTiles = this.standardTile.length;
        if (this.numberOfTiles == 0) {
            return;
        }
        this.standardNormals = this.createStandardNormals(this.standardTile, nx, ny, nz);
        int sides = this.standardTile[0].length;
        this.qa = new QuadArray(this.numberOfTiles * sides * 2, 39);
        this.qa.setCapability(0);
        this.qa.setCapability(1);
        this.qa.setCapability(7);
        this.qa.setCapability(5);
        if (sides == 4) {
            int i = 0;
            int j = 0;
            while (j < this.numberOfTiles) {
                this.qa.setCoordinate(i, this.standardTile[j][0]);
                this.qa.setTextureCoordinate(0, i, this.texCoord[0]);
                this.qa.setNormal(i++, this.standardNormals[j]);
                this.qa.setCoordinate(i, this.standardTile[j][1]);
                this.qa.setTextureCoordinate(0, i, this.texCoord[1]);
                this.qa.setNormal(i++, this.standardNormals[j]);
                this.qa.setCoordinate(i, this.standardTile[j][2]);
                this.qa.setTextureCoordinate(0, i, this.texCoord[2]);
                this.qa.setNormal(i++, this.standardNormals[j]);
                this.qa.setCoordinate(i, this.standardTile[j][3]);
                this.qa.setTextureCoordinate(0, i, this.texCoord[3]);
                this.qa.setNormal(i++, this.standardNormals[j]);
                this.qa.setCoordinate(i, this.standardTile[j][3]);
                this.qa.setTextureCoordinate(0, i, this.texCoord[3]);
                this.qa.setNormal(i++, Java3dAbstractTile.opposite(this.standardNormals[j]));
                this.qa.setCoordinate(i, this.standardTile[j][2]);
                this.qa.setTextureCoordinate(0, i, this.texCoord[2]);
                this.qa.setNormal(i++, Java3dAbstractTile.opposite(this.standardNormals[j]));
                this.qa.setCoordinate(i, this.standardTile[j][1]);
                this.qa.setTextureCoordinate(0, i, this.texCoord[1]);
                this.qa.setNormal(i++, Java3dAbstractTile.opposite(this.standardNormals[j]));
                this.qa.setCoordinate(i, this.standardTile[j][0]);
                this.qa.setTextureCoordinate(0, i, this.texCoord[0]);
                this.qa.setNormal(i++, Java3dAbstractTile.opposite(this.standardNormals[j]));
                ++j;
            }
        } else {
            int i = 0;
            int j = 0;
            while (j < this.numberOfTiles) {
                int k = 0;
                while (k < sides) {
                    this.qa.setCoordinate(i, this.standardTile[j][k]);
                    this.qa.setTextureCoordinate(0, i, this.texCoord[k]);
                    this.qa.setNormal(i++, this.standardNormals[j]);
                    ++k;
                }
                k = sides - 1;
                while (k >= sides) {
                    this.qa.setCoordinate(i, this.standardTile[j][k]);
                    this.qa.setTextureCoordinate(0, i, this.texCoord[k]);
                    this.qa.setNormal(i++, Java3dAbstractTile.opposite(this.standardNormals[j]));
                    --k;
                }
                ++j;
            }
        }
        this.shape.setGeometry((Geometry)this.qa);
    }

    static Vector3f opposite(Vector3f data) {
        Vector3f r = new Vector3f();
        r.x = -data.x;
        r.y = -data.y;
        r.z = -data.z;
        return r;
    }
}

