/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing3d;

import org.opensourcephysics.drawing2d.utils.ColorCodedDrawer;
import org.opensourcephysics.drawing3d.Element;
import org.opensourcephysics.drawing3d.java3d.Java3dElementTessellation;
import org.opensourcephysics.drawing3d.simple3d.SimpleElementTessellation;
import org.opensourcephysics.drawing3d.utils.ImplementingObject;

public class ElementTessellation
extends Element {
    private double[][][] mTileData = new double[0][0][3];
    private double[][] mTileZ = new double[0][0];
    private boolean mAutoscaleZ = true;
    private ColorCodedDrawer mDrawer = new ColorCodedDrawer();

    @Override
    protected ImplementingObject createImplementingObject(int _implementation) {
        switch (_implementation) {
            default: {
                return new SimpleElementTessellation(this);
            }
            case 1: 
        }
        return new Java3dElementTessellation(this);
    }

    public void setTiles(double[][][] tiles) {
        this.mTileData = tiles;
        this.addChange(8);
    }

    public double[][][] getTiles() {
        return this.mTileData;
    }

    public void setValues(double[][] values) {
        this.mTileZ = values;
        if (this.mTileZ != null) {
            this.addChange(128);
        }
    }

    public double[][] getValues() {
        return this.mTileZ;
    }

    public void setAutoscaleZ(boolean isAutoscale, double floor, double ceil) {
        this.mAutoscaleZ = isAutoscale;
        if (!this.mAutoscaleZ) {
            this.mDrawer.setScale(floor, ceil);
        }
        this.addChange(128);
    }

    public boolean isAutoscaleZ() {
        return this.mAutoscaleZ;
    }

    public ColorCodedDrawer getDrawer() {
        return this.mDrawer;
    }

    public void checkScales() {
        if (this.mTileData == null) {
            return;
        }
        if (this.mAutoscaleZ && this.mTileZ != null) {
            double min = Double.MAX_VALUE;
            double max = Double.MIN_VALUE;
            int i = 0;
            int n = this.mTileZ.length;
            while (i < n) {
                double[] tile = this.mTileZ[i];
                int j = 0;
                int m = tile.length;
                while (j < m) {
                    double value = tile[j];
                    max = Math.max(max, value);
                    min = Math.min(min, value);
                    ++j;
                }
                ++i;
            }
            this.mDrawer.setAutoscale(min, max);
        }
    }

    @Override
    public void getExtrema(double[] min, double[] max) {
        if (this.mTileData == null) {
            super.getExtrema(min, max);
            return;
        }
        double minX = Double.POSITIVE_INFINITY;
        double maxX = Double.NEGATIVE_INFINITY;
        double minY = Double.POSITIVE_INFINITY;
        double maxY = Double.NEGATIVE_INFINITY;
        double minZ = Double.POSITIVE_INFINITY;
        double maxZ = Double.NEGATIVE_INFINITY;
        double[] aPoint = new double[3];
        int i = 0;
        int n = this.mTileData.length;
        while (i < n) {
            int j = 0;
            int sides = this.mTileData[i].length;
            while (j < sides) {
                System.arraycopy(this.mTileData[i][j], 0, aPoint, 0, 3);
                this.sizeAndToSpaceFrame(aPoint);
                minX = Math.min(minX, aPoint[0]);
                maxX = Math.max(maxX, aPoint[0]);
                minY = Math.min(minY, aPoint[1]);
                maxY = Math.max(maxY, aPoint[1]);
                minZ = Math.min(minZ, aPoint[2]);
                maxZ = Math.max(maxZ, aPoint[2]);
                ++j;
            }
            ++i;
        }
        min[0] = minX;
        max[0] = maxX;
        min[1] = minY;
        max[1] = maxY;
        min[2] = minZ;
        max[2] = maxZ;
    }
}

