/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing3d;

import java.awt.Color;
import org.opensourcephysics.display.DisplayColors;
import org.opensourcephysics.display.Mesh;
import org.opensourcephysics.drawing2d.utils.ColorCodedDrawer;
import org.opensourcephysics.drawing3d.Element;
import org.opensourcephysics.drawing3d.ElementArrow;
import org.opensourcephysics.drawing3d.ElementTessellation;
import org.opensourcephysics.drawing3d.Group;
import org.opensourcephysics.drawing3d.MultiTrail;
import org.opensourcephysics.drawing3d.Set;
import org.opensourcephysics.drawing3d.utils.Style;

public class ElementMesh
extends Group
implements Mesh {
    public static final int CHANGE_BOUNDARY = 136;
    private double[][] mPoints;
    private int[][] mCellsGeometry;
    private double[][] mValues;
    private double[][][] mCellValues;
    private int[][] mBoundaryData;
    private int[] mBoundaryLabels;
    private Color[] mBoundaryColors = null;
    private ElementTessellation mTessellation;
    private MultiTrail mTrail;
    private double[][][] mTiles = new double[0][0][0];
    private double[][] mTessellationValues = new double[0][0];
    private int mDimension = 1;
    private double mSize = 0.1;
    private Set mArrowSet;

    public ElementMesh() {
        this.mTessellation = new ElementTessellation();
        this.mTrail = new MultiTrail();
        this.mArrowSet = new Set();
        this.mArrowSet.setVisible(false);
        this.addElement(this.mTessellation);
        this.addElement(this.mTrail);
        this.addElement(this.mArrowSet);
    }

    public ElementTessellation getTessellation() {
        return this.mTessellation;
    }

    public MultiTrail getTrail() {
        return this.mTrail;
    }

    @Override
    public void setPoints(double[][] points) {
        this.mPoints = points;
        this.addChange(8);
    }

    @Override
    public void setCells(int[][] cells) {
        this.mCellsGeometry = cells;
        this.addChange(8);
    }

    @Override
    public void setFieldAtPoints(double[][] values) {
        this.mValues = values;
        this.mDimension = this.mValues == null ? 1 : this.mValues[0].length;
        this.mCellValues = null;
        this.mArrowSet.setVisible(this.mDimension > 1);
        this.addChange(8);
    }

    @Override
    public void setFieldAtCells(double[][][] values) {
        this.mCellValues = values;
        this.mValues = null;
        this.mArrowSet.setVisible(this.mDimension > 1);
        this.addChange(8);
    }

    public void setVectorLength(double length) {
        this.mSize = length;
    }

    @Override
    public void setBoundary(int[][] boundary) {
        this.mBoundaryData = boundary;
        this.addChange(8);
    }

    @Override
    public void setBoundaryLabels(int[] labels) {
        this.mBoundaryLabels = labels;
        this.addChange(128);
    }

    @Override
    public void setBoundaryColors(Color[] colors) {
        this.mBoundaryColors = colors;
        this.addChange(128);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processChanges(int _cummulativeChange) {
        int change = this.getChange();
        if (this.mPoints == null) {
            this.mTessellation.setTiles(null);
            this.mTrail.clear();
            super.processChanges(_cummulativeChange);
            return;
        }
        double[][] dArray = this.mPoints;
        synchronized (this.mPoints) {
            if ((change & 8) != 0) {
                this.buildSimpleTiles();
                this.buildBoundary();
            } else if ((change & 0x80) != 0) {
                this.buildBoundary();
            }
            super.processChanges(_cummulativeChange);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    private void buildSimpleTiles() {
        Style style;
        ElementArrow arrow;
        int i;
        this.mArrowSet.removeAllElements();
        if (this.mPoints == null || this.mCellsGeometry == null) {
            this.mTessellation.setTiles(null);
            return;
        }
        int nTiles = this.mCellsGeometry.length;
        if (this.mTiles.length != nTiles) {
            this.mTiles = new double[nTiles][0][];
        }
        int i2 = 0;
        while (i2 < nTiles) {
            int j;
            Object tile = this.mTiles[i2];
            int[] geometry = this.mCellsGeometry[i2];
            int nPoints = geometry.length;
            if (((double[][])tile).length != nPoints) {
                double[][] dArrayArray = new double[nPoints][];
                this.mTiles[i2] = dArrayArray;
                tile = dArrayArray;
            }
            if (this.mPoints[0].length >= 3) {
                j = 0;
                while (j < nPoints) {
                    tile[j] = this.mPoints[geometry[j]];
                    ++j;
                }
            } else {
                j = 0;
                while (j < nPoints) {
                    int pointIndex = geometry[j];
                    double[] point = this.mPoints[pointIndex];
                    tile[j] = new double[]{point[0], point[1], 0.0};
                    if (this.mCellValues != null) {
                        tile[j][2] = this.mDimension <= 1 ? this.mCellValues[i2][j][0] : ElementMesh.vectorNorm(this.mCellValues[i2][j]);
                    }
                    ++j;
                }
            }
            ++i2;
        }
        this.mTessellation.setTiles(this.mTiles);
        if (this.mValues == null && this.mCellValues == null) {
            this.mTessellation.setValues(null);
            return;
        }
        if (this.mTessellationValues.length != nTiles) {
            this.mTessellationValues = new double[nTiles][0];
        }
        ColorCodedDrawer colorDrawer = this.mTessellation.getDrawer();
        if (this.mValues != null) {
            i = 0;
            while (i < nTiles) {
                double[] values = this.mTessellationValues[i];
                int[] geometry = this.mCellsGeometry[i];
                int nPoints = geometry.length;
                if (values.length != nPoints) {
                    this.mTessellationValues[i] = new double[nPoints];
                    values = this.mTessellationValues[i];
                }
                int j = 0;
                while (j < nPoints) {
                    int pointIndex = geometry[j];
                    double d = values[j] = this.mDimension <= 1 ? this.mValues[pointIndex][0] : ElementMesh.vectorNorm(this.mValues[pointIndex]);
                    if (this.mDimension > 1) {
                        arrow = new ElementArrow();
                        arrow.setPosition(this.mPoints[pointIndex]);
                        ElementMesh.setSize(arrow, this.mSize, this.mValues[pointIndex]);
                        style = arrow.getStyle();
                        style.setLineColor(this.getStyle().getLineColor());
                        style.setLineWidth(this.getStyle().getLineWidth());
                        arrow.setDataObject(new Double(values[j]));
                        this.mArrowSet.addElement(arrow);
                    }
                    ++j;
                }
                ++i;
            }
        } else {
            i = 0;
            while (i < nTiles) {
                double[][] tile = this.mTiles[i];
                double[] values = this.mTessellationValues[i];
                double[][] cellValues = this.mCellValues[i];
                int nPoints = cellValues.length;
                if (values.length != nPoints) {
                    this.mTessellationValues[i] = new double[nPoints];
                    values = this.mTessellationValues[i];
                }
                int j = 0;
                while (j < nPoints) {
                    double d = values[j] = this.mDimension <= 1 ? cellValues[j][0] : ElementMesh.vectorNorm(cellValues[j]);
                    if (this.mDimension > 1) {
                        arrow = new ElementArrow();
                        arrow.setPosition(tile[j]);
                        ElementMesh.setSize(arrow, this.mSize, cellValues[j]);
                        style = arrow.getStyle();
                        style.setLineColor(this.getStyle().getLineColor());
                        style.setLineWidth(this.getStyle().getLineWidth());
                        arrow.setDataObject(new Double(values[j]));
                        this.mArrowSet.addElement(arrow);
                    }
                    ++j;
                }
                ++i;
            }
        }
        this.mTessellation.setValues(this.mTessellationValues);
        if (this.mDimension > 1) {
            this.mTessellation.checkScales();
            for (Element arrow2 : this.mArrowSet.getElements()) {
                double value = (Double)arrow2.getDataObject();
                arrow2.getStyle().setFillColor(colorDrawer.doubleToColor(value));
            }
        }
    }

    private static void setSize(Element element, double size, double[] vector) {
        double sx = vector[0];
        double sy = vector[1];
        double alpha = Math.atan2(sy, sx);
        if (vector.length >= 3) {
            double beta = Math.asin(vector[2] / ElementMesh.vectorNorm(vector));
            double cosBeta = Math.cos(beta);
            element.setSizeXYZ(size * Math.cos(alpha) * cosBeta, size * Math.sin(alpha) * cosBeta, size * Math.sin(beta));
        } else {
            element.setSizeXYZ(size * Math.cos(alpha), size * Math.sin(alpha), 0.0);
        }
    }

    private static double vectorNorm(double[] vector) {
        double norm = 0.0;
        int k = 0;
        while (k < vector.length) {
            norm += vector[k] * vector[k];
            ++k;
        }
        return Math.sqrt(norm);
    }

    private void buildBoundary() {
        this.mTrail.clear();
        if (this.mPoints == null || this.mBoundaryData == null) {
            return;
        }
        int nSegments = this.mBoundaryData.length;
        int i = 0;
        while (i < nSegments) {
            if (i > 0) {
                this.mTrail.newSegment();
            }
            Color segmentColor = this.getStyle().getLineColor();
            if (this.mBoundaryColors != null) {
                int colorIndex = i;
                if (this.mBoundaryLabels != null) {
                    colorIndex = this.mBoundaryLabels[i];
                    segmentColor = colorIndex < this.mBoundaryColors.length ? this.mBoundaryColors[colorIndex] : DisplayColors.getLineColor(colorIndex);
                }
            }
            if (segmentColor != null) {
                this.mTrail.getStyle().setLineColor(segmentColor);
                int[] segment = this.mBoundaryData[i];
                int nPoints = segment.length;
                int j = 0;
                while (j < nPoints) {
                    int index = segment[j];
                    double[] point = this.mPoints[index];
                    if (point.length > 2) {
                        this.mTrail.addPoint(point);
                    } else if (this.mValues != null) {
                        this.mTrail.addPoint(point[0], point[1], this.mValues[index][0]);
                    } else {
                        this.mTrail.addPoint(point[0], point[1], 0.0);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }
}

