/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing2d.utils;

import java.awt.Color;
import java.awt.Graphics2D;
import javax.swing.JFrame;
import org.opensourcephysics.display2d.ColorMapper;
import org.opensourcephysics.display2d.ZExpansion;

public class ColorCodedDrawer {
    private boolean mSymmetricZ = false;
    private ColorMapper mColorMapper = new ColorMapper(16, -1.0, 1.0, 0);
    private double[] mThresholds = this.mColorMapper.getColorThresholds();
    private static final double ARROW_CST = 0.35;
    private static final double ARROW_MAX = 25.0;

    public JFrame showLegend() {
        return this.mColorMapper.showLegend();
    }

    public void setScale(double floor, double ceil) {
        this.mColorMapper.setScale(floor, ceil);
        this.mColorMapper.updateLegend(null);
        this.mThresholds = this.mColorMapper.getColorThresholds();
    }

    public double getFloor() {
        return this.mColorMapper.getFloor();
    }

    public double getCeiling() {
        return this.mColorMapper.getCeil();
    }

    public void setFloorCeilColor(Color floorColor, Color ceilColor) {
        this.mColorMapper.setFloorCeilColor(floorColor, ceilColor);
    }

    public void setPaletteType(int type) {
        this.mColorMapper.setPaletteType(type);
    }

    public void setColorPalette(Color[] colors) {
        this.mColorMapper.setColorPalette(colors);
    }

    public void setSymmetricZ(boolean symmetric) {
        this.mSymmetricZ = symmetric;
    }

    public boolean isSymmetricZ() {
        return this.mSymmetricZ;
    }

    public void setExpandedZ(boolean expanded, double expansionFactor) {
        if (expanded && expansionFactor > 0.0) {
            ZExpansion zMap = new ZExpansion(expansionFactor);
            this.mColorMapper.setZMap(zMap);
        } else {
            this.mColorMapper.setZMap(null);
        }
    }

    public Color doubleToColor(double value) {
        int valueIndex = this.mColorMapper.doubleToIndex(value);
        return this.mColorMapper.indexToColor(valueIndex);
    }

    public void setAutoscale(double min, double max) {
        double ceil = max;
        double floor = min;
        if (this.mSymmetricZ) {
            ceil = Math.max(Math.abs(min), Math.abs(max));
            floor = -ceil;
        }
        this.setScale(floor, ceil);
    }

    public void drawColorCoded(Graphics2D g2, int[] a, int[] b, double[] values, boolean drawBorder) {
        int nVertex = a.length;
        int[] vertexIndex = new int[a.length];
        int minIndex = Integer.MAX_VALUE;
        int maxIndex = Integer.MIN_VALUE;
        int i = 0;
        while (i < nVertex) {
            int valueIndex = this.mColorMapper.doubleToIndex(values[i]);
            minIndex = Math.min(valueIndex, minIndex);
            maxIndex = Math.max(valueIndex, maxIndex);
            vertexIndex[i] = valueIndex;
            ++i;
        }
        int[] newCornersX = new int[2 * nVertex];
        int[] newCornersY = new int[2 * nVertex];
        int levelIndex = minIndex;
        while (levelIndex <= maxIndex) {
            int pointsAdded = 0;
            int point = 0;
            while (point < nVertex) {
                double lambda;
                int nextPoint = (point + 1) % nVertex;
                if (vertexIndex[point] <= levelIndex && vertexIndex[nextPoint] >= levelIndex) {
                    if (vertexIndex[point] == levelIndex) {
                        newCornersX[pointsAdded] = a[point];
                        newCornersY[pointsAdded] = b[point];
                        ++pointsAdded;
                    } else {
                        lambda = (this.mThresholds[levelIndex] - values[point]) / (values[nextPoint] - values[point]);
                        newCornersX[pointsAdded] = (int)Math.round((double)a[point] + lambda * (double)(a[nextPoint] - a[point]));
                        newCornersY[pointsAdded] = (int)Math.round((double)b[point] + lambda * (double)(b[nextPoint] - b[point]));
                        ++pointsAdded;
                    }
                    if (vertexIndex[nextPoint] > levelIndex) {
                        lambda = (this.mThresholds[levelIndex + 1] - values[point]) / (values[nextPoint] - values[point]);
                        newCornersX[pointsAdded] = (int)Math.round((double)a[point] + lambda * (double)(a[nextPoint] - a[point]));
                        newCornersY[pointsAdded] = (int)Math.round((double)b[point] + lambda * (double)(b[nextPoint] - b[point]));
                        ++pointsAdded;
                    }
                } else if (vertexIndex[point] >= levelIndex && vertexIndex[nextPoint] <= levelIndex) {
                    if (vertexIndex[point] == levelIndex) {
                        newCornersX[pointsAdded] = a[point];
                        newCornersY[pointsAdded] = b[point];
                        ++pointsAdded;
                    } else {
                        lambda = (this.mThresholds[levelIndex + 1] - values[point]) / (values[nextPoint] - values[point]);
                        newCornersX[pointsAdded] = (int)Math.round((double)a[point] + lambda * (double)(a[nextPoint] - a[point]));
                        newCornersY[pointsAdded] = (int)Math.round((double)b[point] + lambda * (double)(b[nextPoint] - b[point]));
                        ++pointsAdded;
                    }
                    if (vertexIndex[nextPoint] < levelIndex) {
                        lambda = (this.mThresholds[levelIndex] - values[point]) / (values[nextPoint] - values[point]);
                        newCornersX[pointsAdded] = (int)Math.round((double)a[point] + lambda * (double)(a[nextPoint] - a[point]));
                        newCornersY[pointsAdded] = (int)Math.round((double)b[point] + lambda * (double)(b[nextPoint] - b[point]));
                        ++pointsAdded;
                    }
                }
                ++point;
            }
            if (pointsAdded > 0) {
                g2.setPaint(this.mColorMapper.indexToColor(levelIndex));
                g2.fillPolygon(newCornersX, newCornersY, pointsAdded);
                if (drawBorder) {
                    g2.drawPolygon(newCornersX, newCornersY, pointsAdded);
                }
            }
            ++levelIndex;
        }
    }

    public void drawColorCodedArrows(Graphics2D g2, Color color, int[] aPos, int[] bPos, double[] sizes, double[] modules, double[][] coordinates) {
        int nVertex = aPos.length;
        int[] arrowA = new int[6];
        int[] arrowB = new int[6];
        double h = Math.sqrt(sizes[0] * sizes[0] + sizes[1] * sizes[1]);
        double h2 = h / 2.0;
        double sizeCST = 0.35 / h;
        if (h > 25.0) {
            sizeCST *= 25.0 / h;
        }
        int point = 0;
        while (point < nVertex) {
            double[] arrow = coordinates[point];
            if (arrow[0] == 0.0 && arrow[1] == 0.0) {
                return;
            }
            int valueIndex = this.mColorMapper.doubleToIndex(modules[point]);
            Color valueColor = this.mColorMapper.indexToColor(valueIndex);
            int xOrigin = aPos[point];
            int yOrigin = bPos[point];
            double angle = Math.atan2(-arrow[1], arrow[0]);
            double a = sizes[0] * Math.cos(angle);
            double b = sizes[1] * Math.sin(angle);
            double xEnd = (double)xOrigin + a;
            double yEnd = (double)yOrigin + b;
            double p0 = xEnd - (a *= sizeCST) * sizes[0] * 2.0;
            double q0 = yEnd - (b *= sizeCST) * sizes[1] * 2.0;
            arrowA[0] = (int)p0;
            arrowB[0] = (int)q0;
            arrowA[1] = (int)(p0 - (b *= h2));
            arrowB[1] = (int)(q0 + (a *= h2));
            arrowA[2] = (int)xEnd;
            arrowB[2] = (int)yEnd;
            arrowA[3] = (int)(p0 + b);
            arrowB[3] = (int)(q0 - a);
            arrowA[4] = (int)p0;
            arrowB[4] = (int)q0;
            arrowA[5] = xOrigin;
            arrowB[5] = yOrigin;
            g2.setPaint(valueColor);
            g2.fillPolygon(arrowA, arrowB, 5);
            if (color != null) {
                g2.setColor(color);
            } else {
                g2.setColor(valueColor);
            }
            g2.drawPolyline(arrowA, arrowB, 6);
            ++point;
        }
    }
}

