/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing2d;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.List;
import org.opensourcephysics.display.Data;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.drawing2d.Element;
import org.opensourcephysics.drawing2d.Group;
import org.opensourcephysics.drawing2d.interaction.InteractionTarget;

public class ElementPolygon
extends Element
implements Data {
    private boolean closed = true;
    private double[][] coordinates = new double[0][0];
    private ActionListener listener = null;
    private int[] aPoints = null;
    private int[] bPoints = null;
    protected int datasetID = this.hashCode();

    public void setClosed(boolean closed) {
        this.closed = closed;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void setActionListener(ActionListener _listener) {
        this.listener = _listener;
    }

    public void setData(double[][] data) {
        if (data == null) {
            return;
        }
        if (this.coordinates.length != data.length) {
            int n = data.length;
            this.coordinates = new double[n][2];
            this.aPoints = new int[n];
            this.bPoints = new int[n];
        }
        int i = 0;
        int n = data.length;
        while (i < n) {
            System.arraycopy(data[i], 0, this.coordinates[i], 0, 2);
            ++i;
        }
        this.setElementChanged();
    }

    public void setData(double[] xArray, double[] yArray) {
        int n = Math.max(xArray.length, yArray.length);
        if (this.coordinates.length != n) {
            this.coordinates = new double[n][2];
            this.aPoints = new int[n];
            this.bPoints = new int[n];
        }
        if (xArray.length == yArray.length) {
            int i = 0;
            while (i < n) {
                this.coordinates[i][0] = xArray[i];
                this.coordinates[i][1] = yArray[i];
                ++i;
            }
        } else {
            double lastX = xArray[xArray.length - 1];
            double lastY = yArray[yArray.length - 1];
            int i = 0;
            while (i < n) {
                this.coordinates[i][0] = i < xArray.length ? xArray[i] : lastX;
                this.coordinates[i][1] = i < yArray.length ? yArray[i] : lastY;
                ++i;
            }
        }
        this.setElementChanged();
    }

    public double[][] getData() {
        double[][] data = new double[this.coordinates.length][2];
        int i = 0;
        int n = this.coordinates.length;
        while (i < n) {
            System.arraycopy(this.coordinates[i], 0, data[i], 0, 2);
            ++i;
        }
        return data;
    }

    public double[][] getDataArray() {
        return this.coordinates;
    }

    @Override
    public void setID(int id) {
        this.datasetID = id;
    }

    @Override
    public int getID() {
        return this.datasetID;
    }

    @Override
    public double[][] getData2D() {
        double[][] data = new double[2][this.coordinates.length];
        int i = 0;
        int n = this.coordinates.length;
        while (i < n) {
            data[0][i] = this.coordinates[i][0];
            data[1][i] = this.coordinates[i][1];
            ++i;
        }
        return data;
    }

    @Override
    public double[][][] getData3D() {
        return null;
    }

    @Override
    public String[] getColumnNames() {
        return new String[]{"x", "y"};
    }

    @Override
    public Color[] getLineColors() {
        return new Color[]{Color.BLACK, this.getStyle().getLineColor()};
    }

    @Override
    public Color[] getFillColors() {
        Paint fill = this.getStyle().getFillColor();
        if (fill instanceof Color) {
            return new Color[]{Color.BLACK, (Color)fill};
        }
        return new Color[]{Color.BLACK, Color.BLUE};
    }

    @Override
    public List<Data> getDataList() {
        return null;
    }

    @Override
    public ArrayList<Dataset> getDatasets() {
        return null;
    }

    @Override
    protected void updateExtrema() {
        if (!this.hasChanged()) {
            return;
        }
        this.initExtrema();
        double[] aPoint = new double[2];
        int k = 0;
        int n = this.coordinates.length;
        while (k < n) {
            System.arraycopy(this.coordinates[k], 0, aPoint, 0, 2);
            this.getTotalTransform().transform(aPoint, 0, aPoint, 0, 1);
            this.compareToAllExtrema(aPoint[0], aPoint[1]);
            ++k;
        }
    }

    @Override
    public void draw(DrawingPanel _panel, Graphics _g) {
        if (this.listener != null) {
            this.listener.actionPerformed(null);
        }
        if (!this.isReallyVisible() || this.coordinates.length == 0) {
            return;
        }
        if (this.hasChanged() || this.needsToProject()) {
            this.projectPoints(_panel);
        }
        Graphics2D g2 = (Graphics2D)_g;
        g2.setStroke(this.getStyle().getLineStroke());
        Color color = this.getStyle().getLineColor();
        if (this.closed) {
            Paint fill = this.getStyle().getFillColor();
            if (fill != null && this.getStyle().isDrawingFill()) {
                g2.setPaint(fill);
                g2.fillPolygon(this.aPoints, this.bPoints, this.aPoints.length);
            }
            if (color != null && this.getStyle().isDrawingLines()) {
                g2.setColor(color);
                g2.drawPolygon(this.aPoints, this.bPoints, this.aPoints.length);
            }
        } else {
            g2.setColor(color);
            g2.drawPolyline(this.aPoints, this.bPoints, this.aPoints.length);
        }
    }

    private double[] getHotSpotOfPoint(int k) {
        double[] point = new double[]{this.coordinates[k][0], this.coordinates[k][1]};
        this.getTotalTransform().transform(point, 0, point, 0, 1);
        return point;
    }

    @Override
    public void updateHotSpot(InteractionTarget target, double[] point) {
        if (target.getEnabled() == 4) {
            return;
        }
        Group gr = this.getGroup();
        int k = (Integer)target.getDataObject();
        block2 : switch (target.getType()) {
            case 0: {
                if (gr != null && target.getAffectsGroup()) {
                    double[] origin = this.getHotSpotOfPoint(k);
                    switch (target.getEnabled()) {
                        case 2: {
                            gr.setX(gr.getX() + point[0] - origin[0]);
                            break block2;
                        }
                        case 3: {
                            gr.setY(gr.getY() + point[1] - origin[1]);
                            break block2;
                        }
                    }
                    gr.setXY(gr.getX() + point[0] - origin[0], gr.getY() + point[1] - origin[1]);
                    break;
                }
                double[] thePoint = (double[])point.clone();
                this.groupInverseTransformations(thePoint);
                double[] origin = new double[]{this.coordinates[k][0], this.coordinates[k][1]};
                origin[0] = origin[0] * this.getSizeX();
                origin[1] = origin[1] * this.getSizeY();
                this.getTheTransformation().transform(origin, 0, origin, 0, 1);
                switch (target.getEnabled()) {
                    case 2: {
                        this.setX(thePoint[0] - origin[0]);
                        break block2;
                    }
                    case 3: {
                        this.setY(thePoint[1] - origin[1]);
                        break block2;
                    }
                }
                this.setXY(thePoint[0] - origin[0], thePoint[1] - origin[1]);
                break;
            }
            case 1: {
                if (gr != null && target.getAffectsGroup()) {
                    double[] thePoint = (double[])point.clone();
                    thePoint[0] = thePoint[0] - gr.getX();
                    thePoint[1] = thePoint[1] - gr.getY();
                    try {
                        gr.getTheTransformation().inverseTransform(thePoint, 0, thePoint, 0, 1);
                    }
                    catch (Exception origin) {
                        // empty catch block
                    }
                    double[] origin = new double[]{this.coordinates[k][0], this.coordinates[k][1]};
                    this.elementDirectTransformations(origin);
                    thePoint[0] = origin[0] != 0.0 ? thePoint[0] / origin[0] : gr.getX();
                    thePoint[1] = origin[1] != 0.0 ? thePoint[1] / origin[1] : gr.getY();
                    switch (target.getEnabled()) {
                        case 2: {
                            gr.setSizeX(thePoint[0]);
                            break block2;
                        }
                        case 3: {
                            gr.setSizeY(thePoint[1]);
                            break block2;
                        }
                    }
                    gr.setSize(thePoint);
                    break;
                }
                double[] thePoint = (double[])point.clone();
                this.groupInverseTransformations(thePoint);
                thePoint[0] = thePoint[0] - this.getX();
                thePoint[1] = thePoint[1] - this.getY();
                try {
                    this.getTheTransformation().inverseTransform(thePoint, 0, thePoint, 0, 1);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.coordinates[k][0] = thePoint[0];
                this.coordinates[k][1] = thePoint[1];
                this.setNeedToProject(true);
            }
        }
    }

    @Override
    public Interactive findInteractive(DrawingPanel _panel, int _xpix, int _ypix) {
        int sensitivity;
        if (!this.targetPosition.isEnabled() && !this.targetSize.isEnabled()) {
            return null;
        }
        if (!this.isReallyVisible() || this.coordinates.length == 0) {
            return null;
        }
        if (this.hasChanged() || this.needsToProject()) {
            this.projectPoints(_panel);
        }
        if ((sensitivity = this.getStyle().getSensitivity()) <= 0) {
            sensitivity = 1;
        }
        int k = 0;
        int n = this.aPoints.length;
        while (k < n) {
            if (Math.abs(this.aPoints[k] - _xpix) < sensitivity && Math.abs(this.bPoints[k] - _ypix) < sensitivity) {
                if (this.targetPosition.isEnabled()) {
                    this.targetPosition.setDataObject(new Integer(k));
                    return this.targetPosition;
                }
                if (this.targetSize.isEnabled()) {
                    this.targetSize.setDataObject(new Integer(k));
                    return this.targetSize;
                }
            }
            ++k;
        }
        return null;
    }

    private void projectPoints(DrawingPanel _panel) {
        AffineTransform tr = this.getPixelTransform(_panel);
        double[] point = new double[2];
        int k = 0;
        int n = this.coordinates.length;
        while (k < n) {
            System.arraycopy(this.coordinates[k], 0, point, 0, 2);
            tr.transform(point, 0, point, 0, 1);
            this.aPoints[k] = (int)point[0];
            this.bPoints[k] = (int)point[1];
            ++k;
        }
        this.setNeedToProject(false);
    }
}

