/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import org.colos.freefem.PDEData;
import org.colos.freefem.PDEMesh;
import org.opensourcephysics.display.Mesh;

public class MeshTools {
    public static boolean show(PDEData data, Mesh displayMesh) {
        if (data == null) {
            displayMesh.setPoints(null);
            return true;
        }
        switch (data.getType()) {
            case MESH_2D: 
            case MESH_3D: {
                MeshTools.show(data.getProblemMesh(), displayMesh);
                return true;
            }
            case SCALAR_2D_FIELD: 
            case SCALAR_3D_FIELD: 
            case VECTOR_2D_FIELD: 
            case VECTOR_3D_FIELD: {
                MeshTools.show(data.getSolutionMesh(), displayMesh);
                displayMesh.setFieldAtCells(data.getSolutionValues());
                return true;
            }
        }
        return false;
    }

    public static void show(PDEMesh mesh, Mesh displayMesh) {
        displayMesh.setPoints(mesh.getPoints());
        displayMesh.setCells(mesh.getCells());
        displayMesh.setBoundary(mesh.getBoundaryElements());
        displayMesh.setBoundaryLabels(mesh.getBoundaryLabels());
    }
}

