/*
 * Decompiled with CFR 0.152.
 */
package org.colos.freefem;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.colos.ejs.library.server.DataMapExportable;
import org.colos.freefem.PDEMesh;

public class PDEData
implements DataMapExportable {
    private DataType mType;
    private PDEMesh mProblemMesh;
    private double[][] mValues;
    private double[][] mSubpoints;
    private int[][] mSubelements;
    private PDEMesh mSolutionMesh = null;
    private double[][][] mSolutionValues = null;

    public PDEData(long type, PDEMesh mesh, double[][] values, double[][] subpoints, int[][] subelements) {
        switch ((int)type) {
            default: {
                this.mType = DataType.MESH_2D;
                break;
            }
            case 1: {
                this.mType = DataType.SCALAR_2D_FIELD;
                break;
            }
            case 2: {
                this.mType = DataType.VECTOR_2D_FIELD;
                break;
            }
            case 5: {
                this.mType = DataType.MESH_3D;
                break;
            }
            case 6: {
                this.mType = DataType.SCALAR_3D_FIELD;
                break;
            }
            case 7: {
                this.mType = DataType.VECTOR_3D_FIELD;
            }
        }
        this.mProblemMesh = mesh;
        this.mValues = values;
        this.mSubpoints = subpoints;
        this.mSubelements = subelements;
        if (subelements == null) {
            this.mSolutionMesh = this.mProblemMesh;
        }
    }

    public DataType getType() {
        return this.mType;
    }

    public PDEMesh getProblemMesh() {
        return this.mProblemMesh;
    }

    public PDEMesh getSolutionMesh() {
        if (this.mSolutionMesh == null) {
            this.computeSolutionMesh();
        }
        return this.mSolutionMesh;
    }

    public double[][][] getSolutionValues() {
        if (this.mSolutionMesh == null) {
            this.computeSolutionMesh();
        }
        return this.mSolutionValues;
    }

    private static int hasOriginalIndex(int dim, double[] coordinates) {
        switch (dim) {
            default: {
                if (coordinates[0] == 0.0) {
                    if (coordinates[1] == 0.0) {
                        return 0;
                    }
                    if (coordinates[1] != 1.0) break;
                    return 2;
                }
                if (coordinates[0] != 1.0 || coordinates[1] != 0.0) break;
                return 1;
            }
            case 3: {
                if (coordinates[0] == 0.0) {
                    if (coordinates[1] == 0.0) {
                        if (coordinates[2] == 0.0) {
                            return 0;
                        }
                        if (coordinates[2] != 1.0) break;
                        return 3;
                    }
                    if (coordinates[1] != 1.0 || coordinates[2] != 0.0) break;
                    return 2;
                }
                if (coordinates[0] != 1.0 || coordinates[1] != 0.0 || coordinates[2] != 0.0) break;
                return 1;
            }
        }
        return -1;
    }

    private void computeSolutionMesh() {
        double[][] problemPoints = this.mProblemMesh.getPoints();
        int[][] problemCells = this.mProblemMesh.getCells();
        int nProblemCells = problemCells.length;
        int dim = this.mType == DataType.SCALAR_2D_FIELD || this.mType == DataType.VECTOR_2D_FIELD ? 2 : 3;
        int nSolutionPoints = problemPoints.length + nProblemCells * (this.mSubpoints.length - dim - 1);
        int nSolutionCells = nProblemCells * this.mSubelements.length;
        double[][] solutionPoints = new double[nSolutionPoints][];
        int[][] solutionCells = new int[nSolutionCells][];
        this.mSolutionValues = new double[solutionCells.length][][];
        System.arraycopy(problemPoints, 0, solutionPoints, 0, problemPoints.length);
        int[] refIndexes = new int[dim + 1];
        HashSet<Integer> newPointsList = new HashSet<Integer>();
        int p = 0;
        while (p < this.mSubpoints.length) {
            double[] coordinates = this.mSubpoints[p];
            int originalIndex = PDEData.hasOriginalIndex(dim, coordinates);
            if (originalIndex >= 0) {
                refIndexes[originalIndex] = p;
            } else {
                newPointsList.add(p);
            }
            ++p;
        }
        int[] newIndexes = new int[this.mSubpoints.length];
        int newPointIndex = problemPoints.length;
        int newCellIndex = 0;
        int cellIndex = 0;
        while (cellIndex < nProblemCells) {
            int[] problemCell = problemCells[cellIndex];
            int p2 = 0;
            while (p2 < this.mSubpoints.length) {
                double[] coordinates = this.mSubpoints[p2];
                if (newPointsList.contains(p2)) {
                    solutionPoints[newPointIndex] = new double[coordinates.length];
                    double[] point = solutionPoints[newPointIndex];
                    double[] origin = problemPoints[problemCell[0]];
                    System.arraycopy(origin, 0, point, 0, dim);
                    int i = 0;
                    while (i < coordinates.length) {
                        double[] endPoint = problemPoints[problemCell[i + 1]];
                        int j = 0;
                        while (j < dim) {
                            int n = j;
                            point[n] = point[n] + coordinates[i] * (endPoint[j] - origin[j]);
                            ++j;
                        }
                        ++i;
                    }
                    newIndexes[p2] = newPointIndex++;
                } else {
                    int k = 0;
                    while (k < refIndexes.length) {
                        if (refIndexes[k] == p2) {
                            newIndexes[p2] = problemCell[k];
                            break;
                        }
                        ++k;
                    }
                }
                ++p2;
            }
            int offset = cellIndex * this.mSubpoints.length;
            int i = 0;
            while (i < this.mSubelements.length) {
                int[] subCell = this.mSubelements[i];
                solutionCells[newCellIndex] = new int[subCell.length];
                int[] newCell = solutionCells[newCellIndex];
                this.mSolutionValues[newCellIndex] = new double[subCell.length][];
                int j = 0;
                while (j < subCell.length) {
                    int point = subCell[j];
                    newCell[j] = newIndexes[point];
                    newCellValues[j] = this.mValues[offset + point];
                    ++j;
                }
                ++newCellIndex;
                ++i;
            }
            ++cellIndex;
        }
        this.mSolutionMesh = new PDEMesh(solutionPoints, solutionCells, this.mProblemMesh.getBoundaryElements(), this.mProblemMesh.getBoundaryLabels());
    }

    @Override
    public Map<String, Object> toDataMap() {
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("type", this.mType.ordinal());
        dataMap.put("problem_mesh", this.mProblemMesh.toDataMap());
        dataMap.put("solution_mesh", this.mSolutionMesh.toDataMap());
        dataMap.put("solution_values", this.mSolutionValues);
        return dataMap;
    }

    public static enum DataType {
        MESH_2D,
        MESH_3D,
        SCALAR_2D_FIELD,
        SCALAR_3D_FIELD,
        VECTOR_2D_FIELD,
        VECTOR_3D_FIELD;

    }
}

