/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JMenuBar;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import org.colos.ejs.library.control.ControlElement;
import org.colos.ejs.library.control.swing.ControlContainer;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.display.OSPRuntime;

public class ControlRootPane
extends ControlContainer {
    protected JRootPane panel;
    private LayoutManager myLayout = null;
    protected JMenuBar menubar = null;
    private static List<String> infoList = null;

    @Override
    protected Component createVisual() {
        this.panel = new JRootPane();
        this.panel.getContentPane().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent _e) {
                if (_e.isControlDown() && ControlRootPane.this.getSimulation() != null) {
                    if (_e.getKeyCode() == 77) {
                        ControlRootPane.this.getPopupMenu(0, 0);
                    } else if (_e.getKeyCode() == 80) {
                        ControlRootPane.this.printScreen();
                    }
                }
            }
        });
        this.panel.getContentPane().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent _evt) {
                if (ControlRootPane.this.getSimulation() != null && OSPRuntime.isPopupTrigger(_evt)) {
                    ControlRootPane.this.getPopupMenu(_evt.getX(), _evt.getY());
                }
            }
        });
        return this.panel;
    }

    @Override
    public Component getComponent() {
        return this.panel;
    }

    @Override
    public Container getContainer() {
        return this.panel.getContentPane();
    }

    @Override
    public List<String> getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList<String>();
            infoList.add("layout");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    @Override
    public String getPropertyInfo(String _property) {
        if (_property.equals("layout")) {
            return "Layout|Object NO_RESET";
        }
        return super.getPropertyInfo(_property);
    }

    @Override
    public void setValue(int _index, Value _value) {
        switch (_index) {
            case 0: {
                LayoutManager layout;
                if (!(_value.getObject() instanceof LayoutManager) || (layout = (LayoutManager)_value.getObject()) == this.myLayout) break;
                this.myLayout = layout;
                this.getContainer().setLayout(this.myLayout);
                this.adjustChildren();
                this.panel.validate();
                break;
            }
            default: {
                super.setValue(_index - 1, _value);
            }
        }
    }

    @Override
    public void setDefaultValue(int _index) {
        switch (_index) {
            case 0: {
                this.myLayout = new BorderLayout();
                this.getContainer().setLayout(this.myLayout);
                this.adjustChildren();
                this.panel.validate();
                break;
            }
            default: {
                super.setDefaultValue(_index - 1);
            }
        }
    }

    @Override
    public String getDefaultValueString(int _index) {
        switch (_index) {
            case 0: {
                return "BORDER";
            }
        }
        return super.getDefaultValueString(_index - 1);
    }

    @Override
    public Value getValue(int _index) {
        switch (_index) {
            case 0: {
                return null;
            }
        }
        return super.getValue(_index - 1);
    }

    @Override
    public void add(final ControlElement _child) {
        if (!(_child.getVisual() instanceof JMenuBar)) {
            super.add(_child);
            return;
        }
        this.children.add(_child);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ControlRootPane.this.menubar = (JMenuBar)_child.getVisual();
                ControlRootPane.this.panel.setJMenuBar(ControlRootPane.this.menubar);
                ControlRootPane.this.adjustSize();
            }
        });
        this.propagateProperty(_child, "font", this.getPropagatedProperty("font"));
        this.propagateProperty(_child, "foreground", this.getPropagatedProperty("foreground"));
        this.propagateProperty(_child, "background", this.getPropagatedProperty("background"));
    }

    @Override
    public void remove(ControlElement _child) {
        if (!(_child.getVisual() instanceof JMenuBar)) {
            super.remove(_child);
            return;
        }
        this.children.remove(_child);
        this.menubar = null;
        this.panel.setJMenuBar(null);
        this.panel.validate();
        this.panel.repaint();
    }
}

