/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.drawing3d;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import org.colos.ejs.library.control.drawing3d.ControlElement3D;
import org.colos.ejs.library.control.swing.NeedsPreUpdate;
import org.colos.ejs.library.control.value.IntegerValue;
import org.colos.ejs.library.control.value.Value;
import org.colos.freefem.PDEData;
import org.opensourcephysics.display.DisplayColors;
import org.opensourcephysics.display.Mesh;
import org.opensourcephysics.display.MeshTools;
import org.opensourcephysics.display2d.ColorMapper;
import org.opensourcephysics.drawing3d.Element;
import org.opensourcephysics.drawing3d.ElementMesh;

public class ControlMesh3D
extends ControlElement3D
implements NeedsPreUpdate {
    private static final int TILE_PROPERTIES_ADDED = 19;
    protected static final int LINE_COLOR = 29;
    protected static final int DRAWING_LINES = 34;
    private ElementMesh mMesh;
    private int levels;
    private int colormode;
    private double minZ;
    private double maxZ;
    private Color floorColor;
    private Color ceilingColor;
    protected Color[] palette;
    protected double expandedFactor;
    private boolean showLegend;
    private boolean showLegendChanged;
    private JFrame legendFrame;
    static List<String> infoList = null;

    @Override
    public String getObjectClassname() {
        return "org.opensourcephysics.drawing3d.ElementMesh";
    }

    @Override
    protected Element createElement() {
        this.mMesh = new ElementMesh();
        this.levels = 16;
        this.colormode = 0;
        this.minZ = -1.0;
        this.maxZ = 1.0;
        this.floorColor = Color.darkGray;
        this.ceilingColor = Color.lightGray;
        this.palette = new Color[0];
        this.expandedFactor = 0.0;
        this.legendFrame = null;
        this.showLegend = false;
        this.showLegendChanged = false;
        return this.mMesh;
    }

    @Override
    protected int getPropertiesDisplacement() {
        return 19;
    }

    @Override
    public List<String> getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList<String>();
            infoList.add("data");
            infoList.add("field");
            infoList.add("cells");
            infoList.add("autoscaleZ");
            infoList.add("minimumZ");
            infoList.add("maximumZ");
            infoList.add("levels");
            infoList.add("expandedZ");
            infoList.add("symmetricZ");
            infoList.add("colormode");
            infoList.add("floorcolor");
            infoList.add("ceilingcolor");
            infoList.add("showLegend");
            infoList.add("boundary");
            infoList.add("boundaryColors");
            infoList.add("boundaryWidth");
            infoList.add("drawingBoundary");
            infoList.add("boundaryZ");
            infoList.add("length");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    @Override
    public String getPropertyInfo(String _property) {
        if (_property.equals("data")) {
            return "double[][]|PDEData|org.colos.freefem.PDEData|Object";
        }
        if (_property.equals("field")) {
            return "double[][]|double[][][]";
        }
        if (_property.equals("cells")) {
            return "int[][]";
        }
        if (_property.equals("autoscaleZ")) {
            return "boolean";
        }
        if (_property.equals("minimumZ")) {
            return "int|double";
        }
        if (_property.equals("maximumZ")) {
            return "int|double";
        }
        if (_property.equals("levels")) {
            return "int";
        }
        if (_property.equals("expandedZ")) {
            return "int|double ";
        }
        if (_property.equals("symmetricZ")) {
            return "boolean";
        }
        if (_property.equals("colormode")) {
            return "ColorMode|int|Object[]";
        }
        if (_property.equals("floorcolor")) {
            return "Color|Object";
        }
        if (_property.equals("ceilingcolor")) {
            return "Color|Object";
        }
        if (_property.equals("showLegend")) {
            return "boolean";
        }
        if (_property.equals("boundary")) {
            return "int[][]";
        }
        if (_property.equals("boundaryColors")) {
            return "Color|Color[]|Object[]";
        }
        if (_property.equals("boundaryWidth")) {
            return "int|double";
        }
        if (_property.equals("drawingBoundary")) {
            return "boolean";
        }
        if (_property.equals("boundaryZ")) {
            return "int|double";
        }
        if (_property.equals("length")) {
            return "int|double";
        }
        return super.getPropertyInfo(_property);
    }

    @Override
    public Value parseConstant(String _propertyType, String _value) {
        if (_value == null) {
            return null;
        }
        if (_propertyType.indexOf("ColorMode") >= 0 || _propertyType.indexOf("PlotMode") >= 0) {
            if ((_value = _value.trim().toLowerCase()).equals("spectrum")) {
                return new IntegerValue(0);
            }
            if (_value.equals("grayscale")) {
                return new IntegerValue(1);
            }
            if (_value.equals("dualshade")) {
                return new IntegerValue(2);
            }
            if (_value.equals("red")) {
                return new IntegerValue(3);
            }
            if (_value.equals("green")) {
                return new IntegerValue(4);
            }
            if (_value.equals("blue")) {
                return new IntegerValue(5);
            }
            if (_value.equals("black")) {
                return new IntegerValue(6);
            }
            if (_value.equals("binary")) {
                return new IntegerValue(6);
            }
            if (_value.equals("wireframe")) {
                return new IntegerValue(7);
            }
            if (_value.equals("norender")) {
                return new IntegerValue(8);
            }
            if (_value.equals("redblueshade")) {
                return new IntegerValue(9);
            }
        }
        return super.parseConstant(_propertyType, _value);
    }

    @Override
    public void setValue(int _index, Value _value) {
        switch (_index) {
            case 0: {
                if (_value.getObject() instanceof PDEData) {
                    MeshTools.show((PDEData)_value.getObject(), (Mesh)this.mMesh);
                    break;
                }
                this.mMesh.setPoints((double[][])_value.getObject());
                break;
            }
            case 1: {
                if (_value.getObject() instanceof double[][][]) {
                    this.mMesh.setFieldAtCells((double[][][])_value.getObject());
                    break;
                }
                this.mMesh.setFieldAtPoints((double[][])_value.getObject());
                break;
            }
            case 2: {
                this.mMesh.setCells((int[][])_value.getObject());
                break;
            }
            case 3: {
                if (this.mMesh.getTessellation().isAutoscaleZ() == _value.getBoolean()) break;
                this.mMesh.getTessellation().setAutoscaleZ(_value.getBoolean(), this.minZ, this.maxZ);
                break;
            }
            case 4: {
                if (this.minZ == _value.getDouble()) break;
                this.minZ = _value.getDouble();
                this.mMesh.getTessellation().setAutoscaleZ(this.mMesh.getTessellation().isAutoscaleZ(), this.minZ, this.maxZ);
                break;
            }
            case 5: {
                if (this.maxZ == _value.getDouble()) break;
                this.maxZ = _value.getDouble();
                this.mMesh.getTessellation().setAutoscaleZ(this.mMesh.getTessellation().isAutoscaleZ(), this.minZ, this.maxZ);
                break;
            }
            case 6: {
                if (this.levels == _value.getInteger() || this.colormode < 0) break;
                this.levels = _value.getInteger();
                this.mMesh.getTessellation().getDrawer().setColorPalette(ColorMapper.getColorPalette(this.levels, this.colormode));
                this.mMesh.getTessellation().getDrawer().setFloorCeilColor(this.floorColor, this.ceilingColor);
                break;
            }
            case 7: {
                if (_value.getDouble() == this.expandedFactor) break;
                this.expandedFactor = _value.getDouble();
                this.mMesh.getTessellation().getDrawer().setExpandedZ(true, this.expandedFactor);
                break;
            }
            case 8: {
                this.mMesh.getTessellation().getDrawer().setSymmetricZ(_value.getBoolean());
                break;
            }
            case 9: {
                if (_value.getObject() instanceof Object[]) {
                    this.colormode = -1;
                    Object[] newPalette = (Object[])_value.getObject();
                    if (newPalette.length != this.palette.length) {
                        this.palette = new Color[newPalette.length];
                    }
                    boolean differentPalette = false;
                    int i = 0;
                    int n = this.palette.length;
                    while (i < n) {
                        if (this.palette[i] != (Color)newPalette[i]) {
                            this.palette[i] = (Color)newPalette[i];
                            differentPalette = true;
                        }
                        ++i;
                    }
                    if (!differentPalette) break;
                    this.mMesh.getTessellation().getDrawer().setColorPalette(this.palette);
                    this.mMesh.getTessellation().getDrawer().setFloorCeilColor(this.floorColor, this.ceilingColor);
                    break;
                }
                if (this.colormode == _value.getInteger()) break;
                this.colormode = _value.getInteger();
                this.mMesh.getTessellation().getDrawer().setPaletteType(this.colormode);
                this.mMesh.getTessellation().getDrawer().setFloorCeilColor(this.floorColor, this.ceilingColor);
                break;
            }
            case 10: {
                if (!(_value.getObject() instanceof Color) || this.floorColor == (Color)_value.getObject()) break;
                this.floorColor = (Color)_value.getObject();
                this.mMesh.getTessellation().getDrawer().setFloorCeilColor(this.floorColor, this.ceilingColor);
                break;
            }
            case 11: {
                if (!(_value.getObject() instanceof Color) || this.ceilingColor == (Color)_value.getObject()) break;
                this.ceilingColor = (Color)_value.getObject();
                this.mMesh.getTessellation().getDrawer().setFloorCeilColor(this.floorColor, this.ceilingColor);
                break;
            }
            case 12: {
                if (this.showLegend == _value.getBoolean()) break;
                this.showLegend = _value.getBoolean();
                this.showLegendChanged = true;
                break;
            }
            case 13: {
                this.mMesh.setBoundary((int[][])_value.getObject());
                break;
            }
            case 14: {
                if (_value.getObject() instanceof Color[]) {
                    this.mMesh.setBoundaryColors((Color[])_value.getObject());
                    break;
                }
                if (_value.getObject() instanceof int[]) {
                    int[] colorIndexes = (int[])_value.getObject();
                    Color[] colors = new Color[colorIndexes.length];
                    int i = 0;
                    while (i < colorIndexes.length) {
                        colors[i] = DisplayColors.getLineColor(colorIndexes[i]);
                        ++i;
                    }
                    this.mMesh.setBoundaryColors((Color[])_value.getObject());
                    break;
                }
                if (!(_value.getObject() instanceof Object[])) break;
                this.mMesh.setBoundaryColors((Color[])_value.getObject());
                break;
            }
            case 15: {
                this.mMesh.getTrail().getStyle().setLineWidth((float)_value.getDouble());
                break;
            }
            case 16: {
                this.mMesh.getTrail().setVisible(_value.getBoolean());
                break;
            }
            case 17: {
                this.mMesh.getTrail().setZ(_value.getDouble());
                break;
            }
            case 18: {
                this.mMesh.setVectorLength(_value.getDouble());
                break;
            }
            default: {
                super.setValue(_index - 19, _value);
                break;
            }
            case 29: {
                if (_value.getObject() instanceof Color) {
                    this.mMesh.getTessellation().getStyle().setLineColor((Color)_value.getObject());
                } else {
                    this.mMesh.getTessellation().getStyle().setLineColor(DisplayColors.getLineColor(_value.getInteger()));
                }
                super.setValue(_index - 19, _value);
                break;
            }
            case 34: {
                this.mMesh.getTessellation().getStyle().setDrawingLines(_value.getBoolean());
            }
        }
        if (this.isUnderEjs) {
            this.updatePanel();
        }
    }

    @Override
    public void setDefaultValue(int _index) {
        switch (_index) {
            case 0: {
                this.mMesh.setPoints(null);
                break;
            }
            case 1: {
                this.mMesh.setFieldAtPoints(null);
                break;
            }
            case 2: {
                this.mMesh.setCells(null);
                break;
            }
            case 3: {
                this.mMesh.getTessellation().setAutoscaleZ(true, this.minZ, this.maxZ);
                break;
            }
            case 4: {
                this.minZ = -1.0;
                this.mMesh.getTessellation().setAutoscaleZ(this.mMesh.getTessellation().isAutoscaleZ(), -1.0, this.maxZ);
                break;
            }
            case 5: {
                this.maxZ = 1.0;
                this.mMesh.getTessellation().setAutoscaleZ(this.mMesh.getTessellation().isAutoscaleZ(), this.minZ, 1.0);
                break;
            }
            case 6: {
                if (this.colormode < 0) break;
                this.levels = 16;
                this.mMesh.getTessellation().getDrawer().setColorPalette(ColorMapper.getColorPalette(16, this.colormode));
                this.mMesh.getTessellation().getDrawer().setFloorCeilColor(this.floorColor, this.ceilingColor);
                break;
            }
            case 7: {
                this.expandedFactor = 0.0;
                this.mMesh.getTessellation().getDrawer().setExpandedZ(true, 0.0);
                break;
            }
            case 8: {
                this.mMesh.getTessellation().getDrawer().setSymmetricZ(false);
                break;
            }
            case 9: {
                this.colormode = 0;
                this.mMesh.getTessellation().getDrawer().setPaletteType(0);
                this.mMesh.getTessellation().getDrawer().setFloorCeilColor(this.floorColor, this.ceilingColor);
                break;
            }
            case 10: {
                this.floorColor = Color.DARK_GRAY;
                this.mMesh.getTessellation().getDrawer().setFloorCeilColor(this.floorColor, this.ceilingColor);
                break;
            }
            case 11: {
                this.ceilingColor = Color.LIGHT_GRAY;
                this.mMesh.getTessellation().getDrawer().setFloorCeilColor(this.floorColor, this.ceilingColor);
                break;
            }
            case 12: {
                this.showLegend = false;
                this.showLegendChanged = true;
                break;
            }
            case 13: {
                this.mMesh.setBoundary(null);
                break;
            }
            case 14: {
                this.mMesh.setBoundaryColors(null);
                break;
            }
            case 15: {
                this.mMesh.getTrail().getStyle().setLineWidth(1.0f);
                break;
            }
            case 16: {
                this.mMesh.getTrail().setVisible(true);
                break;
            }
            case 17: {
                this.mMesh.getTrail().setZ(0.0);
                break;
            }
            case 18: {
                this.mMesh.setVectorLength(0.1);
                break;
            }
            default: {
                super.setDefaultValue(_index - 19);
                break;
            }
            case 29: {
                this.mMesh.getTessellation().getStyle().setLineColor(this.defLines);
                super.setDefaultValue(_index);
                break;
            }
            case 34: {
                this.mMesh.getTessellation().getStyle().setDrawingLines(true);
            }
        }
        if (this.isUnderEjs) {
            this.updatePanel();
        }
    }

    @Override
    public String getDefaultValueString(int _index) {
        switch (_index) {
            case 0: {
                return "<none>";
            }
            case 1: {
                return "<none>";
            }
            case 2: {
                return "<none>";
            }
            case 3: {
                return "true";
            }
            case 4: {
                return "-1";
            }
            case 5: {
                return "1";
            }
            case 6: {
                return "16";
            }
            case 7: {
                return "0";
            }
            case 8: {
                return "false";
            }
            case 9: {
                return "SPECTRUM";
            }
            case 10: {
                return "DARKGRAY";
            }
            case 11: {
                return "LIGHTGRAY";
            }
            case 12: {
                return "true";
            }
            case 13: {
                return "<none>";
            }
            case 14: {
                return "<none>";
            }
            case 15: {
                return "1";
            }
            case 16: {
                return "true";
            }
            case 17: {
                return "0";
            }
            case 18: {
                return "0.1";
            }
        }
        return super.getDefaultValueString(_index - 19);
    }

    @Override
    public Value getValue(int _index) {
        switch (_index) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                return null;
            }
        }
        return super.getValue(_index - 19);
    }

    @Override
    public void preupdate() {
        if (this.showLegendChanged) {
            if (this.showLegend) {
                if (this.legendFrame == null) {
                    this.legendFrame = this.mMesh.getTessellation().getDrawer().showLegend();
                }
                this.legendFrame.setVisible(true);
            } else if (this.legendFrame != null) {
                this.legendFrame.setVisible(false);
            }
            this.showLegendChanged = false;
        }
    }
}

