/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.drawing3d;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import org.colos.ejs.library.control.drawing3d.ControlElement3D;
import org.colos.ejs.library.control.swing.NeedsPreUpdate;
import org.colos.ejs.library.control.value.DoubleValue;
import org.colos.ejs.library.control.value.GeneralParser;
import org.colos.ejs.library.control.value.IntegerValue;
import org.colos.ejs.library.control.value.ParserAndVariables;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.drawing3d.DrawingPanel3D;
import org.opensourcephysics.drawing3d.Element;
import org.opensourcephysics.drawing3d.ElementSurface;

public class ControlAnalyticSurface3D
extends ControlElement3D
implements NeedsPreUpdate {
    private static final int SURFACE_ROPERTIES_ADDED = 14;
    protected String variable1;
    protected String variable2;
    protected int numPoints1;
    protected int numPoints2;
    protected double min1 = Double.NaN;
    protected double max1 = Double.NaN;
    protected double min2 = Double.NaN;
    protected double max2 = Double.NaN;
    protected String functionX = null;
    protected String functionY = null;
    protected String functionZ = null;
    protected boolean useJavaSyntax = true;
    protected ElementSurface surface;
    protected boolean changedXfunction;
    protected boolean changedYfunction;
    protected boolean changedZfunction;
    protected boolean updateIndexes;
    protected GeneralParser parserX;
    protected GeneralParser parserY;
    protected GeneralParser parserZ;
    protected String[] varsX;
    protected String[] varsY;
    protected String[] varsZ;
    protected int indexX1;
    protected int indexY1;
    protected int indexZ1;
    protected int indexX2;
    protected int indexY2;
    protected int indexZ2;
    private double minAbcise1 = Double.NaN;
    private double maxAbcise1 = Double.NaN;
    private double minAbcise2 = Double.NaN;
    private double maxAbcise2 = Double.NaN;
    private static List<String> infoList = null;

    @Override
    protected Element createElement() {
        this.surface = new ElementSurface();
        this.surface.setActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent _event) {
                ControlAnalyticSurface3D.this.checkExtremes();
            }
        });
        this.surface.setCanBeMeasured(false);
        this.variable1 = "u";
        this.variable2 = "v";
        this.numPoints1 = 20;
        this.numPoints2 = 20;
        this.functionX = null;
        this.varsX = new String[0];
        this.indexX2 = -1;
        this.indexX1 = -1;
        this.functionY = null;
        this.varsY = new String[0];
        this.indexY2 = -1;
        this.indexY1 = -1;
        this.functionZ = null;
        this.varsZ = new String[0];
        this.indexZ2 = -1;
        this.indexZ1 = -1;
        this.changedZfunction = true;
        this.changedYfunction = true;
        this.changedXfunction = true;
        return this.surface;
    }

    @Override
    public String getObjectClassname() {
        return "org.opensourcephysics.drawing3d.ElementSurface";
    }

    @Override
    protected int getPropertiesDisplacement() {
        return 14;
    }

    @Override
    public List<String> getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList<String>();
            infoList.add("variable1");
            infoList.add("min1");
            infoList.add("max1");
            infoList.add("points1");
            infoList.add("variable2");
            infoList.add("min2");
            infoList.add("max2");
            infoList.add("points2");
            infoList.add("functionx");
            infoList.add("functiony");
            infoList.add("functionz");
            infoList.add("javaSyntax");
            infoList.add("onErrorAction");
            infoList.add("onSuccessAction");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    @Override
    public String getPropertyInfo(String _property) {
        if (_property.equals("variable1")) {
            return "String";
        }
        if (_property.equals("variable2")) {
            return "String";
        }
        if (_property.equals("min1")) {
            return "int|double";
        }
        if (_property.equals("max1")) {
            return "int|double";
        }
        if (_property.equals("min2")) {
            return "int|double";
        }
        if (_property.equals("max2")) {
            return "int|double";
        }
        if (_property.equals("points1")) {
            return "int";
        }
        if (_property.equals("points2")) {
            return "int";
        }
        if (_property.equals("functionx")) {
            return "String";
        }
        if (_property.equals("functiony")) {
            return "String";
        }
        if (_property.equals("functionz")) {
            return "String";
        }
        if (_property.equals("javaSyntax")) {
            return "boolean";
        }
        if (_property.equals("onErrorAction")) {
            return "Action CONSTANT";
        }
        if (_property.equals("onSuccessAction")) {
            return "Action CONSTANT";
        }
        return super.getPropertyInfo(_property);
    }

    @Override
    public void setValue(int _index, Value _value) {
        switch (_index) {
            case 0: {
                if (this.variable1 != null && this.variable1.equals(_value.getString())) break;
                this.variable1 = _value.getString();
                this.updateIndexes = true;
                break;
            }
            case 1: {
                this.min1 = _value.getDouble();
                this.checkMeasured();
                break;
            }
            case 2: {
                this.max1 = _value.getDouble();
                this.checkMeasured();
                break;
            }
            case 3: {
                this.numPoints1 = _value.getInteger();
                break;
            }
            case 4: {
                if (this.variable2 != null && this.variable2.equals(_value.getString())) break;
                this.variable2 = _value.getString();
                this.updateIndexes = true;
                break;
            }
            case 5: {
                this.min2 = _value.getDouble();
                this.checkMeasured();
                break;
            }
            case 6: {
                this.max2 = _value.getDouble();
                this.checkMeasured();
                break;
            }
            case 7: {
                this.numPoints2 = _value.getInteger();
                break;
            }
            case 8: {
                if (this.functionX != null && this.functionX.equals(_value.getString())) break;
                this.functionX = _value.getString();
                this.changedXfunction = true;
                break;
            }
            case 9: {
                if (this.functionY != null && this.functionY.equals(_value.getString())) break;
                this.functionY = _value.getString();
                this.changedYfunction = true;
                break;
            }
            case 10: {
                if (this.functionZ != null && this.functionZ.equals(_value.getString())) break;
                this.functionZ = _value.getString();
                this.changedZfunction = true;
                break;
            }
            case 11: {
                if (_value.getBoolean() == this.useJavaSyntax) break;
                this.useJavaSyntax = _value.getBoolean();
                this.changedZfunction = true;
                this.changedYfunction = true;
                this.changedXfunction = true;
                break;
            }
            case 12: {
                this.removeAction(1001, this.getProperty("onErrorAction"));
                this.addAction(1001, _value.getString());
                break;
            }
            case 13: {
                this.removeAction(1002, this.getProperty("onSuccessAction"));
                this.addAction(1002, _value.getString());
                break;
            }
            default: {
                super.setValue(_index - 14, _value);
            }
        }
        if (this.isUnderEjs) {
            this.preupdate();
            this.updatePanel();
        }
    }

    @Override
    public void setDefaultValue(int _index) {
        switch (_index) {
            case 0: {
                this.variable1 = "u";
                this.updateIndexes = true;
                break;
            }
            case 1: {
                this.min1 = Double.NaN;
                this.surface.setCanBeMeasured(false);
                break;
            }
            case 2: {
                this.max1 = Double.NaN;
                this.surface.setCanBeMeasured(false);
                break;
            }
            case 3: {
                this.numPoints1 = 20;
                break;
            }
            case 4: {
                this.variable2 = "v";
                this.updateIndexes = true;
                break;
            }
            case 5: {
                this.min2 = Double.NaN;
                this.surface.setCanBeMeasured(false);
                break;
            }
            case 6: {
                this.max2 = Double.NaN;
                this.surface.setCanBeMeasured(false);
                break;
            }
            case 7: {
                this.numPoints2 = 20;
                break;
            }
            case 8: {
                this.functionX = null;
                this.varsX = new String[0];
                this.changedXfunction = true;
                break;
            }
            case 9: {
                this.functionY = null;
                this.varsY = new String[0];
                this.changedYfunction = true;
                break;
            }
            case 10: {
                this.functionZ = null;
                this.varsZ = new String[0];
                this.changedZfunction = true;
                break;
            }
            case 11: {
                this.useJavaSyntax = true;
                this.changedZfunction = true;
                this.changedYfunction = true;
                this.changedXfunction = true;
                break;
            }
            case 12: {
                this.removeAction(1001, this.getProperty("onErrorAction"));
                break;
            }
            case 13: {
                this.removeAction(1002, this.getProperty("onSuccessAction"));
                break;
            }
            default: {
                super.setDefaultValue(_index - 14);
            }
        }
        if (this.isUnderEjs) {
            this.preupdate();
            this.updatePanel();
        }
    }

    @Override
    public String getDefaultValueString(int _index) {
        switch (_index) {
            case 0: {
                return "u";
            }
            case 1: 
            case 2: {
                return "Double.NaN";
            }
            case 3: {
                return "20";
            }
            case 4: {
                return "u";
            }
            case 5: 
            case 6: {
                return "Double.NaN";
            }
            case 7: {
                return "20";
            }
            case 8: 
            case 9: 
            case 10: {
                return "<none>";
            }
            case 11: {
                return "true";
            }
            case 12: 
            case 13: {
                return "<no_action>";
            }
        }
        return super.getDefaultValueString(_index - 14);
    }

    @Override
    public Value getValue(int _index) {
        switch (_index) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                return null;
            }
        }
        return super.getValue(_index - 14);
    }

    private boolean isVariableDefined(String varName) {
        if (this.variable1.equals(varName)) {
            return true;
        }
        if (this.variable2.equals(varName)) {
            return true;
        }
        Value value = this.myGroup.getValue(varName);
        if (value instanceof IntegerValue) {
            return true;
        }
        return value instanceof DoubleValue;
    }

    private void checkExtremes() {
        if (this.myParent == null) {
            return;
        }
        DrawingPanel3D panel = this.myParent.getDrawingPanel3D();
        boolean mustPreupdate = false;
        if (Double.isNaN(this.min1) || Double.isNaN(this.max1)) {
            if (Double.isNaN(this.min1) && panel.getPreferredMinX() != this.minAbcise1) {
                mustPreupdate = true;
            } else if (Double.isNaN(this.max1) && panel.getPreferredMaxX() != this.maxAbcise1) {
                mustPreupdate = true;
            }
        }
        if (Double.isNaN(this.min2) || Double.isNaN(this.max2)) {
            if (Double.isNaN(this.min2) && panel.getPreferredMinY() != this.minAbcise2) {
                mustPreupdate = true;
            } else if (Double.isNaN(this.max2) && panel.getPreferredMaxY() != this.maxAbcise2) {
                mustPreupdate = true;
            }
        }
        if (mustPreupdate) {
            this.preupdate();
        }
    }

    private void checkMeasured() {
        this.surface.setCanBeMeasured(!Double.isNaN(this.min1) && !Double.isNaN(this.max1) && !Double.isNaN(this.min2) && !Double.isNaN(this.max2));
    }

    @Override
    public void preupdate() {
        double[][][] data;
        int n;
        int i;
        ParserAndVariables pav;
        boolean parsedOk = false;
        boolean errorX = false;
        boolean errorY = false;
        boolean errorZ = false;
        if (this.changedXfunction && this.functionX != null) {
            pav = new ParserAndVariables(this.useJavaSyntax, this.functionX);
            this.varsX = pav.getVariables();
            this.parserX = pav.getParser();
            i = 0;
            n = this.varsX.length;
            while (i < n) {
                if (!this.isVariableDefined(this.varsX[i])) {
                    errorX = true;
                    break;
                }
                this.parserX.defineVariable(i, this.varsX[i]);
                ++i;
            }
            if (!errorX) {
                this.parserX.define(this.functionX);
                this.parserX.parse();
                if (this.parserX.hasError()) {
                    errorX = true;
                } else {
                    parsedOk = true;
                }
            }
            this.changedXfunction = false;
            this.updateIndexes = true;
        }
        if (this.changedYfunction && this.functionY != null) {
            pav = new ParserAndVariables(this.useJavaSyntax, this.functionY);
            this.varsY = pav.getVariables();
            this.parserY = pav.getParser();
            i = 0;
            n = this.varsY.length;
            while (i < n) {
                if (!this.isVariableDefined(this.varsY[i])) {
                    errorY = true;
                    break;
                }
                this.parserY.defineVariable(i, this.varsY[i]);
                ++i;
            }
            if (!errorY) {
                this.parserY.define(this.functionY);
                this.parserY.parse();
                if (this.parserY.hasError()) {
                    errorY = true;
                } else {
                    parsedOk = true;
                }
            }
            this.changedYfunction = false;
            this.updateIndexes = true;
        }
        if (this.changedZfunction && this.functionZ != null) {
            pav = new ParserAndVariables(this.useJavaSyntax, this.functionZ);
            this.varsZ = pav.getVariables();
            this.parserZ = pav.getParser();
            i = 0;
            n = this.varsZ.length;
            while (i < n) {
                if (!this.isVariableDefined(this.varsZ[i])) {
                    errorZ = true;
                    break;
                }
                this.parserZ.defineVariable(i, this.varsZ[i]);
                ++i;
            }
            if (!errorZ) {
                this.parserZ.define(this.functionZ);
                this.parserZ.parse();
                if (this.parserZ.hasError()) {
                    errorZ = true;
                } else {
                    parsedOk = true;
                }
            }
            this.changedZfunction = false;
            this.updateIndexes = true;
        }
        if (errorX || errorY || errorZ) {
            this.invokeActions(1001);
        } else if (parsedOk) {
            this.invokeActions(1002);
        }
        if (this.myEjsPropertyEditor != null) {
            this.myEjsPropertyEditor.displayErrorOnProperty("functionx", errorX);
            this.myEjsPropertyEditor.displayErrorOnProperty("functiony", errorY);
            this.myEjsPropertyEditor.displayErrorOnProperty("functionz", errorZ);
        }
        if (this.updateIndexes) {
            this.indexX1 = ControlAnalyticSurface3D.indexOf(this.variable1, this.varsX);
            this.indexY1 = ControlAnalyticSurface3D.indexOf(this.variable1, this.varsY);
            this.indexZ1 = ControlAnalyticSurface3D.indexOf(this.variable1, this.varsZ);
            this.indexX2 = ControlAnalyticSurface3D.indexOf(this.variable2, this.varsX);
            this.indexY2 = ControlAnalyticSurface3D.indexOf(this.variable2, this.varsY);
            this.indexZ2 = ControlAnalyticSurface3D.indexOf(this.variable2, this.varsZ);
            this.updateIndexes = false;
        }
        if ((data = this.surface.getData()) == null || data.length == 0 || data.length != this.numPoints1 || data[0].length != this.numPoints2) {
            data = new double[this.numPoints1][this.numPoints2][3];
        }
        this.minAbcise1 = this.min1;
        this.maxAbcise1 = this.max1;
        this.minAbcise2 = this.min2;
        this.maxAbcise2 = this.max2;
        if (this.myParent != null) {
            DrawingPanel3D panel = this.myParent.getDrawingPanel3D();
            if (Double.isNaN(this.minAbcise1)) {
                this.minAbcise1 = panel.getPreferredMinX();
            }
            if (Double.isNaN(this.maxAbcise1)) {
                this.maxAbcise1 = panel.getPreferredMaxX();
            }
            if (Double.isNaN(this.minAbcise2)) {
                this.minAbcise2 = panel.getPreferredMinY();
            }
            if (Double.isNaN(this.maxAbcise2)) {
                this.maxAbcise2 = panel.getPreferredMaxY();
            }
        }
        if (this.isUnderEjs) {
            try {
                int i2 = 0;
                n = this.varsX.length;
                while (i2 < n) {
                    if (i2 != this.indexX1 && i2 != this.indexX2) {
                        this.parserX.setVariable(i2, this.myGroup.getDouble(this.varsX[i2]));
                    }
                    ++i2;
                }
                i2 = 0;
                n = this.varsY.length;
                while (i2 < n) {
                    if (i2 != this.indexY1 && i2 != this.indexY2) {
                        this.parserY.setVariable(i2, this.myGroup.getDouble(this.varsY[i2]));
                    }
                    ++i2;
                }
                i2 = 0;
                n = this.varsZ.length;
                while (i2 < n) {
                    if (i2 != this.indexZ1 && i2 != this.indexZ2) {
                        this.parserZ.setVariable(i2, this.myGroup.getDouble(this.varsZ[i2]));
                    }
                    ++i2;
                }
            }
            catch (Exception exc) {
                System.err.println("ControlAnalyticSurface3D: Null String?\n");
                exc.printStackTrace();
            }
        } else {
            int i3 = 0;
            n = this.varsX.length;
            while (i3 < n) {
                if (i3 != this.indexX1 && i3 != this.indexX2) {
                    this.parserX.setVariable(i3, this.myGroup.getDouble(this.varsX[i3]));
                }
                ++i3;
            }
            i3 = 0;
            n = this.varsY.length;
            while (i3 < n) {
                if (i3 != this.indexY1 && i3 != this.indexY2) {
                    this.parserY.setVariable(i3, this.myGroup.getDouble(this.varsY[i3]));
                }
                ++i3;
            }
            i3 = 0;
            n = this.varsZ.length;
            while (i3 < n) {
                if (i3 != this.indexZ1 && i3 != this.indexZ2) {
                    this.parserZ.setVariable(i3, this.myGroup.getDouble(this.varsZ[i3]));
                }
                ++i3;
            }
        }
        int i4 = 0;
        n = this.numPoints1 - 1;
        while (i4 <= n) {
            double u = ((double)(n - i4) * this.minAbcise1 + (double)i4 * this.maxAbcise1) / (double)n;
            if (this.indexX1 >= 0) {
                this.parserX.setVariable(this.indexX1, u);
            }
            if (this.indexY1 >= 0) {
                this.parserY.setVariable(this.indexY1, u);
            }
            if (this.indexZ1 >= 0) {
                this.parserZ.setVariable(this.indexZ1, u);
            }
            int j = 0;
            int m = this.numPoints2 - 1;
            while (j <= m) {
                double v = ((double)(m - j) * this.minAbcise2 + (double)j * this.maxAbcise2) / (double)m;
                if (this.functionX == null || errorX) {
                    data[i4][j][0] = 0.0;
                } else {
                    if (this.indexX2 >= 0) {
                        this.parserX.setVariable(this.indexX2, v);
                    }
                    data[i4][j][0] = this.parserX.evaluate();
                }
                if (this.functionY == null || errorY) {
                    data[i4][j][1] = 0.0;
                } else {
                    if (this.indexY2 >= 0) {
                        this.parserY.setVariable(this.indexY2, v);
                    }
                    data[i4][j][1] = this.parserY.evaluate();
                }
                if (this.functionZ == null || errorZ) {
                    data[i4][j][2] = 0.0;
                } else {
                    if (this.indexZ2 >= 0) {
                        this.parserZ.setVariable(this.indexZ2, v);
                    }
                    data[i4][j][2] = this.parserZ.evaluate();
                }
                ++j;
            }
            ++i4;
        }
        this.surface.setData(data);
    }
}

