/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.drawing2d;

import java.awt.Color;
import java.awt.Paint;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.List;
import org.colos.ejs.library.control.ControlElement;
import org.colos.ejs.library.control.EjsControl;
import org.colos.ejs.library.control.drawing2d.ControlElement2D;
import org.colos.ejs.library.control.value.BooleanValue;
import org.colos.ejs.library.control.value.DoubleValue;
import org.colos.ejs.library.control.value.IntegerValue;
import org.colos.ejs.library.control.value.InterpretedValue;
import org.colos.ejs.library.control.value.ObjectValue;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.display.DisplayColors;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.drawing2d.Element;
import org.opensourcephysics.drawing2d.Set;
import org.opensourcephysics.drawing2d.interaction.InteractionEvent;
import org.opensourcephysics.drawing2d.interaction.InteractionTarget;
import org.opensourcephysics.tools.ToolForData;

public abstract class ControlSet2D
extends ControlElement2D {
    protected static final int SET2D_ADDED = 2;
    protected static final int NUM_ELEMENTS = 0;
    protected static final int ELEMENT_SELECTED = 1;
    private Set set;
    protected Element[] elements;
    private int numElements = 0;
    protected ObjectValue[] allposValues;
    protected ObjectValue[] allsizesValues;
    protected IntegerValue selectedValue = new IntegerValue(-1);
    protected double[] theXs;
    protected double[] theYs;
    protected double[] theSizeXs;
    protected double[] theSizeYs;
    protected double[][] allThePos;
    protected double[][] allTheSizes;
    protected double allScalex = 1.0;
    protected double allScaley = 1.0;
    protected double allLineWidth = 1.0;
    protected boolean numberOfElements_isSet = false;
    private boolean propagatingValue = false;
    protected double defaultElementX;
    protected double defaultElementY;
    protected double defaultElementSizeX;
    protected double defaultElementSizeY;
    protected Color defElementLines;
    protected Paint defElementFill;
    private static List<String> infoList = null;

    public ControlSet2D() {
        this.checkNumberOfElements(1, true);
        this.defaultElementX = this.elements[0].getX();
        this.defaultElementY = this.elements[0].getY();
        this.defaultElementSizeX = this.elements[0].getSizeX();
        this.defaultElementSizeY = this.elements[0].getSizeY();
        this.defElementLines = this.elements[0].getStyle().getLineColor();
        this.defElementFill = this.elements[0].getStyle().getFillColor();
    }

    @Override
    public String getObjectClassname() {
        return "org.opensourcephysics.drawing2d.Set";
    }

    @Override
    protected Drawable createDrawable() {
        this.set = new Set();
        return this.set;
    }

    protected abstract Element createAnElement();

    protected Set getSet() {
        return this.set;
    }

    protected abstract int getPropertiesAddedToSet();

    @Override
    protected final int getPropertiesDisplacement() {
        return this.getPropertiesAddedToSet() + 2;
    }

    protected void copyAnElement(Element oldElement, Element newElement) {
        oldElement.getStyle().copyTo(newElement);
        newElement.setDataObject(oldElement.getDataObject());
        newElement.setPanel(oldElement.getPanel());
        newElement.setName(oldElement.getName());
        newElement.setXY(oldElement.getX(), oldElement.getY());
        newElement.setSizeXY(oldElement.getSizeX(), oldElement.getSizeY());
        newElement.setVisible(oldElement.isVisible());
        newElement.setCanBeMeasured(oldElement.getCanBeMeasured());
        newElement.setTransformation(oldElement.getTransformation());
        newElement.getInteractionTarget(0).setEnabled(oldElement.getInteractionTarget(0).getEnabled());
        newElement.getInteractionTarget(0).setAffectsGroup(oldElement.getInteractionTarget(0).getAffectsGroup());
        newElement.getInteractionTarget(1).setEnabled(oldElement.getInteractionTarget(1).getEnabled());
        newElement.getInteractionTarget(1).setAffectsGroup(oldElement.getInteractionTarget(1).getAffectsGroup());
    }

    protected final void checkNumberOfElements(int newNumber, boolean force) {
        if (newNumber < 0) {
            newNumber = 0;
        }
        if (this.numElements == newNumber && !force) {
            return;
        }
        this.setNumberOfElements(newNumber);
        EjsControl controlGroup = this.getGroup();
        if (controlGroup != null && !controlGroup.isReportingChange() && !this.propagatingValue) {
            this.propagatingValue = true;
            controlGroup.propagateValues();
            this.propagatingValue = false;
        }
    }

    protected int setNumberOfElements(int proposedNumber) {
        Element[] oldElements = this.elements;
        int newNumber = proposedNumber > 0 ? proposedNumber : 1;
        this.elements = new Element[newNumber];
        int i = 0;
        while (i < newNumber) {
            this.elements[i] = this.createAnElement();
            Element oldElement = null;
            if (i < this.numElements) {
                oldElement = oldElements[i];
            } else if (oldElements != null) {
                oldElement = oldElements[0];
            }
            if (oldElement != null) {
                this.copyAnElement(oldElement, this.elements[i]);
            }
            this.elements[i].setName(String.valueOf(this.set.getName()) + "[" + i + "]");
            ++i;
        }
        this.set.removeAllElements();
        if (proposedNumber > 0) {
            i = 0;
            while (i < newNumber) {
                this.set.addElement(this.elements[i]);
                ++i;
            }
        }
        this.theXs = new double[newNumber];
        this.theYs = new double[newNumber];
        this.theSizeXs = new double[newNumber];
        this.theSizeYs = new double[newNumber];
        i = 0;
        while (i < newNumber) {
            this.theXs[i] = this.elements[i].getX();
            this.theYs[i] = this.elements[i].getY();
            this.theSizeXs[i] = this.elements[i].getSizeX();
            this.theSizeYs[i] = this.elements[i].getSizeY();
            this.elements[i].addInteractionListener(this);
            ++i;
        }
        this.allposValues = new ObjectValue[2];
        this.allsizesValues = new ObjectValue[2];
        this.allposValues[0] = new ObjectValue(this.theXs);
        this.allposValues[1] = new ObjectValue(this.theYs);
        this.allsizesValues[0] = new ObjectValue(this.theSizeXs);
        this.allsizesValues[1] = new ObjectValue(this.theSizeYs);
        this.numElements = proposedNumber;
        oldElements = null;
        return newNumber;
    }

    public Element elementAt(int i) {
        return this.elements[i];
    }

    @Override
    public void reset() {
        this.set.clear();
    }

    @Override
    public void initialize() {
        this.set.initialize();
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        int i = 0;
        int n = this.elements.length;
        while (i < n) {
            this.elements[i].setName(String.valueOf(name) + "[" + i + "]");
            ++i;
        }
    }

    @Override
    public List<String> getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList<String>();
            infoList.add("numberOfElements");
            infoList.add("elementSelected");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    @Override
    public String getPropertyInfo(String _property) {
        if (_property.equals("numberOfElements")) {
            return "int PREVIOUS";
        }
        if (_property.equals("elementSelected")) {
            return "int";
        }
        if (_property.equals("x")) {
            return "int|double|double[]";
        }
        if (_property.equals("y")) {
            return "int|double|double[]";
        }
        if (_property.equals("position")) {
            return "double[][]";
        }
        if (_property.equals("sizeX")) {
            return "int|double|double[]";
        }
        if (_property.equals("sizeY")) {
            return "int|double|double[]";
        }
        if (_property.equals("size")) {
            return "double[][]";
        }
        if (_property.equals("scalex")) {
            return "int|double";
        }
        if (_property.equals("scaley")) {
            return "int|double";
        }
        if (_property.equals("transformation")) {
            return "AffineTransform|double|double[]|Object|Object[]";
        }
        if (_property.equals("visible")) {
            return "boolean|boolean[]";
        }
        if (_property.equals("lineColor")) {
            return "int|int[]|Color|Object|Object[]";
        }
        if (_property.equals("lineWidth")) {
            return "int|double|double[]";
        }
        if (_property.equals("fillColor")) {
            return "int|int[]|Color|Object|Object[]";
        }
        if (_property.equals("drawingFill")) {
            return "boolean|boolean[]";
        }
        if (_property.equals("drawingLines")) {
            return "boolean|boolean[]";
        }
        if (_property.equals("enabledPosition")) {
            return "Interaction2D|int|int[]|boolean|boolean[]";
        }
        if (_property.equals("movesGroup")) {
            return "boolean|boolean[]";
        }
        if (_property.equals("enabledSize")) {
            return "Interaction2D|int|int[]|boolean|boolean[]";
        }
        if (_property.equals("resizesGroup")) {
            return "boolean|boolean[]";
        }
        if (_property.equals("sensitivity")) {
            return "int|int[]";
        }
        if (_property.equals("pressAction")) {
            return "Action CONSTANT";
        }
        if (_property.equals("dragAction")) {
            return "Action CONSTANT";
        }
        if (_property.equals("releaseAction")) {
            return "Action CONSTANT";
        }
        if (_property.equals("enteredAction")) {
            return "Action CONSTANT";
        }
        if (_property.equals("exitedAction")) {
            return "Action CONSTANT";
        }
        if (_property.equals("measured")) {
            return "boolean|boolean[]";
        }
        if (_property.equals("extraColor")) {
            return "int|int[]|Color|Object|Object[]";
        }
        return super.getPropertyInfo(_property);
    }

    @Override
    public ControlElement setProperty(String _property, String _value) {
        _property = _property.trim();
        if (_value != null) {
            boolean useDefaultTitle;
            boolean bl = useDefaultTitle = _value.startsWith("%_model.") && _value.endsWith("()%");
            if (_property.equals("x")) {
                this.set.setXLabel(useDefaultTitle ? "x" : _value);
            } else if (_property.equals("y")) {
                this.set.setYLabel(useDefaultTitle ? "y" : _value);
            }
        }
        return super.setProperty(_property, _value);
    }

    @Override
    public void addMenuEntries() {
        if (this.getMenuNameEntry() == null || !ToolForData.getTool().isFullTool()) {
            return;
        }
        this.getSimulation().addElementMenuEntries(this.getMenuNameEntry(), ControlSet2D.getDataInformationMenuEntries(this.getParent().getDrawingPanel(), this.set));
    }

    @Override
    public void setValue(int _index, Value _value) {
        switch (_index) {
            case 0: {
                if (_value.getInteger() != this.numElements) {
                    this.checkNumberOfElements(_value.getInteger(), true);
                }
                this.numberOfElements_isSet = true;
                return;
            }
            case 1: {
                this.selectedValue.value = _value.getInteger();
                return;
            }
        }
        switch (_index -= 2) {
            case 0: {
                this.allThePos = null;
                if (_value.getObject() instanceof double[]) {
                    double[] val = (double[])_value.getObject();
                    if (!this.numberOfElements_isSet) {
                        this.checkNumberOfElements(val.length, false);
                    }
                    int i = 0;
                    int n = Math.min(this.elements.length, val.length);
                    while (i < n) {
                        this.theXs[i] = val[i];
                        this.elements[i].setX(this.theXs[i]);
                        ++i;
                    }
                } else {
                    double val = _value.getDouble();
                    int i = 0;
                    while (i < this.elements.length) {
                        this.theXs[i] = val;
                        this.elements[i].setX(this.theXs[i]);
                        ++i;
                    }
                }
                break;
            }
            case 1: {
                this.allThePos = null;
                if (_value.getObject() instanceof double[]) {
                    double[] val = (double[])_value.getObject();
                    if (!this.numberOfElements_isSet) {
                        this.checkNumberOfElements(val.length, false);
                    }
                    int i = 0;
                    int n = Math.min(this.elements.length, val.length);
                    while (i < n) {
                        this.theYs[i] = val[i];
                        this.elements[i].setY(this.theYs[i]);
                        ++i;
                    }
                } else {
                    double val = _value.getDouble();
                    int i = 0;
                    while (i < this.elements.length) {
                        this.theYs[i] = val;
                        this.elements[i].setY(this.theYs[i]);
                        ++i;
                    }
                }
                break;
            }
            case 2: {
                if (!(_value.getObject() instanceof double[][])) break;
                this.allThePos = (double[][])_value.getObject();
                if (!this.numberOfElements_isSet) {
                    this.checkNumberOfElements(this.allThePos.length, false);
                }
                int i = 0;
                int n = Math.min(this.elements.length, this.allThePos.length);
                while (i < n) {
                    double[] point = this.allThePos[i];
                    this.theXs[i] = point[0];
                    this.theYs[i] = point[1];
                    this.elements[i].setXY(this.theXs[i], this.theYs[i]);
                    ++i;
                }
                break;
            }
            case 3: {
                this.allTheSizes = null;
                if (_value.getObject() instanceof double[]) {
                    double[] val = (double[])_value.getObject();
                    if (!this.numberOfElements_isSet) {
                        this.checkNumberOfElements(val.length, false);
                    }
                    int i = 0;
                    int n = Math.min(this.elements.length, val.length);
                    while (i < n) {
                        this.theSizeXs[i] = val[i];
                        this.elements[i].setSizeX(this.theSizeXs[i] * this.allScalex);
                        ++i;
                    }
                } else {
                    double val = _value.getDouble();
                    int i = 0;
                    while (i < this.elements.length) {
                        this.theSizeXs[i] = val;
                        this.elements[i].setSizeX(this.theSizeXs[i] * this.allScalex);
                        ++i;
                    }
                }
                break;
            }
            case 4: {
                this.allTheSizes = null;
                if (_value.getObject() instanceof double[]) {
                    double[] val = (double[])_value.getObject();
                    if (!this.numberOfElements_isSet) {
                        this.checkNumberOfElements(val.length, false);
                    }
                    int i = 0;
                    int n = Math.min(this.elements.length, val.length);
                    while (i < n) {
                        this.theSizeYs[i] = val[i];
                        this.elements[i].setSizeY(this.theSizeYs[i] * this.allScaley);
                        ++i;
                    }
                } else {
                    double val = _value.getDouble();
                    int i = 0;
                    while (i < this.elements.length) {
                        this.theSizeYs[i] = val;
                        this.elements[i].setSizeY(this.theSizeYs[i] * this.allScaley);
                        ++i;
                    }
                }
                break;
            }
            case 5: {
                if (!(_value.getObject() instanceof double[][])) break;
                this.allTheSizes = (double[][])_value.getObject();
                if (!this.numberOfElements_isSet) {
                    this.checkNumberOfElements(this.allTheSizes.length, false);
                }
                int i = 0;
                int n = Math.min(this.elements.length, this.allTheSizes.length);
                while (i < n) {
                    double[] size = this.allTheSizes[i];
                    this.theSizeXs[i] = size[0];
                    this.theSizeYs[i] = this.allTheSizes[i][1];
                    this.elements[i].setSizeXY(this.theSizeXs[i] * this.allScalex, this.theSizeYs[i] * this.allScaley);
                    ++i;
                }
                break;
            }
            case 6: {
                this.allScalex = _value.getDouble();
                int i = 0;
                while (i < this.elements.length) {
                    this.elements[i].setSizeX(this.theSizeXs[i] * this.allScalex);
                    ++i;
                }
                break;
            }
            case 7: {
                this.allScaley = _value.getDouble();
                int i = 0;
                while (i < this.elements.length) {
                    this.elements[i].setSizeY(this.theSizeYs[i] * this.allScaley);
                    ++i;
                }
                break;
            }
            case 8: {
                if (_value.getObject() instanceof AffineTransform) {
                    AffineTransform theTransform = (AffineTransform)_value.getObject();
                    int i = 0;
                    while (i < this.elements.length) {
                        this.elements[i].setTransformation(theTransform);
                        ++i;
                    }
                } else if (_value.getObject() instanceof double[]) {
                    double[] array = (double[])_value.getObject();
                    int i = 0;
                    int n = Math.min(array.length, this.elements.length);
                    while (i < n) {
                        this.elements[i].setTransformation(AffineTransform.getRotateInstance(array[i]));
                        ++i;
                    }
                } else if (_value instanceof DoubleValue || _value instanceof InterpretedValue) {
                    AffineTransform theTransform = AffineTransform.getRotateInstance(_value.getDouble());
                    int i = 0;
                    while (i < this.elements.length) {
                        this.elements[i].setTransformation(theTransform);
                        ++i;
                    }
                } else if (_value.getObject() instanceof AffineTransform[]) {
                    AffineTransform[] arrayTransform = (AffineTransform[])_value.getObject();
                    int i = 0;
                    int n = Math.min(arrayTransform.length, this.elements.length);
                    while (i < n) {
                        this.elements[i].setTransformation(arrayTransform[i]);
                        ++i;
                    }
                } else {
                    AffineTransform theTransform = ControlSet2D.decodeAffineTransform(_value.getString());
                    int i = 0;
                    while (i < this.elements.length) {
                        this.elements[i].setTransformation(theTransform);
                        ++i;
                    }
                }
                break;
            }
            case 9: {
                if (_value.getObject() instanceof boolean[]) {
                    boolean[] val = (boolean[])_value.getObject();
                    int i = 0;
                    int n = Math.min(this.elements.length, val.length);
                    while (i < n) {
                        this.elements[i].setVisible(val[i]);
                        ++i;
                    }
                } else {
                    boolean val = _value.getBoolean();
                    int i = 0;
                    while (i < this.elements.length) {
                        this.elements[i].setVisible(val);
                        ++i;
                    }
                }
                break;
            }
            case 10: {
                if (_value instanceof IntegerValue) {
                    Color col = DisplayColors.getLineColor(_value.getInteger());
                    int i = 0;
                    while (i < this.elements.length) {
                        this.elements[i].getStyle().setLineColor(col);
                        ++i;
                    }
                } else if (_value.getObject() instanceof int[]) {
                    int[] val = (int[])_value.getObject();
                    int i = 0;
                    int n = Math.min(this.elements.length, val.length);
                    while (i < n) {
                        this.elements[i].getStyle().setLineColor(DisplayColors.getLineColor(val[i]));
                        ++i;
                    }
                } else if (_value.getObject() instanceof Object[]) {
                    Object[] val = (Object[])_value.getObject();
                    int i = 0;
                    int n = Math.min(this.elements.length, val.length);
                    while (i < n) {
                        this.elements[i].getStyle().setLineColor((Color)val[i]);
                        ++i;
                    }
                } else {
                    if (!(_value.getObject() instanceof Color)) break;
                    Color val = (Color)_value.getObject();
                    int i = 0;
                    while (i < this.elements.length) {
                        this.elements[i].getStyle().setLineColor(val);
                        ++i;
                    }
                }
                break;
            }
            case 11: {
                if (_value.getObject() instanceof double[]) {
                    double[] val = (double[])_value.getObject();
                    int i = 0;
                    int n = Math.min(this.elements.length, val.length);
                    while (i < n) {
                        this.elements[i].getStyle().setLineWidth((float)val[i]);
                        ++i;
                    }
                } else {
                    float val = (float)_value.getDouble();
                    int i = 0;
                    while (i < this.elements.length) {
                        this.elements[i].getStyle().setLineWidth(val);
                        ++i;
                    }
                }
                break;
            }
            case 12: {
                if (_value instanceof IntegerValue) {
                    Color col = DisplayColors.getLineColor(_value.getInteger());
                    int i = 0;
                    while (i < this.elements.length) {
                        this.elements[i].getStyle().setFillColor(col);
                        ++i;
                    }
                } else if (_value.getObject() instanceof int[]) {
                    int[] val = (int[])_value.getObject();
                    int i = 0;
                    int n = Math.min(this.elements.length, val.length);
                    while (i < n) {
                        this.elements[i].getStyle().setFillColor(DisplayColors.getLineColor(val[i]));
                        ++i;
                    }
                } else if (_value.getObject() instanceof Object[]) {
                    Object[] val = (Object[])_value.getObject();
                    int i = 0;
                    int n = Math.min(this.elements.length, val.length);
                    while (i < n) {
                        this.elements[i].getStyle().setFillColor((Color)val[i]);
                        ++i;
                    }
                } else {
                    if (!(_value.getObject() instanceof Color)) break;
                    Color val = (Color)_value.getObject();
                    int i = 0;
                    while (i < this.elements.length) {
                        this.elements[i].getStyle().setFillColor(val);
                        ++i;
                    }
                }
                break;
            }
            case 13: {
                if (_value.getObject() instanceof boolean[]) {
                    boolean[] val = (boolean[])_value.getObject();
                    int i = 0;
                    int n = Math.min(this.elements.length, val.length);
                    while (i < n) {
                        this.elements[i].getStyle().setDrawingFill(val[i]);
                        ++i;
                    }
                } else {
                    boolean val = _value.getBoolean();
                    int i = 0;
                    while (i < this.elements.length) {
                        this.elements[i].getStyle().setDrawingFill(val);
                        ++i;
                    }
                }
                break;
            }
            case 14: {
                if (_value.getObject() instanceof boolean[]) {
                    boolean[] val = (boolean[])_value.getObject();
                    int i = 0;
                    int n = Math.min(this.elements.length, val.length);
                    while (i < n) {
                        this.elements[i].getStyle().setDrawingLines(val[i]);
                        ++i;
                    }
                } else {
                    boolean val = _value.getBoolean();
                    int i = 0;
                    while (i < this.elements.length) {
                        this.elements[i].getStyle().setDrawingLines(val);
                        ++i;
                    }
                }
                break;
            }
            case 15: {
                if (_value.getObject() instanceof boolean[]) {
                    boolean[] val = (boolean[])_value.getObject();
                    int i = 0;
                    int n = Math.min(this.elements.length, val.length);
                    while (i < n) {
                        this.elements[i].getInteractionTarget(0).setEnabled(val[i]);
                        ++i;
                    }
                } else if (_value.getObject() instanceof int[]) {
                    int[] val = (int[])_value.getObject();
                    int i = 0;
                    int n = Math.min(this.elements.length, val.length);
                    while (i < n) {
                        this.elements[i].getInteractionTarget(0).setEnabled(val[i]);
                        ++i;
                    }
                } else if (_value instanceof BooleanValue) {
                    boolean val = _value.getBoolean();
                    int i = 0;
                    while (i < this.elements.length) {
                        this.elements[i].getInteractionTarget(0).setEnabled(val);
                        ++i;
                    }
                } else {
                    int val = _value.getInteger();
                    int i = 0;
                    while (i < this.elements.length) {
                        this.elements[i].getInteractionTarget(0).setEnabled(val);
                        ++i;
                    }
                }
                break;
            }
            case 16: {
                if (_value.getObject() instanceof boolean[]) {
                    boolean[] val = (boolean[])_value.getObject();
                    int i = 0;
                    int n = Math.min(this.elements.length, val.length);
                    while (i < n) {
                        this.elements[i].getInteractionTarget(0).setAffectsGroup(val[i]);
                        ++i;
                    }
                } else {
                    boolean val = _value.getBoolean();
                    int i = 0;
                    while (i < this.elements.length) {
                        this.elements[i].getInteractionTarget(0).setAffectsGroup(val);
                        ++i;
                    }
                }
                break;
            }
            case 17: {
                if (_value.getObject() instanceof boolean[]) {
                    boolean[] val = (boolean[])_value.getObject();
                    int i = 0;
                    int n = Math.min(this.elements.length, val.length);
                    while (i < n) {
                        this.elements[i].getInteractionTarget(1).setEnabled(val[i]);
                        ++i;
                    }
                } else if (_value.getObject() instanceof int[]) {
                    int[] val = (int[])_value.getObject();
                    int i = 0;
                    int n = Math.min(this.elements.length, val.length);
                    while (i < n) {
                        this.elements[i].getInteractionTarget(1).setEnabled(val[i]);
                        ++i;
                    }
                } else if (_value instanceof BooleanValue) {
                    boolean val = _value.getBoolean();
                    int i = 0;
                    while (i < this.elements.length) {
                        this.elements[i].getInteractionTarget(1).setEnabled(val);
                        ++i;
                    }
                } else {
                    int val = _value.getInteger();
                    int i = 0;
                    while (i < this.elements.length) {
                        this.elements[i].getInteractionTarget(1).setEnabled(val);
                        ++i;
                    }
                }
                break;
            }
            case 18: {
                if (_value.getObject() instanceof boolean[]) {
                    boolean[] val = (boolean[])_value.getObject();
                    int i = 0;
                    int n = Math.min(this.elements.length, val.length);
                    while (i < n) {
                        this.elements[i].getInteractionTarget(1).setAffectsGroup(val[i]);
                        ++i;
                    }
                } else {
                    boolean val = _value.getBoolean();
                    int i = 0;
                    while (i < this.elements.length) {
                        this.elements[i].getInteractionTarget(1).setAffectsGroup(val);
                        ++i;
                    }
                }
                break;
            }
            case 19: {
                if (_value.getObject() instanceof int[]) {
                    int[] val = (int[])_value.getObject();
                    int i = 0;
                    int n = Math.min(this.elements.length, val.length);
                    while (i < n) {
                        this.elements[i].getStyle().setSensitivity(val[i]);
                        ++i;
                    }
                } else {
                    int val = _value.getInteger();
                    int i = 0;
                    while (i < this.elements.length) {
                        this.elements[i].getStyle().setSensitivity(val);
                        ++i;
                    }
                }
                break;
            }
            case 25: {
                if (_value.getObject() instanceof boolean[]) {
                    boolean[] val = (boolean[])_value.getObject();
                    int i = 0;
                    int n = Math.min(this.elements.length, val.length);
                    while (i < n) {
                        this.elements[i].setCanBeMeasured(val[i]);
                        ++i;
                    }
                } else {
                    boolean val = _value.getBoolean();
                    int i = 0;
                    while (i < this.elements.length) {
                        this.elements[i].setCanBeMeasured(val);
                        ++i;
                    }
                }
                break;
            }
            case 26: {
                if (_value instanceof IntegerValue) {
                    Color col = DisplayColors.getLineColor(_value.getInteger());
                    int i = 0;
                    while (i < this.elements.length) {
                        this.elements[i].getStyle().setExtraColor(col);
                        ++i;
                    }
                } else if (_value.getObject() instanceof int[]) {
                    int[] val = (int[])_value.getObject();
                    int i = 0;
                    int n = Math.min(this.elements.length, val.length);
                    while (i < n) {
                        this.elements[i].getStyle().setExtraColor(DisplayColors.getLineColor(val[i]));
                        ++i;
                    }
                } else if (_value.getObject() instanceof Object[]) {
                    Object[] val = (Object[])_value.getObject();
                    int i = 0;
                    int n = Math.min(this.elements.length, val.length);
                    while (i < n) {
                        this.elements[i].getStyle().setExtraColor((Color)val[i]);
                        ++i;
                    }
                } else {
                    if (!(_value.getObject() instanceof Color)) break;
                    Color val = (Color)_value.getObject();
                    int i = 0;
                    while (i < this.elements.length) {
                        this.elements[i].getStyle().setExtraColor(val);
                        ++i;
                    }
                }
                break;
            }
            default: {
                super.setValue(_index, _value);
            }
        }
    }

    @Override
    public void setDefaultValue(int _index) {
        switch (_index) {
            case 0: {
                this.checkNumberOfElements(1, true);
                this.numberOfElements_isSet = false;
                return;
            }
            case 1: {
                this.selectedValue.value = -1;
                return;
            }
        }
        switch (_index -= 2) {
            case 0: {
                int i = 0;
                while (i < this.elements.length) {
                    this.theXs[i] = this.defaultElementX;
                    this.elements[i].setX(this.theXs[i]);
                    ++i;
                }
                break;
            }
            case 1: {
                int i = 0;
                while (i < this.elements.length) {
                    this.theYs[i] = this.defaultElementY;
                    this.elements[i].setY(this.theYs[i]);
                    ++i;
                }
                break;
            }
            case 2: {
                this.allThePos = null;
                break;
            }
            case 3: {
                int i = 0;
                while (i < this.elements.length) {
                    this.theSizeXs[i] = this.defaultElementSizeX;
                    this.elements[i].setSizeX(this.theSizeXs[i] * this.allScalex);
                    ++i;
                }
                break;
            }
            case 4: {
                int i = 0;
                while (i < this.elements.length) {
                    this.theSizeYs[i] = this.defaultElementSizeY;
                    this.elements[i].setSizeY(this.theSizeYs[i] * this.allScaley);
                    ++i;
                }
                break;
            }
            case 5: {
                this.allTheSizes = null;
                break;
            }
            case 6: {
                this.allScalex = 1.0;
                int i = 0;
                while (i < this.elements.length) {
                    this.elements[i].setSizeX(this.theSizeXs[i] * this.allScalex);
                    ++i;
                }
                break;
            }
            case 7: {
                this.allScaley = 1.0;
                int i = 0;
                while (i < this.elements.length) {
                    this.elements[i].setSizeY(this.theSizeYs[i] * this.allScaley);
                    ++i;
                }
                break;
            }
            case 8: {
                int i = 0;
                while (i < this.elements.length) {
                    this.elements[i].setTransformation(null);
                    ++i;
                }
                break;
            }
            case 9: {
                int i = 0;
                while (i < this.elements.length) {
                    this.elements[i].setVisible(true);
                    ++i;
                }
                break;
            }
            case 10: {
                int i = 0;
                while (i < this.elements.length) {
                    this.elements[i].getStyle().setLineColor(this.defElementLines);
                    ++i;
                }
                break;
            }
            case 11: {
                int i = 0;
                while (i < this.elements.length) {
                    this.elements[i].getStyle().setLineWidth(1.0f);
                    ++i;
                }
                break;
            }
            case 12: {
                int i = 0;
                while (i < this.elements.length) {
                    this.elements[i].getStyle().setFillColor(this.defElementFill);
                    ++i;
                }
                break;
            }
            case 13: {
                int i = 0;
                while (i < this.elements.length) {
                    this.elements[i].getStyle().setDrawingFill(true);
                    ++i;
                }
                break;
            }
            case 14: {
                int i = 0;
                while (i < this.elements.length) {
                    this.elements[i].getStyle().setDrawingLines(true);
                    ++i;
                }
                break;
            }
            case 15: {
                int i = 0;
                while (i < this.elements.length) {
                    this.elements[i].getInteractionTarget(0).setEnabled(false);
                    ++i;
                }
                break;
            }
            case 16: {
                int i = 0;
                while (i < this.elements.length) {
                    this.elements[i].getInteractionTarget(0).setAffectsGroup(false);
                    ++i;
                }
                break;
            }
            case 17: {
                int i = 0;
                while (i < this.elements.length) {
                    this.elements[i].getInteractionTarget(1).setEnabled(false);
                    ++i;
                }
                break;
            }
            case 18: {
                int i = 0;
                while (i < this.elements.length) {
                    this.elements[i].getInteractionTarget(1).setAffectsGroup(false);
                    ++i;
                }
                break;
            }
            case 19: {
                int i = 0;
                while (i < this.elements.length) {
                    this.elements[i].getStyle().setSensitivity(5);
                    ++i;
                }
                break;
            }
            case 25: {
                int i = 0;
                while (i < this.elements.length) {
                    this.elements[i].setCanBeMeasured(true);
                    ++i;
                }
                break;
            }
            case 26: {
                int i = 0;
                while (i < this.elements.length) {
                    this.elements[i].getStyle().setExtraColor(this.defExtraColor);
                    ++i;
                }
                break;
            }
            default: {
                super.setDefaultValue(_index);
            }
        }
    }

    @Override
    public String getDefaultValueString(int _index) {
        switch (_index) {
            case 0: {
                return "1";
            }
            case 1: {
                return "-1";
            }
        }
        switch (_index -= 2) {
            case 0: {
                return Double.toString(this.defaultElementX);
            }
            case 1: {
                return Double.toString(this.defaultElementY);
            }
            case 3: {
                return Double.toString(this.defaultElementSizeX);
            }
            case 4: {
                return Double.toString(this.defaultElementSizeY);
            }
            case 10: {
                return this.defElementLines.toString();
            }
            case 12: {
                return this.defElementFill.toString();
            }
        }
        return super.getDefaultValueString(_index);
    }

    @Override
    public Value getValue(int _index) {
        switch (_index) {
            case 0: {
                return null;
            }
            case 1: {
                return this.selectedValue;
            }
        }
        switch (_index -= 2) {
            case 0: {
                return this.allposValues[0];
            }
            case 1: {
                return this.allposValues[1];
            }
            case 2: {
                return new ObjectValue(this.allThePos);
            }
            case 5: {
                return new ObjectValue(this.allTheSizes);
            }
            case 3: {
                return this.allsizesValues[0];
            }
            case 4: {
                return this.allsizesValues[1];
            }
        }
        return super.getValue(_index);
    }

    protected void propagatePosition(ControlElement2D origin, int _index) {
        this.theXs[_index] = this.elements[_index].getX();
        this.theYs[_index] = this.elements[_index].getY();
        if (this.allThePos != null) {
            this.allThePos[_index][0] = this.theXs[_index];
            this.allThePos[_index][1] = this.theYs[_index];
            ObjectValue objVal = new ObjectValue(this.allThePos);
            this.variableChanged(this.getFullPositionSpot(), objVal);
            if (this != origin) {
                origin.variableChanged(origin.getFullPositionSpot(), objVal);
            }
            if (this.isUnderEjs) {
                this.setFieldListValue(this.getFullPositionSpot(), objVal);
            }
        } else {
            this.variablesChanged(this.getPosSpot(), this.allposValues);
            if (this != origin) {
                origin.variablesChanged(origin.getPosSpot(), this.allposValues);
            }
            if (this.isUnderEjs) {
                this.setFieldListValues(this.getPosSpot(), this.allposValues);
            }
        }
    }

    protected void propagateSize(ControlElement2D origin, int _index) {
        this.theSizeXs[_index] = this.allScalex != 0.0 ? this.elements[_index].getSizeX() / this.allScalex : this.elements[_index].getSizeX();
        this.theSizeYs[_index] = this.allScaley != 0.0 ? this.elements[_index].getSizeY() / this.allScaley : this.elements[_index].getSizeY();
        if (this.allTheSizes != null) {
            this.allTheSizes[_index][0] = this.theSizeXs[_index];
            this.allTheSizes[_index][1] = this.theSizeYs[_index];
            ObjectValue objVal = new ObjectValue(this.allTheSizes);
            this.variableChanged(this.getFullSizeSpot(), objVal);
            if (this != origin) {
                origin.variableChanged(origin.getFullSizeSpot(), objVal);
            }
            if (this.isUnderEjs) {
                this.setFieldListValue(this.getFullSizeSpot(), objVal);
            }
        } else {
            this.variablesChanged(this.getSizeSpot(), this.allsizesValues);
            if (this != origin) {
                origin.variablesChanged(origin.getSizeSpot(), this.allsizesValues);
            }
            if (this.isUnderEjs) {
                this.setFieldListValues(this.getSizeSpot(), this.allsizesValues);
            }
        }
    }

    protected final void reportMouseMotion(Object _info, int _index) {
        InteractionTarget target = (InteractionTarget)_info;
        ControlSet2D gr = this;
        if (target == this.elements[_index].getInteractionTarget(0)) {
            if (target.getAffectsGroup()) {
                gr.propagatePosition(this);
            } else {
                this.propagatePosition(this, _index);
            }
        } else if (target == this.elements[_index].getInteractionTarget(1)) {
            if (target.getAffectsGroup()) {
                gr.propagateSize(this);
            } else {
                this.propagateSize(this, _index);
            }
        }
    }

    @Override
    public void interactionPerformed(InteractionEvent _event) {
        switch (_event.getID()) {
            case 2003: {
                this.selectedValue.value = this.set.getInteractedIndex();
                this.variableExtraChanged(1 + this.getPropertiesAddedToSet(), this.selectedValue);
                this.invokeActions(31);
                break;
            }
            case 2004: {
                this.invokeActions(32);
                this.variableExtraChanged(1 + this.getPropertiesAddedToSet(), this.selectedValue);
                break;
            }
            case 2000: {
                this.selectedValue.value = this.set.getInteractedIndex();
                this.variableExtraChanged(1 + this.getPropertiesAddedToSet(), this.selectedValue);
                this.invokeActions(10);
                break;
            }
            case 2001: {
                this.reportMouseMotion(_event.getInfo(), this.selectedValue.value);
                break;
            }
            case 2002: {
                this.invokeActions(0);
                this.variableExtraChanged(1 + this.getPropertiesAddedToSet(), this.selectedValue);
            }
        }
    }
}

