/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.drawing2d;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import org.colos.ejs.library.control.drawing2d.ControlElement2D;
import org.colos.ejs.library.control.swing.NeedsPreUpdate;
import org.colos.ejs.library.control.value.DoubleValue;
import org.colos.ejs.library.control.value.GeneralParser;
import org.colos.ejs.library.control.value.IntegerValue;
import org.colos.ejs.library.control.value.ParserAndVariables;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.drawing2d.ElementPolygon;

public class ControlAnalyticCurve2D
extends ControlElement2D
implements NeedsPreUpdate {
    private static final int ANALCURVE_PROPERTIES_ADDED = 9;
    protected String variable;
    protected int numPoints;
    protected double min = Double.NaN;
    protected double max = Double.NaN;
    protected String functionX;
    protected String functionY;
    protected boolean useJavaSyntax = true;
    protected ElementPolygon polygon;
    protected boolean changedXfunction;
    protected boolean changedYfunction;
    protected boolean updateIndexes;
    protected GeneralParser parserX;
    protected GeneralParser parserY;
    protected String[] varsX;
    protected String[] varsY;
    protected int indexX;
    protected int indexY;
    private double minAbcise = Double.NaN;
    private double maxAbcise = Double.NaN;
    private static List<String> infoList = null;

    @Override
    public String getObjectClassname() {
        return "org.opensourcephysics.drawing2d.ElementPolygon";
    }

    @Override
    protected int getPropertiesDisplacement() {
        return 9;
    }

    @Override
    protected Drawable createDrawable() {
        this.polygon = new ElementPolygon();
        this.polygon.setActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent _event) {
                ControlAnalyticCurve2D.this.checkExtremes();
            }
        });
        this.polygon.setClosed(false);
        this.polygon.setCanBeMeasured(false);
        this.variable = "t";
        this.functionX = null;
        this.varsX = new String[0];
        this.indexX = -1;
        this.functionY = null;
        this.varsY = new String[0];
        this.indexY = -1;
        this.changedYfunction = true;
        this.changedXfunction = true;
        return this.polygon;
    }

    @Override
    public List<String> getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList<String>();
            infoList.add("variable");
            infoList.add("min");
            infoList.add("max");
            infoList.add("points");
            infoList.add("functionx");
            infoList.add("functiony");
            infoList.add("javaSyntax");
            infoList.add("onErrorAction");
            infoList.add("onSuccessAction");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    @Override
    public String getPropertyInfo(String _property) {
        if (_property.equals("variable")) {
            return "String";
        }
        if (_property.equals("min")) {
            return "int|double";
        }
        if (_property.equals("max")) {
            return "int|double";
        }
        if (_property.equals("points")) {
            return "int";
        }
        if (_property.equals("functionx")) {
            return "String";
        }
        if (_property.equals("functiony")) {
            return "String";
        }
        if (_property.equals("javaSyntax")) {
            return "boolean";
        }
        if (_property.equals("onErrorAction")) {
            return "Action CONSTANT";
        }
        if (_property.equals("onSuccessAction")) {
            return "Action CONSTANT";
        }
        return super.getPropertyInfo(_property);
    }

    @Override
    public void setValue(int _index, Value _value) {
        switch (_index) {
            case 0: {
                if (this.variable != null && this.variable.equals(_value.getString())) break;
                this.variable = _value.getString();
                this.updateIndexes = true;
                break;
            }
            case 1: {
                this.min = _value.getDouble();
                this.polygon.setCanBeMeasured(!Double.isNaN(this.min) && !Double.isNaN(this.max));
                break;
            }
            case 2: {
                this.max = _value.getDouble();
                this.polygon.setCanBeMeasured(!Double.isNaN(this.min) && !Double.isNaN(this.max));
                break;
            }
            case 3: {
                this.numPoints = _value.getInteger();
                break;
            }
            case 4: {
                if (this.functionX != null && this.functionX.equals(_value.getString())) break;
                this.functionX = _value.getString();
                this.changedXfunction = true;
                break;
            }
            case 5: {
                if (this.functionY != null && this.functionY.equals(_value.getString())) break;
                this.functionY = _value.getString();
                this.changedYfunction = true;
                break;
            }
            case 6: {
                if (_value.getBoolean() == this.useJavaSyntax) break;
                this.useJavaSyntax = _value.getBoolean();
                this.changedYfunction = true;
                this.changedXfunction = true;
                break;
            }
            case 7: {
                this.removeAction(1001, this.getProperty("onErrorAction"));
                this.addAction(1001, _value.getString());
                return;
            }
            case 8: {
                this.removeAction(1002, this.getProperty("onSuccessAction"));
                this.addAction(1002, _value.getString());
                return;
            }
            default: {
                super.setValue(_index - 9, _value);
            }
        }
    }

    @Override
    public void setDefaultValue(int _index) {
        switch (_index) {
            case 0: {
                this.variable = "t";
                this.updateIndexes = true;
                break;
            }
            case 1: {
                this.min = Double.NaN;
                this.polygon.setCanBeMeasured(false);
                break;
            }
            case 2: {
                this.max = Double.NaN;
                this.polygon.setCanBeMeasured(false);
                break;
            }
            case 3: {
                this.numPoints = 0;
                break;
            }
            case 4: {
                this.functionX = null;
                this.varsX = new String[0];
                this.changedXfunction = true;
                break;
            }
            case 5: {
                this.functionY = null;
                this.varsY = new String[0];
                this.changedYfunction = true;
                break;
            }
            case 6: {
                this.useJavaSyntax = true;
                this.changedYfunction = true;
                this.changedXfunction = true;
                break;
            }
            case 7: {
                this.removeAction(1001, this.getProperty("onErrorAction"));
                return;
            }
            case 8: {
                this.removeAction(1002, this.getProperty("onSuccessAction"));
                return;
            }
            default: {
                super.setDefaultValue(_index - 9);
            }
        }
    }

    @Override
    public String getDefaultValueString(int _index) {
        switch (_index) {
            case 0: {
                return "t";
            }
            case 1: 
            case 2: {
                return "Double.NaN";
            }
            case 3: {
                return "0";
            }
            case 4: 
            case 5: {
                return "<none>";
            }
            case 6: {
                return "true";
            }
            case 7: 
            case 8: {
                return "<no_action>";
            }
        }
        return super.getDefaultValueString(_index - 9);
    }

    @Override
    public Value getValue(int _index) {
        switch (_index) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return null;
            }
        }
        return super.getValue(_index - 9);
    }

    private boolean isVariableDefined(String varName) {
        if (this.variable.equals(varName)) {
            return true;
        }
        Value value = this.myGroup.getValue(varName);
        if (value instanceof IntegerValue) {
            return true;
        }
        return value instanceof DoubleValue;
    }

    private void checkExtremes() {
        if (Double.isNaN(this.min) || Double.isNaN(this.max)) {
            if (this.myParent == null) {
                return;
            }
            DrawingPanel panel = this.myParent.getDrawingPanel();
            if (Double.isNaN(this.min) && panel.getXMin() != this.minAbcise) {
                this.preupdate();
            } else if (Double.isNaN(this.max) && panel.getXMax() != this.maxAbcise) {
                this.preupdate();
            }
        }
    }

    @Override
    public void preupdate() {
        int n;
        int n2;
        int i;
        ParserAndVariables pav;
        boolean parsedOk = false;
        boolean errorX = false;
        boolean errorY = false;
        if (this.changedXfunction && this.functionX != null) {
            pav = new ParserAndVariables(this.useJavaSyntax, this.functionX);
            this.varsX = pav.getVariables();
            this.parserX = pav.getParser();
            i = 0;
            n2 = this.varsX.length;
            while (i < n2) {
                if (!this.isVariableDefined(this.varsX[i])) {
                    errorX = true;
                    break;
                }
                this.parserX.defineVariable(i, this.varsX[i]);
                ++i;
            }
            if (!errorX) {
                this.parserX.define(this.functionX);
                this.parserX.parse();
                if (this.parserX.hasError()) {
                    errorX = true;
                } else {
                    parsedOk = true;
                }
            }
            this.changedXfunction = false;
            this.updateIndexes = true;
        }
        if (this.changedYfunction && this.functionY != null) {
            pav = new ParserAndVariables(this.useJavaSyntax, this.functionY);
            this.varsY = pav.getVariables();
            this.parserY = pav.getParser();
            i = 0;
            n2 = this.varsY.length;
            while (i < n2) {
                if (!this.isVariableDefined(this.varsY[i])) {
                    errorY = true;
                    break;
                }
                this.parserY.defineVariable(i, this.varsY[i]);
                ++i;
            }
            if (!errorY) {
                this.parserY.define(this.functionY);
                this.parserY.parse();
                if (this.parserY.hasError()) {
                    errorY = true;
                } else {
                    parsedOk = true;
                }
            }
            this.changedYfunction = false;
            this.updateIndexes = true;
        }
        if (errorX || errorY) {
            this.invokeActions(1001);
        } else if (parsedOk) {
            this.invokeActions(1002);
        }
        if (this.isUnderEjs) {
            this.myEjsPropertyEditor.displayErrorOnProperty("functionx", errorX);
            this.myEjsPropertyEditor.displayErrorOnProperty("functiony", errorY);
        }
        if (this.updateIndexes) {
            this.indexX = ControlAnalyticCurve2D.indexOf(this.variable, this.varsX);
            this.indexY = ControlAnalyticCurve2D.indexOf(this.variable, this.varsY);
            this.updateIndexes = false;
        }
        DrawingPanel panel = this.myParent.getDrawingPanel();
        int nPoints = this.numPoints;
        if (nPoints <= 0) {
            nPoints = panel != null ? Math.max(100, panel.getWidth() / 2) : 100;
        }
        if (this.polygon.getDataArray().length != nPoints) {
            this.polygon.setData(new double[nPoints][2]);
        }
        double[][] data = this.polygon.getDataArray();
        this.minAbcise = this.min;
        this.maxAbcise = this.max;
        if (Double.isNaN(this.minAbcise)) {
            this.minAbcise = panel.getXMin();
        }
        if (Double.isNaN(this.maxAbcise)) {
            this.maxAbcise = panel.getXMax();
        }
        if (this.isUnderEjs) {
            try {
                int i2 = 0;
                n = this.varsX.length;
                while (i2 < n) {
                    if (i2 != this.indexX) {
                        this.parserX.setVariable(i2, this.myGroup.getDouble(this.varsX[i2]));
                    }
                    ++i2;
                }
                i2 = 0;
                n = this.varsY.length;
                while (i2 < n) {
                    if (i2 != this.indexY) {
                        this.parserY.setVariable(i2, this.myGroup.getDouble(this.varsY[i2]));
                    }
                    ++i2;
                }
            }
            catch (Exception exc) {
                System.err.println("ControlAnalyticCurve2D: Null String?\n");
                exc.printStackTrace();
            }
        } else {
            int i3 = 0;
            n = this.varsX.length;
            while (i3 < n) {
                if (i3 != this.indexX) {
                    this.parserX.setVariable(i3, this.myGroup.getDouble(this.varsX[i3]));
                }
                ++i3;
            }
            i3 = 0;
            n = this.varsY.length;
            while (i3 < n) {
                if (i3 != this.indexY) {
                    this.parserY.setVariable(i3, this.myGroup.getDouble(this.varsY[i3]));
                }
                ++i3;
            }
        }
        int i4 = 0;
        n = nPoints - 1;
        while (i4 <= n) {
            double t = ((double)(n - i4) * this.minAbcise + (double)i4 * this.maxAbcise) / (double)n;
            if (this.functionX == null || errorX) {
                data[i4][0] = 0.0;
            } else {
                if (this.indexX >= 0) {
                    this.parserX.setVariable(this.indexX, t);
                }
                data[i4][0] = this.parserX.evaluate();
            }
            if (this.functionY == null || errorY) {
                data[i4][1] = 0.0;
            } else {
                if (this.indexY >= 0) {
                    this.parserY.setVariable(this.indexY, t);
                }
                data[i4][1] = this.parserY.evaluate();
            }
            ++i4;
        }
        this.polygon.setElementChanged();
    }
}

